/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.testing;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.browserprefui.BrowserPrefAction;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.testing.TestAppLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class BrowserLauncherTestApp
extends JFrame {
    private static final String debugResources = "edu.stanford.ejalbert.resources.Debugging";
    private TestAppLogger logger;
    private JComboBox browserBox = new JComboBox();
    private JLabel loggingLevelTxtFld = new JLabel();
    private JTextField urlTextField = new JTextField();
    private BrowserLauncher launcher;
    private JTextArea debugTextArea = new JTextArea();
    private JTextField browserListField = new JTextField();
    private ResourceBundle bundle;
    private JCheckBox windowPolicyCBox = new JCheckBox();

    public BrowserLauncherTestApp() {
        try {
            this.bundle = ResourceBundle.getBundle(debugResources);
            this.logger = this.initDebugLogging();
            this.loggingLevelTxtFld.setText(this.logger.getLevelText());
            super.setTitle(this.bundle.getString("label.app.title"));
            this.populateDebugInfo(this.bundle, this.debugTextArea);
            this.launcher = new BrowserLauncher(this.logger, new TestAppErrorHandler(this.debugTextArea));
            DefaultComboBoxModel<Object> cbModel = new DefaultComboBoxModel<Object>(this.launcher.getBrowserList().toArray());
            this.browserBox.setModel(cbModel);
            this.windowPolicyCBox.setSelected(this.launcher.getNewWindowPolicy());
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private TestAppLogger initDebugLogging() {
        String[] levelLabels = this.bundle.getString("logging.level.labels").split(";");
        this.debugTextArea.setEditable(false);
        this.debugTextArea.setLineWrap(true);
        this.debugTextArea.setWrapStyleWord(true);
        this.debugTextArea.setText("");
        return new TestAppLogger(this.debugTextArea, levelLabels, this.bundle.getString("logging.dateformat"));
    }

    public static void main(String[] args) {
        BrowserLauncherTestApp app = new BrowserLauncherTestApp();
        app.pack();
        app.setVisible(true);
    }

    private void windowPolicyItemStateChange(ItemEvent e) {
        this.launcher.setNewWindowPolicy(e.getStateChange() == 1);
    }

    private void populateDebugInfo(ResourceBundle bundle, JTextArea debugTextArea) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println(bundle.getString("debug.mssg"));
        printWriter.println();
        StringTokenizer tokenizer = new StringTokenizer(bundle.getString("debug.propnames"), ";", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int pipeSymbol = token.indexOf(124);
            String display = token.substring(0, pipeSymbol);
            String property = token.substring(pipeSymbol + 1);
            printWriter.print(display);
            printWriter.println(System.getProperty(property));
        }
        printWriter.close();
        debugTextArea.append(stringWriter.toString());
    }

    private void jbInit() throws Exception {
        BrowserPrefAction browserPrefAction = new BrowserPrefAction(this.bundle.getString("bttn.set.preference"), this.launcher, this);
        JButton prefBrowserBttn = new JButton(browserPrefAction);
        JButton browseButton = new JButton(this.bundle.getString("bttn.browse"));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.browseButton_actionPerformed(e);
            }
        });
        JLabel enterUrlLabel = new JLabel(this.bundle.getString("label.url"));
        this.urlTextField.setText(this.bundle.getString("url.default"));
        this.urlTextField.setColumns(25);
        JPanel urlPanel = new JPanel(new BorderLayout());
        urlPanel.add((Component)enterUrlLabel, "Before");
        urlPanel.add((Component)this.urlTextField, "Center");
        urlPanel.add((Component)browseButton, "After");
        JScrollPane debugTextScrollPane = new JScrollPane(this.debugTextArea);
        JLabel debugLevelLabel = new JLabel(this.bundle.getString("label.logging.level"));
        JButton loggingLevelBttn = new JButton(this.bundle.getString("bttn.set.logging"));
        loggingLevelBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.loggingLevelBttn_actionPerformed(e);
            }
        });
        JButton copyButton = new JButton(this.bundle.getString("bttn.copy"));
        copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.copyButton_actionPerformed(e);
            }
        });
        JButton killBrowserButton = new JButton(this.bundle.getString("bttn.killbrowser"));
        killBrowserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncherTestApp.this.killBrowserButton_actionPerformed(e);
            }
        });
        JPanel debugTextBttnPanel = new JPanel();
        BoxLayout bttnBoxLayout = new BoxLayout(debugTextBttnPanel, 0);
        debugTextBttnPanel.setLayout(bttnBoxLayout);
        debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        debugTextBttnPanel.add(this.browserBox);
        debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        debugTextBttnPanel.add(debugLevelLabel);
        debugTextBttnPanel.add(Box.createHorizontalStrut(3));
        debugTextBttnPanel.add(this.loggingLevelTxtFld);
        debugTextBttnPanel.add(Box.createHorizontalStrut(5));
        debugTextBttnPanel.add(Box.createHorizontalGlue());
        debugTextBttnPanel.add(loggingLevelBttn);
        debugTextBttnPanel.add(Box.createHorizontalStrut(3));
        debugTextBttnPanel.add(copyButton);
        debugTextBttnPanel.add(Box.createHorizontalStrut(3));
        debugTextBttnPanel.add(killBrowserButton);
        debugTextBttnPanel.add(Box.createHorizontalStrut(2));
        this.windowPolicyCBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BrowserLauncherTestApp.this.windowPolicyItemStateChange(e);
            }
        });
        this.windowPolicyCBox.setText(this.bundle.getString("label.window.policy"));
        JLabel browserListLabel = new JLabel(this.bundle.getString("label.browser.list"));
        JPanel browserListPanel = new JPanel();
        BoxLayout browserListBoxLayout = new BoxLayout(browserListPanel, 0);
        browserListPanel.setLayout(browserListBoxLayout);
        browserListPanel.add(browserListLabel);
        browserListPanel.add(Box.createHorizontalStrut(2));
        browserListPanel.add(this.browserListField);
        browserListPanel.add(Box.createHorizontalStrut(2));
        browserListPanel.add(this.windowPolicyCBox);
        browserListPanel.add(Box.createHorizontalStrut(2));
        browserListPanel.add(prefBrowserBttn);
        JPanel configPanel = new JPanel(new GridLayout(2, 1, 0, 2));
        configPanel.add(browserListPanel);
        configPanel.add(debugTextBttnPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 3));
        mainPanel.add((Component)debugTextScrollPane, "Center");
        mainPanel.add((Component)urlPanel, "North");
        mainPanel.add((Component)configPanel, "South");
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(browseButton);
        this.setDefaultCloseOperation(3);
    }

    private static void updateDebugTextArea(Exception exception, JTextArea debugTextArea) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        printWriter.println();
        exception.printStackTrace(printWriter);
        printWriter.println();
        printWriter.close();
        debugTextArea.append(stringWriter.toString());
    }

    private void browseButton_actionPerformed(ActionEvent e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("browse button clicked");
        }
        try {
            String urlString = this.urlTextField.getText();
            if (urlString == null || urlString.trim().length() == 0) {
                throw new MalformedURLException("You must specify a url.");
            }
            new URL(urlString);
            TestAppErrorHandler errorHandler = new TestAppErrorHandler(this.debugTextArea);
            String browserItems = this.browserListField.getText();
            if (browserItems != null && browserItems.length() > 0) {
                this.logger.debug("using browser list");
                String[] browserArray = browserItems.split("[ ]+");
                List<String> browserList = Arrays.asList(browserArray);
                this.logger.debug(browserList.toString());
                this.launcher.openURLinBrowser(browserList, urlString);
            } else {
                String targetBrowser = this.browserBox.getSelectedItem().toString();
                this.logger.debug(targetBrowser);
                this.launcher.openURLinBrowser(targetBrowser, urlString);
            }
        }
        catch (Exception ex) {
            BrowserLauncherTestApp.updateDebugTextArea(ex, this.debugTextArea);
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error Message", 0);
        }
    }

    private void killBrowserButton_actionPerformed(ActionEvent e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("kill browser button clicked");
        }
    }

    private void copyButton_actionPerformed(ActionEvent e) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("copy button clicked");
        }
        this.debugTextArea.selectAll();
        this.debugTextArea.copy();
        this.debugTextArea.select(0, 0);
    }

    private void loggingLevelBttn_actionPerformed(ActionEvent e) {
        Object[] levels = this.logger.getLevelOptions();
        int levelIndex = this.logger.getLevel();
        String level = (String)JOptionPane.showInputDialog(this, this.bundle.getString("logging.level.select.message"), this.bundle.getString("logging.level.select.title"), 3, null, levels, levels[levelIndex]);
        if (level != null && level.length() > 0) {
            levelIndex = -1;
            int max = levels.length;
            for (int idx = 0; idx < max && levelIndex == -1; ++idx) {
                if (!level.equals(levels[idx])) continue;
                levelIndex = idx;
            }
            this.logger.setLevel(levelIndex);
            this.loggingLevelTxtFld.setText(this.logger.getLevelText());
        }
    }

    private static class TestAppErrorHandler
    implements BrowserLauncherErrorHandler {
        private JTextArea debugTextArea;

        TestAppErrorHandler(JTextArea debugTextArea) {
            this.debugTextArea = debugTextArea;
        }

        @Override
        public void handleException(Exception ex) {
            BrowserLauncherTestApp.updateDebugTextArea(ex, this.debugTextArea);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "Error Message", 0);
        }
    }
}

