/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs3_1BrowserLaunching
extends MacOsBrowserLaunching {
    private Method openURL;

    @Override
    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            this.openURL = mrjFileUtilsClass.getDeclaredMethod("openURL", String.class);
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
    }

    @Override
    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.openURL.invoke(null, urlString);
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    @Override
    public List getBrowserList() {
        ArrayList<String> browserList = new ArrayList<String>(1);
        browserList.add("Default");
        return browserList;
    }
}

