/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.soylatte;

import edu.stanford.ejalbert.launching.soylatte.SoyLatteBrowser;
import edu.stanford.ejalbert.launching.utils.LaunchingUtils;
import net.sf.wraplog.AbstractLogger;

class SoyLatteBrowserImpl
implements SoyLatteBrowser {
    private final String browserName;
    private final String browserArgName;
    private final String argsForOpenBrowser;
    private final String argsForStartBrowser;
    private final String argsForForcedBrowserWindow;

    SoyLatteBrowserImpl(String configSep, String configStr) {
        String[] configItems = configStr.split(configSep, -2);
        this.browserName = configItems[0];
        this.browserArgName = configItems[1];
        this.argsForStartBrowser = configItems[2];
        this.argsForOpenBrowser = configItems[3];
        this.argsForForcedBrowserWindow = configItems.length == 5 ? configItems[4] : configItems[2];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("display name=");
        buf.append(this.browserName);
        buf.append(" executable name=");
        buf.append(this.browserArgName);
        buf.append(" argsForStartBrowser=");
        buf.append(this.argsForStartBrowser);
        buf.append(" argsForOpenBrowser=");
        buf.append(this.argsForOpenBrowser);
        return buf.toString();
    }

    private String[] getCommandLineArgs(String argsString, String urlString) {
        argsString = LaunchingUtils.replaceArgs(argsString, this.browserArgName, urlString);
        return argsString.split("[ ]");
    }

    @Override
    public String getBrowserDisplayName() {
        return this.browserName;
    }

    @Override
    public String getBrowserApplicationName() {
        return this.browserArgName;
    }

    @Override
    public String[] getArgsForOpenBrowser(String urlString) {
        String argsStartString = this.argsForOpenBrowser != null && this.argsForOpenBrowser.length() > 0 ? this.argsForOpenBrowser : this.argsForStartBrowser;
        return this.getCommandLineArgs(argsStartString, urlString);
    }

    @Override
    public String[] getArgsForStartingBrowser(String urlString) {
        return this.getCommandLineArgs(this.argsForStartBrowser, urlString);
    }

    @Override
    public String[] getArgsForForcingNewBrowserWindow(String urlString) {
        return this.getCommandLineArgs(this.argsForForcedBrowserWindow, urlString);
    }

    @Override
    public boolean isBrowserAvailable(AbstractLogger logger) {
        boolean isAvailable = true;
        return isAvailable;
    }
}

