/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserEventCallBack;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import net.sf.wraplog.AbstractLogger;

public class UnixNetscapeBrowserLaunching
implements IBrowserLaunching {
    public static final String CONFIGFILE_LINUX_UNIX = "/edu/stanford/ejalbert/launching/misc/linuxUnixConfig.properties";
    private Map unixBrowsers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final AbstractLogger logger;
    private final String configFileName;
    private boolean forceNewWindow = false;
    protected IBrowserEventCallBack browserEventCallback = null;

    public UnixNetscapeBrowserLaunching(AbstractLogger logger, String configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("config file cannot be null");
        }
        this.logger = logger;
        this.configFileName = configFile;
    }

    protected StandardUnixBrowser getBrowser(String key) {
        return (StandardUnixBrowser)this.unixBrowsers.get(key);
    }

    protected boolean openUrlWithBrowser(UnixBrowser unixBrowser, String urlString) throws BrowserLaunchingExecutionException {
        boolean success = false;
        this.logger.info(unixBrowser.getBrowserDisplayName());
        this.logger.info(urlString);
        try {
            String[] args;
            int attemptId = this.browserEventCallback.getOpenAttemptId();
            int exitCode = -1;
            Process process = null;
            if (!this.forceNewWindow) {
                args = unixBrowser.getArgsForOpenBrowser(urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(args).toString());
                }
                process = Runtime.getRuntime().exec(args);
                this.browserEventCallback.fireBrowserEvent(1, attemptId, process, unixBrowser.getBrowserApplicationName(), urlString);
                exitCode = process.waitFor();
            }
            if (this.forceNewWindow && exitCode != 0) {
                args = unixBrowser.getArgsForForcingNewBrowserWindow(urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(args).toString());
                }
                process = Runtime.getRuntime().exec(args);
                this.browserEventCallback.fireBrowserEvent(1, attemptId, process, unixBrowser.getBrowserApplicationName(), urlString);
                exitCode = process.waitFor();
            }
            if (exitCode != 0) {
                args = unixBrowser.getArgsForStartingBrowser(urlString);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(Arrays.asList(args).toString());
                }
                process = Runtime.getRuntime().exec(args);
                this.browserEventCallback.fireBrowserEvent(1, attemptId, process, unixBrowser.getBrowserApplicationName(), urlString);
                exitCode = process.waitFor();
            }
            if (exitCode == 0) {
                success = true;
            }
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
        return success;
    }

    @Override
    public void setBrowserEventCallBack(IBrowserEventCallBack callback) {
        this.browserEventCallback = callback;
    }

    @Override
    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            URL configUrl = this.getClass().getResource(this.configFileName);
            if (configUrl == null) {
                throw new BrowserLaunchingInitializingException("unable to find config file: " + this.configFileName);
            }
            StringBuffer potentialBrowserNames = new StringBuffer();
            Properties configProps = new Properties();
            configProps.load(configUrl.openStream());
            String sepChar = configProps.getProperty("delimchar");
            for (String string : configProps.keySet()) {
                if (!string.startsWith("browser.")) continue;
                StandardUnixBrowser browser = new StandardUnixBrowser(sepChar, configProps.getProperty(string));
                if (browser.isBrowserAvailable(this.logger)) {
                    this.unixBrowsers.put(browser.getBrowserDisplayName(), browser);
                    continue;
                }
                if (potentialBrowserNames.length() > 0) {
                    potentialBrowserNames.append("; ");
                }
                potentialBrowserNames.append(browser.getBrowserDisplayName());
            }
            if (this.unixBrowsers.size() == 0) {
                throw new BrowserLaunchingInitializingException("one of the supported browsers must be installed: " + potentialBrowserNames);
            }
            this.logger.info(this.unixBrowsers.keySet().toString());
            this.unixBrowsers = Collections.unmodifiableMap(this.unixBrowsers);
        }
        catch (IOException ioex) {
            throw new BrowserLaunchingInitializingException(ioex);
        }
    }

    @Override
    public void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            UnixBrowser unixBrowser;
            this.logger.info(urlString);
            boolean success = false;
            ArrayList unixBrowsersList = new ArrayList(this.unixBrowsers.values());
            String browserId = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            if (browserId != null && (unixBrowser = (UnixBrowser)this.unixBrowsers.get(browserId)) != null) {
                unixBrowsersList.add(0, unixBrowser);
            }
            Iterator iter = unixBrowsersList.iterator();
            while (iter.hasNext() && !success) {
                UnixBrowser browser = (UnixBrowser)iter.next();
                success = this.openUrlWithBrowser(browser, urlString);
            }
        }
        catch (Exception e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    @Override
    public void openUrl(String browser, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        UnixBrowser unixBrowser = (UnixBrowser)this.unixBrowsers.get(browser);
        if (unixBrowser == null || "Default".equals(browser)) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            boolean success = this.openUrlWithBrowser(unixBrowser, urlString);
            if (!success) {
                this.logger.debug("open browser failure, trying non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    @Override
    public void openUrl(List browsers, String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        if (browsers == null || browsers.isEmpty()) {
            this.logger.debug("falling through to non-targetted openUrl");
            this.openUrl(urlString);
        } else {
            boolean success = false;
            Iterator iter = browsers.iterator();
            while (iter.hasNext() && !success) {
                UnixBrowser unixBrowser = (UnixBrowser)this.unixBrowsers.get(iter.next());
                if (unixBrowser == null) continue;
                success = this.openUrlWithBrowser(unixBrowser, urlString);
            }
            if (!success) {
                this.logger.debug("none of listed browsers succeeded; falling through to non-targetted openUrl");
                this.openUrl(urlString);
            }
        }
    }

    @Override
    public List getBrowserList() {
        ArrayList<String> browsers = new ArrayList<String>();
        if (!this.unixBrowsers.containsKey("Default")) {
            browsers.add("Default");
        }
        browsers.addAll(this.unixBrowsers.keySet());
        return browsers;
    }

    @Override
    public boolean getNewWindowPolicy() {
        return this.forceNewWindow;
    }

    @Override
    public void setNewWindowPolicy(boolean forceNewWindow) {
        this.forceNewWindow = forceNewWindow;
    }
}

