/*
 * Decompiled with CFR 0.152.
 */
package deepview2;

import deepview2.dvArray;
import deepview2.dvBstr;
import deepview2.dvByte;
import deepview2.dvFloat;
import deepview2.dvFlt;
import deepview2.dvInteger;
import deepview2.dvNull;
import deepview2.dvObject;
import deepview2.dvShort;
import deepview2.dvTransmatrix;
import deepview2.dvTypeid;
import deepview2.dvUruobjectref;
import deepview2.dvUrustring;
import deepview2.guiTree;
import deepview2.nodeinfo;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Vector;
import prpobjects.Bstr;
import prpobjects.Transmatrix;
import prpobjects.Typeid;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import shared.Flt;
import shared.m;

public abstract class dvNode {
    Vector<dvNode> children = new Vector();
    nodeinfo info;

    public dvNode getChild(int index) {
        return this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getChildIndex(dvNode n) {
        return this.children.indexOf(n);
    }

    public boolean isLeaf() {
        return false;
    }

    public void loadChildren() {
    }

    public void startEdit() {
    }

    public void onSelect(guiTree tree) {
    }

    public void onDoubleClick(guiTree tree) {
    }

    public void onSave() throws Exception {
        m.throwUncaughtException("Unimplemented save: " + this.getClass().getName());
    }

    protected void save(Object newval) throws Exception {
        this.info.field.set(this.info.parent.obj, newval);
        this.info.rootobject.markAsChanged();
        this.info.prp.markAsChanged();
    }

    public static dvNode load(nodeinfo info) {
        if (info.obj == null) {
            return new dvNull(info.cls, info.name);
        }
        if (info.cls.isPrimitive()) {
            return new dvNull(info.cls, info.name);
        }
        if (info.cls.isArray()) {
            return new dvArray(info);
        }
        if (info.cls == Integer.class) {
            return new dvInteger(info);
        }
        if (info.cls == Bstr.class) {
            return new dvBstr(info);
        }
        if (info.cls == Urustring.class) {
            return new dvUrustring(info);
        }
        if (info.cls == Uruobjectref.class) {
            return new dvUruobjectref(info);
        }
        if (info.cls == Byte.class) {
            return new dvByte(info);
        }
        if (info.cls == Flt.class) {
            return new dvFlt(info);
        }
        if (info.cls == Short.class) {
            return new dvShort(info);
        }
        if (info.cls == Typeid.class) {
            return new dvTypeid(info);
        }
        if (info.cls == Float.class) {
            return new dvFloat(info);
        }
        if (info.cls == Transmatrix.class) {
            return new dvTransmatrix(info);
        }
        return new dvObject(info);
    }

    public static dvNode[] findChildren(nodeinfo info) {
        if (info.cls.isPrimitive()) {
            m.throwUncaughtException("Cannot load children of primitive.");
        }
        if (info.cls.isArray()) {
            m.throwUncaughtException("Cannot load children of array.");
        }
        AccessibleObject[] fields = info.cls.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        dvNode[] r = new dvNode[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            try {
                AccessibleObject curfield2 = fields[i];
                Object curfield = ((Field)curfield2).get(info.obj);
                Class<?> curclass = curfield != null ? curfield.getClass() : ((Field)curfield2).getType();
                String curname = ((Field)curfield2).getName();
                nodeinfo childinfo = new nodeinfo();
                childinfo.cls = curclass;
                childinfo.field = curfield2;
                childinfo.name = curname;
                childinfo.obj = curfield;
                childinfo.parent = info;
                childinfo.rootobject = info.rootobject;
                childinfo.prp = info.prp;
                childinfo.root = info.root;
                r[i] = dvNode.load(childinfo);
                continue;
            }
            catch (IllegalAccessException e2) {
                m.throwUncaughtException("Security problem.");
            }
        }
        return r;
    }
}

