/*
 * Decompiled with CFR 0.152.
 */
package dust.com.sun.java.swing.plaf.motif;

import dust.sun.swing.SwingUtilities2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import sun.awt.shell.ShellFolder;

public class MotifFileChooserUI
extends BasicFileChooserUI {
    private FilterComboBoxModel filterComboBoxModel;
    protected JList<File> directoryList = null;
    protected JList<File> fileList = null;
    protected JTextField pathField = null;
    protected JComboBox<FileFilter> filterComboBox = null;
    protected JTextField filenameTextField = null;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets insets = new Insets(10, 10, 10, 10);
    private static Dimension prefListSize = new Dimension(75, 150);
    private static Dimension WITH_ACCELERATOR_PREF_SIZE = new Dimension(650, 450);
    private static Dimension PREF_SIZE = new Dimension(350, 450);
    private static Dimension MIN_SIZE = new Dimension(200, 300);
    private static Dimension PREF_ACC_SIZE = new Dimension(10, 10);
    private static Dimension ZERO_ACC_SIZE = new Dimension(1, 1);
    private static Dimension MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    private static final Insets buttonMargin = new Insets(3, 3, 3, 3);
    private JPanel bottomPanel;
    protected JButton approveButton;
    private String enterFolderNameLabelText = null;
    private int enterFolderNameLabelMnemonic = 0;
    private String enterFileNameLabelText = null;
    private int enterFileNameLabelMnemonic = 0;
    private String filesLabelText = null;
    private int filesLabelMnemonic = 0;
    private String foldersLabelText = null;
    private int foldersLabelMnemonic = 0;
    private String pathLabelText = null;
    private int pathLabelMnemonic = 0;
    private String filterLabelText = null;
    private int filterLabelMnemonic = 0;
    private JLabel fileNameLabel;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.enterFolderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.enterFolderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.enterFileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.enterFileNameLabelMnemonic);
        }
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    public MotifFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(filename);
        }
    }

    @Override
    public String getDirectoryName() {
        return this.pathField.getText();
    }

    @Override
    public void setDirectoryName(String dirname) {
        this.pathField.setText(dirname);
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.getModel().validateFileCache();
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e2) {
                String prop = e2.getPropertyName();
                if (prop.equals("SelectedFileChangedProperty")) {
                    File f = (File)e2.getNewValue();
                    if (f != null) {
                        MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.getFileChooser().getName(f));
                    }
                } else if (prop.equals("SelectedFilesChangedProperty")) {
                    File[] files = (File[])e2.getNewValue();
                    JFileChooser fc = MotifFileChooserUI.this.getFileChooser();
                    if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
                        MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.fileNameString(files));
                    }
                } else if (prop.equals("fileFilterChanged")) {
                    MotifFileChooserUI.this.fileList.clearSelection();
                } else if (prop.equals("directoryChanged")) {
                    File currentDirectory;
                    MotifFileChooserUI.this.directoryList.clearSelection();
                    ListSelectionModel sm = MotifFileChooserUI.this.directoryList.getSelectionModel();
                    if (sm instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)sm).moveLeadSelectionIndex(0);
                        sm.setAnchorSelectionIndex(0);
                    }
                    MotifFileChooserUI.this.fileList.clearSelection();
                    sm = MotifFileChooserUI.this.fileList.getSelectionModel();
                    if (sm instanceof DefaultListSelectionModel) {
                        ((DefaultListSelectionModel)sm).moveLeadSelectionIndex(0);
                        sm.setAnchorSelectionIndex(0);
                    }
                    if ((currentDirectory = MotifFileChooserUI.this.getFileChooser().getCurrentDirectory()) != null) {
                        try {
                            MotifFileChooserUI.this.setDirectoryName(ShellFolder.getNormalizedFile((File)e2.getNewValue()).getPath());
                        }
                        catch (IOException ioe) {
                            MotifFileChooserUI.this.setDirectoryName(((File)e2.getNewValue()).getAbsolutePath());
                        }
                        if (MotifFileChooserUI.this.getFileChooser().getFileSelectionMode() == 1 && !MotifFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                            MotifFileChooserUI.this.setFileName(MotifFileChooserUI.this.getDirectoryName());
                        }
                    }
                } else if (prop.equals("fileSelectionChanged")) {
                    if (MotifFileChooserUI.this.fileNameLabel != null) {
                        MotifFileChooserUI.this.populateFileNameLabel();
                    }
                    MotifFileChooserUI.this.directoryList.clearSelection();
                } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
                    if (MotifFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                        MotifFileChooserUI.this.fileList.setSelectionMode(2);
                    } else {
                        MotifFileChooserUI.this.fileList.setSelectionMode(0);
                        MotifFileChooserUI.this.fileList.clearSelection();
                        MotifFileChooserUI.this.getFileChooser().setSelectedFiles(null);
                    }
                } else if (prop.equals("AccessoryChangedProperty")) {
                    if (MotifFileChooserUI.this.getAccessoryPanel() != null) {
                        JComponent accessory;
                        if (e2.getOldValue() != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().remove((JComponent)e2.getOldValue());
                        }
                        if ((accessory = (JComponent)e2.getNewValue()) != null) {
                            MotifFileChooserUI.this.getAccessoryPanel().add((Component)accessory, "Center");
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(PREF_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(MAX_SIZE);
                        } else {
                            MotifFileChooserUI.this.getAccessoryPanel().setPreferredSize(ZERO_ACC_SIZE);
                            MotifFileChooserUI.this.getAccessoryPanel().setMaximumSize(ZERO_ACC_SIZE);
                        }
                    }
                } else if (prop.equals("ApproveButtonTextChangedProperty") || prop.equals("ApproveButtonToolTipTextChangedProperty") || prop.equals("DialogTypeChangedProperty")) {
                    MotifFileChooserUI.this.approveButton.setText(MotifFileChooserUI.this.getApproveButtonText(MotifFileChooserUI.this.getFileChooser()));
                    MotifFileChooserUI.this.approveButton.setToolTipText(MotifFileChooserUI.this.getApproveButtonToolTipText(MotifFileChooserUI.this.getFileChooser()));
                } else if (prop.equals("ControlButtonsAreShownChangedProperty")) {
                    MotifFileChooserUI.this.doControlButtonsChanged(e2);
                } else if (prop.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e2.getNewValue();
                    JFileChooser cc = (JFileChooser)e2.getSource();
                    if (o != (ComponentOrientation)e2.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent c) {
        return new MotifFileChooserUI((JFileChooser)c);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener(this.getApproveSelectionAction());
        super.uninstallUI(c);
    }

    @Override
    public void installComponents(JFileChooser fc) {
        fc.setLayout(new BorderLayout(10, 10));
        fc.setAlignmentX(0.5f);
        JPanel interior = new JPanel(){

            @Override
            public Insets getInsets() {
                return insets;
            }
        };
        interior.setInheritsPopupMenu(true);
        this.align(interior);
        interior.setLayout(new BoxLayout(interior, 3));
        fc.add((Component)interior, "Center");
        JLabel l = new JLabel(this.pathLabelText);
        l.setDisplayedMnemonic(this.pathLabelMnemonic);
        this.align(l);
        interior.add(l);
        File currentDirectory = fc.getCurrentDirectory();
        String curDirName = null;
        if (currentDirectory != null) {
            curDirName = currentDirectory.getPath();
        }
        this.pathField = new JTextField(curDirName){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        this.pathField.setInheritsPopupMenu(true);
        l.setLabelFor(this.pathField);
        this.align(this.pathField);
        this.pathField.addActionListener(this.getUpdateAction());
        interior.add(this.pathField);
        interior.add(Box.createRigidArea(vstrut10));
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 2));
        this.align(centerPanel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 3));
        this.align(leftPanel);
        l = new JLabel(this.filterLabelText);
        l.setDisplayedMnemonic(this.filterLabelMnemonic);
        this.align(l);
        leftPanel.add(l);
        this.filterComboBox = new JComboBox<FileFilter>(){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        this.filterComboBox.setInheritsPopupMenu(true);
        l.setLabelFor(this.filterComboBox);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.filterComboBox.setModel(this.filterComboBoxModel);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.align(this.filterComboBox);
        leftPanel.add(this.filterComboBox);
        l = new JLabel(this.foldersLabelText);
        l.setDisplayedMnemonic(this.foldersLabelMnemonic);
        this.align(l);
        leftPanel.add(l);
        JScrollPane sp = this.createDirectoryList();
        sp.getVerticalScrollBar().setFocusable(false);
        sp.getHorizontalScrollBar().setFocusable(false);
        sp.setInheritsPopupMenu(true);
        l.setLabelFor(sp.getViewport().getView());
        leftPanel.add(sp);
        leftPanel.setInheritsPopupMenu(true);
        JPanel rightPanel = new JPanel();
        this.align(rightPanel);
        rightPanel.setLayout(new BoxLayout(rightPanel, 3));
        rightPanel.setInheritsPopupMenu(true);
        l = new JLabel(this.filesLabelText);
        l.setDisplayedMnemonic(this.filesLabelMnemonic);
        this.align(l);
        rightPanel.add(l);
        sp = this.createFilesList();
        l.setLabelFor(sp.getViewport().getView());
        rightPanel.add(sp);
        sp.setInheritsPopupMenu(true);
        centerPanel.add(leftPanel);
        centerPanel.add(Box.createRigidArea(hstrut10));
        centerPanel.add(rightPanel);
        centerPanel.setInheritsPopupMenu(true);
        JPanel accessoryPanel = this.getAccessoryPanel();
        JComponent accessory = fc.getAccessory();
        if (accessoryPanel != null) {
            if (accessory == null) {
                accessoryPanel.setPreferredSize(ZERO_ACC_SIZE);
                accessoryPanel.setMaximumSize(ZERO_ACC_SIZE);
            } else {
                this.getAccessoryPanel().add((Component)accessory, "Center");
                accessoryPanel.setPreferredSize(PREF_ACC_SIZE);
                accessoryPanel.setMaximumSize(MAX_SIZE);
            }
            this.align(accessoryPanel);
            centerPanel.add(accessoryPanel);
            accessoryPanel.setInheritsPopupMenu(true);
        }
        interior.add(centerPanel);
        interior.add(Box.createRigidArea(vstrut10));
        this.fileNameLabel = new JLabel();
        this.populateFileNameLabel();
        this.align(this.fileNameLabel);
        interior.add(this.fileNameLabel);
        this.filenameTextField = new JTextField(){

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getMaximumSize();
                d.height = this.getPreferredSize().height;
                return d;
            }
        };
        this.filenameTextField.setInheritsPopupMenu(true);
        this.fileNameLabel.setLabelFor(this.filenameTextField);
        this.filenameTextField.addActionListener(this.getApproveSelectionAction());
        this.align(this.filenameTextField);
        this.filenameTextField.setAlignmentX(0.0f);
        interior.add(this.filenameTextField);
        this.bottomPanel = this.getBottomPanel();
        this.bottomPanel.add((Component)new JSeparator(), "North");
        JPanel buttonPanel = new JPanel();
        this.align(buttonPanel);
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createGlue());
        this.approveButton = new JButton(this.getApproveButtonText(fc)){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(fc));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.approveButton.setInheritsPopupMenu(true);
        this.align(this.approveButton);
        this.approveButton.setMargin(buttonMargin);
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        buttonPanel.add(this.approveButton);
        buttonPanel.add(Box.createGlue());
        JButton updateButton = new JButton(this.updateButtonText){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        updateButton.setMnemonic(this.updateButtonMnemonic);
        updateButton.setToolTipText(this.updateButtonToolTipText);
        updateButton.setInheritsPopupMenu(true);
        this.align(updateButton);
        updateButton.setMargin(buttonMargin);
        updateButton.addActionListener(this.getUpdateAction());
        buttonPanel.add(updateButton);
        buttonPanel.add(Box.createGlue());
        JButton cancelButton = new JButton(this.cancelButtonText){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        cancelButton.setMnemonic(this.cancelButtonMnemonic);
        cancelButton.setToolTipText(this.cancelButtonToolTipText);
        cancelButton.setInheritsPopupMenu(true);
        this.align(cancelButton);
        cancelButton.setMargin(buttonMargin);
        cancelButton.addActionListener(this.getCancelSelectionAction());
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createGlue());
        JButton helpButton = new JButton(this.helpButtonText){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(MAX_SIZE.width, this.getPreferredSize().height);
            }
        };
        helpButton.setMnemonic(this.helpButtonMnemonic);
        helpButton.setToolTipText(this.helpButtonToolTipText);
        this.align(helpButton);
        helpButton.setMargin(buttonMargin);
        helpButton.setEnabled(false);
        helpButton.setInheritsPopupMenu(true);
        buttonPanel.add(helpButton);
        buttonPanel.add(Box.createGlue());
        buttonPanel.setInheritsPopupMenu(true);
        this.bottomPanel.add((Component)buttonPanel, "South");
        this.bottomPanel.setInheritsPopupMenu(true);
        if (fc.getControlButtonsAreShown()) {
            fc.add((Component)this.bottomPanel, "South");
        }
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel(new BorderLayout(0, 4));
        }
        return this.bottomPanel;
    }

    private void doControlButtonsChanged(PropertyChangeEvent e2) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.getFileChooser().add((Component)this.bottomPanel, "South");
        } else {
            this.getFileChooser().remove(this.getBottomPanel());
        }
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        if (this.filterComboBoxModel != null) {
            fc.removePropertyChangeListener(this.filterComboBoxModel);
        }
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.enterFolderNameLabelText = UIManager.getString((Object)"FileChooser.enterFolderNameLabelText", l);
        this.enterFolderNameLabelMnemonic = this.getMnemonic("FileChooser.enterFolderNameLabelMnemonic", l);
        this.enterFileNameLabelText = UIManager.getString((Object)"FileChooser.enterFileNameLabelText", l);
        this.enterFileNameLabelMnemonic = this.getMnemonic("FileChooser.enterFileNameLabelMnemonic", l);
        this.filesLabelText = UIManager.getString((Object)"FileChooser.filesLabelText", l);
        this.filesLabelMnemonic = this.getMnemonic("FileChooser.filesLabelMnemonic", l);
        this.foldersLabelText = UIManager.getString((Object)"FileChooser.foldersLabelText", l);
        this.foldersLabelMnemonic = this.getMnemonic("FileChooser.foldersLabelMnemonic", l);
        this.pathLabelText = UIManager.getString((Object)"FileChooser.pathLabelText", l);
        this.pathLabelMnemonic = this.getMnemonic("FileChooser.pathLabelMnemonic", l);
        this.filterLabelText = UIManager.getString((Object)"FileChooser.filterLabelText", l);
        this.filterLabelMnemonic = this.getMnemonic("FileChooser.filterLabelMnemonic", l);
    }

    private Integer getMnemonic(String key, Locale l) {
        return SwingUtilities2.getUIDefaultsInt((Object)key, l);
    }

    @Override
    protected void installIcons(JFileChooser fc) {
    }

    @Override
    protected void uninstallIcons(JFileChooser fc) {
    }

    protected JScrollPane createFilesList() {
        this.fileList = new JList();
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.fileList.setSelectionMode(2);
        } else {
            this.fileList.setSelectionMode(0);
        }
        this.fileList.setModel(new MotifFileListModel());
        this.fileList.getSelectionModel().removeSelectionInterval(0, 0);
        this.fileList.setCellRenderer(new FileCellRenderer());
        this.fileList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.fileList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.fileList));
        this.fileList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                int index;
                JFileChooser chooser = MotifFileChooserUI.this.getFileChooser();
                if (SwingUtilities.isLeftMouseButton(e2) && !chooser.isMultiSelectionEnabled() && (index = SwingUtilities2.loc2IndexFileList(MotifFileChooserUI.this.fileList, e2.getPoint())) >= 0) {
                    File file = MotifFileChooserUI.this.fileList.getModel().getElementAt(index);
                    MotifFileChooserUI.this.setFileName(chooser.getName(file));
                }
            }
        });
        this.align(this.fileList);
        JScrollPane scrollpane = new JScrollPane(this.fileList);
        scrollpane.setPreferredSize(prefListSize);
        scrollpane.setMaximumSize(MAX_SIZE);
        this.align(scrollpane);
        this.fileList.setInheritsPopupMenu(true);
        scrollpane.setInheritsPopupMenu(true);
        return scrollpane;
    }

    protected JScrollPane createDirectoryList() {
        this.directoryList = new JList();
        this.align(this.directoryList);
        this.directoryList.setCellRenderer(new DirectoryCellRenderer());
        this.directoryList.setModel(new MotifDirectoryListModel());
        this.directoryList.getSelectionModel().removeSelectionInterval(0, 0);
        this.directoryList.addMouseListener(this.createDoubleClickListener(this.getFileChooser(), this.directoryList));
        this.directoryList.addListSelectionListener(this.createListSelectionListener(this.getFileChooser()));
        this.directoryList.setInheritsPopupMenu(true);
        JScrollPane scrollpane = new JScrollPane(this.directoryList);
        scrollpane.setMaximumSize(MAX_SIZE);
        scrollpane.setPreferredSize(prefListSize);
        scrollpane.setInheritsPopupMenu(true);
        this.align(scrollpane);
        return scrollpane;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension prefSize = this.getFileChooser().getAccessory() != null ? WITH_ACCELERATOR_PREF_SIZE : PREF_SIZE;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefSize.width ? prefSize.width : d.width, d.height < prefSize.height ? prefSize.height : d.height);
        }
        return prefSize;
    }

    @Override
    public Dimension getMinimumSize(JComponent x) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void align(JComponent c) {
        c.setAlignmentX(0.0f);
        c.setAlignmentY(0.0f);
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<FileFilter>
    implements ComboBoxModel<FileFilter>,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = MotifFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e2) {
            String prop = e2.getPropertyName();
            if (prop.equals("ChoosableFileFilterChangedProperty")) {
                this.filters = (FileFilter[])e2.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop.equals("fileFilterChanged")) {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                MotifFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = MotifFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (FileFilter filter : this.filters) {
                    if (filter != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    MotifFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return MotifFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public FileFilter getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return MotifFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class MotifFileListModel
    extends AbstractListModel<File>
    implements ListDataListener {
        public MotifFileListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        @Override
        public int getSize() {
            return MotifFileChooserUI.this.getModel().getFiles().size();
        }

        public boolean contains(Object o) {
            return MotifFileChooserUI.this.getModel().getFiles().contains(o);
        }

        public int indexOf(Object o) {
            return MotifFileChooserUI.this.getModel().getFiles().indexOf(o);
        }

        @Override
        public File getElementAt(int index) {
            return MotifFileChooserUI.this.getModel().getFiles().elementAt(index);
        }

        @Override
        public void intervalAdded(ListDataEvent e2) {
            this.fireIntervalAdded(this, e2.getIndex0(), e2.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e2) {
            this.fireIntervalRemoved(this, e2.getIndex0(), e2.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getFiles().size() - 1);
        }

        @Override
        public void contentsChanged(ListDataEvent e2) {
            this.fireContentsChanged();
        }
    }

    protected class MotifDirectoryListModel
    extends AbstractListModel<File>
    implements ListDataListener {
        public MotifDirectoryListModel() {
            MotifFileChooserUI.this.getModel().addListDataListener(this);
        }

        @Override
        public int getSize() {
            return MotifFileChooserUI.this.getModel().getDirectories().size();
        }

        @Override
        public File getElementAt(int index) {
            return MotifFileChooserUI.this.getModel().getDirectories().elementAt(index);
        }

        @Override
        public void intervalAdded(ListDataEvent e2) {
            this.fireIntervalAdded(this, e2.getIndex0(), e2.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e2) {
            this.fireIntervalRemoved(this, e2.getIndex0(), e2.getIndex1());
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, 0, MotifFileChooserUI.this.getModel().getDirectories().size() - 1);
        }

        @Override
        public void contentsChanged(ListDataEvent e2) {
            this.fireContentsChanged();
        }
    }

    protected class DirectoryCellRenderer
    extends DefaultListCellRenderer {
        protected DirectoryCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)value));
            this.setInheritsPopupMenu(true);
            return this;
        }
    }

    protected class FileCellRenderer
    extends DefaultListCellRenderer {
        protected FileCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setText(MotifFileChooserUI.this.getFileChooser().getName((File)value));
            this.setInheritsPopupMenu(true);
            return this;
        }
    }
}

