/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.bouncycastle.crypto.StreamCipher;
import shared.IBytestream;
import shared.b;
import shared.nested;
import shared.uncaughtexception;

public class CryptoBytestream
extends IBytestream {
    InputStream in;
    StreamCipher cipher;

    public CryptoBytestream(InputStream in, StreamCipher cipher) {
        this.in = in;
        this.cipher = cipher;
    }

    @Override
    public void skip(long n) {
        throw new uncaughtexception("unimplemented");
    }

    @Override
    protected int read() {
        try {
            int r = this.in.read();
            if (r == -1) {
                throw new SocketException("Connection reset");
            }
            return b.ByteToInt32(this.cipher.returnByte((byte)r));
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    @Override
    public byte readByte() {
        try {
            int r = this.in.read();
            if (r == -1) {
                throw new SocketException("Connection reset");
            }
            return this.cipher.returnByte((byte)r);
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    @Override
    public byte[] readBytes(int num) {
        try {
            int count;
            byte[] r = new byte[num];
            for (int n = 0; n < num; n += count) {
                count = this.in.read(r, n, num - n);
                if (count != -1) continue;
                throw new SocketException("Connection reset");
            }
            byte[] r2 = new byte[num];
            this.cipher.processBytes(r, 0, r.length, r2, 0);
            return r2;
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    @Override
    public int readInt() {
        int ch1 = this.read();
        int ch2 = this.read();
        int ch3 = this.read();
        int ch4 = this.read();
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    @Override
    public short readShort() {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 0) + (ch2 << 8));
    }

    @Override
    public int getAbsoluteOffset() {
        return -1;
    }

    @Override
    public int getFilelength() {
        return -1;
    }

    @Override
    public int getBytesRemaining() {
        return -1;
    }

    @Override
    public IBytestream Fork(long offset) {
        throw new uncaughtexception("unimplemented");
    }

    public String toString() {
        try {
            return "available: " + Integer.toString(this.in.available());
        }
        catch (Exception e2) {
            return "exception";
        }
    }
}

