//	$Id: FFEXIF.h 380 2005-02-20 15:59:15Z ravemax $
//	Heavily based on exiftags.c

// The dump levels as typedef
typedef enum {
	TYPE_UNKNOWN	= 0x01, // ED_UNK
	TYPE_CAMERA		= 0x02, // ED_CAM
	TYPE_IMAGE		= 0x04, // ED_IMG
	TYPE_VERBOSE	= 0x08  // ED_VRB
} FFEXIFInfoType;

typedef enum {
	READ_RET_OK	= 0,
	READ_RET_FILE_NOT_FOUND,
	READ_RET_NO_EXIF_DATA,
	READ_JPEG_ERROR,
	READ_INTERNAL_ERROR
} FFReadReturnCode;


@interface NSObject (FFEXIFInfoHandler)

- (void)beginOfInfoType:(FFEXIFInfoType)type;
- (void)handleInfoWithName:(const char*)name andValue:(const char*)value;

@end

void setEXIFInfoHandler(id handler);
FFReadReturnCode readEXIF(NSString* filename);
