# Description: Makefile fragment for mpi-conduit, GASNET_PAR mode
# WARNING: This file is automatically generated - do NOT edit directly
# other/fragment-head.mak.  Generated from fragment-head.mak.in by configure.
# Copyright 2002, Dan Bonachea <bonachea@cs.berkeley.edu>
# Terms of use are as specified in license.txt

# ----------------------------------------------------------------------
# GASNet client usage instructions:
#
# Clients should include this file in their Makefile, using: (no leading '#')
#     include $(GASNET_PREFIX)/include/mpi-conduit/mpi-par.mak
# or alternatively, just:
#     include mpi-par.mak
# and use a -I$(GASNET_PREFIX)/include/mpi-conduit
# command-line option when invoking make
#
# Then in the Makefile, use a compile line something like one of these:
#  $(GASNET_CC)  $(GASNET_CPPFLAGS)    $(GASNET_CFLAGS)   -c myfile.c
#  $(GASNET_CXX) $(GASNET_CXXCPPFLAGS) $(GASNET_CXXFLAGS) -c myfile.cxx
#
# and a link line something like this:
#  $(GASNET_LD) $(GASNET_LDFLAGS) -o myfile myfile.o $(GASNET_LIBS)
# 
# For GASNet clients who need finer-grained control over compiler options,
#  GASNET_CFLAGS is an alias for: 
#     $(GASNET_OPT_CFLAGS) $(GASNET_MISC_CFLAGS)
#  GASNET_CPPFLAGS is an alias for: 
#     $(GASNET_MISC_CPPFLAGS) $(GASNET_DEFINES) $(GASNET_INCLUDES)
#  GASNET_CXXFLAGS is an alias for:
#     $(GASNET_OPT_CXXFLAGS) $(GASNET_MISC_CXXFLAGS)
#  GASNET_CXXCPPFLAGS is an alias for:
#     $(GASNET_MISC_CXXCPPFLAGS) $(GASNET_DEFINES) $(GASNET_INCLUDES)
# and those finer-grained variables can be used rather than the convenience aliases
#
# ----------------------------------------------------------------------

# ----------------------------------------------------------------------
# GASNet conduit-writer instructions:
#
# Most conduit-specific tweaks for these fragments can be accomplished 
# by setting specially-named variables in your conduit.mak file:
#
# * Variables of the form CONDUIT_WHATEVER will be added to the GASNET_WHATEVER
#   variable in the fragment.
#
# * Variables of the form CONDUIT_WHATEVER_<MODE> (where <MODE> is SEQ, PAR or PARSYNC)
#   will be added to the GASNET_WHATEVER variable for the <MODE> fragment only.
#
# * Settings which are contingent on whether the fragment is being used 
#   within the build tree or from an installed copy should be controlled using
#   the standard ###NO INSTALL### marker (without the internal space)
#
# * In the rare cases where a conduit needs to completely replace the 
#   default value for a GASNET_WHATEVER variable (rather than simply adding
#   to it), this can be accomplished by setting one of the GASNET_WHATEVER_OVERRIDE
#   variables in the conduit.mak file. Note this is only supported for the 
#   overridable variables listed below, and should only be used as a last resort
#   because it clobbers the default values established by configure and
#   complicates GASNet framework maintenance.
#
# ----------------------------------------------------------------------

GASNET_PREFIX = /opt/local

# ----------------------------------------------------------------------
# conduit-overridable variables 

GASNET_LD_OVERRIDE = $(GASNET_PREFIX)/bin/mpicc-mpich-gcc6 
GASNET_LDFLAGS_OVERRIDE = -O3 --param max-inline-insns-single=35000 --param inline-unit-growth=10000 --param large-function-growth=200000 -Winline -L$(GASNET_PREFIX)/lib -Wl,-headerpad_max_install_names -Wl,-multiply_defined,suppress -Wl,-no_pie

# ----------------------------------------------------------------------
# mpi-conduit/conduit.mak settings

# AMMPI is MPI-based, which requires us to link using the system MPI compiler
GASNET_LD_OVERRIDE = $(GASNET_PREFIX)/bin/mpicc-mpich-gcc6 
GASNET_LDFLAGS_OVERRIDE =  -O3 --param max-inline-insns-single=35000 --param inline-unit-growth=10000 --param large-function-growth=200000 -Winline -L$(GASNET_PREFIX)/lib -Wl,-headerpad_max_install_names -Wl,-multiply_defined,suppress -Wl,-no_pie


CONDUIT_LIBS = -lammpi 
# $Source: bitbucket.org:berkeleylab/gasnet.git/other/fragment-body.mak.in $
# ----------------------------------------------------------------------
# Following section other/fragment-body.mak.  Generated from fragment-body.mak.in by configure.

# ----------------------------------------------------------------------
# Directory-based options

GASNET_INCLUDES =  -I$(GASNET_PREFIX)/include -I$(GASNET_PREFIX)/include/mpi-conduit $(CONDUIT_INCLUDES) $(CONDUIT_INCLUDES_PAR)
GASNET_LIBDIRS = -L$(GASNET_PREFIX)/lib $(CONDUIT_LIBDIRS) $(CONDUIT_LIBDIRS_PAR)


# ----------------------------------------------------------------------
# C compiler and options

GASNET_CC = $(GASNET_PREFIX)/bin/mpicc-mpich-gcc6 

GASNET_OPT_CFLAGS = -O3 --param max-inline-insns-single=35000 --param inline-unit-growth=10000 --param large-function-growth=200000 -Winline $(CONDUIT_OPT_CFLAGS) $(CONDUIT_OPT_CFLAGS_PAR)
GASNET_MISC_CFLAGS =  $(CONDUIT_MISC_CFLAGS) $(CONDUIT_MISC_CFLAGS_PAR)
GASNET_MISC_CPPFLAGS =  $(CONDUIT_MISC_CPPFLAGS) $(CONDUIT_MISC_CPPFLAGS_PAR)

# ----------------------------------------------------------------------
# C++ compiler and options
# TODO: some options (especially CONDUIT_*) are not distinct from C compiler

GASNET_CXX = $(GASNET_PREFIX)/bin/mpicxx-mpich-gcc6 

GASNET_OPT_CXXFLAGS = -O2 $(CONDUIT_OPT_CFLAGS) $(CONDUIT_OPT_CFLAGS_PAR)
GASNET_MISC_CXXFLAGS =  $(CONDUIT_MISC_CFLAGS) $(CONDUIT_MISC_CFLAGS_PAR)
GASNET_MISC_CXXCPPFLAGS =  $(CONDUIT_MISC_CPPFLAGS) $(CONDUIT_MISC_CPPFLAGS_PAR)

# ----------------------------------------------------------------------
# Common defines

GASNET_EXTRADEFINES_SEQ = 
GASNET_EXTRADEFINES_PAR = -D_REENTRANT
GASNET_EXTRADEFINES_PARSYNC = -D_REENTRANT

GASNET_DEFINES = -DGASNET_PAR $(GASNET_EXTRADEFINES_PAR) $(CONDUIT_DEFINES) $(CONDUIT_DEFINES_PAR)

# ----------------------------------------------------------------------
# Documented compilation convenience aliases

GASNET_CFLAGS = $(GASNET_OPT_CFLAGS) $(GASNET_MISC_CFLAGS) $(MANUAL_CFLAGS)
GASNET_CPPFLAGS = $(GASNET_MISC_CPPFLAGS) $(GASNET_DEFINES) $(GASNET_INCLUDES)

GASNET_CXXFLAGS = $(GASNET_OPT_CXXFLAGS) $(GASNET_MISC_CXXFLAGS) $(MANUAL_CXXFLAGS)
GASNET_CXXCPPFLAGS = $(GASNET_MISC_CXXCPPFLAGS) $(GASNET_DEFINES) $(GASNET_INCLUDES)

# ----------------------------------------------------------------------
# linker and options

GASNET_LD = $(GASNET_LD_OVERRIDE)

# linker flags that GASNet clients should use 
GASNET_LDFLAGS = $(GASNET_LDFLAGS_OVERRIDE) $(CONDUIT_LDFLAGS) $(CONDUIT_LDFLAGS_PAR) $(MANUAL_LDFLAGS)

GASNET_EXTRALIBS_SEQ = 
GASNET_EXTRALIBS_PAR = 
GASNET_EXTRALIBS_PARSYNC = 

# libraries that GASNet clients should append to link line
GASNET_LIBS =                             \
    $(GASNET_LIBDIRS)                     \
    -lgasnet-mpi-par \
    $(CONDUIT_LIBS)                       \
    $(CONDUIT_LIBS_PAR)        \
    $(GASNET_EXTRALIBS_PAR)    \
                        \
    -L$(GASNET_PREFIX)/lib/gcc6/gcc/x86_64-apple-darwin15/6.4.0 -lgcc                              \
                                    \
                                    \
    $(MANUAL_LIBS)

# ----------------------------------------------------------------------
