/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.oauth.IOAuthToken;
import org.openstreetmap.josm.data.oauth.OAuth20Token;
import org.openstreetmap.josm.data.oauth.OAuthException;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.openstreetmap.josm.tools.XmlUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestAccessTokenTask
extends PleaseWaitRunnable {
    private final IOAuthToken tokenOAuth2;
    private boolean canceled;
    private final Component parent;
    private final String apiUrl;
    private HttpClient connection;

    public TestAccessTokenTask(Component parent, String apiUrl, IOAuthToken accessToken) {
        super(parent, I18n.tr("Testing OAuth Access Token", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(apiUrl, "apiUrl");
        CheckParameterUtil.ensureParameterNotNull(accessToken, "accessToken");
        this.tokenOAuth2 = accessToken;
        this.parent = parent;
        this.apiUrl = apiUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        TestAccessTokenTask testAccessTokenTask = this;
        synchronized (testAccessTokenTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected void sign(HttpClient con) throws OAuthException {
        this.tokenOAuth2.sign(con);
    }

    protected String normalizeApiUrl(String url) {
        url = url.trim();
        while (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf(47));
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserInfo getUserDetails() throws OsmOAuthAuthorizationException, XmlParsingException, OsmTransferException {
        boolean authenticatorEnabled = true;
        try {
            URL url = new URL(this.normalizeApiUrl(this.apiUrl) + "/0.6/user/details");
            authenticatorEnabled = DefaultAuthenticator.getInstance().isEnabled();
            DefaultAuthenticator.getInstance().setEnabled(false);
            HttpClient client = HttpClient.create(url);
            this.sign(client);
            TestAccessTokenTask testAccessTokenTask = this;
            synchronized (testAccessTokenTask) {
                this.connection = client;
                this.connection.connect();
            }
            String oauthKey = this.getAuthKey();
            if (this.connection.getResponse().getResponseCode() == 401) {
                throw new OsmApiException(401, I18n.tr("Retrieving user details with Access Token Key ''{0}'' was rejected.", oauthKey), null);
            }
            if (this.connection.getResponse().getResponseCode() == 403) {
                throw new OsmApiException(403, I18n.tr("Retrieving user details with Access Token Key ''{0}'' was forbidden.", oauthKey), null);
            }
            if (this.connection.getResponse().getResponseCode() != 200) {
                throw new OsmApiException(this.connection.getResponse().getResponseCode(), this.connection.getResponse().getHeaderField("Error"), null);
            }
            Document d = XmlUtils.parseSafeDOM(this.connection.getResponse().getContent());
            UserInfo userInfo = OsmServerUserInfoReader.buildFromXML(d);
            return userInfo;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new XmlParsingException(e);
        }
        catch (IOException e) {
            throw new OsmTransferException(e);
        }
        catch (OAuthException e) {
            throw new OsmOAuthAuthorizationException(e);
        }
        finally {
            DefaultAuthenticator.getInstance().setEnabled(authenticatorEnabled);
        }
    }

    protected void notifySuccess(UserInfo userInfo) {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Successfully used the Access Token ''{0}'' to<br>access the OSM server at ''{1}''.<br>You are accessing the OSM server as user ''{2}'' with id ''{3}''.</html>", this.getAuthKey(), this.apiUrl, Utils.escapeReservedCharactersHTML(userInfo.getDisplayName()), userInfo.getId()), I18n.tr("Success", new Object[0]), 1, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenOK"));
    }

    protected void alertFailedAuthentication() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to access the OSM server ''{0}''<br>with the Access Token ''{1}''.<br>The server rejected the Access Token as unauthorized. You will not<br>be able to access any protected resource on this server using this token.</html>", this.apiUrl, this.getAuthKey()), I18n.tr("Test failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenFailed"));
    }

    protected void alertFailedAuthorisation() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>The Access Token ''{1}'' is known to the OSM server ''{0}''.<br>The test to retrieve the user details for this token failed, though.<br>Depending on what rights are granted to this token you may nevertheless use it<br>to upload data, upload GPS traces, and/or access other protected resources.</html>", this.apiUrl, this.getAuthKey()), I18n.tr("Token allows restricted access", new Object[0]), 2, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenFailed"));
    }

    protected void alertFailedConnection() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to retrieve information about the current user from the OSM server ''{0}''.<br>This is probably not a problem caused by the tested Access Token, but<br>rather a problem with the server configuration. Carefully check the server<br>URL and your Internet connection.</html>", this.apiUrl, this.getAuthKey()), I18n.tr("Test failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenFailed"));
    }

    protected void alertFailedSigning() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>Failed to sign the request for the OSM server ''{0}'' with the token ''{1}''.<br>The token ist probably invalid.</html>", this.apiUrl, this.getAuthKey()), I18n.tr("Test failed", new Object[0]), 0, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenFailed"));
    }

    protected void alertInternalError() {
        HelpAwareOptionPane.showMessageDialogInEDT(this.parent, I18n.tr("<html>The test failed because the server responded with an internal error.<br>JOSM could not decide whether the token is valid. Please try again later.</html>", this.apiUrl, this.getAuthKey()), I18n.tr("Test failed", new Object[0]), 2, HelpUtil.ht("/Dialog/OAuthAuthorisationWizard#AccessTokenFailed"));
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            this.getProgressMonitor().indeterminateSubTask(I18n.tr("Retrieving user info...", new Object[0]));
            UserInfo userInfo = this.getUserDetails();
            if (this.canceled) {
                return;
            }
            this.notifySuccess(userInfo);
        }
        catch (OsmOAuthAuthorizationException e) {
            if (this.canceled) {
                return;
            }
            Logging.error(e);
            this.alertFailedSigning();
        }
        catch (OsmApiException e) {
            if (this.canceled) {
                return;
            }
            Logging.error(e);
            if (e.getResponseCode() == 500) {
                this.alertInternalError();
                return;
            }
            if (e.getResponseCode() == 401) {
                this.alertFailedAuthentication();
                return;
            }
            if (e.getResponseCode() == 403) {
                this.alertFailedAuthorisation();
                return;
            }
            this.alertFailedConnection();
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            Logging.error(e);
            this.alertFailedConnection();
        }
    }

    private String getAuthKey() {
        if (this.tokenOAuth2 instanceof OAuth20Token) {
            return ((OAuth20Token)this.tokenOAuth2).getBearerToken();
        }
        throw new IllegalArgumentException("Only OAuth2 tokens are understood: " + String.valueOf(this.tokenOAuth2));
    }
}

