/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.filechooser;

import com.install4j.runtime.filechooser.FileAccessMode;
import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.MultiFileFilter;
import com.install4j.runtime.filechooser.WindowsFileChooserHelper;
import com.install4j.runtime.installer.platform.win32.VistaFileChooser;
import com.install4j.runtime.util.SecondaryLoopHelper;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;

class WindowsFileChooser
extends FileChooser {
    private Collection<File> selectedFiles;

    WindowsFileChooser() {
    }

    @Override
    public boolean selectInternal() {
        VistaFileChooser vistaFileChooser = new VistaFileChooser(this.getFileAccessMode() == FileAccessMode.SAVE).includedOptions(0x42 | (this.isMultiple() ? 512 : 0) | (this.isFileHidingEnabled() ? 0 : 0x10000000)).title(this.getTitle()).button(this.getApproveButtonText()).directory(this.getCurrentDirectory()).fileName(this.getDefaultSelectedFile() != null ? this.getDefaultSelectedFile().getName() : null);
        VistaFileChooser.Question[] questions = WindowsFileChooserHelper.configureQuestions(vistaFileChooser, this);
        this.fillFilter(vistaFileChooser);
        File[] result = WindowsFileChooser.showFileChooser(vistaFileChooser, this.getParent());
        WindowsFileChooserHelper.saveQuestions(questions, this);
        if (result != null && result.length > 0) {
            this.selectedFiles = Arrays.asList(result);
            return true;
        }
        this.selectedFiles = Collections.emptyList();
        return false;
    }

    private void fillFilter(VistaFileChooser vistaFileChooser) {
        if (!this.getFileFilters().isEmpty()) {
            VistaFileChooser.Filter[] filter = new VistaFileChooser.Filter[this.getFileFilters().size()];
            int arrayPos = 0;
            int selectedPos = 0;
            for (MultiFileFilter fileFilter : this.getFileFilters()) {
                if (fileFilter.equals(this.getSelectedFileFilter())) {
                    selectedPos = arrayPos;
                }
                StringBuilder spec = new StringBuilder();
                for (String suffix : fileFilter.getSuffixes()) {
                    if (spec.length() > 0) {
                        spec.append(';');
                    }
                    if (!fileFilter.isExact()) {
                        spec.append("*");
                    }
                    spec.append(suffix);
                }
                filter[arrayPos++] = new VistaFileChooser.Filter(fileFilter.getDescription(), spec.toString());
            }
            vistaFileChooser.filter(filter).selectedFilter(selectedPos);
        }
    }

    @Override
    protected Collection<File> getSelectedFilesInternal() {
        return this.selectedFiles;
    }

    static File[] showFileChooser(final VistaFileChooser vistaFileChooser, final Window parent) {
        return SecondaryLoopHelper.executeWithSecondaryLoop(new Callable<File[]>(){

            @Override
            public File[] call() throws Exception {
                return vistaFileChooser.show(parent);
            }
        });
    }
}

