/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.awt.Color;
import java.util.Arrays;
import mediathek.config.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListeProg;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MVMessageDialog;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DatenPset
implements Comparable<DatenPset> {
    public static final int PROGRAMMSET_NAME = 0;
    public static final int PROGRAMMSET_PRAEFIX_DIREKT = 1;
    public static final int PROGRAMMSET_SUFFIX_DIREKT = 2;
    public static final int PROGRAMMSET_FARBE = 3;
    public static final int PROGRAMMSET_ZIEL_PFAD = 4;
    public static final int PROGRAMMSET_ZIEL_DATEINAME = 5;
    public static final int PROGRAMMSET_THEMA_ANLEGEN = 6;
    public static final int PROGRAMMSET_IST_ABSPIELEN = 7;
    public static final int PROGRAMMSET_IST_SPEICHERN = 8;
    public static final int PROGRAMMSET_IST_BUTTON = 9;
    public static final int PROGRAMMSET_IST_ABO = 10;
    public static final int PROGRAMMSET_LAENGE_BESCHRAENKEN = 11;
    public static final int PROGRAMMSET_LAENGE_FIELD_BESCHRAENKEN = 12;
    public static final int PROGRAMMSET_MAX_LAENGE = 13;
    public static final int PROGRAMMSET_MAX_LAENGE_FIELD = 14;
    public static final int PROGRAMMSET_AUFLOESUNG = 15;
    public static final int PROGRAMMSET_ADD_ON = 16;
    public static final int PROGRAMMSET_BESCHREIBUNG = 17;
    public static final int PROGRAMMSET_INFODATEI = 19;
    public static final int PROGRAMMSET_SPOTLIGHT = 20;
    public static final int PROGRAMMSET_SUBTITLE = 21;
    public static final String TAG = "Programmset";
    public static final int MAX_ELEM = 22;
    public static final String[] COLUMN_NAMES = new String[]{"Setname", "Pr\u00e4fix", "Suffix", "Farbe", "Zielpfad", "Zieldateiname", "Thema anlegen", "Abspielen", "Speichern", "Button", "Abo", "L\u00e4nge", "L\u00e4nge Feld", "max L\u00e4nge", "max L\u00e4nge Feld", "Aufl\u00f6sung", "AddOn", "Beschreibung", "Url Info", "Infodatei", "Spotlight", "Untertitel"};
    public static final String[] XML_NAMES = new String[]{"Name", "Praefix", "Suffix", "Farbe", "Zielpfad", "Zieldateiname", "Thema-anlegen", "Abspielen", "Speichern", "Button", "Abo", "Laenge", "Laenge-Feld", "max-Laenge", "max-Laenge-Feld", "Aufloesung", "AddOn", "Beschreibung", "Info-URL", "Infodatei", "Spotlight", "Untertitel"};
    private static final Logger logger = LogManager.getLogger();
    public static boolean[] spaltenAnzeigen = new boolean[22];
    private final ListeProg listeProg = new ListeProg();
    public String[] arr;

    public DatenPset() {
        this.initialize();
    }

    public DatenPset(String name) {
        this.initialize();
        this.arr[0] = name;
        this.arr[9] = Boolean.TRUE.toString();
    }

    public boolean addProg(DatenProg prog) {
        return this.listeProg.add(prog);
    }

    public ListeProg getListeProg() {
        return this.listeProg;
    }

    public DatenProg getProg(int i) {
        return (DatenProg)this.listeProg.get(i);
    }

    public boolean progsContainPath() {
        boolean ret = false;
        for (DatenProg prog : this.listeProg) {
            if (!prog.arr[3].contains("**") && !prog.arr[3].contains("%a") && !prog.arr[3].contains("%b")) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public boolean isEmpty() {
        boolean ret = true;
        for (String s2 : this.arr) {
            if (s2.isEmpty()) continue;
            ret = false;
        }
        if (!this.listeProg.isEmpty()) {
            ret = false;
        }
        return ret;
    }

    public boolean istAbspielen() {
        return Boolean.parseBoolean(this.arr[7]);
    }

    public boolean istSpeichern() {
        return Boolean.parseBoolean(this.arr[8]);
    }

    public boolean istButton() {
        return Boolean.parseBoolean(this.arr[9]);
    }

    public boolean istAbo() {
        return Boolean.parseBoolean(this.arr[10]);
    }

    public boolean isLabel() {
        if (this.listeProg.isEmpty()) {
            return !this.arr[0].isEmpty();
        }
        return false;
    }

    public boolean isFreeLine() {
        return this.arr[0].isEmpty();
    }

    public void setAbspielen() {
        for (DatenPset datenPset : Daten.listePset) {
            datenPset.arr[7] = Boolean.FALSE.toString();
        }
        this.arr[7] = Boolean.TRUE.toString();
    }

    public void setSpeichern(boolean set) {
        this.arr[8] = Boolean.toString(set);
    }

    public void setButton(boolean set) {
        this.arr[9] = Boolean.toString(set);
    }

    public void setAbo(boolean set) {
        this.arr[10] = Boolean.toString(set);
    }

    public DatenProg getProgUrl(String url) {
        DatenProg ret = null;
        if (this.listeProg.isEmpty()) {
            MVMessageDialog.showMessageDialog(null, "Programme einrichten!", "Kein Programm", 1);
        } else if (this.listeProg.size() == 1) {
            ret = (DatenProg)this.listeProg.getFirst();
        } else {
            for (DatenProg prog : this.listeProg) {
                if (!prog.urlTesten(url)) continue;
                ret = prog;
                break;
            }
            if (!this.listeProg.isEmpty() && ret == null) {
                ret = (DatenProg)this.listeProg.getLast();
            }
        }
        return ret;
    }

    public String getZielDateiname(String url) {
        DatenProg prog = this.getProgUrl(url);
        String ret = this.arr[5];
        if (!this.checkDownloadDirekt(url) && prog != null && !prog.arr[1].equals("")) {
            ret = prog.arr[1];
        }
        return ret;
    }

    public String getZielPfad() {
        return this.arr[4];
    }

    public DatenPset copy() {
        DatenPset ret = new DatenPset();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        ret.arr[0] = "Kopie-" + this.arr[0];
        ret.arr[7] = Boolean.toString(false);
        for (DatenProg prog : this.getListeProg()) {
            ret.addProg(prog.copy());
        }
        return ret;
    }

    public Color getFarbe() {
        Color ret = null;
        if (!this.arr[3].equals("")) {
            String r = this.arr[3].substring(0, this.arr[3].indexOf(44));
            String g2 = this.arr[3].substring(this.arr[3].indexOf(44) + 1, this.arr[3].lastIndexOf(44));
            String b = this.arr[3].substring(this.arr[3].lastIndexOf(44) + 1);
            try {
                ret = new Color(Integer.parseInt(r), Integer.parseInt(g2), Integer.parseInt(b));
            }
            catch (Exception ex) {
                logger.error("getFarbe()", (Throwable)ex);
            }
        }
        return ret;
    }

    public void setFarbe(Color farbe) {
        this.arr[3] = farbe.getRed() + "," + farbe.getGreen() + "," + farbe.getBlue();
    }

    public boolean checkDownloadDirekt(String url) {
        if (!this.arr[1].equals("") || !this.arr[2].equals("")) {
            return GuiFunktionenProgramme.praefixTesten(this.arr[1], url, true) && GuiFunktionenProgramme.praefixTesten(this.arr[2], url, false);
        }
        return false;
    }

    public String toString() {
        Object ret = "";
        ret = (String)ret + "================================================" + System.lineSeparator();
        ret = (String)ret + "| Programmset" + System.lineSeparator();
        for (int i = 0; i < 22; ++i) {
            ret = (String)ret + "| " + COLUMN_NAMES[i] + ": " + this.arr[i] + System.lineSeparator();
        }
        for (Object aListeProg : this.listeProg) {
            ret = (String)ret + "|" + System.lineSeparator();
            ret = (String)ret + aListeProg.toString();
        }
        ret = (String)ret + "|_______________________________________________" + System.lineSeparator();
        return ret;
    }

    private void initialize() {
        this.arr = new String[22];
        Arrays.fill(this.arr, "");
        this.arr[6] = Boolean.toString(true);
        this.arr[7] = Boolean.toString(false);
        this.arr[8] = Boolean.toString(false);
        this.arr[9] = Boolean.toString(false);
        this.arr[10] = Boolean.toString(false);
        this.arr[11] = Boolean.toString(false);
        this.arr[12] = Boolean.toString(false);
        this.arr[19] = Boolean.toString(false);
        this.arr[20] = Boolean.toString(SystemUtils.IS_OS_MAC_OSX);
        this.arr[21] = Boolean.toString(false);
        this.arr[15] = FilmResolution.Enum.NORMAL.toString();
    }

    @Override
    public int compareTo(@NotNull DatenPset o) {
        return 0;
    }
}

