/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javax.swing.table.TableModel;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.tool.Filter;
import mediathek.tool.models.TModelFilm;
import org.jetbrains.annotations.NotNull;

public class GuiFilmeModelHelper {
    private final FilmActionPanel fap;
    private TModelFilm filmModel;
    private final ListeFilme listeFilme;
    private final SeenHistoryController historyController;
    private boolean searchThroughDescriptions;
    private boolean showNewOnly;
    private boolean showBookmarkedOnly;
    private boolean showSubtitlesOnly;
    private boolean showHqOnly;
    private boolean dontShowSeen;
    private boolean dontShowAbos;
    private boolean showLivestreamsOnly;
    private boolean dontShowTrailers;
    private boolean dontShowGebaerdensprache;
    private boolean dontShowAudioVersions;
    private long maxLength;
    private String[] arrIrgendwo;
    private long minLengthInSeconds;
    private long maxLengthInSeconds;

    public GuiFilmeModelHelper(@NotNull FilmActionPanel fap, @NotNull ListeFilme filteredList, @NotNull SeenHistoryController historyController) {
        this.fap = fap;
        this.historyController = historyController;
        this.listeFilme = filteredList;
    }

    private String getFilterThema() {
        String filterThema = (String)this.fap.themaBox.getSelectionModel().getSelectedItem();
        if (filterThema == null) {
            filterThema = "";
        }
        return filterThema;
    }

    private String[] evaluateThemaTitel() {
        String[] arrThemaTitel;
        String filterThemaTitel = this.fap.roSearchStringProperty.getValueSafe();
        if (Filter.isPattern(filterThemaTitel)) {
            arrThemaTitel = new String[]{filterThemaTitel};
        } else {
            arrThemaTitel = filterThemaTitel.split(",");
            for (int i = 0; i < arrThemaTitel.length; ++i) {
                arrThemaTitel[i] = arrThemaTitel[i].trim().toLowerCase();
            }
        }
        return arrThemaTitel;
    }

    private boolean noFiltersAreSet() {
        boolean ret = false;
        if (!(!this.fap.senderList.getCheckModel().isEmpty() || !this.getFilterThema().isEmpty() || !this.fap.roSearchStringProperty.getValueSafe().isEmpty() || (int)this.fap.filmLengthSlider.getLowValue() != 0 || (int)this.fap.filmLengthSlider.getHighValue() != 110 || this.fap.dontShowAbos.getValue().booleanValue() || this.fap.showUnseenOnly.getValue().booleanValue() || this.fap.showOnlyHd.getValue().booleanValue() || this.fap.showSubtitlesOnly.getValue().booleanValue() || this.fap.showLivestreamsOnly.getValue().booleanValue() || this.fap.showNewOnly.getValue().booleanValue() || this.fap.showBookMarkedOnly.getValue().booleanValue() || this.fap.dontShowTrailers.getValue().booleanValue() || this.fap.dontShowSignLanguage.getValue().booleanValue() || this.fap.dontShowAudioVersions.getValue().booleanValue())) {
            ret = true;
        }
        return ret;
    }

    private void updateFilterVars() {
        this.showNewOnly = this.fap.showNewOnly.getValue();
        this.showBookmarkedOnly = this.fap.showBookMarkedOnly.getValue();
        this.showSubtitlesOnly = this.fap.showSubtitlesOnly.getValue();
        this.showHqOnly = this.fap.showOnlyHd.getValue();
        this.dontShowSeen = this.fap.showUnseenOnly.getValue();
        this.dontShowAbos = this.fap.dontShowAbos.getValue();
        this.showLivestreamsOnly = this.fap.showLivestreamsOnly.getValue();
        this.dontShowTrailers = this.fap.dontShowTrailers.getValue();
        this.dontShowGebaerdensprache = this.fap.dontShowSignLanguage.getValue();
        this.dontShowAudioVersions = this.fap.dontShowAudioVersions.getValue();
        this.searchThroughDescriptions = this.fap.searchThroughDescription.getValue();
        this.arrIrgendwo = this.evaluateThemaTitel();
    }

    private void calculateFilmLengthSliderValues() {
        long minLength = (long)this.fap.filmLengthSlider.getLowValue();
        this.maxLength = (long)this.fap.filmLengthSlider.getHighValue();
        this.minLengthInSeconds = TimeUnit.SECONDS.convert(minLength, TimeUnit.MINUTES);
        this.maxLengthInSeconds = TimeUnit.SECONDS.convert(this.maxLength, TimeUnit.MINUTES);
    }

    private void performTableFiltering() {
        boolean searchFieldEmpty;
        this.updateFilterVars();
        this.calculateFilmLengthSliderValues();
        String filterThema = this.getFilterThema();
        ObservableList selectedSenders = this.fap.senderList.getCheckModel().getCheckedItems();
        if (this.dontShowSeen) {
            this.historyController.prepareMemoryCache();
        }
        Stream<Object> stream = this.listeFilme.parallelStream();
        if (!selectedSenders.isEmpty()) {
            HashSet senderSet = new HashSet(selectedSenders.size());
            senderSet.addAll(selectedSenders);
            stream = stream.filter(f -> senderSet.contains(f.getSender()));
        }
        if (this.showNewOnly) {
            stream = stream.filter(DatenFilm::isNew);
        }
        if (this.showBookmarkedOnly) {
            stream = stream.filter(DatenFilm::isBookmarked);
        }
        if (this.showLivestreamsOnly) {
            stream = stream.filter(DatenFilm::isLivestream);
        }
        if (this.showHqOnly) {
            stream = stream.filter(DatenFilm::isHighQuality);
        }
        if (this.dontShowTrailers) {
            stream = stream.filter(film -> !film.isTrailerTeaser());
        }
        if (this.dontShowGebaerdensprache) {
            stream = stream.filter(film -> !film.isSignLanguage());
        }
        if (this.dontShowAudioVersions) {
            stream = stream.filter(film -> !film.isAudioVersion());
        }
        if (this.dontShowAbos) {
            stream = stream.filter(film -> film.getAboName().isEmpty());
        }
        if (this.showSubtitlesOnly) {
            stream = stream.filter(this::subtitleCheck);
        }
        if (!filterThema.isEmpty()) {
            stream = stream.filter(film -> film.getThema().equalsIgnoreCase(filterThema));
        }
        if (this.maxLength < 110L) {
            stream = stream.filter(this::maxLengthCheck);
        }
        if (this.dontShowSeen) {
            stream = stream.filter(this::seenCheck);
        }
        stream = stream.filter(this::minLengthCheck);
        boolean bl = searchFieldEmpty = this.arrIrgendwo.length == 0;
        if (!searchFieldEmpty) {
            stream = stream.filter(this::finalStageFiltering);
        }
        List<DatenFilm> list = stream.collect(Collectors.toList());
        stream.close();
        this.filmModel = new TModelFilm(list.size());
        this.filmModel.addAll(list);
        list.clear();
        if (this.dontShowSeen) {
            this.historyController.emptyMemoryCache();
        }
    }

    private boolean subtitleCheck(DatenFilm film) {
        return film.hasSubtitle() || film.hasBurnedInSubtitles();
    }

    private boolean maxLengthCheck(DatenFilm film) {
        return film.getFilmLength() < this.maxLengthInSeconds;
    }

    private boolean seenCheck(DatenFilm film) {
        return !this.historyController.hasBeenSeenFromCache(film);
    }

    private boolean minLengthCheck(DatenFilm film) {
        long filmLength = film.getFilmLength();
        if (filmLength == 0L) {
            return true;
        }
        return filmLength >= this.minLengthInSeconds;
    }

    private boolean finalStageFiltering(DatenFilm film) {
        boolean result = this.searchThroughDescriptions && !film.getDescription().isEmpty() ? this.searchEntriesWithDescription(film) : this.searchEntries(film);
        return result;
    }

    private boolean searchEntries(DatenFilm film) {
        boolean result = false;
        if (Filter.pruefen(this.arrIrgendwo, film.getThema()) || Filter.pruefen(this.arrIrgendwo, film.getTitle())) {
            result = true;
        }
        return result;
    }

    private boolean searchEntriesWithDescription(DatenFilm film) {
        boolean result = false;
        if (Filter.pruefen(this.arrIrgendwo, film.getDescription()) || this.searchEntries(film)) {
            result = true;
        }
        return result;
    }

    public TableModel getFilteredTableModel() {
        if (!this.listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                this.filmModel = new TModelFilm(this.listeFilme.size());
                this.filmModel.addAll(this.listeFilme);
            } else {
                this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return this.filmModel;
    }
}

