/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.filmlist;

import java.util.Arrays;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mediathek.config.Daten;
import mediathek.daten.FilmListMetaData;
import mediathek.javafx.tool.ComputedLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lmediathek/javafx/filmlist/FilmListAgeLabel;", "Lmediathek/javafx/tool/ComputedLabel;", "()V", "oldAge", "Lmediathek/javafx/filmlist/FilmListAgeLabel$FilmListAge;", "timeline", "Ljavafx/animation/Timeline;", "calculateAge", "computeAgeString", "", "age", "setAgeToLabel", "", "FilmListAge", "MediathekView"})
public final class FilmListAgeLabel
extends ComputedLabel {
    private final Timeline timeline = new Timeline(new KeyFrame(Duration.millis(1000.0), new EventHandler<ActionEvent>(this){
        final /* synthetic */ FilmListAgeLabel this$0;

        public final void handle(ActionEvent it) {
            FilmListAgeLabel.access$setAgeToLabel(this.this$0);
        }
        {
            this.this$0 = filmListAgeLabel;
        }
    }, new KeyValue[0]));
    private FilmListAge oldAge = new FilmListAge(0L, 0L);

    private final void setAgeToLabel() {
        FilmListAge listAge = this.calculateAge();
        if (Intrinsics.areEqual(listAge, this.oldAge) ^ true) {
            this.setComputedText(this.computeAgeString(listAge));
            this.oldAge = listAge;
        }
    }

    private final FilmListAge calculateAge() {
        Daten daten = Daten.getInstance();
        Intrinsics.checkNotNullExpressionValue(daten, "Daten.getInstance()");
        FilmListMetaData filmListMetaData = daten.getListeFilme().metaData();
        Intrinsics.checkNotNullExpressionValue(filmListMetaData, "Daten.getInstance().listeFilme.metaData()");
        java.time.Duration duration = java.time.Duration.ofSeconds(filmListMetaData.getAgeInSeconds());
        long minutes = duration.toMinutes();
        long hours = minutes / (long)60;
        return new FilmListAge(hours, minutes -= hours * (long)60);
    }

    private final String computeAgeString(FilmListAge age) {
        Object object;
        try {
            String string;
            boolean bl;
            Object[] objectArray;
            String string2;
            if (age.getHours() == 0L) {
                object = StringCompanionObject.INSTANCE;
                string2 = "Alter: %dm";
                objectArray = new Object[]{age.getMinutes()};
                bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(format, *args)");
            } else {
                object = StringCompanionObject.INSTANCE;
                string2 = "Alter: %dh %dm";
                objectArray = new Object[]{age.getHours(), age.getMinutes()};
                bl = false;
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue(string4, "java.lang.String.format(format, *args)");
            }
            object = string;
        }
        catch (IllegalArgumentException ex) {
            object = "Ung\u00fcltiges Alter";
        }
        return object;
    }

    public FilmListAgeLabel() {
        this.timeline.setCycleCount(-1);
        this.timeline.play();
        this.setTooltip(new Tooltip("Alter der Filmliste"));
    }

    public static final /* synthetic */ void access$setAgeToLabel(FilmListAgeLabel $this) {
        $this.setAgeToLabel();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lmediathek/javafx/filmlist/FilmListAgeLabel$FilmListAge;", "", "hours", "", "minutes", "(JJ)V", "getHours", "()J", "getMinutes", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "MediathekView"})
    private static final class FilmListAge {
        private final long hours;
        private final long minutes;

        public final long getHours() {
            return this.hours;
        }

        public final long getMinutes() {
            return this.minutes;
        }

        public FilmListAge(long hours, long minutes) {
            this.hours = hours;
            this.minutes = minutes;
        }

        public final long component1() {
            return this.hours;
        }

        public final long component2() {
            return this.minutes;
        }

        @NotNull
        public final FilmListAge copy(long hours, long minutes) {
            return new FilmListAge(hours, minutes);
        }

        public static /* synthetic */ FilmListAge copy$default(FilmListAge filmListAge, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = filmListAge.hours;
            }
            if ((n & 2) != 0) {
                l2 = filmListAge.minutes;
            }
            return filmListAge.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "FilmListAge(hours=" + this.hours + ", minutes=" + this.minutes + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.hours) * 31 + Long.hashCode(this.minutes);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FilmListAge)) break block3;
                    FilmListAge filmListAge = (FilmListAge)object;
                    if (this.hours != filmListAge.hours || this.minutes != filmListAge.minutes) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

