/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.migrator;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SettingsMigrator {
    private static final Logger logger = LogManager.getLogger(SettingsMigrator.class);
    private final Path settingsFile;
    private final Configuration config = ApplicationConfiguration.getConfiguration();

    public SettingsMigrator(Path settingsFile) {
        this.settingsFile = settingsFile;
    }

    public void migrate() throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory2.newDocumentBuilder();
        Document document = builder.parse(this.settingsFile.toFile());
        document.getDocumentElement().normalize();
        Element root = document.getDocumentElement();
        NodeList systemNodeList = root.getElementsByTagName("system");
        if (systemNodeList.getLength() == 0) {
            logger.error("root element is empty");
            return;
        }
        Node systemNode = systemNodeList.item(0);
        NodeList systemChildNodeList = systemNode.getChildNodes();
        block16: for (int temp = 0; temp < systemChildNodeList.getLength(); ++temp) {
            String nodeName;
            Node node = systemChildNodeList.item(temp);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (nodeName = element.getNodeName()) {
                case "Bandwidthmonitor-visible": {
                    this.migrateBandwidthMonitorVisibility(element);
                    continue block16;
                }
                case "Tray-anzeigen": {
                    this.migrateShowTray(element);
                    continue block16;
                }
                case "system-anz-tage-filmilste": {
                    this.migrateFilmListAnzTage(element);
                    continue block16;
                }
                case "maxDownload": {
                    this.migrateMaxNumDownloads(element);
                    continue block16;
                }
                case "system-panel-videoplayer-anzeigen": {
                    this.migrateSystemPanelVideoplayerAnzeigen(element);
                    continue block16;
                }
                case "Blacklist-Geo-nicht-anzeigen": {
                    this.migrateDoNotShowGeoFilms(element);
                }
            }
        }
    }

    private void migrateDoNotShowGeoFilms(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("blacklist.show_geoblocked", result);
            logger.debug("migrateDoNotShowGeoFilms");
        }
    }

    private void migrateSystemPanelVideoplayerAnzeigen(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.buttons_panel.visible", result);
            logger.debug("migrateSystemPanelVideoplayerAnzeigen");
        }
    }

    private void migrateMaxNumDownloads(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            int maxDownloads;
            try {
                maxDownloads = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                maxDownloads = 1;
            }
            this.config.setProperty("download.max_simultaneous.number", maxDownloads);
            logger.debug("migrateMaxNumDownloads");
        }
    }

    private void migrateFilmListAnzTage(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            int anzahl;
            try {
                anzahl = Integer.parseInt(node.getNodeValue());
            }
            catch (NumberFormatException ex) {
                anzahl = 0;
            }
            this.config.setProperty("filmlist.load.days", anzahl);
            logger.debug("migrateFilmListAnzTage");
        }
    }

    private void migrateShowTray(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.ui.tray.use", result);
            logger.debug("migrateShowTray");
        }
    }

    private void migrateBandwidthMonitorVisibility(Element element) {
        Node node = element.getFirstChild();
        if (node != null) {
            boolean result = Boolean.parseBoolean(node.getNodeValue());
            this.config.setProperty("application.ui.bandwidth_monitor.visible", result);
            logger.debug("migrateBandwidthMonitorVisibility");
        }
    }
}

