/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.PasswordDialog;
import com.install4j.runtime.installer.helper.console.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class HttpAuthenticator
extends Authenticator {
    private static HttpAuthenticator authenticator;
    private static final boolean DEBUG;
    private static final String SYSPROP_SERVER_AUTH_USER = "serverAuthUser";
    private static final String SYSPROP_SERVER_AUTH_PASSWORD = "serverAuthPassword";
    private HttpRequestHandler httpRequestHandler;
    private int currentConnection;
    private int lastAuthConnection;

    public static synchronized HttpAuthenticator getInstance() {
        if (authenticator == null) {
            authenticator = new HttpAuthenticator();
            Authenticator.setDefault(authenticator);
        }
        return authenticator;
    }

    public static void setRequestHandler(HttpRequestHandler requestHandler) {
        if (DEBUG) {
            Util.logInfo(null, "HTTP request handler: " + requestHandler);
        }
        HttpAuthenticator instance = HttpAuthenticator.getInstance();
        instance.httpRequestHandler = requestHandler;
        ++instance.currentConnection;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.httpRequestHandler == null) {
            if (DEBUG) {
                Util.logInfo(null, "No HTTP request handler");
            }
            return null;
        }
        if (this.isServerAuthentication()) {
            if (DEBUG) {
                Util.logInfo(null, "Server auth");
            }
            return this.getServerAuthentication();
        }
        if (DEBUG) {
            Util.logInfo(null, "Proxy auth");
        }
        return this.getProxyAuthentication();
    }

    private boolean isServerAuthentication() {
        return HttpAuthenticator.getInstance().getRequestorType() == Authenticator.RequestorType.SERVER;
    }

    private PasswordAuthentication getServerAuthentication() {
        if (DEBUG) {
            Util.logInfo(null, "serverAuthUser: " + System.getProperty(SYSPROP_SERVER_AUTH_USER));
            Util.logInfo(null, "lastAuthConnection: " + this.lastAuthConnection);
            Util.logInfo(null, "currentConnection: " + this.currentConnection);
        }
        if (System.getProperty(SYSPROP_SERVER_AUTH_USER) != null && this.lastAuthConnection != this.currentConnection) {
            this.lastAuthConnection = this.currentConnection;
            return new PasswordAuthentication(System.getProperty(SYSPROP_SERVER_AUTH_USER), System.getProperty(SYSPROP_SERVER_AUTH_PASSWORD).toCharArray());
        }
        if (this.httpRequestHandler.getMode() == 1) {
            String[] credentials = PasswordDialog.getUserAndPassword(Util.getParentWindow(), null, this.getCredentialsMessage(), Messages.getString(".EnterCredentialsTitle"));
            if (credentials != null) {
                return new PasswordAuthentication(credentials[0], credentials[1].toCharArray());
            }
        } else if (this.httpRequestHandler.getMode() == 2) {
            ConsoleImpl console = ConsoleImpl.getInstance();
            console.println(this.getCredentialsMessage());
            try {
                String user = console.askString(Messages.getString(".UserName"), "");
                String password = console.askPassword(Messages.getString(".Password"), "");
                return new PasswordAuthentication(user, password.toCharArray());
            }
            catch (UserCanceledException userCanceledException) {}
        } else if (this.httpRequestHandler.getMode() == 3 && System.getProperty(SYSPROP_SERVER_AUTH_USER) == null) {
            System.err.println(Messages.getString(".ServerPasswordRequired"));
        }
        return null;
    }

    private PasswordAuthentication getProxyAuthentication() {
        block4: {
            try {
                if (ProxyConfig.getAuthPassword().trim().length() == 0) {
                    this.httpRequestHandler.askForProxyPassword();
                }
                if (!ProxyConfig.isCanceled()) {
                    return new PasswordAuthentication(ProxyConfig.getAuthUser(), ProxyConfig.getAuthPassword().toCharArray());
                }
            }
            catch (Exception e) {
                if (this.httpRequestHandler.getMode() != 3) break block4;
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private String getCredentialsMessage() {
        return Messages.format(Messages.getString(".EnterCredentialsLabel"), HttpAuthenticator.getInstance().getRequestingHost());
    }

    static {
        DEBUG = Boolean.getBoolean("install4j.debugAuthentication");
    }
}

