/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.DefaultCaret;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlTextPane
extends JTextPane {
    private CaretTarget caretTarget;

    public HtmlTextPane(CaretTarget caretTarget) {
        this.caretTarget = caretTarget;
        this.setEditable(false);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    GUIHelper.showURL(event.getURL().toExternalForm());
                }
            }
        });
        DefaultCaret caret = (DefaultCaret)this.getCaret();
        if (caretTarget == CaretTarget.UNCHANGED) {
            caret.setUpdatePolicy(1);
        }
    }

    public void updateText(String originalText) {
        String newText;
        String text = InstallerUtil.sanitizeHTML(originalText);
        try {
            newText = this.getText();
        }
        catch (Exception e) {
            newText = "";
        }
        if (!Objects.equals(newText, text)) {
            boolean html = text.toLowerCase(Locale.ENGLISH).contains("<html");
            if (html) {
                if (this.getEditorKit().getClass() != HTMLEditorKit.class) {
                    this.setEditorKit(new HTMLEditorKit());
                    Font font = UIManager.getFont("TextField.font");
                    StyleSheet css = ((HTMLDocument)this.getDocument()).getStyleSheet();
                    css.addRule("body {font-size : " + font.getSize() + "pt; }");
                    css.addRule("body {font-family :" + font.getFontName() + "; }");
                    css.addRule("body {background-color : #FFFFFF}");
                }
            } else {
                if (this.getEditorKit().getClass() != StyledEditorKit.class) {
                    this.setEditorKit(new StyledEditorKit());
                }
                this.setFont(UIManager.getFont("TextField.font"));
            }
            this.setText(text);
            if (this.caretTarget == CaretTarget.START) {
                this.setCaretPosition(0);
                this.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    public static enum CaretTarget {
        START,
        END,
        UNCHANGED;

    }
}

