/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.PartialLineBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class AlertLafHelper {
    public static final float TITLE_FONT_FACTOR = 1.25f;
    private static final Color TITLE_COLOR = AlertLafHelper.getTitleColor();
    public static boolean useWindowsIcons = false;
    private static final Color SEPARATOR_COLOR = GUIHelper.isDarculaLaF() ? UIManager.getColor("Separator.foreground") : new Color(223, 223, 223);
    private static Font alertFont;
    private static String[] availableFontFamilyNames;

    public static boolean isUseWindowsIcons() {
        return useWindowsIcons;
    }

    public static void setUseWindowsIcons(boolean useWindowsIcons) {
        AlertLafHelper.useWindowsIcons = useWindowsIcons;
    }

    private static Color getTitleColor() {
        if (GUIHelper.isLightCrossPlatformIntelliJLaF()) {
            return new Color(0, 94, 140);
        }
        if (GUIHelper.isDarculaLaF()) {
            return UIManager.getColor("darcula.foreground");
        }
        return new Color(0, 51, 153);
    }

    public static <T extends JComponent> T applyBottomSeparator(T component) {
        component.setBorder(new PartialLineBorder(SEPARATOR_COLOR, 1, 2));
        return component;
    }

    public static <T extends JComponent> T alertFont(T component) {
        if (!Boolean.getBoolean("ejt.noNativeDialogFont") && Util.isWindows()) {
            component.setFont(AlertLafHelper.getAlertFont());
        }
        return component;
    }

    public static Font getAlertFont() {
        if (alertFont == null) {
            String fontName = AlertLafHelper.getAlertFontName();
            alertFont = Util.isWindows() && GUIHelper.isWindowsLaF() && AlertLafHelper.isFontInstalled(fontName) ? new Font(fontName, 0, 12) : UIManager.getFont("Label.font");
        }
        return alertFont;
    }

    @NotNull
    private static String getAlertFontName() {
        Locale locale = Locale.getDefault();
        if (locale.equals(new Locale("zh", "CN"))) {
            return "Microsoft YaHei UI";
        }
        if (locale.equals(new Locale("zh", "TW"))) {
            return "Microsoft JhengHei UI";
        }
        if (locale.getLanguage().equals(new Locale("ko").getLanguage())) {
            return "Malgun Gothic";
        }
        if (locale.getLanguage().equals(new Locale("ja").getLanguage())) {
            return "Meiryo UI";
        }
        return "Segoe UI";
    }

    public static <T extends JComponent> T makeAlertTitleLabel(T component) {
        AlertLafHelper.alertFont(component);
        Font font = component.getFont();
        float size = font.getFamily().equals("Segoe UI") ? 16.0f : (float)font.getSize() * 1.25f;
        component.setFont(font.deriveFont(size));
        component.setForeground(TITLE_COLOR);
        return component;
    }

    public static boolean isFontInstalled(@NotNull String familyName) {
        if (availableFontFamilyNames == null) {
            GraphicsEnvironment g = GraphicsEnvironment.getLocalGraphicsEnvironment();
            availableFontFamilyNames = g.getAvailableFontFamilyNames();
        }
        for (String name : availableFontFamilyNames) {
            if (!name.equals(familyName)) continue;
            return true;
        }
        return false;
    }
}

