/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.filmInformation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URISyntaxException;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.daten.DatenFilm;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.sender_icon_cache.MVSenderIconCache;
import net.miginfocom.layout.CC;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tbee.javafx.scene.layout.MigPane;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0002()B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0010H\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0006\u0010$\u001a\u00020\u001cJ\u0010\u0010%\u001a\u00020\u001c2\b\u0010&\u001a\u0004\u0018\u00010\fJ\b\u0010'\u001a\u00020\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lmediathek/gui/filmInformation/InfoDialog;", "Ljavax/swing/JDialog;", "parent", "Ljava/awt/Window;", "(Ljava/awt/Window;)V", "cbHq", "Lmediathek/gui/filmInformation/InfoDialog$DisabledCheckBox;", "cbSubtitle", "config", "Lorg/apache/commons/configuration2/Configuration;", "kotlin.jvm.PlatformType", "currentFilm", "Lmediathek/daten/DatenFilm;", "hyperlink", "Ljavafx/scene/control/Hyperlink;", "lblAbo", "Ljavafx/scene/control/Label;", "lblDate", "lblDescription", "Ljavafx/scene/control/TextArea;", "lblDuration", "lblGeo", "lblSender", "lblSize", "lblThema", "lblTitle", "lblUhrzeit", "buildLayout", "", "clearControls", "createCopyUrlContextMenu", "Ljavafx/scene/control/ContextMenu;", "installContextMenu", "component", "restoreLocation", "saveLocation", "showInfo", "updateCurrentFilm", "film", "updateTextFields", "DisabledCheckBox", "RightOrientedLabel", "MediathekView"})
public final class InfoDialog
extends JDialog {
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private DatenFilm currentFilm;
    private final Label lblSender = new Label();
    private final Label lblThema = new Label();
    private final Label lblTitle = new Label();
    private final Label lblDate = new Label();
    private final Label lblUhrzeit = new Label();
    private final Label lblDuration = new Label();
    private final Label lblSize = new Label();
    private final DisabledCheckBox cbHq = new DisabledCheckBox();
    private final DisabledCheckBox cbSubtitle = new DisabledCheckBox();
    private final Label lblGeo = new Label();
    private final Label lblAbo = new Label();
    private final Hyperlink hyperlink = new Hyperlink("Hier klicken");
    private final TextArea lblDescription = new TextArea();

    private final void installContextMenu(Label component) {
        ContextMenu ctMenu = new ContextMenu();
        MenuItem mi = new MenuItem("Text in die Zwischenablage kopieren");
        mi.setOnAction(new EventHandler<ActionEvent>(component){
            final /* synthetic */ Label $component;

            public final void handle(ActionEvent it) {
                GuiFunktionen.copyToClipboard(this.$component.getText());
            }
            {
                this.$component = label;
            }
        });
        ctMenu.getItems().add(mi);
        component.setContextMenu(ctMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void restoreLocation() {
        this.config.lock(LockMode.READ);
        try {
            Point newLocation = new Point();
            newLocation.x = this.config.getInt("film.information.location.x");
            newLocation.y = this.config.getInt("film.information.location.y");
            this.setLocation(newLocation);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            this.config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveLocation() {
        if (!this.isVisible()) {
            return;
        }
        this.config.lock(LockMode.WRITE);
        try {
            Point location = this.getLocationOnScreen();
            this.config.setProperty("film.information.location.x", location.x);
            this.config.setProperty("film.information.location.y", location.y);
        }
        finally {
            this.config.unlock(LockMode.WRITE);
        }
    }

    public final void showInfo() {
        this.updateTextFields();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
    }

    private final void clearControls() {
        Platform.runLater(new Runnable(this){
            final /* synthetic */ InfoDialog this$0;

            public final void run() {
                InfoDialog.access$getLblDescription$p(this.this$0).setText("");
                InfoDialog.access$getLblAbo$p(this.this$0).setText("");
                InfoDialog.access$getLblGeo$p(this.this$0).setText("");
                InfoDialog.access$getLblSender$p(this.this$0).setText("");
                InfoDialog.access$getLblSender$p(this.this$0).setGraphic(null);
                InfoDialog.access$getLblSize$p(this.this$0).setText("");
                InfoDialog.access$getLblThema$p(this.this$0).setText("");
                InfoDialog.access$getLblTitle$p(this.this$0).setText("");
                InfoDialog.access$getLblDate$p(this.this$0).setText("");
                InfoDialog.access$getLblUhrzeit$p(this.this$0).setText("");
                InfoDialog.access$getLblDuration$p(this.this$0).setText("");
                InfoDialog.access$getCbHq$p(this.this$0).setSelected(false);
                InfoDialog.access$getCbSubtitle$p(this.this$0).setSelected(false);
                InfoDialog.access$getHyperlink$p(this.this$0).setTooltip(null);
                InfoDialog.access$getHyperlink$p(this.this$0).setDisable(true);
            }
            {
                this.this$0 = infoDialog;
            }
        });
    }

    private final void updateTextFields() {
        if (this.currentFilm == null) {
            this.clearControls();
        } else {
            Platform.runLater(new Runnable(this){
                final /* synthetic */ InfoDialog this$0;

                public final void run() {
                    DatenFilm datenFilm = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm);
                    String string = datenFilm.getDescription();
                    Intrinsics.checkNotNullExpressionValue(string, "currentFilm!!.description");
                    String $this$trim$iv = string;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    String desc = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    InfoDialog.access$getLblDescription$p(this.this$0).setText(desc);
                    InfoDialog.access$getLblDescription$p(this.this$0).setScrollTop(0.0);
                    InfoDialog.access$getLblDescription$p(this.this$0).setScrollLeft(0.0);
                    DatenFilm datenFilm2 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm2);
                    String string2 = datenFilm2.getSender();
                    Intrinsics.checkNotNullExpressionValue(string2, "currentFilm!!.sender");
                    MVSenderIconCache.get(string2, true).ifPresent(new Consumer<ImageIcon>(this){
                        final /* synthetic */ updateTextFields.1 this$0;

                        public final void accept(@Nullable ImageIcon icon) {
                            InfoDialog.access$getLblSender$p(this.this$0.this$0).setText("");
                            InfoDialog.access$getLblSender$p(this.this$0.this$0).setGraphic(new ImageView(SwingFXUtils.toFXImage(JavaFxUtils.toBufferedImage(icon), null)));
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Label label = InfoDialog.access$getLblGeo$p(this.this$0);
                    DatenFilm datenFilm3 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm3);
                    label.setText(datenFilm3.getGeo().orElse(""));
                    Label label2 = InfoDialog.access$getLblSize$p(this.this$0);
                    DatenFilm datenFilm4 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm4);
                    label2.setText(datenFilm4.getSize());
                    Label label3 = InfoDialog.access$getLblThema$p(this.this$0);
                    DatenFilm datenFilm5 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm5);
                    label3.setText(datenFilm5.getThema());
                    Label label4 = InfoDialog.access$getLblTitle$p(this.this$0);
                    DatenFilm datenFilm6 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm6);
                    label4.setText(datenFilm6.getTitle());
                    Label label5 = InfoDialog.access$getLblDate$p(this.this$0);
                    DatenFilm datenFilm7 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm7);
                    label5.setText(datenFilm7.getSendeDatum());
                    Label label6 = InfoDialog.access$getLblUhrzeit$p(this.this$0);
                    DatenFilm datenFilm8 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm8);
                    label6.setText(datenFilm8.getSendeZeit());
                    Label label7 = InfoDialog.access$getLblDuration$p(this.this$0);
                    DatenFilm datenFilm9 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm9);
                    label7.setText(datenFilm9.getDauer());
                    DisabledCheckBox disabledCheckBox = InfoDialog.access$getCbHq$p(this.this$0);
                    DatenFilm datenFilm10 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm10);
                    disabledCheckBox.setSelected(datenFilm10.isHighQuality());
                    DisabledCheckBox disabledCheckBox2 = InfoDialog.access$getCbSubtitle$p(this.this$0);
                    DatenFilm datenFilm11 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm11);
                    disabledCheckBox2.setSelected(datenFilm11.hasSubtitle());
                    Hyperlink hyperlink = InfoDialog.access$getHyperlink$p(this.this$0);
                    DatenFilm datenFilm12 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm12);
                    hyperlink.setTooltip(new Tooltip(datenFilm12.getWebsiteLink()));
                    InfoDialog.access$getHyperlink$p(this.this$0).setDisable(false);
                    Label label8 = InfoDialog.access$getLblAbo$p(this.this$0);
                    DatenFilm datenFilm13 = InfoDialog.access$getCurrentFilm$p(this.this$0);
                    Intrinsics.checkNotNull(datenFilm13);
                    label8.setText(datenFilm13.getAboName());
                }
                {
                    this.this$0 = infoDialog;
                }
            });
        }
    }

    public final void updateCurrentFilm(@Nullable DatenFilm film) {
        this.currentFilm = film;
        if (this.isVisible()) {
            this.updateTextFields();
        }
    }

    private final void buildLayout() {
        Container contentPane;
        Container container = contentPane = this.getContentPane();
        Intrinsics.checkNotNullExpressionValue(container, "contentPane");
        container.setLayout(new BorderLayout());
        JFXPanel newFxPanel = new JFXPanel();
        contentPane.add((Component)newFxPanel, "Center");
        Platform.runLater(new Runnable(this, newFxPanel){
            final /* synthetic */ InfoDialog this$0;
            final /* synthetic */ JFXPanel $newFxPanel;

            public final void run() {
                MigPane migPane = new MigPane("hidemode 3", "[fill,shrink 0][fill]", "[][][][][][][][][][][][][][fill,grow]");
                migPane.add((Node)new RightOrientedLabel("Sender:"), new CC().cell(0, 0));
                migPane.add((Node)InfoDialog.access$getLblSender$p(this.this$0), new CC().cell(1, 0));
                migPane.add((Node)new RightOrientedLabel("Thema:"), new CC().cell(0, 1));
                InfoDialog.access$getLblThema$p(this.this$0).setWrapText(true);
                InfoDialog.access$installContextMenu(this.this$0, InfoDialog.access$getLblThema$p(this.this$0));
                migPane.add((Node)InfoDialog.access$getLblThema$p(this.this$0), new CC().cell(1, 1).growY());
                migPane.add((Node)new RightOrientedLabel("Titel:"), new CC().cell(0, 2));
                InfoDialog.access$getLblTitle$p(this.this$0).setWrapText(true);
                InfoDialog.access$installContextMenu(this.this$0, InfoDialog.access$getLblTitle$p(this.this$0));
                migPane.add((Node)InfoDialog.access$getLblTitle$p(this.this$0), new CC().cell(1, 2).growY());
                migPane.add((Node)new RightOrientedLabel("Datum:"), new CC().cell(0, 3));
                migPane.add((Node)InfoDialog.access$getLblDate$p(this.this$0), new CC().cell(1, 3));
                migPane.add((Node)new RightOrientedLabel("Uhrzeit:"), new CC().cell(0, 4));
                migPane.add((Node)InfoDialog.access$getLblUhrzeit$p(this.this$0), new CC().cell(1, 4));
                migPane.add((Node)new RightOrientedLabel("Dauer:"), new CC().cell(0, 5));
                migPane.add((Node)InfoDialog.access$getLblDuration$p(this.this$0), new CC().cell(1, 5));
                migPane.add((Node)new RightOrientedLabel("Gr\u00f6\u00dfe (MB):"), new CC().cell(0, 6));
                migPane.add((Node)InfoDialog.access$getLblSize$p(this.this$0), new CC().cell(1, 6));
                migPane.add((Node)new RightOrientedLabel("HQ:"), new CC().cell(0, 7));
                migPane.add((Node)InfoDialog.access$getCbHq$p(this.this$0), new CC().cell(1, 7));
                migPane.add((Node)new RightOrientedLabel("Untertitel:"), new CC().cell(0, 8));
                migPane.add((Node)InfoDialog.access$getCbSubtitle$p(this.this$0), new CC().cell(1, 8));
                migPane.add((Node)new RightOrientedLabel("Geo:"), new CC().cell(0, 9));
                migPane.add((Node)InfoDialog.access$getLblGeo$p(this.this$0), new CC().cell(1, 9));
                migPane.add((Node)new RightOrientedLabel("Abo:"), new CC().cell(0, 10));
                migPane.add((Node)InfoDialog.access$getLblAbo$p(this.this$0), new CC().cell(1, 10));
                migPane.add((Node)new RightOrientedLabel("Website:"), new CC().cell(0, 11));
                migPane.add((Node)new RightOrientedLabel("Beschreibung:"), new CC().cell(0, 12));
                InfoDialog.access$getHyperlink$p(this.this$0).setContextMenu(InfoDialog.access$createCopyUrlContextMenu(this.this$0));
                InfoDialog.access$getHyperlink$p(this.this$0).setUnderline(true);
                InfoDialog.access$getHyperlink$p(this.this$0).setOnAction(new EventHandler<ActionEvent>(this){
                    final /* synthetic */ buildLayout.1 this$0;

                    public final void handle(ActionEvent it) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ buildLayout.1 this$0;

                            public final void run() {
                                if (InfoDialog.access$getCurrentFilm$p(this.this$0.this$0.this$0) != null) {
                                    try {
                                        DatenFilm datenFilm = InfoDialog.access$getCurrentFilm$p(this.this$0.this$0.this$0);
                                        Intrinsics.checkNotNull(datenFilm);
                                        UrlHyperlinkAction.openURL(null, datenFilm.getWebsiteLink());
                                    }
                                    catch (URISyntaxException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                migPane.add((Node)InfoDialog.access$getHyperlink$p(this.this$0), new CC().cell(1, 11));
                InfoDialog.access$getLblDescription$p(this.this$0).setWrapText(true);
                InfoDialog.access$getLblDescription$p(this.this$0).setPrefRowCount(4);
                InfoDialog.access$getLblDescription$p(this.this$0).setEditable(false);
                migPane.add((Node)InfoDialog.access$getLblDescription$p(this.this$0), new CC().cell(0, 13).spanX(2).growY().growX().minHeight("60"));
                this.$newFxPanel.setScene(new Scene(migPane));
            }
            {
                this.this$0 = infoDialog;
                this.$newFxPanel = jFXPanel;
            }
        });
    }

    private final ContextMenu createCopyUrlContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem mi = new MenuItem("URL kopieren");
        mi.setOnAction(new EventHandler<ActionEvent>(this){
            final /* synthetic */ InfoDialog this$0;

            public final void handle(ActionEvent it) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ createCopyUrlContextMenu.1 this$0;

                    public final void run() {
                        DatenFilm datenFilm = InfoDialog.access$getCurrentFilm$p(this.this$0.this$0);
                        Intrinsics.checkNotNull(datenFilm);
                        GuiFunktionen.copyToClipboard(datenFilm.getWebsiteLink());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = infoDialog;
            }
        });
        contextMenu.getItems().add(mi);
        return contextMenu;
    }

    public InfoDialog(@Nullable Window parent) {
        super(parent);
        this.setType(Window.Type.UTILITY);
        this.setTitle("Filminformation");
        this.setResizable(false);
        this.setSize(325, 520);
        this.setDefaultCloseOperation(2);
        this.buildLayout();
        this.updateTextFields();
        this.restoreLocation();
        boolean wasVisible = this.config.getBoolean("film.information.visible", false);
        if (wasVisible) {
            this.setVisible(true);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", true);
            }

            @Override
            public void windowClosed(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                config.setProperty("film.information.visible", false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                if (this.isVisible()) {
                    this.saveLocation();
                }
            }
        });
    }

    public static final /* synthetic */ TextArea access$getLblDescription$p(InfoDialog $this) {
        return $this.lblDescription;
    }

    public static final /* synthetic */ Label access$getLblAbo$p(InfoDialog $this) {
        return $this.lblAbo;
    }

    public static final /* synthetic */ Label access$getLblGeo$p(InfoDialog $this) {
        return $this.lblGeo;
    }

    public static final /* synthetic */ Label access$getLblSender$p(InfoDialog $this) {
        return $this.lblSender;
    }

    public static final /* synthetic */ Label access$getLblSize$p(InfoDialog $this) {
        return $this.lblSize;
    }

    public static final /* synthetic */ Label access$getLblThema$p(InfoDialog $this) {
        return $this.lblThema;
    }

    public static final /* synthetic */ Label access$getLblTitle$p(InfoDialog $this) {
        return $this.lblTitle;
    }

    public static final /* synthetic */ Label access$getLblDate$p(InfoDialog $this) {
        return $this.lblDate;
    }

    public static final /* synthetic */ Label access$getLblUhrzeit$p(InfoDialog $this) {
        return $this.lblUhrzeit;
    }

    public static final /* synthetic */ Label access$getLblDuration$p(InfoDialog $this) {
        return $this.lblDuration;
    }

    public static final /* synthetic */ DisabledCheckBox access$getCbHq$p(InfoDialog $this) {
        return $this.cbHq;
    }

    public static final /* synthetic */ DisabledCheckBox access$getCbSubtitle$p(InfoDialog $this) {
        return $this.cbSubtitle;
    }

    public static final /* synthetic */ Hyperlink access$getHyperlink$p(InfoDialog $this) {
        return $this.hyperlink;
    }

    public static final /* synthetic */ DatenFilm access$getCurrentFilm$p(InfoDialog $this) {
        return $this.currentFilm;
    }

    public static final /* synthetic */ void access$setCurrentFilm$p(InfoDialog $this, DatenFilm datenFilm) {
        $this.currentFilm = datenFilm;
    }

    public static final /* synthetic */ void access$installContextMenu(InfoDialog $this, Label component) {
        $this.installContextMenu(component);
    }

    public static final /* synthetic */ ContextMenu access$createCopyUrlContextMenu(InfoDialog $this) {
        return $this.createCopyUrlContextMenu();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$RightOrientedLabel;", "Ljavafx/scene/control/Label;", "label", "", "(Ljava/lang/String;)V", "MediathekView"})
    public static final class RightOrientedLabel
    extends Label {
        public RightOrientedLabel(@Nullable String label) {
            super(label);
            this.setAlignment(Pos.BASELINE_RIGHT);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lmediathek/gui/filmInformation/InfoDialog$DisabledCheckBox;", "Ljavafx/scene/control/CheckBox;", "()V", "MediathekView"})
    public static final class DisabledCheckBox
    extends CheckBox {
        public DisabledCheckBox() {
            this.setDisable(true);
        }
    }
}

