/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.tool.FileSize;
import okhttp3.HttpUrl;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0004J\u001c\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\"\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a8\u0006\u001b"}, d2={"Lmediathek/tool/MVInfoFile;", "", "()V", "appendFormattedTableLine", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sb", "formatString", "", "keyTitle", "value", "formatFilmAsString", "film", "Lmediathek/daten/DatenFilm;", "url", "Lokhttp3/HttpUrl;", "splitStringIntoMaxFixedLengthLines", "input", "lineLength", "", "writeInfoFile", "", "datenDownload", "Lmediathek/daten/DatenDownload;", "path", "Ljava/nio/file/Path;", "Companion", "MediathekView"})
public class MVInfoFile {
    private static final Logger logger;
    private static final String FILM_GROESSE = "Gr\u00f6\u00dfe";
    private static final String FILM_SENDER = "Sender";
    private static final String FILM_THEMA = "Thema";
    private static final String FILM_TITEL = "Titel";
    private static final String FILM_DATUM = "Datum";
    private static final String FILM_ZEIT = "Zeit";
    private static final String FILM_DAUER = "Dauer";
    private static final String FILM_URL = "URL";
    private static final int MAX_HEADER_LENGTH = 12;
    private static final int MAX_LINE_LENGTH = 62;
    @NotNull
    private static final Companion Companion;

    private final String formatFilmAsString(DatenFilm film, HttpUrl url) {
        if (film == null || url == null) {
            return "";
        }
        long fileSize = FileSize.getFileSizeFromUrl(url);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%%-%ds %%s";
        Object[] objectArray = new Object[]{12};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "java.lang.String.format(format, *args)");
        String formatString = string2;
        StringBuilder sb = new StringBuilder();
        sb = this.appendFormattedTableLine(sb, formatString, FILM_SENDER, film.getSender());
        StringBuilder stringBuilder = this.appendFormattedTableLine(sb, formatString, FILM_THEMA, film.getThema()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "appendFormattedTableLine\u2026d(System.lineSeparator())");
        sb = stringBuilder;
        StringBuilder stringBuilder2 = this.appendFormattedTableLine(sb, formatString, FILM_TITEL, film.getTitle()).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "appendFormattedTableLine\u2026d(System.lineSeparator())");
        sb = stringBuilder2;
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DATUM, film.getSendeDatum());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_ZEIT, film.getSendeZeit());
        sb = this.appendFormattedTableLine(sb, formatString, FILM_DAUER, film.getDauer());
        if (fileSize > (long)-1) {
            sb = this.appendFormattedTableLine(sb, formatString, FILM_GROESSE, FileUtils.byteCountToDisplaySize(fileSize));
        } else {
            sb.append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        sb.append("Website");
        sb.append(System.lineSeparator());
        sb.append(film.getWebsiteLink());
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(FILM_URL);
        sb.append(System.lineSeparator());
        sb.append(url);
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        sb.append(this.splitStringIntoMaxFixedLengthLines(film.getDescription(), 62));
        sb.append(System.lineSeparator());
        sb.append(System.lineSeparator());
        String string3 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "sb.toString()");
        return string3;
    }

    @NotNull
    protected final StringBuilder appendFormattedTableLine(@NotNull StringBuilder sb, @Nullable String formatString, @Nullable String keyTitle, @Nullable String value) {
        Intrinsics.checkNotNullParameter(sb, "sb");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = formatString;
        Intrinsics.checkNotNull(string);
        String string2 = string;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = StringCompanionObject.INSTANCE;
        String string3 = "%s:";
        Object[] objectArray3 = new Object[]{keyTitle};
        boolean bl = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray3, objectArray3.length));
        Intrinsics.checkNotNullExpressionValue(string4, "java.lang.String.format(format, *args)");
        objectArray[0] = string4;
        objectArray[1] = value;
        objectArray2 = objectArray;
        boolean bl2 = false;
        String string5 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue(string5, "java.lang.String.format(format, *args)");
        StringBuilder stringBuilder = sb.append(string5).append(System.lineSeparator());
        Intrinsics.checkNotNullExpressionValue(stringBuilder, "sb.append(String.format(\u2026d(System.lineSeparator())");
        return stringBuilder;
    }

    @NotNull
    protected final String splitStringIntoMaxFixedLengthLines(@Nullable String input, int lineLength) {
        String string = Optional.ofNullable(input).map((Function)new Function<String, String>(lineLength){
            final /* synthetic */ int $lineLength;

            public final String apply(@Nullable String s2) {
                return WordUtils.wrap(s2, this.$lineLength);
            }
            {
                this.$lineLength = n;
            }
        }).orElse("");
        Intrinsics.checkNotNullExpressionValue(string, "Optional.ofNullable(inpu\u2026              .orElse(\"\")");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeInfoFile(@Nullable DatenFilm film, @NotNull Path path, @Nullable HttpUrl url) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        logger.info("Infofile schreiben nach: {}", (Object)((Object)path.toAbsolutePath()).toString());
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "path.toFile()");
        file.getParentFile().mkdirs();
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new DataOutputStream(os);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                DataOutputStream dos = (DataOutputStream)closeable2;
                boolean bl6 = false;
                Closeable closeable3 = new OutputStreamWriter(dos);
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable3 = null;
                try {
                    OutputStreamWriter osw = (OutputStreamWriter)closeable3;
                    boolean bl9 = false;
                    Closeable closeable4 = new BufferedWriter(osw);
                    boolean bl10 = false;
                    boolean bl11 = false;
                    Throwable throwable4 = null;
                    try {
                        BufferedWriter br = (BufferedWriter)closeable4;
                        boolean bl12 = false;
                        br.write(this.formatFilmAsString(film, url));
                        br.flush();
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable4, throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally(closeable3, throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        logger.info("Infodatei geschrieben");
    }

    public final void writeInfoFile(@NotNull DatenDownload datenDownload) throws IOException {
        block0: {
            Intrinsics.checkNotNullParameter(datenDownload, "datenDownload");
            new File(datenDownload.arr[30]).mkdirs();
            Path path = Paths.get(datenDownload.getFileNameWithoutSuffix() + ".txt", new String[0]);
            DatenFilm film = datenDownload.film;
            String string = datenDownload.arr[21];
            Intrinsics.checkNotNullExpressionValue(string, "datenDownload.arr[DatenDownload.DOWNLOAD_URL]");
            HttpUrl url = HttpUrl.Companion.get(string);
            DatenFilm datenFilm = film;
            if (datenFilm == null) break block0;
            DatenFilm datenFilm2 = datenFilm;
            boolean bl = false;
            boolean bl2 = false;
            DatenFilm it = datenFilm2;
            boolean bl3 = false;
            Path path2 = path;
            Intrinsics.checkNotNullExpressionValue(path2, "path");
            this.writeInfoFile(it, path2, url);
        }
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger(MVInfoFile.class);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lmediathek/tool/MVInfoFile$Companion;", "", "()V", "FILM_DATUM", "", "FILM_DAUER", "FILM_GROESSE", "FILM_SENDER", "FILM_THEMA", "FILM_TITEL", "FILM_URL", "FILM_ZEIT", "MAX_HEADER_LENGTH", "", "MAX_LINE_LENGTH", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

