/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.styles;

import com.install4j.api.beans.Anchor;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.styles.ControlButton;
import com.install4j.api.styles.ControlButtonContainer;
import com.install4j.api.styles.StyleContext;
import com.install4j.api.styles.StyleContextReceiver;
import com.install4j.runtime.beans.AnchorUtil;
import com.install4j.runtime.beans.screens.SystemStyle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FormStyle
extends SystemStyle
implements FormPanelContainer {
    private JPanel formPanel;
    private FormEnvironment formEnvironment;
    private boolean fillHorizontal = true;
    private boolean fillVertical = true;
    private Anchor horizontalAnchor = Anchor.CENTER;
    private Anchor verticalAnchor = Anchor.CENTER;
    private boolean standalone = true;
    private StyleContext lastStyleContext;
    private List<Runnable> deferredRunnables = new ArrayList<Runnable>();

    @Override
    public boolean isFillHorizontal() {
        return this.replaceWithTextOverride("fillHorizontal", this.fillHorizontal);
    }

    public void setFillHorizontal(boolean fillHorizontal) {
        this.fillHorizontal = fillHorizontal;
    }

    @Override
    public boolean isFillVertical() {
        return this.replaceWithTextOverride("fillVertical", this.fillVertical);
    }

    public void setFillVertical(boolean fillVertical) {
        this.fillVertical = fillVertical;
    }

    public Anchor getHorizontalAnchor() {
        return this.replaceWithTextOverride("horizontalAnchor", this.horizontalAnchor, Anchor.class);
    }

    public void setHorizontalAnchor(Anchor horizontalAnchor) {
        this.horizontalAnchor = horizontalAnchor;
    }

    public Anchor getVerticalAnchor() {
        return this.replaceWithTextOverride("verticalAnchor", this.verticalAnchor, Anchor.class);
    }

    public void setVerticalAnchor(Anchor verticalAnchor) {
        this.verticalAnchor = verticalAnchor;
    }

    @Override
    public Anchor getAnchor() {
        return AnchorUtil.getAnchor(this.getHorizontalAnchor(), this.getVerticalAnchor());
    }

    @Override
    public boolean isStandalone() {
        return this.replaceWithTextOverride("standalone", this.standalone);
    }

    public void setStandalone(boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public void willActivate() {
        super.willActivate();
        if (this.getFormEnvironment() != null) {
            for (Runnable runnable : this.deferredRunnables) {
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.deferredRunnables.clear();
        }
    }

    @Override
    public void setControlButtonEnabled(final ControlButtonType controlButtonType, final boolean enabled) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                ((FormComponent)((Object)controlButton)).setEnabled(enabled);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonEnabled(controlButtonType, enabled);
            }
        });
    }

    @Override
    public void setControlButtonVisible(final ControlButtonType controlButtonType, final boolean visible) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                ((FormComponent)((Object)controlButton)).setVisible(visible);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonVisible(controlButtonType, visible);
            }
        });
    }

    @Override
    public void setControlButtonText(final ControlButtonType controlButtonType, final String text) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                controlButton.setControlButtonText(text);
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.setControlButtonText(controlButtonType, text);
            }
        });
    }

    @Override
    public void focusControlButton(final ControlButtonType controlButtonType) {
        this.visitControlButtons(controlButtonType, new ControlButtonVisitor(){

            @Override
            public void visit(ControlButton controlButton) {
                controlButton.focusControlButton();
            }
        });
        this.visitControlButtonContainers(new ControlButtonContainerVisitor(){

            @Override
            public void visit(ControlButtonContainer controlButtonContainer) {
                controlButtonContainer.focusControlButton(controlButtonType);
            }
        });
    }

    @Override
    public JComponent createComponent() {
        return this.formPanel;
    }

    @Override
    public void setStyleContext(StyleContext styleContext) {
        this.lastStyleContext = styleContext;
        if (this.getFormEnvironment() != null) {
            this.setStyleContext();
        }
    }

    @Override
    public void setFormPanel(JPanel formPanel, FormEnvironment formEnvironment) {
        this.formPanel = formPanel;
        AnchorUtil.setAlignments(formPanel, this.getAnchor());
        this.setFormEnvironment(formEnvironment);
        if (this.lastStyleContext != null) {
            this.setStyleContext();
        }
    }

    private void setStyleContext() {
        if (this.lastStyleContext != null) {
            StyleContextReceiver[] styleContextReceivers;
            for (StyleContextReceiver styleContextReceiver : styleContextReceivers = this.getFormEnvironment().getFormComponents(StyleContextReceiver.class)) {
                styleContextReceiver.setStyleContext(this.lastStyleContext);
            }
        }
    }

    @Override
    public boolean isScrollFormPanel() {
        return false;
    }

    @Override
    public FormEnvironment getFormEnvironment() {
        return this.replaceWithTextOverride("formEnvironment", this.formEnvironment, FormEnvironment.class);
    }

    private void visitControlButtons(final ControlButtonType controlButtonType, final ControlButtonVisitor visitor) {
        if (this.getFormEnvironment() != null) {
            ControlButton[] formComponents;
            for (ControlButton controlButton : formComponents = this.getFormEnvironment().getFormComponents(ControlButton.class)) {
                if (controlButton.getControlButtonType() != controlButtonType) continue;
                visitor.visit(controlButton);
            }
        } else {
            this.deferredRunnables.add(new Runnable(){

                @Override
                public void run() {
                    FormStyle.this.visitControlButtons(controlButtonType, visitor);
                }
            });
        }
    }

    private void visitControlButtonContainers(final ControlButtonContainerVisitor visitor) {
        if (this.getFormEnvironment() != null) {
            ControlButtonContainer[] formComponents;
            for (ControlButtonContainer controlButtonContainer : formComponents = this.getFormEnvironment().getFormComponents(ControlButtonContainer.class)) {
                visitor.visit(controlButtonContainer);
            }
        } else {
            this.deferredRunnables.add(new Runnable(){

                @Override
                public void run() {
                    FormStyle.this.visitControlButtonContainers(visitor);
                }
            });
        }
    }

    public void setFormEnvironment(FormEnvironment formEnvironment) {
        this.formEnvironment = formEnvironment;
    }

    private static interface ControlButtonContainerVisitor {
        public void visit(ControlButtonContainer var1);
    }

    private static interface ControlButtonVisitor {
        public void visit(ControlButton var1);
    }
}

