/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class CommonFileUtil {
    public static long pumpCharStream(Reader reader, Writer writer) throws IOException {
        int c;
        long count = 0L;
        while ((c = reader.read()) != -1) {
            if (writer != null) {
                writer.write(c);
            }
            ++count;
        }
        if (writer != null) {
            writer.flush();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static LinkedList<String> readLines(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            LinkedList<String> linkedList = CommonFileUtil.readLines(fis);
            return linkedList;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @NotNull
    public static LinkedList<String> readLines(InputStream fis) throws IOException {
        String line;
        LinkedList<String> lineList = new LinkedList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        while ((line = br.readLine()) != null) {
            while (line.endsWith("\r") || line.endsWith("\n")) {
                line = line.substring(0, line.length() - 1);
            }
            lineList.add(line);
        }
        return lineList;
    }
}

