/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class HtmlDisplayTextArea
extends JTextPane {
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public HtmlDisplayTextArea() {
        this.setEditable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.setRequestFocusEnabled(false);
        this.setMargin(NO_MARGIN);
        this.updateUI();
        this.setOpaque(false);
        this.setFocusable(false);
        this.setEditorKit(new HTMLEditorKit());
        Font font = UIManager.getFont("Label.font");
        StyleSheet css = ((HTMLDocument)this.getDocument()).getStyleSheet();
        css.addRule("body {color : #" + this.getHexValue(UIManager.getColor("Label.foreground")) + " }");
        css.addRule("body {font-size : " + font.getSize() + "pt; }");
        css.addRule("body {font-family :" + font.getFontName() + "; }");
    }

    private String getHexValue(Color color) {
        StringBuffer buffer = new StringBuffer();
        this.appendComponent(buffer, color.getRed());
        this.appendComponent(buffer, color.getGreen());
        this.appendComponent(buffer, color.getBlue());
        return buffer.toString();
    }

    private void appendComponent(StringBuffer buffer, int component) {
        buffer.append(StringUtil.padLeft(Integer.toHexString(component), '0', 2));
    }

    @Override
    public void setText(String text) {
        text = InstallerUtil.sanitizeHTML(text);
        super.setText(text);
    }
}

