/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.CustomDialog;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends CustomDialog
implements ActionListener {
    public static final String PASSWORD_TEXT_FIELD_NAME = "password";
    public static final String USER_TEXT_FIELD_NAME = "user";
    private static final Icon ICON = GUIHelper.loadIcon("lock_open_32.png");
    private static final int TEXT_FIELD_WIDTH = 350;
    private static final int TEXT_FIELD_WIDTH_USER = 250;
    private JButton btnOk;
    private JButton btnCancel;
    private DisplayTextArea displayTextArea;
    private String header;
    private String footer;
    private String title;
    private InputTextValidator inputTextValidator;
    private boolean user;
    private boolean canceled = true;
    private JTextField txtPassword;
    private JTextField txtUser;

    public static String getPassword(Window parentWindow, String header, String footer, String title, InputTextValidator inputTextValidator) {
        PasswordDialog inputDialog = PasswordDialog.createInputDialog(parentWindow, header, footer, title, inputTextValidator, false);
        inputDialog.setVisible(true);
        inputDialog.dispose();
        if (!inputDialog.isCanceled()) {
            return inputDialog.getPassword();
        }
        return null;
    }

    public static String[] getUserAndPassword(Window parentWindow, String header, String footer, String title) {
        PasswordDialog inputDialog = PasswordDialog.createInputDialog(parentWindow, header, footer, title, null, true);
        inputDialog.setVisible(true);
        inputDialog.dispose();
        if (!inputDialog.isCanceled()) {
            return new String[]{inputDialog.getUser(), inputDialog.getPassword()};
        }
        return null;
    }

    private static PasswordDialog createInputDialog(Window parentWindow, String header, String footer, String title, InputTextValidator inputTextValidator, boolean user) {
        PasswordDialog inputDialog;
        if (parentWindow instanceof Dialog) {
            inputDialog = new PasswordDialog((Dialog)parentWindow, header, footer, title, inputTextValidator, user);
        } else if (parentWindow instanceof Frame || parentWindow == null) {
            inputDialog = new PasswordDialog((Frame)parentWindow, header, footer, title, inputTextValidator, user);
        } else {
            throw new IllegalArgumentException();
        }
        return inputDialog;
    }

    private PasswordDialog(Frame parentWindow, String header, String footer, String title, InputTextValidator inputTextValidator, boolean user) {
        super((Window)parentWindow);
        this.init(header, footer, title, inputTextValidator, user);
    }

    private PasswordDialog(Dialog parentWindow, String header, String footer, String title, InputTextValidator inputTextValidator, boolean user) {
        super((Window)parentWindow);
        this.init(header, footer, title, inputTextValidator, user);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.btnOk) {
            this.doOk();
        } else if (source == this.btnCancel) {
            this.doCancel();
        }
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.canceled = true;
        }
        super.setVisible(visible);
    }

    private void init(String header, String footer, String title, InputTextValidator inputTextValidator, boolean user) {
        this.header = header;
        this.footer = footer;
        this.title = title;
        this.inputTextValidator = inputTextValidator;
        this.user = user;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setupAccelerators();
    }

    private void setupControls() {
        this.txtPassword = new JPasswordField();
        this.txtPassword.setName(PASSWORD_TEXT_FIELD_NAME);
        this.adjustPreferredSize(this.txtPassword);
        this.txtUser = new JTextField();
        this.txtUser.setName(USER_TEXT_FIELD_NAME);
        this.adjustPreferredSize(this.txtUser);
        this.btnOk = GUIHelper.adjustButton(new JButton(Messages.getString(".ButtonOK")));
        this.btnOk.setName("ok");
        this.btnCancel = GUIHelper.adjustButton(new JButton(Messages.getString(".ButtonCancel")));
        this.btnCancel.setName("cancel");
    }

    private void adjustPreferredSize(JTextField textField) {
        Dimension preferredSize = textField.getPreferredSize();
        preferredSize.width = this.user ? 250 : 350;
        textField.setPreferredSize(preferredSize);
    }

    private void setupComponent() {
        this.setModal(true);
        this.setTitle(this.title);
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.createContentPanel());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.pack();
        this.pack();
        this.setBounds(this.getFrameBounds());
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    @Override
    protected int getFrameWidth() {
        return -1;
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        Insets defaultInsets = new Insets(5, 5, 0, 5);
        Insets innerInsets = new Insets(0, 5, 0, 5);
        gc.insets = defaultInsets;
        gc.anchor = 21;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridheight = 2;
        panel.add((Component)new JLabel(ICON), gc);
        gc.gridx = 1;
        gc.gridheight = 1;
        gc.gridwidth = 2;
        if (this.header != null) {
            panel.add((Component)new JLabel(this.header), gc);
        }
        gc.gridwidth = 1;
        ++gc.gridy;
        if (this.user) {
            panel.add((Component)new JLabel(Messages.getString(".UserInfoName")), gc);
            ++gc.gridy;
            gc.insets = innerInsets;
            panel.add((Component)new JLabel(Messages.getString(".PasswordEditLabel")), gc);
            --gc.gridy;
            gc.insets = defaultInsets;
        }
        gc.gridx = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        if (this.user) {
            panel.add((Component)this.txtUser, gc);
            gc.insets = innerInsets;
            ++gc.gridy;
        }
        panel.add((Component)this.txtPassword, gc);
        gc.insets = defaultInsets;
        ++gc.gridy;
        gc.gridx = 1;
        gc.gridwidth = 2;
        gc.weighty = 1.0;
        gc.fill = 1;
        if (this.footer != null) {
            this.displayTextArea = new DisplayTextArea();
            this.displayTextArea.setText(this.footer);
            panel.add((Component)this.displayTextArea, gc);
            ++gc.gridy;
        } else {
            panel.add((Component)new JPanel(), gc);
        }
        gc.weighty = 0.0;
        gc.fill = 2;
        ++gc.gridy;
        gc.gridx = 0;
        gc.gridwidth = 3;
        gc.insets.bottom = 5;
        panel.add((Component)ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOk, this.btnCancel}, 1), gc);
        return panel;
    }

    protected void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PasswordDialog.this.doCancel();
            }

            @Override
            public void windowActivated(WindowEvent event) {
                if (PasswordDialog.this.user) {
                    PasswordDialog.this.txtUser.requestFocus();
                } else {
                    PasswordDialog.this.txtPassword.requestFocus();
                }
            }
        });
    }

    private void doOk() {
        if (this.inputTextValidator != null && !this.inputTextValidator.isValidInputText(this.getPassword(), this)) {
            this.txtPassword.requestFocus();
            return;
        }
        this.canceled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void setupAccelerators() {
        KeyboardUtil.addAccelerator(1, this.btnCancel, (JComponent)this.getContentPane(), this, 27, 0);
    }

    public static void main(String[] args) {
        PasswordDialog.getPassword(null, "Please enter your password:", "You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service.", "Enter Password", null);
        PasswordDialog.getUserAndPassword(null, null, "The site requires that you log in.", "Enter Credentials");
        System.exit(0);
    }

    public static interface InputTextValidator {
        public boolean isValidInputText(String var1, PasswordDialog var2);
    }
}

