/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.TimeSection;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class TimeSectionBuilder<B extends TimeSectionBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected TimeSectionBuilder() {
    }

    public static final TimeSectionBuilder create() {
        return new TimeSectionBuilder();
    }

    public final B start(LocalTime VALUE) {
        this.properties.put("start", new SimpleObjectProperty<LocalTime>(VALUE));
        return (B)this;
    }

    public final B stop(LocalTime VALUE) {
        this.properties.put("stop", new SimpleObjectProperty<LocalTime>(VALUE));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B icon(Image IMAGE) {
        this.properties.put("icon", new SimpleObjectProperty<Image>(IMAGE));
        return (B)this;
    }

    public final B color(Color COLOR) {
        this.properties.put("color", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B highlightColor(Color COLOR) {
        this.properties.put("highlightColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B active(boolean ACTIVE) {
        this.properties.put("active", new SimpleBooleanProperty(ACTIVE));
        return (B)this;
    }

    public final B days(DayOfWeek ... DAYS) {
        this.properties.put("daysArray", new SimpleObjectProperty<DayOfWeek[]>(DAYS));
        return (B)this;
    }

    public final B onTimeSectionEntered(EventHandler<TimeSection.TimeSectionEvent> HANDLER) {
        this.properties.put("onTimeSectionEntered", new SimpleObjectProperty<EventHandler<TimeSection.TimeSectionEvent>>(HANDLER));
        return (B)this;
    }

    public final B onTimeSectionLeft(EventHandler<TimeSection.TimeSectionEvent> HANDLER) {
        this.properties.put("onTimeSectionLeft", new SimpleObjectProperty<EventHandler<TimeSection.TimeSectionEvent>>(HANDLER));
        return (B)this;
    }

    public final TimeSection build() {
        TimeSection SECTION = new TimeSection();
        if (this.properties.containsKey("daysArray")) {
            SECTION.setDays((DayOfWeek[])((ObjectProperty)this.properties.get("daysArray")).get());
        }
        for (String key : this.properties.keySet()) {
            if ("start".equals(key)) {
                SECTION.setStart((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("stop".equals(key)) {
                SECTION.setStop((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                SECTION.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("icon".equals(key)) {
                SECTION.setIcon((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("color".equals(key)) {
                SECTION.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightColor".equals(key)) {
                SECTION.setHighlightColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                SECTION.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("active".equals(key)) {
                SECTION.setActive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onTimeSectionEntered".equals(key)) {
                SECTION.setOnTimeSectionEntered((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"onTimeSectionLeft".equals(key)) continue;
            SECTION.setOnTimeSectionLeft((EventHandler)((ObjectProperty)this.properties.get(key)).get());
        }
        return SECTION;
    }
}

