/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public class GaugeTileSkin
extends TileSkin {
    private double oldValue;
    private Arc barBackground;
    private Arc thresholdBar;
    private Rectangle needleRect;
    private Path needle;
    private Rotate needleRotate;
    private Rotate needleRectRotate;
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text minValueText;
    private Text maxValueText;
    private Rectangle thresholdRect;
    private Text thresholdText;
    private Pane sectionPane;
    private Path alertIcon;
    private Tooltip alertTooltip;
    private Map<Section, Arc> sectionMap;
    private Color barColor;
    private Color thresholdColor;

    public GaugeTileSkin(Tile TILE) {
        super(TILE);
        this.handleCurrentValue(this.tile.getValue());
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.oldValue = this.tile.getValue();
        this.sectionMap = new HashMap<Section, Arc>(this.sections.size());
        for (Section section : this.sections) {
            this.sectionMap.put(section, new Arc());
        }
        this.barColor = this.tile.getBarColor();
        this.thresholdColor = this.tile.getThresholdColor();
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke(this.barColor);
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.thresholdBar = new Arc(125.0, 174.0, 68.75, 68.75, -this.angleRange * 0.5 + 90.0, 0.0);
        this.thresholdBar.setType(ArcType.OPEN);
        this.thresholdBar.setStroke(this.tile.getThresholdColor());
        this.thresholdBar.setStrokeWidth(14.097745);
        this.thresholdBar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.thresholdBar.setFill(null);
        Helper.enableNode(this.thresholdBar, !this.tile.getSectionsVisible());
        this.sectionPane = new Pane();
        Helper.enableNode(this.sectionPane, this.tile.getSectionsVisible());
        if (this.sectionsVisible) {
            this.drawSections();
        }
        this.alertIcon = new Path();
        this.alertIcon.setFillRule(FillRule.EVEN_ODD);
        this.alertIcon.setFill(Color.YELLOW);
        this.alertIcon.setStroke(null);
        Helper.enableNode(this.alertIcon, this.tile.isAlert());
        this.alertTooltip = new Tooltip(this.tile.getAlertMessage());
        Tooltip.install(this.alertIcon, this.alertTooltip);
        this.needleRotate = new Rotate((this.tile.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRectRotate = new Rotate((this.tile.getValue() - this.oldValue - this.minValue) * this.angleStep);
        this.needleRect = new Rectangle();
        this.needleRect.setFill(this.tile.getBackgroundColor());
        this.needleRect.getTransforms().setAll((Transform[])new Transform[]{this.needleRectRotate});
        this.needle = new Path();
        this.needle.setFillRule(FillRule.EVEN_ODD);
        this.needle.getTransforms().setAll((Transform[])new Transform[]{this.needleRotate});
        this.needle.setFill(this.tile.getNeedleColor());
        this.needle.setStrokeWidth(0.0);
        this.needle.setStroke(Color.TRANSPARENT);
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.valueText.setFill(this.tile.getValueColor());
        this.valueText.setTextOrigin(VPos.BASELINE);
        Helper.enableNode(this.valueText, this.tile.isValueVisible() && !this.tile.isAlert());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(this.upperUnitText, this.unitText);
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(this.valueText, this.unitFlow);
        this.valueUnitFlow.setAlignment(Pos.CENTER);
        this.valueUnitFlow.setMouseTransparent(true);
        this.minValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMinValue()));
        this.minValueText.setFill(this.tile.getTitleColor());
        this.maxValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMaxValue()));
        this.maxValueText.setFill(this.tile.getTitleColor());
        this.thresholdRect = new Rectangle();
        this.thresholdRect.setFill(this.sectionsVisible ? Color.TRANSPARENT : (this.tile.getValue() > this.tile.getThreshold() ? this.tile.getThresholdColor() : Tile.GRAY));
        Helper.enableNode(this.thresholdRect, this.tile.isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getThreshold()));
        this.thresholdText.setFill(this.sectionsVisible ? Color.TRANSPARENT : Tile.GRAY);
        Helper.enableNode(this.thresholdText, this.tile.isThresholdVisible());
        this.getPane().getChildren().addAll((Node[])new Node[]{this.barBackground, this.thresholdBar, this.sectionPane, this.alertIcon, this.needleRect, this.needle, this.titleText, this.valueUnitFlow, this.fractionLine, this.minValueText, this.maxValueText, this.thresholdRect, this.thresholdText});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.sectionPane, this.tile.getSectionsVisible());
            Helper.enableNode(this.thresholdRect, this.tile.isThresholdVisible());
            Helper.enableNode(this.thresholdText, this.tile.isThresholdVisible());
            Helper.enableNode(this.unitFlow, !this.tile.getUnit().isEmpty());
            this.sectionsVisible = this.tile.getSectionsVisible();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.tile.getSections();
            this.sectionMap.clear();
            for (Section section : this.sections) {
                this.sectionMap.put(section, new Arc());
            }
        } else if ("ALERT".equals(EVENT_TYPE)) {
            Helper.enableNode(this.valueText, this.tile.isValueVisible() && !this.tile.isAlert());
            Helper.enableNode(this.unitText, this.tile.isValueVisible() && !this.tile.isAlert());
            Helper.enableNode(this.alertIcon, this.tile.isAlert());
            this.alertTooltip.setText(this.tile.getAlertMessage());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        double needleStartAngle = this.angleRange * 0.5;
        double targetAngle = (VALUE - this.minValue) * this.angleStep - needleStartAngle;
        targetAngle = Helper.clamp(-needleStartAngle, -needleStartAngle + this.angleRange, targetAngle);
        this.needleRotate.setAngle(targetAngle);
        this.needleRectRotate.setAngle(targetAngle);
        if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.thresholdRect.setFill(this.sectionsVisible ? Color.TRANSPARENT : (this.tile.getValue() > this.tile.getThreshold() ? this.tile.getThresholdColor() : Tile.GRAY));
        this.resizeDynamicText();
        this.highlightSections(VALUE);
    }

    private void highlightSections(double VALUE) {
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        if (this.highlightSections) {
            this.sections.forEach(section -> this.sectionMap.get(section).setVisible(section.contains(VALUE)));
        } else {
            this.sections.forEach(section -> this.sectionMap.get(section).setOpacity(section.contains(VALUE) ? 1.0 : 0.25));
        }
    }

    private void drawSections() {
        this.sectionPane.getChildren().clear();
        if (!this.sectionsVisible || this.sections.isEmpty()) {
            return;
        }
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.5;
        double innerRadius = this.size * 0.2775;
        double outerRadius = this.size * 0.3225;
        int noOfSections = this.sections.size();
        ArrayList<Line> sectionLines = new ArrayList<Line>(noOfSections);
        for (int i = 0; i < noOfSections - 1; ++i) {
            Section section = (Section)this.sections.get(i);
            double angle = Helper.clamp(90.0, 270.0, (section.getStop() - this.minValue) * this.angleStep + 90.0);
            Line line = new Line(centerX + innerRadius * Math.sin(-Math.toRadians(angle)), centerY + innerRadius * Math.cos(-Math.toRadians(angle)), centerX + outerRadius * Math.sin(-Math.toRadians(angle)), centerY + outerRadius * Math.cos(-Math.toRadians(angle)));
            line.setStroke(this.tile.getBackgroundColor());
            sectionLines.add(line);
        }
        this.sectionPane.getChildren().addAll((Collection<Node>)sectionLines);
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.045;
        double maxValue = this.tile.getMaxValue();
        for (Section section : this.sections) {
            double startAngle = (section.getStart() - this.minValue) * this.angleStep - this.angleRange;
            double length = section.getStop() > maxValue ? (maxValue - section.getStart()) * this.angleStep : (Double.compare(section.getStart(), this.minValue) < 0 ? (section.getStop() - this.minValue) * this.angleStep : (section.getStop() - section.getStart()) * this.angleStep);
            Arc sectionArc = new Arc(centerX, centerY + this.size * 0.2825, barRadius, barRadius, -startAngle, -length);
            sectionArc.setType(ArcType.OPEN);
            sectionArc.setStroke(section.getColor());
            sectionArc.setStrokeWidth(barWidth);
            sectionArc.setStrokeLineCap(StrokeLineCap.BUTT);
            sectionArc.setFill(null);
            sectionArc.setVisible(!this.highlightSections);
            sectionArc.setOpacity(this.highlightSections ? 1.0 : 0.25);
            Tooltip sectionTooltip = new Tooltip(section.getText());
            sectionTooltip.setTextAlignment(TextAlignment.CENTER);
            Tooltip.install(sectionArc, sectionTooltip);
            this.sectionMap.put(section, sectionArc);
        }
        this.sectionPane.getChildren().addAll(this.sectionMap.values());
    }

    private void drawNeedle() {
        double needleWidth = this.size * 0.05;
        double needleHeight = this.size * 0.3325;
        this.needle.setCache(false);
        this.needle.getElements().clear();
        this.needle.getElements().add(new MoveTo(0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.25 * needleWidth, 0.9022556390977443 * needleHeight, 0.35 * needleWidth, 0.8872180451127819 * needleHeight, 0.5 * needleWidth, 0.8872180451127819 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.65 * needleWidth, 0.8872180451127819 * needleHeight, 0.75 * needleWidth, 0.9022556390977443 * needleHeight, 0.75 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.75 * needleWidth, 0.9473684210526315 * needleHeight, 0.65 * needleWidth, 0.9624060150375939 * needleHeight, 0.5 * needleWidth, 0.9624060150375939 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.35 * needleWidth, 0.9624060150375939 * needleHeight, 0.25 * needleWidth, 0.9473684210526315 * needleHeight, 0.25 * needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new ClosePath());
        this.needle.getElements().add(new MoveTo(0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.0, 0.9699248120300752 * needleHeight, 0.2 * needleWidth, needleHeight, 0.5 * needleWidth, needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.8 * needleWidth, needleHeight, needleWidth, 0.9699248120300752 * needleHeight, needleWidth, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(needleWidth, 0.8947368421052632 * needleHeight, 0.85 * needleWidth, 0.8646616541353384 * needleHeight, 0.65 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.65 * needleWidth, 0.849624060150376 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight, 0.65 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.65 * needleWidth, 0.007518796992481203 * needleHeight, 0.6 * needleWidth, 0.0, 0.5 * needleWidth, 0.0));
        this.needle.getElements().add(new CubicCurveTo(0.4 * needleWidth, 0.0, 0.35 * needleWidth, 0.007518796992481203 * needleHeight, 0.35 * needleWidth, 0.022556390977443608 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.35 * needleWidth, 0.022556390977443608 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight, 0.35 * needleWidth, 0.849624060150376 * needleHeight));
        this.needle.getElements().add(new CubicCurveTo(0.15 * needleWidth, 0.8646616541353384 * needleHeight, 0.0, 0.8947368421052632 * needleHeight, 0.0, 0.924812030075188 * needleHeight));
        this.needle.getElements().add(new ClosePath());
        this.needle.setCache(true);
        this.needle.setCacheHint(CacheHint.ROTATE);
    }

    private void drawAlertIcon() {
        this.alertIcon.setCache(false);
        double iconWidth = this.size * 0.155;
        double iconHeight = this.size * 0.135;
        this.alertIcon.getElements().clear();
        this.alertIcon.getElements().add(new MoveTo(0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4411764705882353 * iconWidth, 0.3 * iconHeight, 0.4684873949579832 * iconWidth, 0.2714285714285714 * iconHeight, 0.5 * iconWidth, 0.2714285714285714 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.5315126050420168 * iconWidth, 0.2714285714285714 * iconHeight, 0.5588235294117647 * iconWidth, 0.3 * iconHeight, 0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.5588235294117647 * iconWidth, 0.3380952380952381 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight, 0.5588235294117647 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.5588235294117647 * iconWidth, 0.6357142857142857 * iconHeight, 0.5315126050420168 * iconWidth, 0.6666666666666666 * iconHeight, 0.5 * iconWidth, 0.6666666666666666 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4684873949579832 * iconWidth, 0.6666666666666666 * iconHeight, 0.4411764705882353 * iconWidth, 0.6357142857142857 * iconHeight, 0.4411764705882353 * iconWidth, 0.6 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4411764705882353 * iconWidth, 0.6 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.3380952380952381 * iconHeight));
        this.alertIcon.getElements().add(new ClosePath());
        this.alertIcon.getElements().add(new MoveTo(0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4411764705882353 * iconWidth, 0.7642857142857142 * iconHeight, 0.4684873949579832 * iconWidth, 0.7333333333333333 * iconHeight, 0.5 * iconWidth, 0.7333333333333333 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.5315126050420168 * iconWidth, 0.7333333333333333 * iconHeight, 0.5588235294117647 * iconWidth, 0.7642857142857142 * iconHeight, 0.5588235294117647 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.5588235294117647 * iconWidth, 0.8380952380952381 * iconHeight, 0.5315126050420168 * iconWidth, 0.8666666666666667 * iconHeight, 0.5 * iconWidth, 0.8666666666666667 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4684873949579832 * iconWidth, 0.8666666666666667 * iconHeight, 0.4411764705882353 * iconWidth, 0.8380952380952381 * iconHeight, 0.4411764705882353 * iconWidth, 0.8 * iconHeight));
        this.alertIcon.getElements().add(new ClosePath());
        this.alertIcon.getElements().add(new MoveTo(0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.523109243697479 * iconWidth, -0.011904761904761904 * iconHeight, 0.47689075630252103 * iconWidth, -0.011904761904761904 * iconHeight, 0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.4495798319327731 * iconWidth, 0.04285714285714286 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight, 0.012605042016806723 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(-0.014705882352941176 * iconWidth, 0.9547619047619048 * iconHeight, 0.0063025210084033615 * iconWidth, iconHeight, 0.06302521008403361 * iconWidth, iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.06302521008403361 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight, 0.9369747899159664 * iconWidth, iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.9936974789915967 * iconWidth, iconHeight, 1.0147058823529411 * iconWidth, 0.9547619047619048 * iconHeight, 0.9873949579831933 * iconWidth, 0.9 * iconHeight));
        this.alertIcon.getElements().add(new CubicCurveTo(0.9873949579831933 * iconWidth, 0.9 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight, 0.5504201680672269 * iconWidth, 0.04285714285714286 * iconHeight));
        this.alertIcon.getElements().add(new ClosePath());
        this.alertIcon.setCache(true);
        this.alertIcon.setCacheHint(CacheHint.SPEED);
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        this.thresholdText.setFill(this.sectionsVisible ? Color.TRANSPARENT : this.tile.getBackgroundColor());
        if (!this.sectionsVisible) {
            fontSize = this.size * 0.08;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.width - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.07;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        double textRadius = this.size * 0.3;
        double sinValue = Math.sin(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double cosValue = Math.cos(Math.toRadians(90.0 + (180.0 - this.angleRange) * 0.5));
        double textX = this.width * 0.5 + textRadius * sinValue;
        double textY = this.barBackground.getLayoutBounds().getMaxY() + this.size * 0.05 + textRadius * cosValue;
        this.maxValueText.setTranslateX(-this.maxValueText.getLayoutBounds().getWidth() * 0.5);
        this.maxValueText.setTranslateY(-this.maxValueText.getLayoutBounds().getHeight() * 0.5);
        this.maxValueText.relocate(textX, textY);
        this.minValueText.setFont(Fonts.latoRegular(this.maxValueText.getFont().getSize()));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        sinValue = Math.sin(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        cosValue = Math.cos(Math.toRadians(-90.0 - (180.0 - this.angleRange) * 0.5));
        textX = this.width * 0.5 + textRadius * sinValue;
        this.minValueText.setTranslateX(-this.minValueText.getLayoutBounds().getWidth() * 0.5);
        this.minValueText.setTranslateY(-this.minValueText.getLayoutBounds().getHeight() * 0.5);
        this.minValueText.relocate(textX, textY);
        if (!this.sectionsVisible) {
            maxWidth = this.size * 0.3;
            fontSize = this.size * 0.08;
            this.thresholdText.setFont(Fonts.latoRegular(fontSize));
            this.thresholdText.setTextOrigin(VPos.CENTER);
            if (this.thresholdText.getLayoutBounds().getWidth() > maxWidth) {
                Helper.adjustTextSize(this.thresholdText, maxWidth, fontSize);
            }
            this.thresholdText.setX((this.width - this.thresholdText.getLayoutBounds().getWidth()) * 0.5);
            this.thresholdText.setY(this.thresholdRect.getLayoutBounds().getMinY() + this.thresholdRect.getHeight() * 0.5);
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resize() {
        super.resize();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.5;
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.045;
        this.sectionPane.setMaxSize(this.size, this.size);
        this.barBackground.setCenterX(centerX);
        this.barBackground.setCenterY(centerY + this.size * 0.2825);
        this.barBackground.setRadiusX(barRadius);
        this.barBackground.setRadiusY(barRadius);
        this.barBackground.setStrokeWidth(barWidth);
        this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
        this.barBackground.setLength(-this.angleRange);
        this.thresholdBar.setCenterX(centerX);
        this.thresholdBar.setCenterY(centerY + this.size * 0.2825);
        this.thresholdBar.setRadiusX(barRadius);
        this.thresholdBar.setRadiusY(barRadius);
        this.thresholdBar.setStrokeWidth(barWidth);
        this.thresholdBar.setStartAngle(90.0 - this.angleRange * 0.5);
        this.thresholdBar.setLength((this.tile.getMaxValue() - this.tile.getThreshold()) * this.angleStep);
        if (this.sectionsVisible) {
            this.drawSections();
        }
        this.drawAlertIcon();
        this.alertIcon.relocate((this.size - this.alertIcon.getLayoutBounds().getWidth()) * 0.5, this.size * 0.244);
        this.needleRect.setWidth(this.size * 0.035);
        this.needleRect.setHeight(this.size * 0.05);
        this.needleRect.relocate((this.width - this.needleRect.getWidth()) * 0.5, centerY - this.size * 0.0425);
        this.needleRectRotate.setPivotX(this.needleRect.getLayoutBounds().getWidth() * 0.5);
        this.needleRectRotate.setPivotY(this.size * 0.325);
        this.drawNeedle();
        this.needle.relocate((this.width - this.needle.getLayoutBounds().getWidth()) * 0.5, centerY - this.size * 0.025);
        this.needleRotate.setPivotX(this.needle.getLayoutBounds().getWidth() * 0.5);
        this.needleRotate.setPivotY(this.needle.getLayoutBounds().getHeight() - this.needle.getLayoutBounds().getWidth() * 0.5);
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        this.thresholdRect.setWidth(this.thresholdText.getLayoutBounds().getWidth() + this.size * 0.05);
        this.thresholdRect.setHeight(this.thresholdText.getLayoutBounds().getHeight());
        this.thresholdRect.setX((this.width - this.thresholdRect.getWidth()) * 0.5);
        this.thresholdRect.setY(centerY + this.size * 0.35);
        this.thresholdRect.setArcWidth(this.size * 0.025);
        this.thresholdRect.setArcHeight(this.size * 0.025);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode(this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode(this.fractionLine, false);
        }
        this.minValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMaxValue()));
        this.thresholdText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getThreshold()));
        this.resizeStaticText();
        this.barColor = this.tile.getBarColor();
        this.thresholdColor = this.tile.getThresholdColor();
        this.barBackground.setStroke(this.barColor);
        this.thresholdBar.setStroke(this.tile.getThresholdColor());
        this.needleRect.setFill(this.tile.getBackgroundColor());
        this.needle.setFill(this.tile.getNeedleColor());
        this.titleText.setFill(this.tile.getTitleColor());
        this.minValueText.setFill(this.tile.getTitleColor());
        this.maxValueText.setFill(this.tile.getTitleColor());
        this.thresholdRect.setFill(this.sectionsVisible ? Color.TRANSPARENT : (this.tile.getValue() > this.tile.getThreshold() ? this.tile.getThresholdColor() : Tile.GRAY));
        this.thresholdText.setFill(this.sectionsVisible ? Color.TRANSPARENT : this.tile.getBackgroundColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.upperUnitText.setFill(this.tile.getUnitColor());
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.drawSections();
        this.highlightSections(this.tile.getValue());
    }
}

