/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmResolution;
import mediathek.gui.tabs.tab_film.JDownloadHelper;
import mediathek.tool.http.MVHttpClient;
import mediathek.tool.javafx.FXErrorDialog;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper;", "", "()V", "historyController", "Lmediathek/controller/history/SeenHistoryController;", "downloadUrl", "", "url", "Lokhttp3/HttpUrl;", "film", "Lmediathek/daten/DatenFilm;", "installContextMenu", "jPopupMenu", "Ljavax/swing/JPopupMenu;", "showErrorMessage", "Companion", "MediathekView"})
public final class JDownloadHelper {
    private final SeenHistoryController historyController = new SeenHistoryController();
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadUrl(HttpUrl url, DatenFilm film) {
        RequestBody formBody = new FormBody.Builder(null, 1, null).add("urls", url.toString()).build();
        Request request = new Request.Builder().url("http://127.0.0.1:9666/flash/add").post(formBody).build();
        try {
            MVHttpClient mVHttpClient = MVHttpClient.getInstance();
            Intrinsics.checkNotNullExpressionValue(mVHttpClient, "MVHttpClient.getInstance()");
            OkHttpClient.Builder builder = mVHttpClient.getReducedTimeOutClient().newBuilder();
            builder.connectTimeout(125L, TimeUnit.MILLISECONDS);
            OkHttpClient client = builder.build();
            Closeable closeable = client.newCall(request).execute();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                boolean bl3 = false;
                if (it.isSuccessful()) {
                    this.historyController.markSeen(film);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (ConnectException e) {
            this.showErrorMessage();
        }
        catch (SocketTimeoutException e) {
            this.showErrorMessage();
        }
        catch (Exception e) {
            logger.error("downloadUrl", (Throwable)e);
            Platform.runLater(new Runnable(e){
                final /* synthetic */ Exception $e;

                public final void run() {
                    FXErrorDialog.showErrorDialog("MediathekView", "Download nicht m\u00f6glich", "Die URL konnte nicht mit JDownloader geladen werden.\nBitte wenden Sie sich bei Bedarf an das Forum.", this.$e);
                }
                {
                    this.$e = exception;
                }
            });
        }
    }

    private final void showErrorMessage() {
        Platform.runLater(showErrorMessage.1.INSTANCE);
    }

    public final void installContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu jPopupMenu) {
        Intrinsics.checkNotNullParameter(film, "film");
        Intrinsics.checkNotNullParameter(jPopupMenu, "jPopupMenu");
        jPopupMenu.addSeparator();
        String miText = "Mit JDownloader herunterladen";
        if (film.isPlayList()) {
            JMenuItem miDownloadJD = new JMenuItem(miText);
            miDownloadJD.addActionListener(new ActionListener(this, film){
                final /* synthetic */ JDownloadHelper this$0;
                final /* synthetic */ DatenFilm $film;

                public final void actionPerformed(ActionEvent it) {
                    String string = this.$film.getUrl();
                    Intrinsics.checkNotNullExpressionValue(string, "film.url");
                    HttpUrl url = HttpUrl.Companion.get(string);
                    JDownloadHelper.access$downloadUrl(this.this$0, url, this.$film);
                }
                {
                    this.this$0 = jDownloadHelper;
                    this.$film = datenFilm;
                }
            });
            jPopupMenu.add(miDownloadJD);
        } else {
            JMenu mJD = new JMenu(miText);
            String string = film.getUrl();
            Intrinsics.checkNotNullExpressionValue(string, "film.url");
            HttpUrl uNormal = HttpUrl.Companion.get(string);
            String string2 = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            Intrinsics.checkNotNullExpressionValue(string2, "film.getUrlFuerAufloesun\u2026lution.Enum.HIGH_QUALITY)");
            HttpUrl uHq = HttpUrl.Companion.get(string2);
            String string3 = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            Intrinsics.checkNotNullExpressionValue(string3, "film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)");
            HttpUrl uLow = HttpUrl.Companion.get(string3);
            if (uHq != uNormal) {
                JMenuItem miHq = new JMenuItem("in bester Qualit\u00e4t");
                miHq.addActionListener(new ActionListener(this, uHq, film){
                    final /* synthetic */ JDownloadHelper this$0;
                    final /* synthetic */ HttpUrl $uHq;
                    final /* synthetic */ DatenFilm $film;

                    public final void actionPerformed(ActionEvent it) {
                        JDownloadHelper.access$downloadUrl(this.this$0, this.$uHq, this.$film);
                    }
                    {
                        this.this$0 = jDownloadHelper;
                        this.$uHq = httpUrl;
                        this.$film = datenFilm;
                    }
                });
                mJD.add(miHq);
            }
            JMenuItem miNormal = new JMenuItem("in normaler Qualit\u00e4t");
            miNormal.addActionListener(new ActionListener(this, uNormal, film){
                final /* synthetic */ JDownloadHelper this$0;
                final /* synthetic */ HttpUrl $uNormal;
                final /* synthetic */ DatenFilm $film;

                public final void actionPerformed(ActionEvent it) {
                    JDownloadHelper.access$downloadUrl(this.this$0, this.$uNormal, this.$film);
                }
                {
                    this.this$0 = jDownloadHelper;
                    this.$uNormal = httpUrl;
                    this.$film = datenFilm;
                }
            });
            mJD.add(miNormal);
            if (uLow != uNormal) {
                JMenuItem miLow = new JMenuItem("in niedriger Qualit\u00e4t");
                miLow.addActionListener(new ActionListener(this, uLow, film){
                    final /* synthetic */ JDownloadHelper this$0;
                    final /* synthetic */ HttpUrl $uLow;
                    final /* synthetic */ DatenFilm $film;

                    public final void actionPerformed(ActionEvent it) {
                        JDownloadHelper.access$downloadUrl(this.this$0, this.$uLow, this.$film);
                    }
                    {
                        this.this$0 = jDownloadHelper;
                        this.$uLow = httpUrl;
                        this.$film = datenFilm;
                    }
                });
                mJD.add(miLow);
            }
            jPopupMenu.add(mJD);
        }
    }

    static {
        Companion = new Companion(null);
        logger = LogManager.getLogger();
    }

    public static final /* synthetic */ void access$downloadUrl(JDownloadHelper $this, HttpUrl url, DatenFilm film) {
        $this.downloadUrl(url, film);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

