/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.cellrenderer;

import java.awt.Component;
import javax.swing.JTable;
import mediathek.daten.abo.AboTags;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.abo.FilmLengthState;
import mediathek.tool.cellrenderer.CellRendererBase;
import mediathek.tool.table.MVTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CellRendererAbo
extends CellRendererBase {
    private static final Logger logger = LogManager.getLogger(CellRendererAbo.class);

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(null);
        this.setForeground(null);
        this.setFont(null);
        this.setIcon(null);
        this.setHorizontalAlignment(10);
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        try {
            DatenAbo abo = (DatenAbo)table.getModel().getValueAt(table.convertRowIndexToModel(row), 13);
            AboTags.fromIndex(table.convertColumnIndexToModel(column)).ifPresent(col -> {
                switch (col) {
                    case NR: {
                        this.setHorizontalAlignment(0);
                        this.setText(Integer.toString(abo.getNr()));
                        break;
                    }
                    case NAME: {
                        this.setText(abo.getName());
                        break;
                    }
                    case THEMA: {
                        this.setText(abo.getThema());
                        break;
                    }
                    case TITEL: {
                        this.setText(abo.getTitle());
                        break;
                    }
                    case MINDESTDAUER: {
                        this.setHorizontalAlignment(0);
                        break;
                    }
                    case MIN: {
                        this.setHorizontalAlignment(0);
                        if (abo.getFilmLengthState() == FilmLengthState.MINIMUM) {
                            this.setText("min");
                            break;
                        }
                        this.setText("max");
                        break;
                    }
                    case SENDER: {
                        if (!((MVTable)table).showSenderIcons()) break;
                        this.setSenderIcon(abo.getSender(), ((MVTable)table).useSmallSenderIcons);
                    }
                }
            });
            if (!abo.isActive()) {
                this.setFont(this.getFont().deriveFont(2));
            }
        }
        catch (Exception ex) {
            logger.error("Fehler 630365892", (Throwable)ex);
        }
        return this;
    }
}

