/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.alert;

import com.ejt.internal.util.CommonStringUtil;
import com.install4j.api.Util;
import com.install4j.runtime.alert.Alert;
import com.install4j.runtime.alert.AlertOptionPane;
import com.install4j.runtime.alert.AlertType;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.util.AlertLafHelper;
import com.install4j.runtime.util.ButtonBoxLayout;
import com.install4j.runtime.util.CustomDialog;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class DefaultAlertDialog
extends CustomDialog {
    private static final int MIN_MESSAGE_WIDTH = 300;
    private static final int MAX_MESSAGE_WIDTH = 600;
    private static final int REL_HORIZONTAL = 4;
    private static final int UNREL_HORIZONTAL = 7;
    private static final int PARA = 14;
    private static final Pattern LINE_PATTERN = Pattern.compile("[^\n\r]+");
    private static JCheckBox chkDoNotShowAgain;
    private static final Color DARK_CONTENT_BACKGROUND_COLOR;
    private int defaultButtonIndex;
    private int cancelButtonIndex;
    private int selectedButtonIndex;
    private int width;
    private FontMetrics fontMetrics;
    private int maxCharsPerLine;

    public static boolean isDoNotShowAgain() {
        return chkDoNotShowAgain != null && chkDoNotShowAgain.isSelected();
    }

    public static int show(Window parentWindow, AlertType alertType, String windowTitle, String mainMessage, String contentMessage, List<String> buttonTitles, int defaultButtonIndex, int cancelButtonIndex, boolean doNotShowAgainOption, boolean rawMode) {
        DefaultAlertDialog dialog = new DefaultAlertDialog(parentWindow);
        dialog.init(windowTitle, alertType, mainMessage, contentMessage, buttonTitles, defaultButtonIndex, cancelButtonIndex, doNotShowAgainOption, rawMode);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog.selectedButtonIndex;
    }

    private DefaultAlertDialog(Window parentWindow) {
        super(parentWindow);
    }

    @Override
    protected int getFrameWidth() {
        return -1;
    }

    @Override
    protected int getFrameHeight() {
        return -1;
    }

    private void init(String windowTitle, AlertType alertType, String mainMessage, String contentMessage, List<String> buttonTitles, int defaultButtonIndex, int cancelButtonIndex, boolean doNotShowAgainOption, boolean rawMode) {
        this.defaultButtonIndex = defaultButtonIndex;
        this.cancelButtonIndex = cancelButtonIndex;
        this.pack();
        this.fontMetrics = this.getGraphics().getFontMetrics(AlertLafHelper.getAlertFont());
        this.maxCharsPerLine = 600 / this.fontMetrics.charWidth('o');
        mainMessage = Alert.replaceTabs(mainMessage);
        if (!rawMode) {
            mainMessage = this.ellipsify(mainMessage);
        }
        this.width = this.calculateWidth(mainMessage, rawMode);
        if (contentMessage != null) {
            contentMessage = Alert.replaceTabs(contentMessage);
            if (!rawMode) {
                contentMessage = this.ellipsify(contentMessage);
            }
            this.width = Math.max(this.width, this.calculateWidth(contentMessage, rawMode));
        }
        this.setTitle(windowTitle);
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultAlertDialog.this.cancel();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.fill = 1;
        panel.setFocusable(true);
        panel.add(this.createMessagePanel(alertType, mainMessage, contentMessage), gc);
        gc.weighty = 1.0;
        gc.fill = 2;
        gc.insets.top = 7;
        gc.insets.bottom = 8;
        ++gc.gridy;
        panel.add((Component)this.createButtonPanel(doNotShowAgainOption, buttonTitles), gc);
        KeyboardUtil.addAccelerator(1, panel, panel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultAlertDialog.this.defaultButton();
            }
        }, 10, 0);
        KeyboardUtil.addAccelerator(1, panel, panel, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultAlertDialog.this.cancel();
            }
        }, 27, 0);
        this.setContentPane(panel);
        this.setBounds(this.getFrameBounds());
        this.setBounds(this.getFrameBounds());
        if (Util.isLinux()) {
            this.addWindowListener(new WindowAdapter(){
                boolean activated = false;

                @Override
                public void windowActivated(WindowEvent e) {
                    if (!this.activated) {
                        this.activated = true;
                        DefaultAlertDialog.this.setBounds(DefaultAlertDialog.this.getFrameBounds());
                    }
                }
            });
        }
    }

    private String ellipsify(String text) {
        Matcher matcher = Alert.NO_WRAP_PATTERN.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String match = matcher.group();
            boolean ellipsedFile = false;
            if (match.contains(File.separator)) {
                try {
                    matcher.appendReplacement(buffer, Matcher.quoteReplacement(CommonStringUtil.ellipseFileName(new File(match), this.maxCharsPerLine)));
                    ellipsedFile = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (ellipsedFile) continue;
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(CommonStringUtil.ellipse(match, this.maxCharsPerLine)));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private int calculateWidth(String text, boolean rawMode) {
        int width = 300;
        Matcher matcher = (rawMode ? LINE_PATTERN : Alert.NO_WRAP_PATTERN).matcher(text);
        while (matcher.find()) {
            String match = matcher.group();
            width = Math.max(width, this.fontMetrics.stringWidth(match));
        }
        return width + 2;
    }

    private Component createMessagePanel(AlertType alertType, String mainMessage, String contentMessage) {
        boolean mainMessageAdded;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.gridheight = contentMessage != null ? 2 : 1;
        gc.anchor = 23;
        gc.insets.right = 10;
        panel.add((Component)new JLabel(alertType.getIcon()), gc);
        gc.gridheight = 1;
        gc.insets.right = 0;
        gc.gridx = 1;
        gc.weightx = 1.0;
        gc.fill = 2;
        boolean bl = mainMessageAdded = !mainMessage.isEmpty();
        if (mainMessageAdded) {
            panel.add((Component)this.createMessageLabel(mainMessage, true), gc);
        }
        if (contentMessage != null) {
            gc.anchor = 21;
            if (mainMessageAdded) {
                ++gc.gridy;
                gc.insets.top = 14;
            }
            panel.add((Component)this.createMessageLabel(contentMessage, false), gc);
        }
        panel.setOpaque(true);
        panel.setBackground(GUIHelper.isDarculaLaF() ? DARK_CONTENT_BACKGROUND_COLOR : Color.WHITE);
        AlertLafHelper.applyBottomSeparator(panel);
        Border border = panel.getBorder();
        panel.setBorder(new CompoundBorder(border, new EmptyBorder(10, 10, 15, 10)));
        return panel;
    }

    private DisplayTextArea createMessageLabel(String text, boolean title) {
        DisplayTextArea displayTextArea = AlertLafHelper.alertFont(new DisplayTextArea());
        displayTextArea.setText(text);
        if (title) {
            AlertLafHelper.makeAlertTitleLabel(displayTextArea);
        }
        Dimension preferredSize = displayTextArea.getPreferredSize();
        preferredSize.width = this.width;
        displayTextArea.setSize(preferredSize);
        displayTextArea.setMinimumSize(preferredSize);
        return displayTextArea;
    }

    private JPanel createButtonPanel(boolean doNotShowAgainOption, List<String> buttonTitles) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = -1;
        if (doNotShowAgainOption) {
            if (chkDoNotShowAgain == null) {
                chkDoNotShowAgain = AlertLafHelper.alertFont(new JCheckBox(" " + AlertOptionPane.getDontShowAgainMessage()));
            }
            chkDoNotShowAgain.setSelected(false);
            gc.insets.left = 7;
            panel.add((Component)chkDoNotShowAgain, gc);
            gc.insets.right = 7;
        }
        gc.insets.right = 10;
        gc.insets.left = 10;
        JPanel buttonBox = new JPanel(new ButtonBoxLayout(4));
        for (int i = 0; i < buttonTitles.size(); ++i) {
            JButton cancelButton = this.createButton(buttonTitles.get(i), i);
            buttonBox.add(cancelButton);
        }
        gc.fill = 2;
        gc.anchor = 22;
        panel.add((Component)buttonBox, gc);
        return panel;
    }

    private JButton createButton(String caption, final int index) {
        JButton button = AlertLafHelper.alertFont(new JButton(caption));
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultAlertDialog.this.selectedButtonIndex = index;
                DefaultAlertDialog.this.setVisible(false);
            }
        };
        button.addActionListener(cancelListener);
        if (index == this.defaultButtonIndex) {
            this.getRootPane().setDefaultButton(button);
        }
        return button;
    }

    private void cancel() {
        this.selectedButtonIndex = this.cancelButtonIndex;
        this.setVisible(false);
    }

    private void defaultButton() {
        this.selectedButtonIndex = this.defaultButtonIndex;
        this.setVisible(false);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultAlertDialog.test1();
                DefaultAlertDialog.test2();
                DefaultAlertDialog.test3();
                DefaultAlertDialog.testLongMessage();
                DefaultAlertDialog.testLongFile();
                DefaultAlertDialog.testLongText();
            }
        });
    }

    private static void test1() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.INFORMATION, "Title", "Main message", "This is the content message", Arrays.asList("OK", "Cancel"), 0, 1, true, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    private static void test2() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.WARNING, "Title", "Just a very long title message. Just a very long title message. Just a very long title message. Just a very long title message.", null, Arrays.asList("OK", "Cancel"), 0, 1, false, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    private static void test3() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.QUESTION, "Title", "Main message", "This is a long content message. This is a long content message. This is a long content message. This is a long content message. This is a long content message. ", Arrays.asList("Skip", "Retry", "Ignore"), 1, -1, true, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    private static void testLongMessage() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.INFORMATION, "Title", "Main message", "This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. This is the content message. ", Arrays.asList("OK", "Cancel"), 0, 1, true, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    private static void testLongFile() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.INFORMATION, "Title", "Main message", "This is the content message width a file name of c:\\Users\\bob\\folder1\\folder2\\folder3\\folder4\\folder5\\folder6\\folder7\\folder8\\folder9\\folder10\\fileName.txt which is too long to be displayed.", Arrays.asList("OK", "Cancel"), 0, 1, true, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    private static void testLongText() {
        int selectedButtonIndex = DefaultAlertDialog.show(null, AlertType.INFORMATION, "Title", "Main message", "This is the content message width a file name aaaaaaaaaaaaaaaaaaaaaaaabbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbccccccccccccccccccccccccccccccccccddddddddddddddddddddddddddddddddddddeeeeeeeeeeeeeeeeeee which is too long to be displayed.", Arrays.asList("OK", "Cancel"), 0, 1, true, false);
        System.out.println("selected index : " + selectedButtonIndex);
    }

    static {
        DARK_CONTENT_BACKGROUND_COLOR = new Color(71, 75, 76);
    }
}

