/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.VariableErrorHandlingDescriptor;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.runtime.beans.actions.desktop.AbstractAssociationAction;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.MenuHelper;
import com.install4j.runtime.installer.helper.XmlHelper;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.FileAssociations;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateFileAssociationAction
extends AbstractAssociationAction {
    public static final String CF_BUNDLE_DOCUMENT_TYPES = "CFBundleDocumentTypes";
    private String extension = "";
    private String description = "";
    private boolean selected = true;
    private boolean windows = true;
    private ExternalFile windowsIconFile = null;
    private String winAdditionalParameters = null;
    private boolean mac = true;
    private ExternalFile macIconFile = null;
    private boolean unix = false;
    private String unixMimeType = "";
    private ExternalFile unixIconFile = null;
    private boolean restartFinder = false;
    private static final String PROP_EXTENSION = "extension";
    private static final String ELEMENT_MIME_TYPE = "mime-type";
    private static final String ELEMENT_INSTALLATION = "i4j-installation";
    private transient boolean mimeTypeCreated = false;

    public String getExtension() {
        return CreateFileAssociationAction.replaceVariables(CreateFileAssociationAction.replaceVariables(this.extension));
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getDescription() {
        return CreateFileAssociationAction.replaceVariables(CreateFileAssociationAction.replaceVariables(this.description, VariableErrorHandlingDescriptor.ALWAYS_ERROR_MESSAGE));
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isSelected() {
        return this.replaceWithTextOverride("selected", this.selected);
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isWindows() {
        return this.replaceWithTextOverride("windows", this.windows);
    }

    public void setWindows(boolean windows) {
        this.windows = windows;
    }

    public ExternalFile getWindowsIconFile() {
        return this.replaceWithTextOverride("windowsIconFile", this.windowsIconFile, ExternalFile.class);
    }

    public void setWindowsIconFile(ExternalFile windowsIconFile) {
        this.windowsIconFile = windowsIconFile;
    }

    public String getWinAdditionalParameters() {
        return CreateFileAssociationAction.replaceVariables(CreateFileAssociationAction.replaceVariables(this.winAdditionalParameters));
    }

    public void setWinAdditionalParameters(String winAdditionalParameters) {
        this.winAdditionalParameters = winAdditionalParameters;
    }

    public boolean isMac() {
        return this.replaceWithTextOverride("mac", this.mac);
    }

    public void setMac(boolean mac) {
        this.mac = mac;
    }

    public boolean isUnix() {
        return this.replaceWithTextOverride("unix", this.unix);
    }

    public void setUnix(boolean unix) {
        this.unix = unix;
    }

    public String getUnixMimeType() {
        return CreateFileAssociationAction.replaceVariables(CreateFileAssociationAction.replaceVariables(this.unixMimeType));
    }

    public void setUnixMimeType(String unixMimeType) {
        this.unixMimeType = unixMimeType;
    }

    public ExternalFile getMacIconFile() {
        return this.replaceWithTextOverride("macIconFile", this.macIconFile, ExternalFile.class);
    }

    public void setMacIconFile(ExternalFile macIconFile) {
        this.macIconFile = macIconFile;
    }

    public boolean isRestartFinder() {
        return this.replaceWithTextOverride("restartFinder", this.restartFinder);
    }

    public void setRestartFinder(boolean restartFinder) {
        this.restartFinder = restartFinder;
    }

    public ExternalFile getUnixIconFile() {
        return this.replaceWithTextOverride("unixIconFile", this.unixIconFile, ExternalFile.class);
    }

    public void setUnixIconFile(ExternalFile unixIconFile) {
        this.unixIconFile = unixIconFile;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        if (!this.isSelected()) {
            return true;
        }
        try {
            if (InstallerUtil.isWindows()) {
                if (this.isWindows()) {
                    return this.installWindows(context);
                }
            } else if (InstallerUtil.isMacOS()) {
                if (this.isMac()) {
                    return this.installMac(context);
                }
            } else if (!Util.isWindows() && !Util.isMacOS() && this.isUnix()) {
                return this.installUnix(context);
            }
            Util.logInfo(this, "Nothing to do");
        }
        catch (IOException e) {
            Util.log(e);
            return false;
        }
        return true;
    }

    @Override
    public boolean uninstall(UninstallerContext context) {
        try {
            if (InstallerUtil.isWindows()) {
                this.uninstallWindows();
            }
        }
        catch (Throwable e) {
            Util.log(e);
        }
        return true;
    }

    private void uninstallWindows() throws IOException, UserCanceledException {
        Properties persistentProperties = this.getPersistentProperties();
        String extension = persistentProperties.getProperty(PROP_EXTENSION);
        String executablePath = persistentProperties.getProperty("executable");
        if (executablePath == null || extension == null) {
            return;
        }
        File executable = new File(executablePath).getCanonicalFile();
        this.remove(extension, RegistryRoot.HKEY_CURRENT_USER, executable);
        this.remove(extension, RegistryRoot.HKEY_CLASSES_ROOT, executable);
    }

    private void remove(String extension, RegistryRoot registryRoot, File executable) throws IOException, UserCanceledException {
        int i;
        String[] extensions = CreateFileAssociationAction.getExtensions(extension);
        String[] registeredExecutableNames = new String[extensions.length];
        for (i = 0; i < extensions.length; ++i) {
            registeredExecutableNames[i] = FileAssociations.getExecutable(CreateFileAssociationAction.prependDot(extensions[i]), registryRoot);
        }
        for (i = 0; i < extensions.length; ++i) {
            String registeredExecutableName = registeredExecutableNames[i];
            if (registeredExecutableName == null || !Objects.equals(new File(registeredExecutableName).getCanonicalFile(), executable)) continue;
            FileAssociations.remove(CreateFileAssociationAction.prependDot(extensions[i]), registryRoot, true);
        }
    }

    private boolean installWindows(InstallerContext context) throws UserCanceledException {
        File executable = this.getExecutableFile(context);
        if (executable == null || !executable.exists()) {
            Util.logError(this, "executable does not exist: " + executable);
            return false;
        }
        File icon = context.getExternalFile(this.getWindowsIconFile(), true);
        String usedExtension = this.getExtension();
        String[] multipleExtensions = CreateFileAssociationAction.getExtensions(usedExtension);
        if (multipleExtensions.length < 2) {
            usedExtension = CreateFileAssociationAction.prependDot(usedExtension);
            this.addRollbackActions(FileAssociations.create(usedExtension, this.getDescription(), icon, executable, this.getWinAdditionalParameters()));
        } else {
            for (String singleExtension : multipleExtensions) {
                this.addRollbackActions(FileAssociations.create(CreateFileAssociationAction.prependDot(singleExtension), this.getDescription(), icon, executable, this.getWinAdditionalParameters()));
            }
        }
        Properties persistentProperties = this.getPersistentProperties();
        persistentProperties.setProperty(PROP_EXTENSION, usedExtension);
        persistentProperties.setProperty("executable", executable.getAbsolutePath());
        return true;
    }

    private boolean installUnix(final InstallerContext context) throws IOException, UserCanceledException {
        File executable = this.getExecutableFile(context);
        if (executable == null || !executable.isFile()) {
            Util.logError(this, "executable does not exist: " + executable);
            return false;
        }
        if (this.getUnixMimeType().isEmpty()) {
            Util.logError(this, "no mime type specified");
            return false;
        }
        String usedExtension = this.getExtension();
        usedExtension = CreateFileAssociationAction.removeLeadingDot(usedExtension);
        AbstractAssociationAction.UnixAssociationInfo associationInfo = CreateFileAssociationAction.getUnixAssociationInfo(executable);
        String iconName = null;
        if (this.getUnixIconFile() != null && !this.installUnixIcon(context, iconName = this.getFileBaseName(FileUtil.getCanonicalPath(context.getInstallationDirectory())), this.getUnixIconFile())) {
            iconName = null;
        }
        boolean success = true;
        Logger.getInstance().info(this, "existing desktop files: " + associationInfo.getDesktopFiles());
        for (File desktopFile : associationInfo.getDesktopFiles()) {
            if (!desktopFile.isFile() || this.executeForDesktopFile(context.getInstallationDirectory(), usedExtension, this.getDescription(), iconName, desktopFile)) continue;
            success = false;
        }
        final String finalUsedExtension = usedExtension;
        final String finalIconName = iconName;
        associationInfo.addAction(this, new AbstractAssociationAction.DesktopFileHandler(){

            @Override
            public void handle(File desktopFile) throws IOException, UserCanceledException {
                CreateFileAssociationAction.this.executeForDesktopFile(context.getInstallationDirectory(), finalUsedExtension, CreateFileAssociationAction.this.getDescription(), finalIconName, desktopFile);
            }
        });
        return success;
    }

    private boolean installUnixIcon(InstallerContext context, String iconName, ExternalFile externalFile) {
        File file = context.getExternalFile(externalFile, true);
        if (file != null) {
            if (!file.isFile()) {
                Util.logError(this, "icon file " + file + " not found.");
            } else {
                try {
                    int size = GUIHelper.getIconSize(file);
                    if (MenuHelper.execute("xdg-icon-resource", "install", "--mode", MenuHelper.getMode(), "--context", "mimetypes", "--size", String.valueOf(size), file.getAbsolutePath(), iconName)) {
                        FileInstaller.getInstance().registerPreUninstallCommand(file, "xdg-icon-resource", "uninstall", "--mode", MenuHelper.getMode(), "--context", "mimetypes", "--size", String.valueOf(size), iconName);
                        return true;
                    }
                }
                catch (IOException e) {
                    Util.log(e);
                }
            }
        }
        return false;
    }

    private boolean executeForDesktopFile(File installationDir, String extension, String description, String icon, File desktopFile) throws IOException, UserCanceledException {
        if (!this.installMimeType(installationDir, extension, description, icon)) {
            return false;
        }
        return CreateFileAssociationAction.addMimeTypeToDesktopFile(desktopFile, this.getUnixMimeType());
    }

    private boolean installMimeType(File installationDir, String extension, String description, String icon) throws IOException, UserCanceledException {
        if (!this.mimeTypeCreated) {
            String mimeType = this.getUnixMimeType();
            String installation = FileUtil.getCanonicalPath(installationDir);
            File tempFile = File.createTempFile("i4j", null);
            try {
                DocumentBuilderFactory factory = XmlHelper.createDocumentBuilderFactory();
                factory.setNamespaceAware(true);
                Document document = factory.newDocumentBuilder().newDocument();
                document.setXmlStandalone(true);
                Element root = document.createElementNS("http://www.freedesktop.org/standards/shared-mime-info", "mime-info");
                document.appendChild(root);
                Element mimeTypeEl = document.createElement(ELEMENT_MIME_TYPE);
                mimeTypeEl.setAttribute("type", mimeType);
                root.appendChild(mimeTypeEl);
                if (description != null && !description.isEmpty()) {
                    Element commentElement = document.createElement("comment");
                    commentElement.setTextContent(description);
                    mimeTypeEl.appendChild(commentElement);
                }
                if (icon != null && !icon.isEmpty()) {
                    Element iconElement = document.createElement("icon");
                    iconElement.setAttribute("name", icon);
                    mimeTypeEl.appendChild(iconElement);
                }
                for (String singleExtension : CreateFileAssociationAction.getExtensions(extension)) {
                    Element globElement = document.createElement("glob");
                    globElement.setAttribute("pattern", "*." + CreateFileAssociationAction.removeLeadingDot(singleExtension));
                    globElement.setAttribute("weight", "60");
                    mimeTypeEl.appendChild(globElement);
                }
                Element installerElement = document.createElementNS("http://www.ej-technologies.com/shared-mime-info-ext", ELEMENT_INSTALLATION);
                installerElement.setTextContent(installation);
                mimeTypeEl.appendChild(installerElement);
                byte[] bytes = XmlHelper.getBytes(document);
                try (FileOutputStream out = new FileOutputStream(tempFile);){
                    out.write(bytes);
                }
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e);
            }
            File runtimeDir = new File(installationDir, ".install4j");
            runtimeDir.mkdirs();
            File mimeFile = FileUtil.getCanonicalFile(new File(runtimeDir, this.getFileBaseName(installation) + ".xml"));
            FileInstaller.getInstance().install(tempFile, mimeFile, new FileOptions(new Date().getTime(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
            tempFile.delete();
            if (MenuHelper.execute(mimeFile.getParentFile(), "xdg-mime", "install", "--mode", MenuHelper.getMode(), mimeFile.getName())) {
                FileInstaller.getInstance().registerPreUninstallCommand(mimeFile, "xdg-mime", "uninstall", "--mode", MenuHelper.getMode(), mimeFile.getAbsolutePath());
            }
            this.mimeTypeCreated = true;
        }
        return true;
    }

    @NotNull
    private String getFileBaseName(String installationDir) {
        return MenuHelper.getVendorPrefix(installationDir) + this.getUnixMimeType().replace('/', '.');
    }

    private boolean installMac(InstallerContext context) throws IOException {
        File bundleDir = CreateFileAssociationAction.getBundleDir(context, this.getLauncherId());
        if (bundleDir != null && bundleDir.exists()) {
            File infoPlistFile = new File(bundleDir, "Contents/Info.plist");
            if (infoPlistFile.exists()) {
                final File icon = context.getExternalFile(this.getMacIconFile(), true);
                if (CreateFileAssociationAction.insertMacAssociation(infoPlistFile, icon, "<!-- I4J_INSERT_DOCTYPE -->", CF_BUNDLE_DOCUMENT_TYPES, new AbstractAssociationAction.InsertFunction(){

                    @Override
                    public void insert(PrintWriter pw, String bundleIdentifier) {
                        CreateFileAssociationAction.insertMacFileAssociation(pw, CreateFileAssociationAction.this.getExtension(), CreateFileAssociationAction.this.getDescription(), icon, CreateFileAssociationAction.this.getMacRole().toString());
                    }
                })) {
                    CreateFileAssociationAction.refresh(bundleDir, this.isRestartFinder());
                    return true;
                }
                Util.logError(this, "did not find insertion point");
            } else {
                Util.logError(this, "Info.plist not found: " + infoPlistFile);
            }
        } else {
            Util.logError(this, "bundleDir not found: " + bundleDir);
        }
        return false;
    }

    public static void insertMacFileAssociation(PrintWriter pw, String extension, String description, File icon, String role) {
        pw.println("<dict>");
        pw.println("<key>CFBundleTypeExtensions</key>");
        pw.println("<array>");
        for (String singleExtension : CreateFileAssociationAction.getExtensions(extension)) {
            pw.println("<string>" + CreateFileAssociationAction.removeLeadingDot(singleExtension) + "</string>");
        }
        pw.println("</array>");
        pw.println("<key>CFBundleTypeName</key>");
        pw.println("<string>" + XmlHelper.escapeXmlText(description) + "</string>");
        if (icon != null) {
            pw.println("<key>CFBundleTypeIconFile</key>");
            pw.println("<string>" + icon.getName() + "</string>");
        }
        pw.println("<key>CFBundleTypeRole</key>");
        pw.println("<string>" + role + "</string>");
        pw.println("</dict>");
    }

    @Override
    public boolean isUsedForStaticAssociation(String launcherId) {
        return super.isUsedForStaticAssociation(launcherId) && this.isMac() && this.isSelected();
    }

    public boolean fileExists(Context context) {
        File testFile = null;
        if (Util.isWindowsInstaller()) {
            testFile = this.getExecutableFile(context);
        } else if (Util.isMacosInstaller()) {
            testFile = CreateFileAssociationAction.getBundleDir(context, this.getLauncherId());
        }
        return testFile != null && testFile.exists();
    }

    private static String getInstallation(File mimeFile) {
        try {
            Element installation;
            Document readDoc = XmlHelper.parseFile(mimeFile);
            Element mimeType = XmlHelper.findChild(readDoc.getDocumentElement(), ELEMENT_MIME_TYPE);
            if (mimeType != null && (installation = XmlHelper.findChild(mimeType, ELEMENT_INSTALLATION)) != null) {
                System.out.println(installation.getTextContent());
            }
        }
        catch (Exception e) {
            Logger.getInstance().info(null, "could not parse " + mimeFile + ": " + e.toString());
        }
        return null;
    }

    public static String[] getExtensions(String extensionString) {
        if (extensionString == null) {
            return null;
        }
        String[] ret = extensionString.split(",");
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ret[i].trim();
        }
        return ret;
    }

    @NotNull
    private static String removeLeadingDot(String singleExtension) {
        if (singleExtension.startsWith(".")) {
            singleExtension = singleExtension.substring(1);
        }
        return singleExtension;
    }

    @NotNull
    private static String prependDot(String singleExtension) {
        if (!singleExtension.startsWith(".")) {
            singleExtension = "." + singleExtension;
        }
        return singleExtension;
    }
}

