/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.net;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.BackupFileForRollbackAction;
import com.install4j.runtime.beans.actions.net.DigestAlgorithm;
import com.install4j.runtime.beans.actions.net.DownloadAction;
import com.install4j.runtime.beans.actions.net.DualDigest;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.NoPercentageProgressDelegate;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.content.ChecksumChecker;
import com.install4j.runtime.installer.helper.content.Downloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Objects;

public class DownloadFileAction
extends DownloadAction {
    private File targetFile;
    private boolean showProgress = true;
    private boolean showFileName = true;
    private boolean deleteOnExit = false;
    private boolean checkDigest = false;
    private String digestUrl = "";
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
    private boolean dontAskForRetry = false;
    private boolean retryIfInterrupted = true;

    public boolean isCheckDigest() {
        return this.replaceWithTextOverride("checkDigest", this.checkDigest);
    }

    public void setCheckDigest(boolean checkForMd5Sums) {
        this.checkDigest = checkForMd5Sums;
    }

    public String getDigestUrl() {
        return DownloadFileAction.replaceVariables(DownloadFileAction.replaceVariables(this.digestUrl));
    }

    public void setDigestUrl(String digestUrl) {
        this.digestUrl = digestUrl;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.replaceWithTextOverride("digestAlgorithm", this.digestAlgorithm, DigestAlgorithm.class);
    }

    public void setDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }

    public boolean isDontAskForRetry() {
        return this.replaceWithTextOverride("dontAskForRetry", this.dontAskForRetry);
    }

    public void setDontAskForRetry(boolean dontAskForRetry) {
        this.dontAskForRetry = dontAskForRetry;
    }

    public boolean isRetryIfInterrupted() {
        return this.replaceWithTextOverride("retryIfInterrupted", this.retryIfInterrupted);
    }

    public void setRetryIfInterrupted(boolean retryIfInterrupted) {
        this.retryIfInterrupted = retryIfInterrupted;
    }

    public File getTargetFile() {
        return this.replaceWithTextOverride("targetFile", DownloadFileAction.replaceVariables(this.targetFile), File.class);
    }

    public void setTargetFile(File targetFile) {
        this.targetFile = targetFile;
    }

    public boolean isShowProgress() {
        return this.replaceWithTextOverride("showProgress", this.showProgress);
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public boolean isShowFileName() {
        return this.replaceWithTextOverride("showFileName", this.showFileName);
    }

    public void setShowFileName(boolean showFileName) {
        this.showFileName = showFileName;
    }

    public boolean isDeleteOnExit() {
        return this.replaceWithTextOverride("deleteOnExit", this.deleteOnExit);
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(Context context) throws UserCanceledException {
        boolean bl;
        block12: {
            File file = context.getDestinationFile(this.getTargetFile());
            ProgressInterface progressInterface = context.getProgressInterface();
            if (this.isShowProgress()) {
                if (this.isShowFileName()) {
                    String fileName = file.getName();
                    progressInterface.setStatusMessage(this.wrapMessageInNobr(Messages.format(Messages.getString(".DownloadingWithFileName"), "<b>" + fileName + "</b>")));
                } else {
                    progressInterface.setStatusMessage(Messages.getString(".Downloading"));
                }
            } else {
                progressInterface = new NoPercentageProgressDelegate(progressInterface);
            }
            BackupFileForRollbackAction backupFileForRollbackAction = null;
            if (context instanceof InstallerContext && file.exists()) {
                backupFileForRollbackAction = new BackupFileForRollbackAction(file, true);
                backupFileForRollbackAction.install((InstallerContext)context);
                this.addRollbackAction(backupFileForRollbackAction);
            }
            try {
                Downloader downloader = this.createDownloader(context, this.isShowProgress() ? progressInterface : null);
                bl = DownloadFileAction.doDownload(downloader, context, file, this.getUrl(), this.isDeleteOnExit(), this.isRetryIfInterrupted(), this.isCheckDigest(), this.getDigestUrl(), this.getDigestAlgorithm(), this.isDontAskForRetry());
                if (backupFileForRollbackAction == null) break block12;
            }
            catch (IOException e) {
                boolean bl2;
                block13: {
                    try {
                        if (this.isShowError()) {
                            Util.showErrorMessage(Messages.format(Messages.getString("updater.DownloadError"), this.getUrl()));
                        }
                        Logger.getInstance().error(this, "Could not download file");
                        Logger.getInstance().log(e);
                        if (backupFileForRollbackAction != null) {
                            backupFileForRollbackAction.rollback((InstallerContext)context);
                            backupFileForRollbackAction = null;
                        }
                        bl2 = false;
                        if (backupFileForRollbackAction == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (backupFileForRollbackAction != null) {
                            this.addRollbackAction(backupFileForRollbackAction);
                        }
                        throw throwable;
                    }
                    this.addRollbackAction(backupFileForRollbackAction);
                }
                return bl2;
            }
            this.addRollbackAction(backupFileForRollbackAction);
        }
        return bl;
    }

    private static boolean doDownload(Downloader downloader, Context context, File file, String url, boolean deleteOnExit, boolean retryIfInterrupted, boolean checkDigest, String digestUrl, DigestAlgorithm digestAlgorithm, boolean dontAskForRetry) throws UserCanceledException, IOException {
        MessageDigest messageDigest = digestAlgorithm.createMessageDigest();
        downloader.setMessageDigest(messageDigest);
        boolean success = true;
        String expectedChecksum = null;
        String actualChecksum = null;
        String actualSha1 = null;
        String actualMD5 = null;
        while (true) {
            boolean retry = false;
            try {
                downloader.connect(url);
            }
            catch (UserCanceledException e) {
                if (context.isCancelling()) {
                    throw new UserCanceledException();
                }
                success = false;
            }
            if (success) {
                try {
                    downloader.download(file, -1L, deleteOnExit);
                    if (messageDigest instanceof DualDigest) {
                        DualDigest dualDigest = (DualDigest)messageDigest;
                        actualSha1 = ChecksumChecker.getHexStringFromBytes(dualDigest.getSha256().digest());
                        actualMD5 = ChecksumChecker.getHexStringFromBytes(dualDigest.getMd5().digest());
                    } else {
                        actualChecksum = ChecksumChecker.getHexStringFromBytes(messageDigest.digest());
                    }
                }
                catch (FileNotFoundException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (retryIfInterrupted) {
                        Logger.getInstance().error(DownloadFileAction.class, "Could not download file");
                        Logger.getInstance().log(e);
                        retry = success = DownloadFileAction.askRetry(Messages.getString(".DownloadInterrupted"));
                    }
                    throw e;
                }
            }
            if (retry) continue;
            if (success) {
                if (expectedChecksum == null) {
                    expectedChecksum = checkDigest ? ChecksumChecker.getExpectedDigest(downloader, context, digestUrl, url, digestAlgorithm, file.getName()) : "";
                }
                if (!Objects.equals("", expectedChecksum)) {
                    if (messageDigest instanceof DualDigest) {
                        actualChecksum = expectedChecksum.length() > 32 ? actualSha1 : actualMD5;
                    }
                    Logger.getInstance().info(DownloadFileAction.class, "Expected digest " + expectedChecksum + ", actual digest " + actualChecksum);
                    if (!Objects.equals(expectedChecksum, actualChecksum)) {
                        downloader.resetLastTransfer();
                        success = dontAskForRetry ? false : DownloadFileAction.askRetry(Messages.getString(".DownloadFileCorrupt"));
                    }
                }
            }
            if (!success || Objects.equals("", expectedChecksum) || Objects.equals(actualChecksum, expectedChecksum)) break;
        }
        return success;
    }
}

