/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.function;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ExpressionWithFlags;
import org.h2.expression.Format;
import org.h2.expression.Subquery;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.function.DateTimeFunctions;
import org.h2.expression.function.FunctionCall;
import org.h2.expression.function.FunctionInfo;
import org.h2.expression.function.TableFunction;
import org.h2.expression.function.ToChar;
import org.h2.expression.function.ToDateParser;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mode.FunctionsMSSQLServer;
import org.h2.mode.FunctionsMySQL;
import org.h2.mode.FunctionsOracle;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.security.BlockCipher;
import org.h2.security.CipherFactory;
import org.h2.store.fs.FileUtils;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.LinkSchema;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.tools.CompressTool;
import org.h2.tools.Csv;
import org.h2.util.Bits;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.util.json.JSONByteArrayTarget;
import org.h2.util.json.JSONBytesSource;
import org.h2.util.json.JSONStringTarget;
import org.h2.util.json.JSONValidationTargetWithUniqueKeys;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueBytes;
import org.h2.value.ValueCollectionBase;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueJson;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueString;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;

public class Function
extends Expression
implements FunctionCall,
ExpressionWithFlags {
    public static final int ABS = 0;
    public static final int ACOS = 1;
    public static final int ASIN = 2;
    public static final int ATAN = 3;
    public static final int ATAN2 = 4;
    public static final int BITAND = 5;
    public static final int BITOR = 6;
    public static final int BITXOR = 7;
    public static final int CEILING = 8;
    public static final int COS = 9;
    public static final int COT = 10;
    public static final int DEGREES = 11;
    public static final int EXP = 12;
    public static final int FLOOR = 13;
    public static final int LOG = 14;
    public static final int LOG10 = 15;
    public static final int MOD = 16;
    public static final int PI = 17;
    public static final int POWER = 18;
    public static final int RADIANS = 19;
    public static final int RAND = 20;
    public static final int ROUND = 21;
    public static final int ROUNDMAGIC = 22;
    public static final int SIGN = 23;
    public static final int SIN = 24;
    public static final int SQRT = 25;
    public static final int TAN = 26;
    public static final int TRUNCATE = 27;
    public static final int SECURE_RAND = 28;
    public static final int HASH = 29;
    public static final int ENCRYPT = 30;
    public static final int DECRYPT = 31;
    public static final int COMPRESS = 32;
    public static final int EXPAND = 33;
    public static final int ZERO = 34;
    public static final int RANDOM_UUID = 35;
    public static final int COSH = 36;
    public static final int SINH = 37;
    public static final int TANH = 38;
    public static final int LN = 39;
    public static final int BITGET = 40;
    public static final int ORA_HASH = 41;
    public static final int BITNOT = 42;
    public static final int LSHIFT = 43;
    public static final int RSHIFT = 44;
    public static final int ASCII = 50;
    public static final int BIT_LENGTH = 51;
    public static final int CHAR = 52;
    public static final int CHAR_LENGTH = 53;
    public static final int CONCAT = 54;
    public static final int DIFFERENCE = 55;
    public static final int HEXTORAW = 56;
    public static final int INSERT = 57;
    public static final int INSTR = 58;
    public static final int LCASE = 59;
    public static final int LEFT = 60;
    public static final int LENGTH = 61;
    public static final int LOCATE = 62;
    public static final int LTRIM = 63;
    public static final int OCTET_LENGTH = 64;
    public static final int RAWTOHEX = 65;
    public static final int REPEAT = 66;
    public static final int REPLACE = 67;
    public static final int RIGHT = 68;
    public static final int RTRIM = 69;
    public static final int SOUNDEX = 70;
    public static final int SPACE = 71;
    public static final int SUBSTRING = 73;
    public static final int UCASE = 74;
    public static final int LOWER = 75;
    public static final int UPPER = 76;
    public static final int POSITION = 77;
    public static final int TRIM = 78;
    public static final int STRINGENCODE = 79;
    public static final int STRINGDECODE = 80;
    public static final int STRINGTOUTF8 = 81;
    public static final int UTF8TOSTRING = 82;
    public static final int XMLATTR = 83;
    public static final int XMLNODE = 84;
    public static final int XMLCOMMENT = 85;
    public static final int XMLCDATA = 86;
    public static final int XMLSTARTDOC = 87;
    public static final int XMLTEXT = 88;
    public static final int REGEXP_REPLACE = 89;
    public static final int RPAD = 90;
    public static final int LPAD = 91;
    public static final int CONCAT_WS = 92;
    public static final int TO_CHAR = 93;
    public static final int TRANSLATE = 94;
    public static final int QUOTE_IDENT = 95;
    public static final int TO_DATE = 96;
    public static final int TO_TIMESTAMP = 97;
    public static final int ADD_MONTHS = 98;
    public static final int TO_TIMESTAMP_TZ = 99;
    public static final int CURRENT_DATE = 100;
    public static final int CURRENT_TIME = 101;
    public static final int LOCALTIME = 102;
    public static final int CURRENT_TIMESTAMP = 103;
    public static final int LOCALTIMESTAMP = 104;
    public static final int DATEADD = 105;
    public static final int DATEDIFF = 106;
    public static final int DAY_NAME = 107;
    public static final int DAY_OF_MONTH = 108;
    public static final int DAY_OF_WEEK = 109;
    public static final int DAY_OF_YEAR = 110;
    public static final int HOUR = 111;
    public static final int MINUTE = 112;
    public static final int MONTH = 113;
    public static final int MONTH_NAME = 114;
    public static final int QUARTER = 115;
    public static final int SECOND = 116;
    public static final int WEEK = 117;
    public static final int YEAR = 118;
    public static final int EXTRACT = 119;
    public static final int FORMATDATETIME = 120;
    public static final int PARSEDATETIME = 121;
    public static final int ISO_YEAR = 122;
    public static final int ISO_WEEK = 123;
    public static final int ISO_DAY_OF_WEEK = 124;
    public static final int DATE_TRUNC = 125;
    public static final int MILLISECOND = 126;
    public static final int EPOCH = 127;
    public static final int MICROSECOND = 128;
    public static final int NANOSECOND = 129;
    public static final int TIMEZONE_HOUR = 130;
    public static final int TIMEZONE_MINUTE = 131;
    public static final int TIMEZONE_SECOND = 132;
    public static final int DECADE = 133;
    public static final int CENTURY = 134;
    public static final int MILLENNIUM = 135;
    public static final int DOW = 136;
    public static final int CURRENT_CATALOG = 150;
    public static final int USER = 151;
    public static final int CURRENT_USER = 152;
    public static final int IDENTITY = 153;
    public static final int SCOPE_IDENTITY = 154;
    public static final int AUTOCOMMIT = 155;
    public static final int READONLY = 156;
    public static final int DATABASE_PATH = 157;
    public static final int LOCK_TIMEOUT = 158;
    public static final int DISK_SPACE_USED = 159;
    public static final int SIGNAL = 160;
    public static final int ESTIMATED_ENVELOPE = 161;
    private static final Pattern SIGNAL_PATTERN = Pattern.compile("[0-9A-Z]{5}");
    public static final int IFNULL = 200;
    public static final int CASEWHEN = 201;
    public static final int CONVERT = 202;
    public static final int CAST = 203;
    public static final int COALESCE = 204;
    public static final int NULLIF = 205;
    public static final int CASE = 206;
    public static final int NEXTVAL = 207;
    public static final int CURRVAL = 208;
    public static final int ARRAY_GET = 209;
    public static final int CSVREAD = 210;
    public static final int CSVWRITE = 211;
    public static final int MEMORY_FREE = 212;
    public static final int MEMORY_USED = 213;
    public static final int LOCK_MODE = 214;
    public static final int CURRENT_SCHEMA = 215;
    public static final int SESSION_ID = 216;
    public static final int ARRAY_LENGTH = 217;
    public static final int LINK_SCHEMA = 218;
    public static final int GREATEST = 219;
    public static final int LEAST = 220;
    public static final int CANCEL_SESSION = 221;
    public static final int SET = 222;
    public static final int TABLE = 223;
    public static final int TABLE_DISTINCT = 224;
    public static final int FILE_READ = 225;
    public static final int TRANSACTION_ID = 226;
    public static final int TRUNCATE_VALUE = 227;
    public static final int NVL2 = 228;
    public static final int DECODE = 229;
    public static final int ARRAY_CONTAINS = 230;
    public static final int FILE_WRITE = 232;
    public static final int UNNEST = 233;
    public static final int ARRAY_CONCAT = 234;
    public static final int ARRAY_APPEND = 235;
    public static final int ARRAY_SLICE = 236;
    public static final int REGEXP_LIKE = 240;
    public static final int VALUES = 250;
    public static final int JSON_OBJECT = 251;
    public static final int JSON_ARRAY = 252;
    public static final int H2VERSION = 231;
    private static final int COUNT = 253;
    public static final int TRIM_LEADING = 1;
    public static final int TRIM_TRAILING = 2;
    public static final int JSON_ABSENT_ON_NULL = 1;
    public static final int JSON_WITH_UNIQUE_KEYS = 2;
    protected static final int VAR_ARGS = -1;
    private static final FunctionInfo[] FUNCTIONS_BY_ID = new FunctionInfo[253];
    private static final HashMap<String, FunctionInfo> FUNCTIONS_BY_NAME = new HashMap(256);
    private static final char[] SOUNDEX_INDEX = new char[128];
    protected Expression[] args;
    private int argsCount;
    protected final FunctionInfo info;
    private int flags;
    protected TypeInfo type;
    private final Database database;

    private static void addFunction(String string, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        FunctionInfo functionInfo = new FunctionInfo(string, n, n2, n3, bl, bl2, bl3, bl4);
        if (FUNCTIONS_BY_ID[n] == null) {
            Function.FUNCTIONS_BY_ID[n] = functionInfo;
        }
        FUNCTIONS_BY_NAME.put(string, functionInfo);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3) {
        Function.addFunctionNotDeterministic(string, n, n2, n3, true);
    }

    private static void addFunctionNotDeterministic(String string, int n, int n2, int n3, boolean bl) {
        Function.addFunction(string, n, n2, n3, true, false, bl, false);
    }

    private static void addFunction(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, true, true, true, false);
    }

    private static void addFunctionWithNull(String string, int n, int n2, int n3) {
        Function.addFunction(string, n, n2, n3, false, true, true, false);
    }

    public static Function getFunction(Database database, int n) {
        return Function.createFunction(database, FUNCTIONS_BY_ID[n], null);
    }

    public static Function getFunctionWithArgs(Database database, int n, Expression ... expressionArray) {
        return Function.createFunction(database, FUNCTIONS_BY_ID[n], expressionArray);
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo;
        if (!database.getSettings().databaseToUpper) {
            string = StringUtils.toUpperEnglish(string);
        }
        if ((functionInfo = FUNCTIONS_BY_NAME.get(string)) == null) {
            switch (database.getMode().getEnum()) {
                case MSSQLServer: {
                    return FunctionsMSSQLServer.getFunction(database, string);
                }
                case MySQL: {
                    return FunctionsMySQL.getFunction(database, string);
                }
                case Oracle: {
                    return FunctionsOracle.getFunction(database, string);
                }
            }
            return null;
        }
        return Function.createFunction(database, functionInfo, null);
    }

    private static Function createFunction(Database database, FunctionInfo functionInfo, Expression[] expressionArray) {
        switch (functionInfo.type) {
            case 223: 
            case 224: 
            case 233: {
                assert (expressionArray == null);
                return new TableFunction(database, functionInfo, Long.MAX_VALUE);
            }
        }
        return expressionArray != null ? new Function(database, functionInfo, expressionArray) : new Function(database, functionInfo);
    }

    public static FunctionInfo getFunctionInfo(String string) {
        return FUNCTIONS_BY_NAME.get(string);
    }

    public Function(Database database, FunctionInfo functionInfo) {
        this.database = database;
        this.info = functionInfo;
        int n = functionInfo.parameterCount;
        this.args = new Expression[n != -1 ? n : 4];
    }

    public Function(Database database, FunctionInfo functionInfo, Expression[] expressionArray) {
        this.database = database;
        this.info = functionInfo;
        int n = functionInfo.parameterCount;
        int n2 = expressionArray.length;
        if (n == -1) {
            this.checkParameterCount(n2);
        } else if (n != n2) {
            throw DbException.get(7001, functionInfo.name, Integer.toString(n));
        }
        this.args = expressionArray;
    }

    public void addParameter(Expression expression) {
        int n = this.args.length;
        if (this.argsCount >= n) {
            if (this.info.parameterCount != -1) {
                throw DbException.get(7001, this.info.name, Integer.toString(n));
            }
            this.args = Arrays.copyOf(this.args, n * 2);
        }
        this.args[this.argsCount++] = expression;
    }

    @Override
    public void setFlags(int n) {
        this.flags = n;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Value getValue(Session session) {
        return this.getValueWithArgs(session, this.args);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Value getSimpleValue(Session session, Value value, Expression[] expressionArray, Value[] valueArray) {
        Expression expression;
        block115: {
            int n;
            int n2;
            switch (this.info.type) {
                case 0: {
                    return value.getSignum() >= 0 ? value : value.negate();
                }
                case 1: {
                    return ValueDouble.get(Math.acos(value.getDouble()));
                }
                case 2: {
                    return ValueDouble.get(Math.asin(value.getDouble()));
                }
                case 3: {
                    return ValueDouble.get(Math.atan(value.getDouble()));
                }
                case 8: {
                    return Function.getCeilOrFloor(value, false);
                }
                case 9: {
                    return ValueDouble.get(Math.cos(value.getDouble()));
                }
                case 36: {
                    return ValueDouble.get(Math.cosh(value.getDouble()));
                }
                case 10: {
                    double d = Math.tan(value.getDouble());
                    if (d != 0.0) return ValueDouble.get(1.0 / d);
                    throw DbException.get(22012, this.getSQL(false));
                }
                case 11: {
                    return ValueDouble.get(Math.toDegrees(value.getDouble()));
                }
                case 12: {
                    return ValueDouble.get(Math.exp(value.getDouble()));
                }
                case 13: {
                    return Function.getCeilOrFloor(value, true);
                }
                case 39: {
                    double d = value.getDouble();
                    if (!(d <= 0.0)) return ValueDouble.get(Math.log(d));
                    throw DbException.getInvalidValueException("LN() argument", d);
                }
                case 14: {
                    return this.log(value, Function.getNullOrValue(session, expressionArray, valueArray, 1));
                }
                case 15: {
                    double d = value.getDouble();
                    if (!(d <= 0.0)) return ValueDouble.get(Math.log10(d));
                    throw DbException.getInvalidValueException("LOG10() argument", d);
                }
                case 17: {
                    return ValueDouble.get(Math.PI);
                }
                case 19: {
                    return ValueDouble.get(Math.toRadians(value.getDouble()));
                }
                case 20: {
                    if (value == null) return ValueDouble.get(session.getRandom().nextDouble());
                    session.getRandom().setSeed(value.getInt());
                    return ValueDouble.get(session.getRandom().nextDouble());
                }
                case 22: {
                    return ValueDouble.get(Function.roundMagic(value.getDouble()));
                }
                case 23: {
                    return ValueInt.get(value.getSignum());
                }
                case 24: {
                    return ValueDouble.get(Math.sin(value.getDouble()));
                }
                case 37: {
                    return ValueDouble.get(Math.sinh(value.getDouble()));
                }
                case 25: {
                    return ValueDouble.get(Math.sqrt(value.getDouble()));
                }
                case 26: {
                    return ValueDouble.get(Math.tan(value.getDouble()));
                }
                case 38: {
                    return ValueDouble.get(Math.tanh(value.getDouble()));
                }
                case 28: {
                    return ValueBytes.getNoCopy(MathUtils.secureRandomBytes(value.getInt()));
                }
                case 33: {
                    return ValueBytes.getNoCopy(CompressTool.getInstance().expand(value.getBytesNoCopy()));
                }
                case 34: {
                    return ValueInt.get(0);
                }
                case 35: {
                    return ValueUuid.getNewRandom();
                }
                case 50: {
                    String string = value.getString();
                    if (!string.isEmpty()) return ValueInt.get(string.charAt(0));
                    return ValueNull.INSTANCE;
                }
                case 51: {
                    return ValueLong.get(16L * Function.length(value));
                }
                case 52: {
                    return ValueString.get(String.valueOf((char)value.getInt()), this.database);
                }
                case 53: 
                case 61: {
                    return ValueLong.get(Function.length(value));
                }
                case 64: {
                    return ValueLong.get(2L * Function.length(value));
                }
                case 54: 
                case 92: {
                    Value value2 = ValueNull.INSTANCE;
                    int n3 = 0;
                    String string = "";
                    if (this.info.type == 92) {
                        n3 = 1;
                        string = Function.getNullOrValue(session, expressionArray, valueArray, 0).getString();
                    }
                    int n4 = n3;
                    while (true) {
                        if (n4 >= expressionArray.length) {
                            if (this.info.type != 92) return value2;
                            if (string == null) return value2;
                            if (value2 != ValueNull.INSTANCE) return value2;
                            return ValueString.get("", this.database);
                        }
                        Value value3 = Function.getNullOrValue(session, expressionArray, valueArray, n4);
                        if (value3 != ValueNull.INSTANCE) {
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value3;
                            } else {
                                String string2 = value3.getString();
                                if (!StringUtils.isNullOrEmpty(string) && !StringUtils.isNullOrEmpty(string2)) {
                                    string2 = string + string2;
                                }
                                value2 = ValueString.get(value2.getString() + string2, this.database);
                            }
                        }
                        ++n4;
                    }
                }
                case 56: {
                    return Function.hexToRaw(value.getString(), this.database);
                }
                case 59: 
                case 75: {
                    return ValueString.get(value.getString().toLowerCase(), this.database);
                }
                case 65: {
                    return ValueString.get(Function.rawToHex(value, this.database.getMode()), this.database);
                }
                case 70: {
                    return ValueString.get(Function.getSoundex(value.getString()), this.database);
                }
                case 71: {
                    int n5 = Math.max(0, value.getInt());
                    char[] cArray = new char[n5];
                    int n6 = n5 - 1;
                    while (true) {
                        if (n6 < 0) {
                            return ValueString.get(new String(cArray), this.database);
                        }
                        cArray[n6] = 32;
                        --n6;
                    }
                }
                case 74: 
                case 76: {
                    return ValueString.get(value.getString().toUpperCase(), this.database);
                }
                case 79: {
                    return ValueString.get(StringUtils.javaEncode(value.getString()), this.database);
                }
                case 80: {
                    return ValueString.get(StringUtils.javaDecode(value.getString()), this.database);
                }
                case 81: {
                    return ValueBytes.getNoCopy(value.getString().getBytes(StandardCharsets.UTF_8));
                }
                case 82: {
                    return ValueString.get(new String(value.getBytesNoCopy(), StandardCharsets.UTF_8), this.database);
                }
                case 85: {
                    return ValueString.get(StringUtils.xmlComment(value.getString()), this.database);
                }
                case 86: {
                    return ValueString.get(StringUtils.xmlCData(value.getString()), this.database);
                }
                case 87: {
                    return ValueString.get(StringUtils.xmlStartDoc(), this.database);
                }
                case 100: {
                    return session.currentTimestamp().convertTo(10);
                }
                case 101: {
                    return session.currentTimestamp().convertTo(41).convertScale(false, value == null ? 0 : value.getInt());
                }
                case 102: {
                    return session.currentTimestamp().convertTo(9).convertScale(false, value == null ? 0 : value.getInt());
                }
                case 103: {
                    return session.currentTimestamp().convertScale(false, value == null ? 6 : value.getInt());
                }
                case 104: {
                    return session.currentTimestamp().convertTo(11).convertScale(false, value == null ? 6 : value.getInt());
                }
                case 107: {
                    int n7 = DateTimeUtils.getSundayDayOfWeek(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(1)[n7], this.database);
                }
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 122: 
                case 123: 
                case 124: {
                    return ValueInt.get(DateTimeFunctions.getIntDatePart(value, this.info.type, this.database.getMode()));
                }
                case 114: {
                    int n8 = DateTimeUtils.monthFromDateValue(DateTimeUtils.dateAndTimeFromValue(value)[0]);
                    return ValueString.get(DateTimeFunctions.getMonthsAndWeeks(0)[n8 - 1], this.database);
                }
                case 150: {
                    return ValueString.get(this.database.getShortName(), this.database);
                }
                case 151: 
                case 152: {
                    return ValueString.get(session.getUser().getName(), this.database);
                }
                case 153: {
                    return session.getLastIdentity();
                }
                case 154: {
                    return session.getLastScopeIdentity();
                }
                case 155: {
                    return ValueBoolean.get(session.getAutoCommit());
                }
                case 156: {
                    return ValueBoolean.get(this.database.isReadOnly());
                }
                case 157: {
                    String string = this.database.getDatabasePath();
                    return string == null ? ValueNull.INSTANCE : ValueString.get(string, this.database);
                }
                case 158: {
                    return ValueInt.get(session.getLockTimeout());
                }
                case 159: {
                    return ValueLong.get(Function.getDiskSpaceUsed(session, value));
                }
                case 161: {
                    return Function.getEstimatedEnvelope(session, value, valueArray[1]);
                }
                case 202: 
                case 203: {
                    return this.type.cast(value, session, false, true, null);
                }
                case 212: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryFree());
                }
                case 213: {
                    session.getUser().checkAdmin();
                    return ValueInt.get(Utils.getMemoryUsed());
                }
                case 214: {
                    return ValueInt.get(this.database.getLockMode());
                }
                case 215: {
                    return ValueString.get(session.getCurrentSchemaName(), this.database);
                }
                case 216: {
                    return ValueInt.get(session.getId());
                }
                case 200: {
                    Value value2 = value;
                    if (value != ValueNull.INSTANCE) return value2.convertTo(this.type, session, false, null);
                    value2 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value2.convertTo(this.type, session, false, null);
                }
                case 201: {
                    Value value4 = !value.getBoolean() ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value4.convertTo(this.type, session, false, null);
                }
                case 229: {
                    int n9 = -1;
                    int n10 = expressionArray.length - 1;
                    for (int i = 1; i < n10; i += 2) {
                        if (!this.database.areEqual(value, Function.getNullOrValue(session, expressionArray, valueArray, i))) continue;
                        n9 = i + 1;
                        break;
                    }
                    if (n9 < 0 && expressionArray.length % 2 == 0) {
                        n9 = expressionArray.length - 1;
                    }
                    ValueNull valueNull = n9 < 0 ? ValueNull.INSTANCE : Function.getNullOrValue(session, expressionArray, valueArray, n9);
                    return valueNull.convertTo(this.type, session, false, null);
                }
                case 228: {
                    Value value5 = value == ValueNull.INSTANCE ? Function.getNullOrValue(session, expressionArray, valueArray, 2) : Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    return value5.convertTo(this.type, session, false, null);
                }
                case 204: {
                    Value value2 = value;
                    int n11 = 0;
                    while (n11 < expressionArray.length) {
                        Value value6 = Function.getNullOrValue(session, expressionArray, valueArray, n11);
                        if (value6 != ValueNull.INSTANCE) {
                            return value6.convertTo(this.type, session, false, null);
                        }
                        ++n11;
                    }
                    return value2;
                }
                case 219: 
                case 220: {
                    Value value2 = ValueNull.INSTANCE;
                    int n12 = 0;
                    while (n12 < expressionArray.length) {
                        Value value7 = Function.getNullOrValue(session, expressionArray, valueArray, n12);
                        if (value7 != ValueNull.INSTANCE) {
                            value7 = value7.convertTo(this.type, session, true, null);
                            if (value2 == ValueNull.INSTANCE) {
                                value2 = value7;
                            } else {
                                int n13 = this.database.compareTypeSafe(value2, value7);
                                if (this.info.type == 219 && n13 < 0) {
                                    value2 = value7;
                                } else if (this.info.type == 220 && n13 > 0) {
                                    value2 = value7;
                                }
                            }
                        }
                        ++n12;
                    }
                    return value2;
                }
                case 206: {
                    expression = null;
                    if (value == null) {
                        n2 = expressionArray.length - 1;
                        break;
                    }
                    if (value == ValueNull.INSTANCE) break block115;
                    int n14 = expressionArray.length - 1;
                    for (n = 1; n < n14; n += 2) {
                        Value value8 = expressionArray[n].getValue(session);
                        if (!this.database.areEqual(value, value8)) continue;
                        expression = expressionArray[n + 1];
                        break block115;
                    }
                    break block115;
                }
                case 209: {
                    Value[] valueArray2 = Function.getArray(value);
                    if (valueArray2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value9 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    int n15 = value9.getInt();
                    if (n15 < 1) return ValueNull.INSTANCE;
                    if (n15 > valueArray2.length) return ValueNull.INSTANCE;
                    return valueArray2[n15 - 1];
                }
                case 217: {
                    Value[] valueArray3 = Function.getArray(value);
                    if (valueArray3 == null) return ValueNull.INSTANCE;
                    return ValueInt.get(valueArray3.length);
                }
                case 230: {
                    Value value2 = ValueBoolean.FALSE;
                    Value[] valueArray4 = Function.getArray(value);
                    if (valueArray4 == null) {
                        return ValueNull.INSTANCE;
                    }
                    Value value10 = Function.getNullOrValue(session, expressionArray, valueArray, 1);
                    Value[] valueArray5 = valueArray4;
                    int n16 = valueArray5.length;
                    int n17 = 0;
                    while (n17 < n16) {
                        Value value11 = valueArray5[n17];
                        if (this.database.areEqual(value11, value10)) {
                            return ValueBoolean.TRUE;
                        }
                        ++n17;
                    }
                    return value2;
                }
                case 221: {
                    return ValueBoolean.get(Function.cancelStatement(session, value.getInt()));
                }
                case 226: {
                    return session.getTransactionId();
                }
                case 251: {
                    return this.jsonObject(session, expressionArray);
                }
                case 252: {
                    return this.jsonArray(session, expressionArray);
                }
                default: {
                    return null;
                }
            }
            for (n = 1; n < n2; n += 2) {
                Value value12 = expressionArray[n].getValue(session);
                if (!value12.getBoolean()) continue;
                expression = expressionArray[n + 1];
                break;
            }
        }
        if (expression == null && expressionArray.length % 2 == 0) {
            expression = expressionArray[expressionArray.length - 1];
        }
        ValueNull valueNull = expression == null ? ValueNull.INSTANCE : expression.getValue(session);
        return valueNull.convertTo(this.type, session, false, null);
    }

    private static Value getCeilOrFloor(Value value, boolean bl) {
        Value value2;
        int n = value.getValueType();
        if (n == 7 || n == 8) {
            double d = value.getDouble();
            d = bl ? Math.floor(d) : Math.ceil(d);
            value2 = n == 7 ? ValueDouble.get(d) : ValueFloat.get((float)d);
        } else {
            value2 = ValueDecimal.get(value.getBigDecimal().setScale(0, bl ? RoundingMode.FLOOR : RoundingMode.CEILING));
        }
        return value2;
    }

    private static Value[] getArray(Value value) {
        int n = value.getValueType();
        Object object = n == 17 || n == 39 ? ((ValueCollectionBase)value).getList() : null;
        return object;
    }

    private static boolean cancelStatement(Session session, int n) {
        Session[] sessionArray;
        session.getUser().checkAdmin();
        for (Session session2 : sessionArray = session.getDatabase().getSessions(false)) {
            if (session2.getId() != n) continue;
            Command command = session2.getCurrentCommand();
            if (command == null) {
                return false;
            }
            command.cancel();
            return true;
        }
        return false;
    }

    private static long getDiskSpaceUsed(Session session, Value value) {
        return Function.getTable(session, value).getDiskSpaceUsed();
    }

    private static Value getEstimatedEnvelope(Session session, Value value, Value value2) {
        Table table = Function.getTable(session, value);
        Column column = table.getColumn(value2.getString());
        ArrayList<Index> arrayList = table.getIndexes();
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 1; i < n; ++i) {
                Index index = arrayList.get(i);
                if (!(index instanceof MVSpatialIndex) || !index.isFirstColumn(column)) continue;
                return ((MVSpatialIndex)index).getEstimatedBounds(session);
            }
        }
        return ValueNull.INSTANCE;
    }

    private static Table getTable(Session session, Value value) {
        return new Parser(session).parseTableName(value.getString());
    }

    protected static Value getNullOrValue(Session session, Expression[] expressionArray, Value[] valueArray, int n) {
        if (n >= expressionArray.length) {
            return null;
        }
        Value value = valueArray[n];
        if (value == null) {
            Expression expression = expressionArray[n];
            if (expression == null) {
                return null;
            }
            value = valueArray[n] = expression.getValue(session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Value getValueWithArgs(Session var1_1, Expression[] var2_2) {
        var3_3 = new Value[var2_2.length];
        if (this.info.nullIfParameterIsNull) {
            for (var4_4 = 0; var4_4 < var2_2.length; ++var4_4) {
                var5_6 = var2_2[var4_4];
                var6_7 = var5_6.getValue(var1_1);
                if (var6_7 == ValueNull.INSTANCE) {
                    return ValueNull.INSTANCE;
                }
                var3_3[var4_4] = var6_7;
            }
        }
        if ((var5_6 = this.getSimpleValue(var1_1, var4_5 = this.info.specialArguments != false ? null : Function.getNullOrValue(var1_1, var2_2, var3_3, 0), var2_2, var3_3)) != null) {
            return var5_6;
        }
        var6_7 = Function.getNullOrValue(var1_1, var2_2, var3_3, 1);
        var7_8 = Function.getNullOrValue(var1_1, var2_2, var3_3, 2);
        var8_9 = Function.getNullOrValue(var1_1, var2_2, var3_3, 3);
        var9_10 = Function.getNullOrValue(var1_1, var2_2, var3_3, 4);
        var10_11 = Function.getNullOrValue(var1_1, var2_2, var3_3, 5);
        block10 : switch (this.info.type) {
            case 4: {
                var11_12 = ValueDouble.get(Math.atan2(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 5: {
                var11_12 = ValueLong.get(var4_5.getLong() & var6_7.getLong());
                break;
            }
            case 40: {
                var11_12 = ValueBoolean.get((var4_5.getLong() & 1L << var6_7.getInt()) != 0L);
                break;
            }
            case 42: {
                var11_12 = ValueLong.get(var4_5.getLong() ^ -1L);
                break;
            }
            case 6: {
                var11_12 = ValueLong.get(var4_5.getLong() | var6_7.getLong());
                break;
            }
            case 7: {
                var11_12 = ValueLong.get(var4_5.getLong() ^ var6_7.getLong());
                break;
            }
            case 43: {
                var11_12 = ValueLong.get(var4_5.getLong() << var6_7.getInt());
                break;
            }
            case 44: {
                var11_12 = ValueLong.get(var4_5.getLong() >> var6_7.getInt());
                break;
            }
            case 16: {
                var12_13 = var6_7.getLong();
                if (var12_13 == 0L) {
                    throw DbException.get(22012, this.getSQL(false));
                }
                var11_12 = ValueLong.get(var4_5.getLong() % var12_13);
                break;
            }
            case 18: {
                var11_12 = ValueDouble.get(Math.pow(var4_5.getDouble(), var6_7.getDouble()));
                break;
            }
            case 21: {
                var11_12 = this.round(var4_5, var6_7);
                break;
            }
            case 27: {
                var11_12 = Function.truncate(var1_1, var4_5, var6_7);
                break;
            }
            case 29: {
                var11_12 = Function.getHash(var4_5.getString(), var6_7, var7_8 == null ? 1 : var7_8.getInt());
                break;
            }
            case 30: {
                var11_12 = ValueBytes.getNoCopy(Function.encrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 31: {
                var11_12 = ValueBytes.getNoCopy(Function.decrypt(var4_5.getString(), var6_7.getBytesNoCopy(), var7_8.getBytesNoCopy()));
                break;
            }
            case 32: {
                var12_14 = null;
                if (var6_7 != null) {
                    var12_14 = var6_7.getString();
                }
                var11_12 = ValueBytes.getNoCopy(CompressTool.getInstance().compress(var4_5.getBytesNoCopy(), var12_14));
                break;
            }
            case 41: {
                var11_12 = Function.oraHash(var4_5, var6_7 == null ? 0xFFFFFFFFL : var6_7.getLong(), var7_8 == null ? 0L : var7_8.getLong());
                break;
            }
            case 55: {
                var11_12 = ValueInt.get(Function.getDifference(var4_5.getString(), var6_7.getString()));
                break;
            }
            case 57: {
                if (var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE) {
                    var11_12 = var6_7;
                    break;
                }
                var11_12 = ValueString.get(Function.insert(var4_5.getString(), var6_7.getInt(), var7_8.getInt(), var8_9.getString()), this.database);
                break;
            }
            case 60: {
                var11_12 = ValueString.get(Function.left(var4_5.getString(), var6_7.getInt()), this.database);
                break;
            }
            case 62: {
                var12_15 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), var12_15));
                break;
            }
            case 58: {
                var12_16 = var7_8 == null ? 0 : var7_8.getInt();
                var11_12 = ValueInt.get(Function.locate(var6_7.getString(), var4_5.getString(), var12_16));
                break;
            }
            case 66: {
                var12_17 = Math.max(0, var6_7.getInt());
                var11_12 = ValueString.get(Function.repeat(var4_5.getString(), var12_17), this.database);
                break;
            }
            case 67: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE || var7_8 == ValueNull.INSTANCE && this.database.getMode().getEnum() != Mode.ModeEnum.Oracle) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                var12_18 = var4_5.getString();
                var13_37 = var6_7.getString();
                v0 = var14_55 = var7_8 == null ? "" : var7_8.getString();
                if (var14_55 == null) {
                    var14_55 = "";
                }
                var11_12 = ValueString.get(StringUtils.replaceAll(var12_18, var13_37, var14_55), this.database);
                break;
            }
            case 68: {
                var11_12 = ValueString.get(Function.right(var4_5.getString(), var6_7.getInt()), this.database);
                break;
            }
            case 63: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), true, false, var6_7 == null ? " " : var6_7.getString()), this.database);
                break;
            }
            case 78: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), (this.flags & 1) != 0, (this.flags & 2) != 0, var6_7 == null ? " " : var6_7.getString()), this.database);
                break;
            }
            case 69: {
                var11_12 = ValueString.get(StringUtils.trim(var4_5.getString(), false, true, var6_7 == null ? " " : var6_7.getString()), this.database);
                break;
            }
            case 73: {
                var11_12 = this.substring(var4_5, var6_7, var7_8);
                break;
            }
            case 77: {
                var11_12 = ValueInt.get(Function.locate(var4_5.getString(), var6_7.getString(), 0));
                break;
            }
            case 83: {
                var11_12 = ValueString.get(StringUtils.xmlAttr(var4_5.getString(), var6_7.getString()), this.database);
                break;
            }
            case 84: {
                v1 = var6_7 == null ? null : (var12_19 = var6_7 == ValueNull.INSTANCE ? null : var6_7.getString());
                var13_38 = var7_8 == null ? null : (var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var14_56 = var8_9 == null ? true : var8_9.getBoolean();
                var11_12 = ValueString.get(StringUtils.xmlNode(var4_5.getString(), var12_19, var13_38, var14_56), this.database);
                break;
            }
            case 89: {
                var12_20 = var4_5.getString();
                var13_39 = var6_7.getString();
                var14_57 = var7_8.getString();
                var15_69 = var8_9 != null ? var8_9.getString() : null;
                var11_12 = this.regexpReplace(var12_20, var13_39, var14_57, var15_69);
                break;
            }
            case 90: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), true), this.database);
                break;
            }
            case 91: {
                var11_12 = ValueString.get(StringUtils.pad(var4_5.getString(), var6_7.getInt(), var7_8 == null ? null : var7_8.getString(), false), this.database);
                break;
            }
            case 93: {
                switch (var4_5.getValueType()) {
                    case 9: 
                    case 10: 
                    case 11: 
                    case 24: {
                        var11_12 = ValueString.get(ToChar.toCharDateTime(var4_5, var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database);
                        break block10;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        var11_12 = ValueString.get(ToChar.toChar(var4_5.getBigDecimal(), var6_7 == null ? null : var6_7.getString(), var7_8 == null ? null : var7_8.getString()), this.database);
                        break block10;
                    }
                }
                var11_12 = ValueString.get(var4_5.getString(), this.database);
                break;
            }
            case 96: {
                var11_12 = ToDateParser.toDate(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 97: {
                var11_12 = ToDateParser.toTimestamp(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 98: {
                var11_12 = DateTimeFunctions.dateadd("MONTH", var6_7.getInt(), var4_5);
                break;
            }
            case 99: {
                var11_12 = ToDateParser.toTimestampTz(var1_1, var4_5.getString(), var6_7 == null ? null : var6_7.getString());
                break;
            }
            case 94: {
                var12_21 = var6_7.getString();
                var13_40 = var7_8.getString();
                if (this.database.getMode().getEnum() == Mode.ModeEnum.DB2) {
                    var14_58 = var12_21;
                    var12_21 = var13_40;
                    var13_40 = var14_58;
                }
                var11_12 = ValueString.get(Function.translate(var4_5.getString(), var12_21, var13_40), this.database);
                break;
            }
            case 95: {
                var11_12 = ValueString.get(StringUtils.quoteIdentifier(var4_5.getString()), this.database);
                break;
            }
            case 231: {
                var11_12 = ValueString.get(Constants.VERSION, this.database);
                break;
            }
            case 105: {
                var11_12 = DateTimeFunctions.dateadd(var4_5.getString(), var6_7.getLong(), var7_8);
                break;
            }
            case 106: {
                var11_12 = ValueLong.get(DateTimeFunctions.datediff(var4_5.getString(), var6_7, var7_8));
                break;
            }
            case 125: {
                var11_12 = DateTimeFunctions.truncateDate(var4_5.getString(), var6_7);
                break;
            }
            case 119: {
                var11_12 = DateTimeFunctions.extract(var4_5.getString(), var6_7, this.database.getMode());
                break;
            }
            case 120: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v2 = var7_8 == null ? null : (var12_22 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                v3 = var8_9 == null ? null : (var13_41 = var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                if (var4_5 instanceof ValueTimestampTimeZone) {
                    var13_41 = DateTimeUtils.timeZoneNameFromOffsetSeconds(((ValueTimestampTimeZone)var4_5).getTimeZoneOffsetSeconds());
                }
                var11_12 = ValueString.get(DateTimeFunctions.formatDateTime(var4_5.getTimestamp(null), var6_7.getString(), var12_22, var13_41), this.database);
                break;
            }
            case 121: {
                if (var4_5 == ValueNull.INSTANCE || var6_7 == ValueNull.INSTANCE) {
                    var11_12 = ValueNull.INSTANCE;
                    break;
                }
                v4 = var7_8 == null ? null : (var12_23 = var7_8 == ValueNull.INSTANCE ? null : var7_8.getString());
                var13_42 = var8_9 == null ? null : (var8_9 == ValueNull.INSTANCE ? null : var8_9.getString());
                var14_59 = DateTimeFunctions.parseDateTime(var4_5.getString(), var6_7.getString(), var12_23, var13_42);
                var11_12 = ValueTimestamp.fromMillis(var14_59.getTime(), 0);
                break;
            }
            case 205: {
                var11_12 = this.database.areEqual(var4_5, var6_7) != false ? ValueNull.INSTANCE : var4_5;
                break;
            }
            case 207: {
                var11_12 = this.getSequence(var1_1, var4_5, var6_7).getNext(var1_1);
                break;
            }
            case 208: {
                var11_12 = var1_1.getCurrentValueFor(this.getSequence(var1_1, var4_5, var6_7));
                break;
            }
            case 210: {
                var12_24 = var4_5.getString();
                var13_43 = var6_7 == null ? null : var6_7.getString();
                var14_60 = new Csv();
                var15_70 = var7_8 == null ? null : var7_8.getString();
                var16_75 = null;
                if (var15_70 != null && var15_70.indexOf(61) >= 0) {
                    var16_75 = var14_60.setOptions(var15_70);
                } else {
                    var16_75 = var15_70;
                    var17_82 = var8_9 == null ? null : var8_9.getString();
                    var18_86 = var9_10 == null ? null : var9_10.getString();
                    var19_88 = var10_11 == null ? null : var10_11.getString();
                    var20_91 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var21_93 = var20_91 == null ? null : var20_91.getString();
                    Function.setCsvDelimiterEscape(var14_60, var17_82, (String)var18_86, var19_88);
                    var14_60.setNullString(var21_93);
                }
                var17_83 = var14_60.getFieldSeparatorRead();
                var18_86 = StringUtils.arraySplit(var13_43, var17_83, true);
                try {
                    var11_12 = ValueResultSet.get(var1_1, var14_60.read(var12_24, var18_86, var16_75), 0x7FFFFFFF);
                    break;
                }
                catch (SQLException var19_89) {
                    throw DbException.convert(var19_89);
                }
            }
            case 234: {
                var12_25 = (ValueArray)var4_5.convertTo(17);
                var13_44 = (ValueArray)var6_7.convertTo(17);
                if (!var12_25.getComponentType().equals(var13_44.getComponentType())) {
                    throw DbException.get(50000, "Expected component type " + var12_25.getComponentType() + " but got " + var13_44.getComponentType());
                }
                var14_61 = Arrays.copyOf(var12_25.getList(), var12_25.getList().length + var13_44.getList().length);
                System.arraycopy(var13_44.getList(), 0, var14_61, var12_25.getList().length, var13_44.getList().length);
                var11_12 = ValueArray.get(var12_25.getComponentType(), var14_61);
                break;
            }
            case 235: {
                var12_26 = (ValueArray)var4_5.convertTo(17);
                if (var6_7 != ValueNull.INSTANCE && var12_26.getComponentType() != Object.class && !var12_26.getComponentType().isInstance(var6_7.getObject())) {
                    throw DbException.get(50000, "Expected component type " + var12_26.getComponentType() + " but got " + var6_7.getClass());
                }
                var13_45 = Arrays.copyOf(var12_26.getList(), var12_26.getList().length + 1);
                var13_45[var12_26.getList().length] = var6_7;
                var11_12 = ValueArray.get(var12_26.getComponentType(), var13_45);
                break;
            }
            case 236: {
                var11_12 = null;
                var12_27 = (ValueArray)var4_5.convertTo(17);
                var13_46 = var6_7.getInt() - 1;
                var14_62 = var7_8.getInt();
                v5 = var15_71 = this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
                if (var13_46 > var14_62) {
                    var11_12 = var15_71 ? ValueArray.get(var12_27.getComponentType(), new Value[0]) : ValueNull.INSTANCE;
                } else {
                    if (var13_46 < 0) {
                        if (var15_71) {
                            var13_46 = 0;
                        } else {
                            var11_12 = ValueNull.INSTANCE;
                        }
                    }
                    if (var14_62 > var12_27.getList().length) {
                        if (var15_71) {
                            var14_62 = var12_27.getList().length;
                        } else {
                            var11_12 = ValueNull.INSTANCE;
                        }
                    }
                }
                if (var11_12 != null) break;
                var11_12 = ValueArray.get(var12_27.getComponentType(), Arrays.copyOfRange(var12_27.getList(), var13_46, var14_62));
                break;
            }
            case 218: {
                var1_1.getUser().checkAdmin();
                var12_28 = var1_1.createConnection(false);
                var13_47 = LinkSchema.linkSchema(var12_28, var4_5.getString(), var6_7.getString(), var7_8.getString(), var8_9.getString(), var9_10.getString(), var10_11.getString());
                var11_12 = ValueResultSet.get(var1_1, var13_47, 0x7FFFFFFF);
                break;
            }
            case 211: {
                var1_1.getUser().checkAdmin();
                var12_29 = var1_1.createConnection(false);
                var13_48 = new Csv();
                var14_63 = var7_8 == null ? null : var7_8.getString();
                var15_72 = null;
                if (var14_63 != null && var14_63.indexOf(61) >= 0) {
                    var15_72 = var13_48.setOptions(var14_63);
                } else {
                    var15_72 = var14_63;
                    var16_76 = var8_9 == null ? null : var8_9.getString();
                    var17_84 = var9_10 == null ? null : var9_10.getString();
                    var18_87 = var10_11 == null ? null : var10_11.getString();
                    var19_90 = Function.getNullOrValue(var1_1, var2_2, var3_3, 6);
                    var20_92 = var19_90 == null ? null : var19_90.getString();
                    var21_94 = Function.getNullOrValue(var1_1, var2_2, var3_3, 7);
                    var22_95 = var21_94 == null ? null : var21_94.getString();
                    Function.setCsvDelimiterEscape(var13_48, var16_76, var17_84, var18_87);
                    var13_48.setNullString(var20_92);
                    if (var22_95 != null) {
                        var13_48.setLineSeparator(var22_95);
                    }
                }
                try {
                    var16_77 = var13_48.write(var12_29, var4_5.getString(), var6_7.getString(), var15_72);
                    var11_12 = ValueInt.get(var16_77);
                    break;
                }
                catch (SQLException var16_78) {
                    throw DbException.convert(var16_78);
                }
            }
            case 222: {
                var12_30 = (Variable)var2_2[0];
                var1_1.setVariable(var12_30.getName(), var6_7);
                var11_12 = var6_7;
                break;
            }
            case 225: {
                var1_1.getUser().checkAdmin();
                var12_31 = var4_5.getString();
                var13_49 = var2_2.length == 1;
                try {
                    var14_64 = FileUtils.size(var12_31);
                    var16_79 = FileUtils.newInputStream(var12_31);
                    try {
                        if (var13_49) {
                            var11_12 = this.database.getLobStorage().createBlob(var16_79, var14_64);
                        } else {
                            var17_85 = var6_7 == ValueNull.INSTANCE ? new InputStreamReader(var16_79) : new InputStreamReader(var16_79, var6_7.getString());
                            var11_12 = this.database.getLobStorage().createClob(var17_85, var14_64);
                        }
                    }
                    finally {
                        IOUtils.closeSilently(var16_79);
                    }
                    var1_1.addTemporaryLob(var11_12);
                    break;
                }
                catch (IOException var14_65) {
                    throw DbException.convertIOException(var14_65, var12_31);
                }
            }
            case 232: {
                var1_1.getUser().checkAdmin();
                var11_12 = ValueNull.INSTANCE;
                var12_32 = var6_7.getString();
                try {
                    var13_50 = new FileOutputStream(var12_32);
                    var14_66 = var4_5.getInputStream();
                    var15_73 = null;
                    var11_12 = ValueLong.get(IOUtils.copyAndClose(var14_66, var13_50));
                    if (var14_66 == null) break;
                    if (var15_73 == null) ** GOTO lbl367
                    try {
                        var14_66.close();
                    }
                    catch (Throwable var16_80) {
                        var15_73.addSuppressed(var16_80);
                    }
                    break;
lbl367:
                    // 1 sources

                    var14_66.close();
                    ** break;
                    catch (Throwable var16_81) {
                        try {
                            var15_73 = var16_81;
                            throw var16_81;
                        }
                        catch (Throwable var24_97) {
                            if (var14_66 != null) {
                                if (var15_73 != null) {
                                    try {
                                        var14_66.close();
                                    }
                                    catch (Throwable var25_98) {
                                        var15_73.addSuppressed(var25_98);
                                    }
                                } else {
                                    var14_66.close();
                                }
                            }
                            throw var24_97;
lbl384:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (IOException var13_51) {
                    throw DbException.convertIOException(var13_51, var12_32);
                }
            }
            case 227: {
                var12_33 = var6_7.getLong();
                if (var7_8.getBoolean() && DataType.isNumericType(var14_67 = var4_5.getValueType()) && var14_67 != 6) {
                    var11_12 = var4_5.checkPrecision(var12_33) != false ? var4_5 : var4_5.convertTo(6).convertPrecision(var12_33).convertTo(var14_67);
                    break;
                }
                var11_12 = var4_5.convertPrecision(var12_33);
                break;
            }
            case 88: {
                if (var6_7 == null) {
                    var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString()), this.database);
                    break;
                }
                var11_12 = ValueString.get(StringUtils.xmlText(var4_5.getString(), var6_7.getBoolean()), this.database);
                break;
            }
            case 240: {
                var12_34 = var6_7.getString();
                var13_52 = var7_8 != null ? var7_8.getString() : null;
                var14_68 = Function.makeRegexpFlags(var13_52, false);
                try {
                    var11_12 = ValueBoolean.get(Pattern.compile(var12_34, var14_68).matcher(var4_5.getString()).find());
                    break;
                }
                catch (PatternSyntaxException var15_74) {
                    throw DbException.get(22025, var15_74, new String[]{var12_34});
                }
            }
            case 250: {
                var12_35 = var2_2[0];
                var13_53 = new StringBuilder();
                Parser.quoteIdentifier(var13_53, var12_35.getSchemaName(), true).append('.');
                Parser.quoteIdentifier(var13_53, var12_35.getTableName(), true).append('.');
                Parser.quoteIdentifier(var13_53, var12_35.getColumnName(), true);
                var11_12 = var1_1.getVariable(var13_53.toString());
                break;
            }
            case 160: {
                var12_36 = var4_5.getString();
                if (var12_36.startsWith("00") || !Function.SIGNAL_PATTERN.matcher(var12_36).matches()) {
                    throw DbException.getInvalidValueException("SQLSTATE", var12_36);
                }
                var13_54 = var6_7.getString();
                throw DbException.fromUser(var12_36, var13_54);
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return var11_12;
    }

    private Value round(Value value, Value value2) {
        Value value3;
        BigDecimal bigDecimal = value.getBigDecimal().setScale(value2 == null ? 0 : value2.getInt(), RoundingMode.HALF_UP);
        switch (this.type.getValueType()) {
            case 7: {
                value3 = ValueDouble.get(bigDecimal.doubleValue());
                break;
            }
            case 8: {
                value3 = ValueFloat.get(bigDecimal.floatValue());
                break;
            }
            default: {
                value3 = ValueDecimal.get(bigDecimal);
            }
        }
        return value3;
    }

    private static Value truncate(Session session, Value value, Value value2) {
        Value value3;
        int n = value.getValueType();
        switch (n) {
            case 11: {
                value3 = ValueTimestamp.fromDateValueAndNanos(((ValueTimestamp)value).getDateValue(), 0L);
                break;
            }
            case 10: {
                value3 = ValueTimestamp.fromDateValueAndNanos(((ValueDate)value).getDateValue(), 0L);
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                value3 = ValueTimestampTimeZone.fromDateValueAndNanos(valueTimestampTimeZone.getDateValue(), 0L, valueTimestampTimeZone.getTimeZoneOffsetSeconds());
                break;
            }
            case 13: {
                value3 = ValueTimestamp.fromDateValueAndNanos(ValueTimestamp.parse(value.getString(), session).getDateValue(), 0L);
                break;
            }
            default: {
                int n2;
                int n3 = n2 = value2 == null ? 0 : value2.getInt();
                if (n == 7 || n == 8) {
                    double d;
                    double d2 = value.getDouble();
                    d2 = n2 == 0 ? (d2 < 0.0 ? Math.ceil(d2) : Math.floor(d2)) : ((d2 *= (d = Math.pow(10.0, n2))) < 0.0 ? Math.ceil(d2) : Math.floor(d2)) / d;
                    value3 = n == 7 ? ValueDouble.get(d2) : ValueFloat.get((float)d2);
                    break;
                }
                value3 = ValueDecimal.get(value.getBigDecimal().setScale(n2, RoundingMode.DOWN));
            }
        }
        return value3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Sequence getSequence(Session session, Value value, Value value2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        if (value2 == null) {
            object3 = new Parser(session);
            object2 = value.getString();
            Expression expression = ((Parser)object3).parseExpression((String)object2);
            if (!(expression instanceof ExpressionColumn)) throw DbException.getSyntaxError((String)object2, 1);
            ExpressionColumn expressionColumn = (ExpressionColumn)expression;
            string = expressionColumn.getOriginalTableAliasName();
            if (string == null) {
                string = session.getCurrentSchemaName();
                object = object2;
            } else {
                object = expressionColumn.getColumnName();
            }
        } else {
            string = value.getString();
            object = value2.getString();
        }
        if ((object3 = this.database.findSchema(string)) == null) {
            string = StringUtils.toUpperEnglish(string);
            object3 = this.database.getSchema(string);
        }
        if ((object2 = ((Schema)object3).findSequence((String)object)) != null) return object2;
        object = StringUtils.toUpperEnglish((String)object);
        return ((Schema)object3).getSequence((String)object);
    }

    private static long length(Value value) {
        switch (value.getValueType()) {
            case 12: 
            case 15: 
            case 16: 
            case 19: {
                return value.getType().getPrecision();
            }
        }
        return value.getString().length();
    }

    private Value log(Value value, Value value2) {
        double d;
        double d2 = value.getDouble();
        Mode mode = this.database.getMode();
        if (value2 == null) {
            if (d2 <= 0.0) {
                throw DbException.getInvalidValueException("LOG() argument", d2);
            }
            d = mode.logIsLogBase10 ? Math.log10(d2) : Math.log(d2);
        } else {
            double d3 = value2.getDouble();
            if (!mode.swapLogFunctionParameters) {
                double d4 = d2;
                d2 = d3;
                d3 = d4;
            }
            if (d2 <= 0.0) {
                throw DbException.getInvalidValueException("LOG() argument", d2);
            }
            if (d3 <= 0.0 || d3 == 1.0) {
                throw DbException.getInvalidValueException("LOG() base", d3);
            }
            d = d3 == Math.E ? Math.log(d2) : (d3 == 10.0 ? Math.log10(d2) : Math.log(d2) / Math.log(d3));
        }
        return ValueDouble.get(d);
    }

    private static byte[] getPaddedArrayCopy(byte[] byArray, int n) {
        int n2 = MathUtils.roundUpInt(byArray.length, n);
        return Utils.copyBytes(byArray, n2);
    }

    private static byte[] decrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.decrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static byte[] encrypt(String string, byte[] byArray, byte[] byArray2) {
        BlockCipher blockCipher = CipherFactory.getBlockCipher(string);
        byte[] byArray3 = Function.getPaddedArrayCopy(byArray, blockCipher.getKeyLength());
        blockCipher.setKey(byArray3);
        byte[] byArray4 = Function.getPaddedArrayCopy(byArray2, 16);
        blockCipher.encrypt(byArray4, 0, byArray4.length);
        return byArray4;
    }

    private static Value getHash(String string, Value value, int n) {
        if (!"SHA256".equalsIgnoreCase(string)) {
            throw DbException.getInvalidValueException("algorithm", string);
        }
        if (n <= 0) {
            throw DbException.getInvalidValueException("iterations", n);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-256");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        byte[] byArray = messageDigest.digest();
        for (int i = 1; i < n; ++i) {
            byArray = messageDigest.digest(byArray);
        }
        return ValueBytes.getNoCopy(byArray);
    }

    private Value substring(Value value, Value value2, Value value3) {
        if (this.type.getValueType() == 12) {
            byte[] byArray = value.getBytesNoCopy();
            int n = byArray.length;
            int n2 = value2.getInt();
            if (n2 == 0) {
                n2 = 1;
            } else if (n2 < 0) {
                n2 = n + n2 + 1;
            }
            int n3 = value3 == null ? Math.max(n + 1, n2) : n2 + value3.getInt();
            n2 = Math.max(n2, 1);
            n3 = Math.min(n3, n + 1);
            if (n2 > n || n3 <= n2) {
                return ValueBytes.EMPTY;
            }
            if (--n2 == 0 && --n3 == byArray.length) {
                return value.convertTo(12);
            }
            return ValueBytes.getNoCopy(Arrays.copyOfRange(byArray, n2, n3));
        }
        String string = value.getString();
        int n = string.length();
        int n4 = value2.getInt();
        if (n4 == 0) {
            n4 = 1;
        } else if (n4 < 0) {
            n4 = n + n4 + 1;
        }
        int n5 = value3 == null ? Math.max(n + 1, n4) : n4 + value3.getInt();
        n4 = Math.max(n4, 1);
        n5 = Math.min(n5, n + 1);
        if (n4 > n || n5 <= n4) {
            return this.database.getMode().treatEmptyStringsAsNull ? ValueNull.INSTANCE : ValueString.EMPTY;
        }
        return ValueString.get(string.substring(n4 - 1, n5 - 1), null);
    }

    private static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * n);
        while (n-- > 0) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String rawToHex(Value value, Mode mode) {
        if (DataType.isBinaryStringOrSpecialBinaryType(value.getValueType())) {
            return StringUtils.convertBytesToHex(value.getBytesNoCopy());
        }
        String string = value.getString();
        if (mode.getEnum() == Mode.ModeEnum.Oracle) {
            return StringUtils.convertBytesToHex(string.getBytes(StandardCharsets.UTF_8));
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(4 * n);
        for (int i = 0; i < n; ++i) {
            String string2 = Integer.toHexString(string.charAt(i) & 0xFFFF);
            for (int j = string2.length(); j < 4; ++j) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static int locate(String string, String string2, int n) {
        if (n < 0) {
            int n2 = string2.length() + n;
            return string2.lastIndexOf(string, n2) + 1;
        }
        int n3 = n == 0 ? 0 : n - 1;
        return string2.indexOf(string, n3) + 1;
    }

    private static String right(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(string.length() - n);
    }

    private static String left(String string, int n) {
        if (n < 0) {
            n = 0;
        } else if (n > string.length()) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    private static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    private static Value hexToRaw(String string, Database database) {
        if (database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
            return ValueBytes.get(StringUtils.convertHexToBytes(string));
        }
        int n = string.length();
        if (n % 4 != 0) {
            throw DbException.get(22018, string);
        }
        StringBuilder stringBuilder = new StringBuilder(n / 4);
        for (int i = 0; i < n; i += 4) {
            try {
                char c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                stringBuilder.append(c);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw DbException.get(22018, string);
            }
        }
        return ValueString.get(stringBuilder.toString(), database);
    }

    private static int getDifference(String string, String string2) {
        string = Function.getSoundex(string);
        string2 = Function.getSoundex(string2);
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (string.charAt(i) != string2.charAt(i)) continue;
            ++n;
        }
        return n;
    }

    private static String translate(String string, String string2, String string3) {
        if (StringUtils.isNullOrEmpty(string) || StringUtils.isNullOrEmpty(string2)) {
            return string;
        }
        StringBuilder stringBuilder = null;
        int n = string3 == null ? 0 : string3.length();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            int n3 = string2.indexOf(c);
            if (n3 >= 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(n2);
                    if (i > 0) {
                        stringBuilder.append(string, 0, i);
                    }
                }
                if (n3 < n) {
                    c = string3.charAt(n3);
                }
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    private static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(d);
        if (stringBuilder.toString().indexOf(69) >= 0) {
            return d;
        }
        int n = stringBuilder.length();
        if (n < 16) {
            return d;
        }
        if (stringBuilder.toString().indexOf(46) > n - 3) {
            return d;
        }
        stringBuilder.delete(n - 2, n);
        char c = stringBuilder.charAt((n -= 2) - 2);
        char c2 = stringBuilder.charAt(n - 3);
        char c3 = stringBuilder.charAt(n - 4);
        if (c == '0' && c2 == '0' && c3 == '0') {
            stringBuilder.setCharAt(n - 1, '0');
        } else if (c == '9' && c2 == '9' && c3 == '9') {
            stringBuilder.setCharAt(n - 1, '9');
            stringBuilder.append('9');
            stringBuilder.append('9');
            stringBuilder.append('9');
        }
        return Double.parseDouble(stringBuilder.toString());
    }

    private static String getSoundex(String string) {
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        char c = '0';
        int n2 = 0;
        for (int i = 0; i < n && n2 < 4; ++i) {
            char c2;
            char c3 = string.charAt(i);
            char c4 = c2 = c3 > SOUNDEX_INDEX.length ? (char)'\u0000' : SOUNDEX_INDEX[c3];
            if (c2 == '\u0000') continue;
            if (n2 == 0) {
                cArray[n2++] = c3;
                c = c2;
                continue;
            }
            if (c2 <= '6') {
                if (c2 == c) continue;
                cArray[n2++] = c2;
                c = c2;
                continue;
            }
            if (c2 != '7') continue;
            c = c2;
        }
        return new String(cArray);
    }

    private static Value oraHash(Value value, long l, long l2) {
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("bucket", l);
        }
        if ((l2 & 0xFFFFFFFF00000000L) != 0L) {
            throw DbException.getInvalidValueException("seed", l2);
        }
        MessageDigest messageDigest = Function.hashImpl(value, "SHA-1");
        if (messageDigest == null) {
            return ValueNull.INSTANCE;
        }
        if (l2 != 0L) {
            byte[] byArray = new byte[4];
            Bits.writeInt(byArray, 0, (int)l2);
            messageDigest.update(byArray);
        }
        long l3 = Bits.readLong(messageDigest.digest(), 0);
        return ValueLong.get((l3 & Long.MAX_VALUE) % (l + 1L));
    }

    /*
     * Unable to fully structure code
     */
    private static MessageDigest hashImpl(Value var0, String var1_1) {
        switch (var0.getValueType()) {
            case 0: {
                return null;
            }
            case 13: 
            case 14: 
            case 21: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var2_2.update(var0.getString().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                catch (Exception var3_3) {
                    throw DbException.convert(var3_3);
                }
            }
            case 15: 
            case 16: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var3_4 = new byte[4096];
                    var4_7 = var0.getInputStream();
                    var5_8 = null;
                    while ((var6_9 = var4_7.read(var3_4)) > 0) {
                        var2_2.update(var3_4, 0, var6_9);
                    }
                    if (var4_7 == null) break;
                    if (var5_8 == null) ** GOTO lbl29
                    try {
                        var4_7.close();
                    }
                    catch (Throwable var6_10) {
                        var5_8.addSuppressed(var6_10);
                    }
                    break;
lbl29:
                    // 1 sources

                    var4_7.close();
                    ** break;
                    catch (Throwable var6_11) {
                        try {
                            var5_8 = var6_11;
                            throw var6_11;
                        }
                        catch (Throwable var7_12) {
                            if (var4_7 != null) {
                                if (var5_8 != null) {
                                    try {
                                        var4_7.close();
                                    }
                                    catch (Throwable var8_13) {
                                        var5_8.addSuppressed(var8_13);
                                    }
                                } else {
                                    var4_7.close();
                                }
                            }
                            throw var7_12;
lbl46:
                            // 1 sources

                            break;
                        }
                    }
                }
                catch (Exception var3_5) {
                    throw DbException.convert(var3_5);
                }
            }
            default: {
                try {
                    var2_2 = MessageDigest.getInstance(var1_1);
                    var2_2.update(var0.getBytesNoCopy());
                    break;
                }
                catch (Exception var3_6) {
                    throw DbException.convert(var3_6);
                }
            }
        }
        return var2_2;
    }

    private Value regexpReplace(String string, String string2, String string3, String string4) {
        int n;
        Mode mode = this.database.getMode();
        if (mode.regexpReplaceBackslashReferences && (string3.indexOf(92) >= 0 || string3.indexOf(36) >= 0)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < string3.length(); ++n) {
                char c = string3.charAt(n);
                if (c == '$') {
                    stringBuilder.append('\\');
                } else if (c == '\\' && ++n < string3.length()) {
                    c = string3.charAt(n);
                    stringBuilder.append((char)(c >= '0' && c <= '9' ? 36 : 92));
                }
                stringBuilder.append(c);
            }
            string3 = stringBuilder.toString();
        }
        boolean bl = Mode.ModeEnum.PostgreSQL.equals((Object)mode.getEnum());
        n = Function.makeRegexpFlags(string4, bl);
        try {
            Matcher matcher = Pattern.compile(string2, n).matcher(string);
            return ValueString.get(bl && (string4 == null || string4.indexOf(103) < 0) ? matcher.replaceFirst(string3) : matcher.replaceAll(string3), this.database);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DbException.get(22025, patternSyntaxException, string2);
        }
        catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            throw DbException.get(22025, runtimeException, string3);
        }
    }

    private static int makeRegexpFlags(String string, boolean bl) {
        int n = 64;
        if (string != null) {
            block7: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case 'i': {
                        n |= 2;
                        continue block7;
                    }
                    case 'c': {
                        n &= 0xFFFFFFFD;
                        continue block7;
                    }
                    case 'n': {
                        n |= 0x20;
                        continue block7;
                    }
                    case 'm': {
                        n |= 8;
                        continue block7;
                    }
                    case 'g': {
                        if (bl) continue block7;
                    }
                    default: {
                        throw DbException.get(90008, string);
                    }
                }
            }
        }
        return n;
    }

    private Value jsonObject(Session session, Expression[] expressionArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(123);
        int n = 0;
        int n2 = expressionArray.length;
        while (n < n2) {
            Value value;
            String string;
            if ((string = expressionArray[n++].getValue(session).getString()) == null) {
                throw DbException.getInvalidValueException("JSON_OBJECT key", "NULL");
            }
            if ((value = expressionArray[n++].getValue(session)) == ValueNull.INSTANCE) {
                if ((this.flags & 1) != 0) continue;
                value = ValueJson.NULL;
            }
            Function.jsonObjectAppend(byteArrayOutputStream, string, value);
        }
        return Function.jsonObjectFinish(byteArrayOutputStream, this.flags);
    }

    public static void jsonObjectAppend(ByteArrayOutputStream byteArrayOutputStream, String string, Value value) {
        if (byteArrayOutputStream.size() > 1) {
            byteArrayOutputStream.write(44);
        }
        JSONByteArrayTarget.encodeString(byteArrayOutputStream, string).write(58);
        byte[] byArray = value.convertTo(40).getBytesNoCopy();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    public static Value jsonObjectFinish(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(125);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if ((n & 2) != 0) {
            try {
                JSONBytesSource.parse(byArray, new JSONValidationTargetWithUniqueKeys());
            }
            catch (RuntimeException runtimeException) {
                String string = JSONBytesSource.parse(byArray, new JSONStringTarget());
                throw DbException.getInvalidValueException("JSON WITH UNIQUE KEYS", string.length() < 128 ? byArray : (byte[])(string.substring(0, 128) + "..."));
            }
        }
        return ValueJson.getInternal(byArray);
    }

    /*
     * Unable to fully structure code
     */
    private Value jsonArray(Session var1_1, Expression[] var2_2) {
        var3_3 = new ByteArrayOutputStream();
        var3_3.write(91);
        var4_4 = var2_2.length;
        if (var4_4 != 1) ** GOTO lbl-1000
        var5_5 = var2_2[0];
        if (var5_5 instanceof Subquery) {
            var6_7 = (Subquery)var5_5;
            for (Value var8_11 : var6_7.getAllRows(var1_1)) {
                Function.jsonArrayAppend(var3_3, var8_11, this.flags);
            }
        } else if (var5_5 instanceof Format && (var5_5 = (var6_8 = (Format)var5_5).getSubexpression(0)) instanceof Subquery) {
            var7_10 = (Subquery)var5_5;
            for (Value var9_13 : var7_10.getAllRows(var1_1)) {
                Function.jsonArrayAppend(var3_3, var6_8.getValue(var9_13), this.flags);
            }
        } else lbl-1000:
        // 2 sources

        {
            var5_6 = 0;
            while (var5_6 < var4_4) {
                Function.jsonArrayAppend(var3_3, var2_2[var5_6++].getValue(var1_1), this.flags);
            }
        }
        var3_3.write(93);
        return ValueJson.getInternal(var3_3.toByteArray());
    }

    public static void jsonArrayAppend(ByteArrayOutputStream byteArrayOutputStream, Value value, int n) {
        if (value == ValueNull.INSTANCE) {
            if ((n & 1) != 0) {
                return;
            }
            value = ValueJson.NULL;
        }
        if (byteArrayOutputStream.size() > 1) {
            byteArrayOutputStream.write(44);
        }
        byte[] byArray = value.convertTo(40).getBytesNoCopy();
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public int getValueType() {
        return this.type.getValueType();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    protected void checkParameterCount(int n) {
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        switch (this.info.type) {
            case 204: 
            case 210: 
            case 219: 
            case 220: {
                n2 = 1;
                break;
            }
            case 20: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                n3 = 1;
                break;
            }
            case 14: 
            case 21: 
            case 27: 
            case 32: 
            case 63: 
            case 69: 
            case 78: 
            case 88: 
            case 97: 
            case 99: 
            case 207: 
            case 208: 
            case 225: {
                n2 = 1;
                n3 = 2;
                break;
            }
            case 125: {
                n2 = 2;
                n3 = 2;
                break;
            }
            case 41: 
            case 93: 
            case 96: {
                n2 = 1;
                n3 = 3;
                break;
            }
            case 29: 
            case 58: 
            case 62: 
            case 67: 
            case 73: 
            case 90: 
            case 91: 
            case 240: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 54: 
            case 92: 
            case 211: {
                n2 = 2;
                break;
            }
            case 84: {
                n2 = 1;
                n3 = 4;
                break;
            }
            case 120: 
            case 121: {
                n2 = 2;
                n3 = 4;
                break;
            }
            case 206: 
            case 229: {
                n2 = 3;
                break;
            }
            case 89: {
                n2 = 3;
                n3 = 4;
                break;
            }
            case 251: 
            case 252: {
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
            }
        }
        if (n < n2 || n > n3) {
            throw DbException.get(7001, this.info.name, n2 + ".." + n3);
        }
    }

    public void doneWithParameters() {
        int n = this.info.parameterCount;
        if (n == -1) {
            this.checkParameterCount(this.argsCount);
            if (this.args.length != this.argsCount) {
                this.args = Arrays.copyOf(this.args, this.argsCount);
            }
        } else if (n != this.argsCount) {
            throw DbException.get(7001, this.info.name, Integer.toString(this.argsCount));
        }
    }

    public void setDataType(TypeInfo typeInfo) {
        this.type = typeInfo;
    }

    @Override
    public Expression optimize(Session session) {
        TypeInfo typeInfo;
        Expression expression;
        boolean bl = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            expression = this.args[i];
            if (expression == null) continue;
            this.args[i] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        expression = this.args.length < 1 ? null : this.args[0];
        block0 : switch (this.info.type) {
            case 105: {
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                if (!expression.isConstant()) break;
                Expression expression2 = this.args[2];
                block26 : switch (expression2.getType().getValueType()) {
                    case 9: {
                        typeInfo = TypeInfo.TYPE_TIME;
                        break;
                    }
                    case 10: {
                        int n = DateTimeFunctions.getDatePart(expression.getValue(session).getString());
                        switch (n) {
                            case 111: 
                            case 112: 
                            case 116: 
                            case 126: 
                            case 127: 
                            case 128: 
                            case 129: {
                                break block26;
                            }
                        }
                        this.type = TypeInfo.TYPE_DATE;
                        break;
                    }
                    case 24: {
                        this.type = TypeInfo.TYPE_TIMESTAMP_TZ;
                    }
                }
                break;
            }
            case 119: {
                if (expression.isConstant() && DateTimeFunctions.getDatePart(expression.getValue(session).getString()) == 127) {
                    typeInfo = TypeInfo.getTypeInfo(6, 28L, 9, null);
                    break;
                }
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 125: {
                typeInfo = this.args[1].getType();
                if (typeInfo.getValueType() == 24) break;
                typeInfo = TypeInfo.TYPE_TIMESTAMP;
                break;
            }
            case 200: 
            case 204: 
            case 205: 
            case 219: 
            case 220: {
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                for (Expression expression3 : this.args) {
                    TypeInfo typeInfo2;
                    int n;
                    if (expression3.isNullConstant() || (n = (typeInfo2 = expression3.getType()).getValueType()) == -1 || n == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo2);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 206: 
            case 229: {
                TypeInfo typeInfo3;
                int n;
                Expression expression4;
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                int n2 = this.args.length;
                for (int i = 2; i < n2; i += 2) {
                    TypeInfo typeInfo4;
                    int n3;
                    Expression expression5 = this.args[i];
                    if (expression5.isNullConstant() || (n3 = (typeInfo4 = expression5.getType()).getValueType()) == -1 || n3 == 0) continue;
                    typeInfo = Value.getHigherType(typeInfo, typeInfo4);
                }
                if (this.args.length % 2 == 0 && !(expression4 = this.args[this.args.length - 1]).isNullConstant() && (n = (typeInfo3 = expression4.getType()).getValueType()) != -1 && n != 0) {
                    typeInfo = Value.getHigherType(typeInfo, typeInfo3);
                }
                if (typeInfo.getValueType() != -1) break;
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 201: {
                typeInfo = Value.getHigherType(this.args[1].getType(), this.args[2].getType());
                break;
            }
            case 228: {
                TypeInfo typeInfo5 = this.args[1].getType();
                TypeInfo typeInfo6 = this.args[2].getType();
                switch (typeInfo5.getValueType()) {
                    case 13: 
                    case 14: 
                    case 16: 
                    case 21: {
                        typeInfo = TypeInfo.getTypeInfo(typeInfo5.getValueType(), -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = Value.getHigherType(typeInfo5, typeInfo6);
                break;
            }
            case 202: 
            case 203: 
            case 227: {
                if (this.type != null) {
                    typeInfo = this.type;
                    break;
                }
                typeInfo = TypeInfo.TYPE_UNKNOWN;
                break;
            }
            case 8: 
            case 13: 
            case 21: {
                switch (expression.getType().getValueType()) {
                    case 7: {
                        typeInfo = TypeInfo.TYPE_DOUBLE;
                        break block0;
                    }
                    case 8: {
                        typeInfo = TypeInfo.TYPE_FLOAT;
                        break block0;
                    }
                }
                typeInfo = this.getRoundNumericType(session);
                break;
            }
            case 27: {
                switch (expression.getType().getValueType()) {
                    case 7: {
                        typeInfo = TypeInfo.TYPE_DOUBLE;
                        break block0;
                    }
                    case 8: {
                        typeInfo = TypeInfo.TYPE_FLOAT;
                        break block0;
                    }
                    case 10: 
                    case 11: 
                    case 13: {
                        if (this.args.length > 1) {
                            throw DbException.get(7001, this.info.name, "1");
                        }
                        typeInfo = TypeInfo.getTypeInfo(11, -1L, 0, null);
                        break block0;
                    }
                    case 24: {
                        if (this.args.length > 1) {
                            throw DbException.get(7001, this.info.name, "1");
                        }
                        typeInfo = TypeInfo.getTypeInfo(24, -1L, 0, null);
                        break block0;
                    }
                }
                typeInfo = this.getRoundNumericType(session);
                break;
            }
            case 0: {
                TypeInfo typeInfo7;
                typeInfo = typeInfo7 = expression.getType();
                if (typeInfo.getValueType() != 0) break;
                typeInfo = TypeInfo.TYPE_INT;
                break;
            }
            case 222: {
                typeInfo = this.args[1].getType();
                if (expression instanceof Variable) break;
                throw DbException.get(90137, expression.getSQL(false));
            }
            case 225: {
                if (this.args.length == 1) {
                    typeInfo = TypeInfo.getTypeInfo(15, Integer.MAX_VALUE, 0, null);
                    break;
                }
                typeInfo = TypeInfo.getTypeInfo(16, Integer.MAX_VALUE, 0, null);
                break;
            }
            case 73: {
                TypeInfo typeInfo8 = this.args[0].getType();
                long l = typeInfo8.getPrecision();
                if (this.args[1].isConstant()) {
                    l -= this.args[1].getValue(session).getLong() - 1L;
                }
                if (this.args.length == 3 && this.args[2].isConstant()) {
                    l = Math.min(l, this.args[2].getValue(session).getLong());
                }
                l = Math.max(0L, l);
                typeInfo = TypeInfo.getTypeInfo(DataType.isBinaryStringType(typeInfo8.getValueType()) ? 12 : 13, l, 0, null);
                break;
            }
            case 30: 
            case 31: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[2].getType().getPrecision(), 0, null);
                break;
            }
            case 32: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 52: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 1L, 0, null);
                break;
            }
            case 54: {
                long l = 0L;
                for (Expression expression6 : this.args) {
                    TypeInfo typeInfo9 = expression6.getType();
                    if ((l += typeInfo9.getPrecision()) >= 0L) continue;
                    l = Long.MAX_VALUE;
                }
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l, 0, null);
                break;
            }
            case 56: {
                TypeInfo typeInfo10 = this.args[0].getType();
                if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
                    if (DataType.isStringType(typeInfo10.getValueType())) {
                        typeInfo = TypeInfo.getTypeInfo(12, typeInfo10.getPrecision() / 2L, 0, null);
                        break;
                    }
                    typeInfo = TypeInfo.TYPE_BYTES;
                    break;
                }
                if (DataType.isStringType(typeInfo10.getValueType())) {
                    typeInfo = TypeInfo.getTypeInfo(13, typeInfo10.getPrecision() / 4L, 0, null);
                    break;
                }
                typeInfo = TypeInfo.TYPE_STRING;
                break;
            }
            case 59: 
            case 63: 
            case 68: 
            case 69: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, this.args[0].getType().getPrecision(), 0, null);
                break;
            }
            case 65: {
                TypeInfo typeInfo11 = this.args[0].getType();
                long l = typeInfo11.getPrecision();
                int n = DataType.isBinaryStringOrSpecialBinaryType(typeInfo11.getValueType()) ? 2 : (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle ? 6 : 4);
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, l <= Long.MAX_VALUE / (long)n ? l * (long)n : Long.MAX_VALUE, 0, null);
                break;
            }
            case 70: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 4L, 0, null);
                break;
            }
            case 107: 
            case 114: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, 20L, 0, null);
                break;
            }
            case 207: 
            case 208: {
                typeInfo = this.database.getMode().decimalSequences ? TypeInfo.getTypeInfo(6, 19L, 0, null) : TypeInfo.TYPE_LONG;
                break;
            }
            default: {
                typeInfo = TypeInfo.getTypeInfo(this.info.returnDataType, -1L, -1, null);
            }
        }
        this.type = typeInfo;
        if (bl) {
            Value value = this.getValue(session);
            if (this.info.type == 203 || this.info.type == 202) {
                if (value == ValueNull.INSTANCE) {
                    return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
                }
                DataType dataType = DataType.getDataType(this.type.getValueType());
                TypeInfo typeInfo12 = value.getType();
                if (dataType.supportsPrecision && this.type.getPrecision() != typeInfo12.getPrecision() || dataType.supportsScale && this.type.getScale() != typeInfo12.getScale()) {
                    return TypedValueExpression.get(value, this.type);
                }
            }
            return ValueExpression.get(value);
        }
        return this;
    }

    private TypeInfo getRoundNumericType(Session session) {
        int n = 0;
        if (this.args.length > 1) {
            Expression expression = this.args[1];
            if (expression.isConstant()) {
                Value value = expression.getValue(session);
                if (value != ValueNull.INSTANCE) {
                    n = value.getInt();
                }
            } else {
                n = Integer.MAX_VALUE;
            }
        }
        return TypeInfo.getTypeInfo(6, Integer.MAX_VALUE, n, null);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        boolean bl2;
        stringBuilder.append(this.info.name);
        if (this.info.type == 206) {
            if (this.args[0] != null) {
                stringBuilder.append(' ');
                this.args[0].getSQL(stringBuilder, bl);
            }
            int n = this.args.length - 1;
            for (int i = 1; i < n; i += 2) {
                stringBuilder.append(" WHEN ");
                this.args[i].getSQL(stringBuilder, bl);
                stringBuilder.append(" THEN ");
                this.args[i + 1].getSQL(stringBuilder, bl);
            }
            if (this.args.length % 2 == 0) {
                stringBuilder.append(" ELSE ");
                this.args[this.args.length - 1].getSQL(stringBuilder, bl);
            }
            return stringBuilder.append(" END");
        }
        boolean bl3 = bl2 = this.args.length > 0 || this.info.requireParentheses;
        if (bl2) {
            stringBuilder.append('(');
        }
        switch (this.info.type) {
            case 73: {
                this.args[0].getSQL(stringBuilder, bl).append(" FROM ");
                this.args[1].getSQL(stringBuilder, bl);
                if (this.args.length <= 2) break;
                stringBuilder.append(" FOR ");
                this.args[2].getSQL(stringBuilder, bl);
                break;
            }
            case 78: {
                switch (this.flags) {
                    case 1: {
                        stringBuilder.append("LEADING ");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("TRAILING ");
                    }
                }
                if (this.args.length > 1) {
                    this.args[1].getSQL(stringBuilder, bl).append(" FROM ");
                }
                this.args[0].getSQL(stringBuilder, bl);
                break;
            }
            case 203: {
                this.args[0].getSQL(stringBuilder, bl).append(" AS ");
                this.type.getSQL(stringBuilder);
                break;
            }
            case 202: {
                if (this.database.getMode().swapConvertFunctionParameters) {
                    this.type.getSQL(stringBuilder).append(", ");
                    this.args[0].getSQL(stringBuilder, bl);
                    break;
                }
                this.args[0].getSQL(stringBuilder, bl).append(", ");
                this.type.getSQL(stringBuilder);
                break;
            }
            case 119: {
                ValueString valueString = (ValueString)((ValueExpression)this.args[0]).getValue(null);
                stringBuilder.append(valueString.getString()).append(" FROM ");
                this.args[1].getSQL(stringBuilder, bl);
                break;
            }
            case 251: {
                int n = 0;
                int n2 = this.args.length;
                while (n < n2) {
                    if (n > 0) {
                        stringBuilder.append(", ");
                    }
                    this.args[n++].getSQL(stringBuilder, bl).append(": ");
                    this.args[n++].getSQL(stringBuilder, bl);
                }
                Function.getJsonFunctionFlagsSQL(stringBuilder, this.flags, false);
                break;
            }
            case 252: {
                Function.writeExpressions(stringBuilder, this.args, bl);
                Function.getJsonFunctionFlagsSQL(stringBuilder, this.flags, true);
                break;
            }
            default: {
                Function.writeExpressions(stringBuilder, this.args, bl);
            }
        }
        if (bl2) {
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    public static void getJsonFunctionFlagsSQL(StringBuilder stringBuilder, int n, boolean bl) {
        if ((n & 1) != 0) {
            if (!bl) {
                stringBuilder.append(" ABSENT ON NULL");
            }
        } else if (bl) {
            stringBuilder.append(" NULL ON NULL");
        }
        if (!bl && (n & 2) != 0) {
            stringBuilder.append(" WITH UNIQUE KEYS");
        }
    }

    @Override
    public void updateAggregate(Session session, int n) {
        for (Expression expression : this.args) {
            if (expression == null) continue;
            expression.updateAggregate(session, n);
        }
    }

    public int getFunctionType() {
        return this.info.type;
    }

    @Override
    public String getName() {
        return this.info.name;
    }

    @Override
    public ValueResultSet getValueForColumnList(Session session, Expression[] expressionArray) {
        switch (this.info.type) {
            case 210: {
                ValueResultSet valueResultSet;
                ResultSet resultSet;
                String[] stringArray;
                String string = expressionArray[0].getValue(session).getString();
                if (string == null) {
                    throw DbException.get(90012, "fileName");
                }
                String string2 = expressionArray.length < 2 ? null : expressionArray[1].getValue(session).getString();
                Csv csv = new Csv();
                String string3 = expressionArray.length < 3 ? null : expressionArray[2].getValue(session).getString();
                String string4 = null;
                if (string3 != null && string3.indexOf(61) >= 0) {
                    string4 = csv.setOptions(string3);
                } else {
                    string4 = string3;
                    String string5 = expressionArray.length < 4 ? null : expressionArray[3].getValue(session).getString();
                    stringArray = expressionArray.length < 5 ? null : expressionArray[4].getValue(session).getString();
                    resultSet = expressionArray.length < 6 ? null : expressionArray[5].getValue(session).getString();
                    Function.setCsvDelimiterEscape(csv, string5, (String)stringArray, (String)((Object)resultSet));
                }
                char c = csv.getFieldSeparatorRead();
                stringArray = StringUtils.arraySplit(string2, c, true);
                resultSet = null;
                try {
                    resultSet = csv.read(string, stringArray, string4);
                    valueResultSet = ValueResultSet.get(session, resultSet, 0);
                }
                catch (SQLException sQLException) {
                    throw DbException.convert(sQLException);
                }
                finally {
                    csv.close();
                    JdbcUtils.closeSilently(resultSet);
                }
                return valueResultSet;
            }
        }
        return (ValueResultSet)this.getValueWithArgs(session, expressionArray);
    }

    private static void setCsvDelimiterEscape(Csv csv, String string, String string2, String string3) {
        char c;
        if (string != null) {
            csv.setFieldSeparatorWrite(string);
            if (!string.isEmpty()) {
                c = string.charAt(0);
                csv.setFieldSeparatorRead(c);
            }
        }
        if (string2 != null) {
            c = string2.isEmpty() ? (char)'\u0000' : string2.charAt(0);
            csv.setFieldDelimiter(c);
        }
        if (string3 != null) {
            c = string3.isEmpty() ? (char)'\u0000' : string3.charAt(0);
            csv.setEscapeCharacter(c);
        }
    }

    @Override
    public Expression[] getArgs() {
        return this.args;
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 2: 
            case 5: 
            case 8: {
                return this.info.deterministic;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        int n = 3;
        for (Expression expression : this.args) {
            if (expression == null) continue;
            n += expression.getCost();
        }
        return n;
    }

    @Override
    public boolean isDeterministic() {
        return this.info.deterministic;
    }

    @Override
    public int getSubexpressionCount() {
        return this.args.length;
    }

    @Override
    public Expression getSubexpression(int n) {
        return this.args[n];
    }

    static {
        String string = "7AEIOUY8HW1BFPV2CGJKQSXZ3DT4L5MN6R";
        char c = '\u0000';
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 < '9') {
                c = c2;
                continue;
            }
            Function.SOUNDEX_INDEX[c2] = c;
            Function.SOUNDEX_INDEX[Character.toLowerCase((char)c2)] = c;
        }
        Function.addFunction("ABS", 0, 1, 0);
        Function.addFunction("ACOS", 1, 1, 7);
        Function.addFunction("ASIN", 2, 1, 7);
        Function.addFunction("ATAN", 3, 1, 7);
        Function.addFunction("ATAN2", 4, 2, 7);
        Function.addFunction("BITAND", 5, 2, 5);
        Function.addFunction("BITGET", 40, 2, 1);
        Function.addFunction("BITNOT", 42, 1, 5);
        Function.addFunction("BITOR", 6, 2, 5);
        Function.addFunction("BITXOR", 7, 2, 5);
        Function.addFunction("CEILING", 8, 1, 0);
        Function.addFunction("CEIL", 8, 1, 0);
        Function.addFunction("COS", 9, 1, 7);
        Function.addFunction("COSH", 36, 1, 7);
        Function.addFunction("COT", 10, 1, 7);
        Function.addFunction("DEGREES", 11, 1, 7);
        Function.addFunction("EXP", 12, 1, 7);
        Function.addFunction("FLOOR", 13, 1, 0);
        Function.addFunction("LOG", 14, -1, 7);
        Function.addFunction("LN", 39, 1, 7);
        Function.addFunction("LOG10", 15, 1, 7);
        Function.addFunction("LSHIFT", 43, 2, 5);
        Function.addFunction("MOD", 16, 2, 5);
        Function.addFunction("PI", 17, 0, 7);
        Function.addFunction("POWER", 18, 2, 7);
        Function.addFunction("RADIANS", 19, 1, 7);
        Function.addFunctionNotDeterministic("RAND", 20, -1, 7);
        Function.addFunctionNotDeterministic("RANDOM", 20, -1, 7);
        Function.addFunction("ROUND", 21, -1, 0);
        Function.addFunction("ROUNDMAGIC", 22, 1, 7);
        Function.addFunction("RSHIFT", 44, 2, 5);
        Function.addFunction("SIGN", 23, 1, 4);
        Function.addFunction("SIN", 24, 1, 7);
        Function.addFunction("SINH", 37, 1, 7);
        Function.addFunction("SQRT", 25, 1, 7);
        Function.addFunction("TAN", 26, 1, 7);
        Function.addFunction("TANH", 38, 1, 7);
        Function.addFunction("TRUNCATE", 27, -1, 0);
        Function.addFunction("TRUNC", 27, -1, 0);
        Function.addFunction("HASH", 29, -1, 12);
        Function.addFunction("ENCRYPT", 30, 3, 12);
        Function.addFunction("DECRYPT", 31, 3, 12);
        Function.addFunctionNotDeterministic("SECURE_RAND", 28, 1, 12);
        Function.addFunction("COMPRESS", 32, -1, 12);
        Function.addFunction("EXPAND", 33, 1, 12);
        Function.addFunction("ZERO", 34, 0, 4);
        Function.addFunctionNotDeterministic("RANDOM_UUID", 35, 0, 20);
        Function.addFunctionNotDeterministic("UUID", 35, 0, 20);
        Function.addFunction("ORA_HASH", 41, -1, 5);
        Function.addFunction("ASCII", 50, 1, 4);
        Function.addFunction("BIT_LENGTH", 51, 1, 5);
        Function.addFunction("CHAR", 52, 1, 13);
        Function.addFunction("CHR", 52, 1, 13);
        Function.addFunction("CHAR_LENGTH", 53, 1, 4);
        Function.addFunction("CHARACTER_LENGTH", 53, 1, 4);
        Function.addFunctionWithNull("CONCAT", 54, -1, 13);
        Function.addFunctionWithNull("CONCAT_WS", 92, -1, 13);
        Function.addFunction("DIFFERENCE", 55, 2, 4);
        Function.addFunction("HEXTORAW", 56, 1, 0);
        Function.addFunctionWithNull("INSERT", 57, 4, 13);
        Function.addFunction("LCASE", 59, 1, 13);
        Function.addFunction("LEFT", 60, 2, 13);
        Function.addFunction("LENGTH", 61, 1, 5);
        Function.addFunction("LOCATE", 62, -1, 4);
        Function.addFunction("POSITION", 62, 2, 4);
        Function.addFunction("INSTR", 58, -1, 4);
        Function.addFunction("LTRIM", 63, -1, 13);
        Function.addFunction("OCTET_LENGTH", 64, 1, 5);
        Function.addFunction("RAWTOHEX", 65, 1, 13);
        Function.addFunction("REPEAT", 66, 2, 13);
        Function.addFunctionWithNull("REPLACE", 67, -1, 13);
        Function.addFunction("RIGHT", 68, 2, 13);
        Function.addFunction("RTRIM", 69, -1, 13);
        Function.addFunction("SOUNDEX", 70, 1, 13);
        Function.addFunction("SPACE", 71, 1, 13);
        Function.addFunction("SUBSTR", 73, -1, 0);
        Function.addFunction("SUBSTRING", 73, -1, 0);
        Function.addFunction("UCASE", 74, 1, 13);
        Function.addFunction("LOWER", 75, 1, 13);
        Function.addFunction("UPPER", 76, 1, 13);
        Function.addFunction("POSITION", 77, 2, 4);
        Function.addFunction("TRIM", 78, -1, 13);
        Function.addFunction("STRINGENCODE", 79, 1, 13);
        Function.addFunction("STRINGDECODE", 80, 1, 13);
        Function.addFunction("STRINGTOUTF8", 81, 1, 12);
        Function.addFunction("UTF8TOSTRING", 82, 1, 13);
        Function.addFunction("XMLATTR", 83, 2, 13);
        Function.addFunctionWithNull("XMLNODE", 84, -1, 13);
        Function.addFunction("XMLCOMMENT", 85, 1, 13);
        Function.addFunction("XMLCDATA", 86, 1, 13);
        Function.addFunction("XMLSTARTDOC", 87, 0, 13);
        Function.addFunction("XMLTEXT", 88, -1, 13);
        Function.addFunction("REGEXP_REPLACE", 89, -1, 13);
        Function.addFunction("RPAD", 90, -1, 13);
        Function.addFunction("LPAD", 91, -1, 13);
        Function.addFunction("TO_CHAR", 93, -1, 13);
        Function.addFunction("TRANSLATE", 94, 3, 13);
        Function.addFunction("QUOTE_IDENT", 95, 1, 13);
        Function.addFunction("REGEXP_LIKE", 240, -1, 1);
        Function.addFunctionNotDeterministic("CURRENT_DATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURDATE", 100, 0, 10);
        Function.addFunctionNotDeterministic("SYSDATE", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("TODAY", 100, 0, 10, false);
        Function.addFunctionNotDeterministic("CURRENT_TIME", 101, -1, 41, false);
        Function.addFunctionNotDeterministic("LOCALTIME", 102, -1, 9, false);
        Function.addFunctionNotDeterministic("SYSTIME", 102, 0, 9, false);
        Function.addFunctionNotDeterministic("CURTIME", 102, -1, 9);
        Function.addFunctionNotDeterministic("CURRENT_TIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("SYSTIMESTAMP", 103, -1, 24, false);
        Function.addFunctionNotDeterministic("LOCALTIMESTAMP", 104, -1, 11, false);
        Function.addFunctionNotDeterministic("NOW", 104, -1, 11);
        Function.addFunction("TO_DATE", 96, -1, 11);
        Function.addFunction("TO_TIMESTAMP", 97, -1, 11);
        Function.addFunction("ADD_MONTHS", 98, 2, 11);
        Function.addFunction("TO_TIMESTAMP_TZ", 99, -1, 24);
        Function.addFunction("DATEADD", 105, 3, 11);
        Function.addFunction("TIMESTAMPADD", 105, 3, 11);
        Function.addFunction("DATEDIFF", 106, 3, 5);
        Function.addFunction("TIMESTAMPDIFF", 106, 3, 5);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAYNAME", 107, 1, 13);
        Function.addFunction("DAY", 108, 1, 4);
        Function.addFunction("DAY_OF_MONTH", 108, 1, 4);
        Function.addFunction("DAY_OF_WEEK", 109, 1, 4);
        Function.addFunction("DAY_OF_YEAR", 110, 1, 4);
        Function.addFunction("DAYOFMONTH", 108, 1, 4);
        Function.addFunction("DAYOFWEEK", 109, 1, 4);
        Function.addFunction("DAYOFYEAR", 110, 1, 4);
        Function.addFunction("HOUR", 111, 1, 4);
        Function.addFunction("MINUTE", 112, 1, 4);
        Function.addFunction("MONTH", 113, 1, 4);
        Function.addFunction("MONTHNAME", 114, 1, 13);
        Function.addFunction("QUARTER", 115, 1, 4);
        Function.addFunction("SECOND", 116, 1, 4);
        Function.addFunction("WEEK", 117, 1, 4);
        Function.addFunction("YEAR", 118, 1, 4);
        Function.addFunction("EXTRACT", 119, 2, 4);
        Function.addFunctionWithNull("FORMATDATETIME", 120, -1, 13);
        Function.addFunctionWithNull("PARSEDATETIME", 121, -1, 11);
        Function.addFunction("ISO_YEAR", 122, 1, 4);
        Function.addFunction("ISO_WEEK", 123, 1, 4);
        Function.addFunction("ISO_DAY_OF_WEEK", 124, 1, 4);
        Function.addFunction("DATE_TRUNC", 125, 2, 0);
        Function.addFunctionNotDeterministic("CURRENT_CATALOG", 150, 0, 13, false);
        Function.addFunctionNotDeterministic("DATABASE", 150, 0, 13);
        Function.addFunctionNotDeterministic("USER", 151, 0, 13);
        Function.addFunctionNotDeterministic("CURRENT_USER", 152, 0, 13);
        Function.addFunctionNotDeterministic("IDENTITY", 153, 0, 5);
        Function.addFunctionNotDeterministic("SCOPE_IDENTITY", 154, 0, 5);
        Function.addFunctionNotDeterministic("IDENTITY_VAL_LOCAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("LASTVAL", 153, 0, 5);
        Function.addFunctionNotDeterministic("AUTOCOMMIT", 155, 0, 1);
        Function.addFunctionNotDeterministic("READONLY", 156, 0, 1);
        Function.addFunction("DATABASE_PATH", 157, 0, 13);
        Function.addFunctionNotDeterministic("LOCK_TIMEOUT", 158, 0, 4);
        Function.addFunctionWithNull("IFNULL", 200, 2, 0);
        Function.addFunctionWithNull("ISNULL", 200, 2, 0);
        Function.addFunctionWithNull("CASEWHEN", 201, 3, 0);
        Function.addFunctionWithNull("CONVERT", 202, 1, 0);
        Function.addFunctionWithNull("CAST", 203, 1, 0);
        Function.addFunctionWithNull("TRUNCATE_VALUE", 227, 3, 0);
        Function.addFunctionWithNull("COALESCE", 204, -1, 0);
        Function.addFunctionWithNull("NVL", 204, -1, 0);
        Function.addFunctionWithNull("NVL2", 228, 3, 0);
        Function.addFunctionWithNull("NULLIF", 205, 2, 0);
        Function.addFunctionWithNull("CASE", 206, -1, 0);
        Function.addFunctionNotDeterministic("NEXTVAL", 207, -1, 0);
        Function.addFunctionNotDeterministic("CURRVAL", 208, -1, 0);
        Function.addFunction("ARRAY_GET", 209, 2, 0);
        Function.addFunctionWithNull("ARRAY_CONTAINS", 230, 2, 1);
        Function.addFunction("ARRAY_CAT", 234, 2, 17);
        Function.addFunction("ARRAY_APPEND", 235, 2, 17);
        Function.addFunction("ARRAY_SLICE", 236, 3, 17);
        Function.addFunction("CSVREAD", 210, -1, 18, false, false, true, false);
        Function.addFunction("CSVWRITE", 211, -1, 4, false, false, true, false);
        Function.addFunctionNotDeterministic("MEMORY_FREE", 212, 0, 4);
        Function.addFunctionNotDeterministic("MEMORY_USED", 213, 0, 4);
        Function.addFunctionNotDeterministic("LOCK_MODE", 214, 0, 4);
        Function.addFunctionNotDeterministic("CURRENT_SCHEMA", 215, 0, 13, false);
        Function.addFunctionNotDeterministic("SCHEMA", 215, 0, 13);
        Function.addFunctionNotDeterministic("SESSION_ID", 216, 0, 4);
        Function.addFunction("ARRAY_LENGTH", 217, 1, 4);
        Function.addFunctionNotDeterministic("LINK_SCHEMA", 218, 6, 18);
        Function.addFunctionWithNull("LEAST", 220, -1, 0);
        Function.addFunctionWithNull("GREATEST", 219, -1, 0);
        Function.addFunctionNotDeterministic("CANCEL_SESSION", 221, 1, 1);
        Function.addFunction("SET", 222, 2, 0, false, false, true, false);
        Function.addFunction("FILE_READ", 225, -1, 0, false, false, true, false);
        Function.addFunction("FILE_WRITE", 232, 2, 5, false, false, true, false);
        Function.addFunctionNotDeterministic("TRANSACTION_ID", 226, 0, 13);
        Function.addFunctionWithNull("DECODE", 229, -1, 0);
        Function.addFunctionNotDeterministic("DISK_SPACE_USED", 159, 1, 5);
        Function.addFunctionWithNull("SIGNAL", 160, 2, 0);
        Function.addFunctionNotDeterministic("ESTIMATED_ENVELOPE", 161, 2, 5);
        Function.addFunction("H2VERSION", 231, 0, 13);
        Function.addFunctionWithNull("TABLE", 223, -1, 18);
        Function.addFunctionWithNull("TABLE_DISTINCT", 224, -1, 18);
        Function.addFunctionWithNull("UNNEST", 233, -1, 18);
        Function.addFunction("VALUES", 250, 1, 0, false, true, true, false);
        Function.addFunction("JSON_ARRAY", 252, -1, 40, false, true, true, true);
        Function.addFunction("JSON_OBJECT", 251, -1, 40, false, true, true, true);
    }
}

