/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.ReadIOException;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerDirectoryEvent;
import com.install4j.api.events.InstallerFileEvent;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.ContextInt;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.RemoveSignatureType;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.Unpacker;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.ExtendedFileOptions;
import com.install4j.runtime.installer.helper.fileinst.FileInstallerState;
import com.install4j.runtime.installer.helper.fileinst.FileRemover;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import com.install4j.runtime.installer.helper.fileinst.InstallHelper;
import com.install4j.runtime.installer.platform.macos.macho.SignatureRemover;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class FileInstaller
implements Serializable {
    public static final String PROPERTY_SIMULATE_FILE_FAILURE = "install4j.simulateFileFailure";
    private static final String SIMULATE_FILE_FAILURE_FILE_NAME = System.getProperty("install4j.simulateFileFailure");
    static final String LOG_FILENAME = "files.log";
    private static FileInstaller fileInstaller = new FileInstaller();
    private transient ProgressInterface defaultProgressInterface = new ProgressAdapter(null, false);
    private transient String lastOptionsVerbose;
    private transient FileInstallerState installerState = FileInstallerState.getInstance();
    private transient FileRemover fileRemover = new FileRemover();
    private int maxRollbackId = 0;

    public static FileInstaller getInstance() {
        FileInstaller.fileInstaller.lastOptionsVerbose = null;
        return fileInstaller;
    }

    public static void clearFileInstaller() {
        fileInstaller = new FileInstaller();
    }

    FileRemover getFileRemover() {
        return this.fileRemover;
    }

    private BackupPair backupFile(InstallFile file) throws IOException {
        long modTime = file.lastModified();
        File backupFile = File.createTempFile("i4b", null);
        backupFile.delete();
        if (!file.renameTo(backupFile)) {
            File newBackupFile;
            try {
                newBackupFile = File.createTempFile("i4b", null, file.getParentFile());
                newBackupFile.delete();
            }
            catch (IOException e) {
                newBackupFile = backupFile;
            }
            if (file.renameTo(newBackupFile)) {
                backupFile = newBackupFile;
            } else {
                FileUtil.copyFile(file, backupFile);
            }
        }
        BackupPair backupPair = new BackupPair(file, backupFile, modTime, HelperCommunication.getInstance().isElevatedHelper());
        this.installerState.addReplacedFile(backupPair);
        return backupPair;
    }

    private boolean checkFile(File tempFile, InstallFile destFile, int overwrite, UninstallMode uninstallMode, boolean previouslyCreated, ProgressInterface progressInterface) throws IOException, UserCanceledException {
        this.createDirectory(destFile.getParentFile(), InstallHelper.getParentUninstallMode(uninstallMode));
        if (destFile.exists()) {
            boolean overwriteWithoutAsking;
            if (overwrite == 0 || (overwrite == 4 || overwrite == 5) && this.installerState.isRespondedOverwriteNever()) {
                Logger.getInstance().info(null, "Don't overwrite because file exists (ron: " + this.installerState.isRespondedOverwriteNever() + ")");
                return false;
            }
            boolean bl = overwriteWithoutAsking = overwrite != 4 && overwrite != 5;
            if (overwrite == 2 || overwrite == 3) {
                boolean isNewer = InstallHelper.isFirstFileNewer(tempFile, destFile);
                if (!isNewer && (overwrite == 2 || this.installerState.isRespondedOverwriteNever())) {
                    Logger.getInstance().info(null, "Don't overwrite because existing file is newer (ron: " + this.installerState.isRespondedOverwriteNever() + ")");
                    return false;
                }
                overwriteWithoutAsking = isNewer;
            }
            if (overwrite == 1 || this.installerState.isRespondedOverwriteAlways() || previouslyCreated && overwrite != 5) {
                overwriteWithoutAsking = true;
            }
            if (!overwriteWithoutAsking) {
                switch (progressInterface.askOverwrite(destFile)) {
                    case 4: {
                        this.installerState.setRespondedOverwriteNever(true);
                        Logger.getInstance().info(null, "Don't overwrite because of user action (never)");
                        return false;
                    }
                    case 1: {
                        Logger.getInstance().info(null, "Don't overwrite because of user action (no)");
                        return false;
                    }
                    case 3: {
                        this.installerState.setRespondedOverwriteAlways(true);
                    }
                }
            }
            BackupPair currentBackupPair = this.backupFile(destFile);
            currentBackupPair.setPreviouslyCreated(previouslyCreated);
        } else {
            this.installerState.addCreatedFile(destFile, true);
        }
        return true;
    }

    public void registerPreUninstallCommand(File file, String command, String ... arguments) {
        this.installerState.registerPreUninstallCommand(file, Util.hasFullAdminRights(), command, arguments);
    }

    public void registerUninstallFile(File file) {
        InstallFile installFile = new InstallFile(file, false);
        if (file.isDirectory()) {
            this.installerState.addCreatedDir(installFile);
        } else {
            this.installerState.addCreatedFile(installFile, true);
        }
    }

    public void createDirectory(File dir, UninstallMode uninstallMode) {
        ContextInt context;
        try {
            dir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
        }
        ArrayList<File> dirList = new ArrayList<File>();
        for (File curDir = dir.getParentFile(); curDir != null; curDir = curDir.getParentFile()) {
            dirList.add(curDir);
        }
        UninstallMode parentMode = InstallHelper.getParentUninstallMode(uninstallMode);
        for (int i = dirList.size() - 1; i >= 0; --i) {
            File curDir = (File)dirList.get(i);
            boolean created = curDir.mkdir();
            if (!created && parentMode != UninstallMode.ALWAYS && parentMode != UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) continue;
            InstallFile createdDir = new InstallFile(curDir, false, parentMode);
            this.installerState.addCreatedDir(createdDir);
        }
        boolean fire = !dir.exists();
        boolean created = dir.mkdir();
        if (created || uninstallMode == UninstallMode.ALWAYS || uninstallMode == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
            InstallFile createdDir = new InstallFile(dir, false, uninstallMode);
            this.installerState.addCreatedDir(createdDir);
        }
        if (fire && (context = ContextImpl.getSingleContextInt()) != null) {
            context.fireInstallerEvent(new InstallerDirectoryEvent(context.getEventSource(), context, EventType.DIRECTORY_CREATED, created, dir));
        }
    }

    public void createDirectory(File dir) {
        this.createDirectory(dir, UninstallMode.IF_CREATED);
    }

    public boolean install(File sourceFile, File destFile) throws UserCanceledException {
        return this.install(sourceFile, destFile, new FileOptions(sourceFile.lastModified()));
    }

    public boolean install(File sourceFile, File destFile, FileOptions options) throws UserCanceledException {
        return this.install(sourceFile, destFile, options, null);
    }

    public boolean install(File sourceFile, File destFile, FileOptions options, ProgressInterface progressInterface) throws UserCanceledException {
        if (progressInterface == null) {
            progressInterface = this.defaultProgressInterface;
        }
        boolean ret = false;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(sourceFile));
            ret = this.install(in, destFile, options, progressInterface, sourceFile.length(), false);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
            String message = Messages.format(Messages.getString(".ErrorInternal2"), "Could not read " + sourceFile);
            progressInterface.showFailure(message);
        }
        return ret;
    }

    public boolean install(InputStream in, File destFile, FileOptions options) throws UserCanceledException, ReadIOException {
        return this.install(in, destFile, options, null, 0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean install(InputStream in, File destFile, FileOptions options, ProgressInterface progressInterface, long length, boolean unpackJars) throws UserCanceledException, ReadIOException {
        block45: {
            block50: {
                block46: {
                    block47: {
                        block48: {
                            block49: {
                                if (progressInterface == null) {
                                    progressInterface = this.defaultProgressInterface;
                                }
                                if ((removeSignatureType = FileInstaller.getRemoveSignatureType(options)) == RemoveSignatureType.REMOVE_FILE) {
                                    return true;
                                }
                                context = ContextImpl.getSingleContextInt();
                                if (context != null) {
                                    context.fireInstallerEvent(new InstallerFileEvent(context.getEventSource(), context, EventType.BEFORE_INSTALL_FILE, destFile, length));
                                }
                                if (!Objects.equals(this.lastOptionsVerbose, optionsVerbose = options.toString())) {
                                    Logger.getInstance().info(null, "File options set to: [" + optionsVerbose + "]");
                                    this.lastOptionsVerbose = optionsVerbose;
                                }
                                success = false;
                                try {
                                    delayedInstallation = false;
                                    successTemp = false;
                                    tryTemp = true;
lbl16:
                                    // 6 sources

                                    while (tryTemp && !successTemp && !success) {
                                        try {
                                            this.createDirectory(destFile.getParentFile(), InstallHelper.getParentUninstallMode(options.getUninstallMode()));
                                            tempFile = File.createTempFile("i4j", null, destFile.getParentFile());
                                            progressAdapter = new ProgressAdapter(progressInterface, false);
                                            isJarFile = destFile.getName().endsWith(".jar");
                                            if (unpackJars && isJarFile) {
                                                progressAdapter.setMaxCopyProgress(length * 3L);
                                            } else {
                                                progressAdapter.setMaxCopyProgress(length);
                                            }
                                            lowerCaseDestFileName = destFile.getName().toLowerCase(Locale.ENGLISH);
                                            if (!lowerCaseDestFileName.endsWith(".exe") && !lowerCaseDestFileName.endsWith(".dll")) ** GOTO lbl59
                                            if (!FileUtil.extractFile(in, tempFile, length, progressAdapter, true)) {
                                                tempFile.delete();
                                                var19_22 = false;
                                                if (!delayedInstallation) {
                                                    tempFile.delete();
                                                }
                                            }
                                            ** GOTO lbl-1000
                                            if (context == null) return var19_22;
                                            context.fireInstallerEvent(new InstallerFileEvent(context.getEventSource(), context, EventType.AFTER_INSTALL_FILE, success, destFile, length));
                                            return var19_22;
                                        }
                                        catch (IOException e) {
                                            if (e instanceof ReadIOException) {
                                                throw (ReadIOException)e;
                                            }
                                            Logger.getInstance().info(null, e.getMessage());
                                            switch (progressInterface.askRetry(destFile)) {
                                                case 1: {
                                                    tryTemp = false;
                                                    break;
                                                }
                                                case 3: {
                                                    throw new UserCanceledException();
                                                }
                                            }
                                        }
                                    }
                                    break block45;
                                }
                                catch (Throwable var25_31) {
                                    if (context == null) throw var25_31;
                                    context.fireInstallerEvent(new InstallerFileEvent(context.getEventSource(), context, EventType.AFTER_INSTALL_FILE, success, destFile, length));
                                    throw var25_31;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    successTemp = true;
lbl59:
                                    // 2 sources

                                    tempFile.setLastModified(options.getFileTime());
                                    shareableDestFile = new InstallFile(destFile, options.isShared(), options.getUninstallMode());
                                    previouslyCreated = this.installerState.wasPreviouslyCreated(destFile);
                                    if (!this.checkFile(tempFile, shareableDestFile, options.getOverwriteMode().getIntValue(), options.getUninstallMode(), previouslyCreated, progressInterface)) break block46;
                                    if (successTemp) break block47;
                                    if (FileUtil.extractFile(in, tempFile, length, progressAdapter, true)) break block48;
                                    tempFile.delete();
                                    var21_24 = false;
                                    if (delayedInstallation) break block49;
                                    tempFile.delete();
                                }
                            }
                            if (context == null) return var21_24;
                            context.fireInstallerEvent(new InstallerFileEvent(context.getEventSource(), context, EventType.AFTER_INSTALL_FILE, success, destFile, length));
                            return var21_24;
                        }
                        ** try [egrp 7[TRYBLOCK] [4 : 486->971)] { 
lbl78:
                        // 1 sources

                        tempFile.setLastModified(options.getFileTime());
                        successTemp = true;
                    }
                    if (unpackJars && isJarFile) {
                        unpackedTempFile = File.createTempFile("i4j", null, destFile.getParentFile());
                        try {
                            if (!Unpacker.unpack(tempFile, unpackedTempFile, progressAdapter)) {
                                FileUtil.rename(tempFile, unpackedTempFile);
                            }
                        }
                        catch (IOException e) {
                            Logger.getInstance().log(e);
                            progressInterface.showFailure("Corrupted .pack file for " + destFile.getPath() + ".\nPossibly the minimum Java version requirement for this installer has not been configured correctly.");
                            throw e;
                        }
                        tempFile.delete();
                        tempFile = unpackedTempFile;
                    }
                    tryInstall = true;
                    simulatedFileFailure = false;
                    while (tryInstall && !success) {
                        try {
                            if (destFile.getName().equals(FileInstaller.SIMULATE_FILE_FAILURE_FILE_NAME) & simulatedFileFailure == false) {
                                simulatedFileFailure = true;
                                throw new IOException("Simulated file failure");
                            }
                            InstallHelper.copyTemp(tempFile, shareableDestFile, options);
                            success = true;
                        }
                        catch (IOException e) {
                            if (InstallerUtil.isWindows() && Util.hasFullAdminRights() && options.isDelayIfNecessary()) {
                                delayedInstallation = true;
                                success = true;
                                this.installerState.addCreatedFile(new InstallFile(tempFile, false, UninstallMode.ALWAYS), false);
                                WinFileSystem.moveWithDelayUntilReboot(shareableDestFile, null);
                                WinFileSystem.moveWithDelayUntilReboot(tempFile, shareableDestFile);
                                this.installerState.setCurrentRebootRequired(true);
                                if (context != null) {
                                    context.setVariable("sys.rebootRequired", Boolean.TRUE);
                                }
                                Logger.getInstance().info(null, "Delayed installation of " + destFile.getPath() + " from " + tempFile.getPath() + " until reboot.");
                                continue;
                            }
                            Logger.getInstance().info(null, e.getMessage());
                            switch (progressInterface.askRetry(shareableDestFile)) {
                                case 1: {
                                    tryInstall = false;
                                    break;
                                }
                                case 3: {
                                    throw new UserCanceledException();
                                }
                            }
                        }
                    }
                    break block50;
                }
                Logger.getInstance().info(null, "Did not replace " + destFile.getPath());
                success = true;
                if (options.isShared() && !previouslyCreated && (options.getUninstallMode() == UninstallMode.ALWAYS || options.getUninstallMode() == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE)) {
                    this.installerState.addCreatedFile(shareableDestFile, false);
                }
            }
            if (!options.isShared() || previouslyCreated) ** GOTO lbl16
            InstallHelper.registerShared(destFile);
            ** GOTO lbl16
lbl137:
            // 1 sources

            finally {
                if (delayedInstallation) ** GOTO lbl16
                tempFile.delete();
            }
        }
        if (!success) {
            Logger.getInstance().error(null, "Could not write " + destFile.getPath());
        }
        if (success && removeSignatureType == RemoveSignatureType.REMOVE_SIGNATURE) {
            Logger.getInstance().info(null, "Removing notarization-only signature from " + destFile.getPath());
            try {
                SignatureRemover.removeFat(destFile);
            }
            catch (IOException e) {
                Logger.getInstance().log(e);
            }
        }
        var15_17 = success;
        if (context == null) return var15_17;
        context.fireInstallerEvent(new InstallerFileEvent(context.getEventSource(), context, EventType.AFTER_INSTALL_FILE, success, destFile, length));
        return var15_17;
    }

    public static RemoveSignatureType getRemoveSignatureType(FileOptions options) {
        if (InstallerUtil.isMacOS() && options instanceof ExtendedFileOptions) {
            return ((ExtendedFileOptions)options).getRemoveSignatureType();
        }
        return RemoveSignatureType.KEEP;
    }

    public void setDefaultProgressInterface(ProgressInterface progressInterface) {
        this.defaultProgressInterface = new ProgressAdapter(progressInterface, true);
    }

    public void setRollbackBarrier() {
        this.installerState.setRollbackBarrier();
    }

    public void setLogDir(File logDir) {
        this.installerState.setLogDir(logDir);
    }

    public void writeLog() throws IOException, UserCanceledException {
        this.installerState.writeLog();
    }

    public boolean wasPreviouslyCreated(File destFile) {
        return this.installerState.wasPreviouslyCreated(destFile);
    }

    public boolean hasRollbackFiles() {
        return this.installerState.hasRollbackFiles();
    }

    public boolean isFileRollbackPerformed() {
        return this.installerState.isFileRollbackPerformed();
    }

    public boolean hasUnrollbackedFiles() {
        return this.installerState.hasUnrollbackedFiles();
    }

    public void registerCleanupFile(File file) {
        this.installerState.registerCleanupFile(file);
    }

    public void cleanup() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().cleanup(context.getProgressInterface());
            }
        });
    }

    public void finishUninstall() {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                try {
                    FileInstaller.getInstance().getFileRemover().finishUninstall();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void deleteRecursive(final File directory) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().deleteRecursive(directory);
            }
        });
    }

    public void deleteFile(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().deleteFile(file);
            }
        });
    }

    public void deleteDir(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().deleteDir(file);
            }
        });
    }

    public void uninstall(final boolean uninstallForUpgrade, final File installationDirectory) throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                try {
                    FileInstaller.getInstance().getFileRemover().uninstall(context.getProgressInterface(), uninstallForUpgrade, installationDirectory);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void rollback(final int id) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().rollback(context.getProgressInterface(), id);
            }
        });
    }

    public void rollbackAll() {
        this.rollback(-1);
    }

    public List<File> deleteUndeleted() {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.MAXIMUM, new FetchObjectAction<List<File>>(){

            @Override
            protected List<File> fetchValue(Context context) throws UserCanceledException {
                return FileInstaller.getInstance().getFileRemover().deleteUndeleted();
            }
        });
    }

    public void resetCurrentRebootRequired() {
        this.installerState.setCurrentRebootRequired(false);
    }

    public boolean isCurrentRebootRequired() {
        return this.installerState.isCurrentRebootRequired();
    }

    public void setCurrentAction(ActionBeanConfig actionBeanConfig) {
        if (actionBeanConfig.getRollbackId() == -1) {
            actionBeanConfig.setRollbackId(++this.maxRollbackId);
        }
        this.installerState.setRollbackIds(actionBeanConfig.getRollbackId(), this.maxRollbackId);
    }

    public void addRetainedFile(final File file) {
        HelperCommunication.getInstance().executeAction(ExecutionContext.MAXIMUM, new RunAction(){

            @Override
            protected void run(Context context) {
                FileInstaller.getInstance().getFileRemover().addRetainedFile(file);
            }
        });
    }
}

