/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.Part;
import com.install4j.runtime.installer.platform.macos.macho.VersionCommand;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BuildVersionCommand
extends VersionCommand {
    public static final int PLATFORM_MACOS = 1;
    public static final int PLATFORM_IOS = 2;
    public static final int PLATFORM_TVOS = 3;
    public static final int PLATFORM_WATCHOS = 4;
    public static final int PLATFORM_BRIDGEOS = 5;
    private int platform;
    private final List<BuildToolVersion> tools = new ArrayList<BuildToolVersion>();

    public BuildVersionCommand(int contentLength) {
        super(contentLength);
    }

    @Override
    public void readData(ByteBuffer buf, boolean bit64) throws IOException {
        this.platform = buf.getInt();
        this.setMinos(buf.getInt());
        this.setSdk(buf.getInt());
        int ntools = buf.getInt();
        this.tools.clear();
        for (int i = 0; i < ntools; ++i) {
            BuildToolVersion buildToolVersion = new BuildToolVersion();
            buildToolVersion.read(buf, bit64);
            this.tools.add(buildToolVersion);
        }
    }

    @Override
    public void writeData(ByteBuffer buf, boolean bit64) throws IOException {
        buf.putInt(this.platform);
        buf.putInt(this.getMinos());
        buf.putInt(this.getSdk());
        buf.putInt(this.tools.size());
        for (BuildToolVersion tool : this.tools) {
            tool.write(buf, bit64);
        }
    }

    private static class BuildToolVersion
    implements Part {
        public static final int TOOL_CLANG = 1;
        public static final int TOOL_SWIFT = 2;
        public static final int TOOL_LD = 3;
        private int tool;
        private int version;

        private BuildToolVersion() {
        }

        @Override
        public void read(ByteBuffer buf, boolean bit64) throws IOException {
            this.tool = buf.getInt();
            this.version = buf.getInt();
        }

        @Override
        public void write(ByteBuffer buf, boolean bit64) throws IOException {
            buf.putInt(this.tool);
            buf.putInt(this.version);
        }
    }
}

