/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.net.URL;
import java.util.List;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.core.simplifierrules.ParseException;
import net.sf.okapi.core.simplifierrules.SimplifierRules;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroupParameters
extends StringParameters
implements ISimplifierRulesParameters {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String data;

    protected abstract void load(ParametersString var1);

    protected abstract void save(ParametersString var1);

    @Override
    public void fromString(String data) {
        this.data = StringUtil.normalizeLineBreaks(data);
        super.fromString(this.data);
        this.load(this.buffer);
        this.setSimplifierRules(null);
    }

    @Override
    public final String toString() {
        this.buffer.reset();
        this.save(this.buffer);
        return super.toString();
    }

    public <T extends AbstractGroupParameters> void loadGroup(ParametersString buffer, List<T> group, Class<T> elementClass) {
        if (elementClass == null) {
            return;
        }
        this.loadGroup(buffer, elementClass.getSimpleName(), group, elementClass);
    }

    public <T extends AbstractGroupParameters> void loadGroup(ParametersString buffer, String groupName, List<T> group, Class<T> elementClass) {
        if (buffer == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (Util.isEmpty(groupName)) {
            return;
        }
        if (elementClass == null) {
            return;
        }
        group.clear();
        int count = buffer.getInteger(String.format("%sCount", groupName));
        for (int i = 0; i < count; ++i) {
            AbstractGroupParameters item = null;
            try {
                item = (AbstractGroupParameters)elementClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.logger.debug("Group element instantiation failed: {}", (Object)e.getMessage());
                return;
            }
            if (item == null) {
                return;
            }
            item.load(new ParametersString(buffer.getGroup(String.format("%s%d", groupName, i))));
            group.add(item);
        }
    }

    public <T extends AbstractGroupParameters> void saveGroup(ParametersString buffer, String groupName, List<T> group) {
        if (buffer == null) {
            return;
        }
        if (group == null) {
            return;
        }
        if (Util.isEmpty(groupName)) {
            return;
        }
        buffer.setInteger(String.format("%sCount", groupName), group.size());
        for (int i = 0; i < group.size(); ++i) {
            AbstractGroupParameters item = (AbstractGroupParameters)group.get(i);
            ParametersString tmp = new ParametersString();
            item.save(tmp);
            buffer.setGroup(String.format("%s%d", groupName, i), tmp.toString());
        }
    }

    public <T extends AbstractGroupParameters> void saveGroup(ParametersString buffer, List<T> group, Class<T> elementClass) {
        if (elementClass == null) {
            return;
        }
        this.saveGroup(buffer, elementClass.getSimpleName(), group);
    }

    public boolean loadFromResource(Class<?> classRef, String resourceLocation) {
        URL url = classRef.getResource(resourceLocation);
        if (url == null) {
            return false;
        }
        this.load(url, false);
        return true;
    }

    public void saveToResource(Class<?> classRef, String resourceLocation) {
        URL url = classRef.getResource(resourceLocation);
        if (url == null) {
            return;
        }
        this.save(url.getPath());
    }

    public String getData() {
        return this.data;
    }

    @Override
    public String getSimplifierRules() {
        return this.getString("simplifierRules");
    }

    @Override
    public void setSimplifierRules(String rules) {
        this.setString("simplifierRules", rules);
    }

    @Override
    public void validateSimplifierRules() throws ParseException {
        SimplifierRules r = new SimplifierRules(this.getSimplifierRules(), new Code());
        r.parse();
    }
}

