/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.Util;

public class DecodeUtil {
    private static final Pattern NCR = Pattern.compile("&#(\\S+?);");
    private static final Pattern CER = Pattern.compile("(&\\w*?;)");
    private static final HTMLCharacterEntities entities = new HTMLCharacterEntities();

    public static String fromPlainTextHTML(String text) {
        int val;
        Matcher m;
        if (Util.isEmpty(text)) {
            return "";
        }
        text = text.replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder();
        sb.append(text.replace("&amp;", "&"));
        while ((m = CER.matcher(sb.toString())).find() && (val = entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16) : Integer.parseInt(m.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        return sb.toString();
    }

    static {
        entities.ensureInitialization(false);
    }
}

