/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.resource.BaseNameable;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.SkeletonUtil;

public class ResourceUtil {
    public static void copyProperties(BaseNameable srcResource, BaseNameable trgResource) {
        for (String propName : srcResource.getPropertyNames()) {
            trgResource.setProperty(srcResource.getProperty(propName));
        }
    }

    public static StartSubDocument startSubDocumentFromStartDocument(StartDocument sd, String id, String parentId, String name) {
        StartSubDocument ssd = new StartSubDocument(parentId, id);
        ResourceUtil.copyProperties(sd, ssd);
        ssd.setName(name);
        ISkeleton ssdSkel = sd.getSkeleton().clone();
        ssd.setSkeleton(ssdSkel);
        SkeletonUtil.changeParent(ssdSkel, sd, ssd);
        return ssd;
    }

    public static StartDocument startDocumentFromStartSubDocument(StartSubDocument ssd, String id, String lineBreak) {
        StartDocument sd = new StartDocument(id);
        sd.setLineBreak("\n");
        sd.setSkeleton(ssd.getSkeleton().clone());
        ResourceUtil.copyProperties(ssd, sd);
        return sd;
    }
}

