/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class ZipUtil {
    public static void safeUnzip(ZipInputStream zis, Path unzipDirectory) throws IOException {
        Files.createDirectories(unzipDirectory, new FileAttribute[0]);
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            String outFilename = entry.getName();
            Path p = unzipDirectory.resolve(outFilename).normalize();
            if (!p.startsWith(unzipDirectory)) {
                throw new IllegalStateException("Zip entry points to path outside of target directory: " + entry.getName());
            }
            if (entry.isDirectory()) {
                Files.createDirectories(p, new FileAttribute[0]);
                continue;
            }
            if (!Files.exists(p.getParent(), new LinkOption[0])) {
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
            }
            Files.copy(zis, p, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void safeUnzip(Path zipFile, Path unzipDirectory) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(zipFile, new OpenOption[0]));){
            ZipUtil.safeUnzip(zis, unzipDirectory);
        }
    }

    public static void zipDirectory(String sourceDir, String zipExtension) {
        ZipUtil.zipDirectory(sourceDir, zipExtension, null);
    }

    public static void zipDirectory(String sourceDir, String zipExtension, String destinationPathWithoutExtension) {
        Object zipPath = null;
        zipPath = Util.isEmpty(destinationPathWithoutExtension) ? (sourceDir.endsWith(File.separator) || sourceDir.endsWith("/") ? sourceDir.substring(0, sourceDir.length() - 1) : sourceDir) : destinationPathWithoutExtension;
        zipPath = Util.isEmpty(zipExtension) ? (String)zipPath + ".zip" : (String)zipPath + zipExtension;
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream((String)zipPath));){
            File dir = new File(sourceDir);
            if (!dir.isDirectory()) {
                return;
            }
            ZipUtil.addDirectoryToZip(dir, os, null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while zipping.", e);
        }
    }

    public static void zipFiles(String zipPath, String sourceDir, String ... filenames) {
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipPath));){
            Util.createDirectories(zipPath);
            Path sourceDirPath = Paths.get(sourceDir, new String[0]);
            for (String name : filenames) {
                Path file = sourceDirPath.resolve(name);
                os.putNextEntry(new ZipEntry(file.getFileName().toString()));
                Files.copy(file, os);
                os.closeEntry();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error while zipping.", e);
        }
    }

    private static void addDirectoryToZip(File dir, ZipOutputStream os, String subDir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                ZipUtil.addDirectoryToZip(file, os, (String)(subDir == null ? "" : subDir + "/") + file.getName());
                continue;
            }
            os.putNextEntry(new ZipEntry((String)(subDir == null ? "" : subDir + "/") + file.getName()));
            Files.copy(file.toPath(), os);
            os.closeEntry();
        }
    }
}

