/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.encoder;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.DefaultEncoder;
import net.sf.okapi.common.encoder.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownEncoder
extends DefaultEncoder {
    private final Logger LOGGER = LoggerFactory.getLogger(MarkdownEncoder.class);
    private boolean escapeSpecialMarkdownCharacters = false;
    private String markdownCharactersToEscape = "*_`{}[]<>()#+\\-.!|";
    private String htmlEntitiesToEscape = "";
    private IParameters params;
    public static final String DEFAULT_CHARACTERS_TO_ESCAPE = "*_`{}[]<>()#+\\-.!|";
    private Pattern escapingRegex;
    private Pattern htmlEntityEscapingRegex;
    private final HTMLCharacterEntities htmlCharacterEntities = new HTMLCharacterEntities();

    public MarkdownEncoder() {
        this.htmlCharacterEntities.ensureInitialization(true);
    }

    @Override
    public void setOptions(IParameters params, String encoding, String lineBreak) {
        this.params = params;
        if (params != null) {
            this.escapeSpecialMarkdownCharacters = params.getBoolean("unescapeBackslashCharacters");
            this.markdownCharactersToEscape = params.getString("charactersToEscape");
            this.htmlEntitiesToEscape = params.getString("htmlEntitiesToEscape");
            if (this.escapeSpecialMarkdownCharacters) {
                this.escapingRegex = this.buildEscapingRegex();
            }
            if (!this.htmlEntitiesToEscape.isEmpty()) {
                this.htmlEntityEscapingRegex = this.buildHtmlEntityEscapingRegex();
            }
        }
        this.setLineBreak(lineBreak);
    }

    @Override
    public String encode(String text, EncoderContext context) {
        if (text == null) {
            return "";
        }
        String result = text.replace("\n", this.getLineBreak());
        result = this.escapeHtmlEntities(result);
        if (this.escapeSpecialMarkdownCharacters) {
            result = result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    @Override
    public String encode(char value, EncoderContext context) {
        String result = String.valueOf(value).replace("\n", this.getLineBreak());
        if (!this.htmlEntitiesToEscape.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            this.escapeHtmlEntity(value, sb);
            result = sb.toString();
        }
        if (this.escapeSpecialMarkdownCharacters) {
            result = result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    @Override
    public String encode(int value, EncoderContext context) {
        String result = Character.isSupplementaryCodePoint(value) ? new String(Character.toChars(value)).replace("\n", this.getLineBreak()) : String.valueOf((char)value).replace("\n", this.getLineBreak());
        result = this.escapeHtmlEntities(result);
        if (this.escapeSpecialMarkdownCharacters) {
            result = result.replaceAll(this.escapingRegex.pattern(), "\\\\$1");
        }
        return result;
    }

    private Pattern buildEscapingRegex() {
        try {
            return Pattern.compile("([" + Pattern.quote(this.markdownCharactersToEscape) + "])");
        }
        catch (PatternSyntaxException e) {
            this.LOGGER.warn("Invalid charactersToEscape value: {}", (Object)this.markdownCharactersToEscape);
            return Pattern.compile("([" + Pattern.quote(DEFAULT_CHARACTERS_TO_ESCAPE) + "])");
        }
    }

    private Pattern buildHtmlEntityEscapingRegex() {
        try {
            return Pattern.compile("([" + Pattern.quote(this.htmlEntitiesToEscape) + "])");
        }
        catch (PatternSyntaxException e) {
            this.LOGGER.warn("Invalid htmlEntitiesToEscape value: {}", (Object)this.htmlEntitiesToEscape);
            return Pattern.compile("");
        }
    }

    private String escapeHtmlEntities(String result) {
        if (!this.htmlEntitiesToEscape.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (char c : result.toCharArray()) {
                this.escapeHtmlEntity(c, sb);
            }
            result = sb.toString();
        }
        return result;
    }

    private void escapeHtmlEntity(char value, StringBuilder sb) {
        if (this.htmlEntityEscapingRegex.matcher(String.valueOf(value)).find()) {
            String htmlName = this.htmlCharacterEntities.getName(value);
            if (htmlName != null) {
                sb.append(String.format("&%s;", htmlName));
            } else {
                sb.append(value);
            }
        } else {
            sb.append(value);
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }
}

