/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinedriver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.exceptions.OkapiBadStepInputException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.ICallableStep;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.IWorkQueueStep;
import net.sf.okapi.common.pipeline.annotations.ConfigurationParameter;
import net.sf.okapi.common.pipeline.annotations.StepIntrospector;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;

public class PipelineDriverUtils {
    public static void assignRuntimeParameters(PipelineDriver driver, LinkedList<List<ConfigurationParameter>> paramList, IBatchItemContext item) {
        for (List list : paramList) {
            PipelineDriverUtils.assignRuntimeParameters(driver, null, item, list);
        }
    }

    public static void assignSingleRuntimeParameter(PipelineDriver driver, IPipelineStep currentStep, IBatchItemContext item, ConfigurationParameter p) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        RawDocument input = item.getRawDocument(0);
        Method method = p.getMethod();
        if (method == null) {
            return;
        }
        switch (p.getParameterType()) {
            case OUTPUT_URI: {
                if (item.getOutputURI(0) == null) break;
                method.invoke((Object)currentStep, item.getOutputURI(0));
                break;
            }
            case TARGET_LOCALE: {
                method.invoke((Object)currentStep, input.getTargetLocale());
                break;
            }
            case TARGET_LOCALES: {
                method.invoke((Object)currentStep, input.getTargetLocales());
                break;
            }
            case SOURCE_LOCALE: {
                method.invoke((Object)currentStep, input.getSourceLocale());
                break;
            }
            case OUTPUT_ENCODING: {
                method.invoke((Object)currentStep, item.getOutputEncoding(0));
                break;
            }
            case INPUT_URI: {
                method.invoke((Object)currentStep, input.getInputURI());
                break;
            }
            case FILTER_CONFIGURATION_ID: {
                method.invoke((Object)currentStep, input.getFilterConfigId());
                break;
            }
            case FILTER_CONFIGURATION_MAPPER: {
                method.invoke((Object)currentStep, driver.getFcMapper());
                break;
            }
            case INPUT_RAWDOC: {
                method.invoke((Object)currentStep, input);
                break;
            }
            case SECOND_INPUT_RAWDOC: {
                method.invoke((Object)currentStep, item.getRawDocument(1));
                break;
            }
            case THIRD_INPUT_RAWDOC: {
                method.invoke((Object)currentStep, item.getRawDocument(2));
                break;
            }
            case ROOT_DIRECTORY: {
                method.invoke((Object)currentStep, driver.getRootDir() == null ? "" : driver.getRootDir());
                break;
            }
            case INPUT_ROOT_DIRECTORY: {
                method.invoke((Object)currentStep, driver.getInputRootDir() == null ? "" : driver.getInputRootDir());
                break;
            }
            case OUTPUT_DIRECTORY: {
                method.invoke((Object)currentStep, driver.getOutputDir() == null ? "" : driver.getOutputDir());
                break;
            }
            case BATCH_INPUT_COUNT: {
                method.invoke((Object)currentStep, driver.getBatchItems().size());
                break;
            }
            case EXECUTION_CONTEXT: {
                method.invoke((Object)currentStep, driver.getContext());
                break;
            }
            default: {
                throw new OkapiBadStepInputException(String.format("The step '%s' is using a runtime parameter not supported by this driver.", currentStep.getName()));
            }
        }
    }

    public static void assignRuntimeParameters(PipelineDriver driver, IPipelineStep step, IBatchItemContext item, List<ConfigurationParameter> pList) {
        try {
            List<ConfigurationParameter> stepParams = pList;
            IPipelineStep currentStep = step;
            if (step != null) {
                stepParams = currentStep instanceof IWorkQueueStep ? StepIntrospector.getStepParameters(((IWorkQueueStep)currentStep).getMainStep()) : StepIntrospector.getStepParameters(step);
                currentStep = step;
            } else if (!pList.isEmpty()) {
                currentStep = pList.get(0).getStep();
            }
            for (ConfigurationParameter p : stepParams) {
                if (currentStep instanceof IWorkQueueStep) {
                    IPipelineStep s = ((IWorkQueueStep)currentStep).getMainStep();
                    PipelineDriverUtils.assignSingleRuntimeParameter(driver, s, item, p);
                    LinkedList cSteps = ((IWorkQueueStep)currentStep).getCallableSteps();
                    for (ICallableStep iCallableStep : cSteps) {
                        PipelineDriverUtils.assignSingleRuntimeParameter(driver, iCallableStep.getMainStep(), item, p);
                    }
                    continue;
                }
                PipelineDriverUtils.assignSingleRuntimeParameter(driver, currentStep, item, p);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new OkapiException("Error when assigning runtime parameters.", e);
        }
    }
}

