/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.Property;

public class BaseNameable
implements INameable {
    protected String id;
    protected String name;
    protected String type;
    protected String mimeType;
    protected boolean isTranslatable = true;
    protected boolean preserveWS = false;
    private Annotations annotations;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private ISkeleton skeleton;

    public BaseNameable() {
        this.annotations = new Annotations();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String value) {
        this.type = value;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String value) {
        this.mimeType = value;
    }

    @Override
    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void setIsTranslatable(boolean value) {
        this.isTranslatable = value;
    }

    @Override
    public boolean preserveWhitespaces() {
        return this.preserveWS;
    }

    @Override
    public void setPreserveWhitespaces(boolean value) {
        this.preserveWS = value;
    }

    @Override
    public ISkeleton getSkeleton() {
        return this.skeleton;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        this.skeleton = skeleton;
    }

    public String toString() {
        return this.skeleton == null ? super.toString() : this.skeleton.toString();
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public Annotations getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Property>();
        }
        return this.properties.keySet();
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(type);
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }
}

