/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

public final class CodeMatches {
    public static int NO_MATCH = Integer.MIN_VALUE;
    public static int ADDED_MATCH = -2147483647;
    public static int ANNOTATION_ONLY = -2147483646;
    public static CodeMatches NO_CODES = new CodeMatches(0, 0);
    public static CodeMatches SAME_CODES = new CodeMatches(0, 0);
    private final int[] fromMatches;
    private final int[] toMatches;
    private final boolean[] toIsolated;
    private final boolean[] fromIsolated;

    private CodeMatches(int fromSize, int toSize) {
        this.fromMatches = new int[fromSize];
        this.toMatches = new int[toSize];
        this.toIsolated = new boolean[toSize];
        this.fromIsolated = new boolean[fromSize];
        Arrays.fill(this.fromMatches, NO_MATCH);
        Arrays.fill(this.toMatches, NO_MATCH);
        Arrays.fill(this.toIsolated, false);
        Arrays.fill(this.fromIsolated, false);
    }

    public CodeMatches(TextFragment from, TextFragment to) {
        this(from.codes.size(), to.codes.size());
        int pos;
        Code c;
        int i;
        for (i = 0; i < from.codes.size(); ++i) {
            c = from.getCode(i);
            if (c.type.equals("_annotation_")) {
                this.fromMatches[i] = ANNOTATION_ONLY;
            }
            pos = from.getCodePosition(i);
            switch (from.charAt(pos)) {
                case '\ue103': {
                    this.fromIsolated[i] = true;
                }
            }
        }
        for (i = 0; i < to.codes.size(); ++i) {
            c = to.getCode(i);
            if (c.type.equals("_annotation_")) {
                this.toMatches[i] = ANNOTATION_ONLY;
            }
            pos = to.getCodePosition(i);
            switch (to.charAt(pos)) {
                case '\ue103': {
                    this.toIsolated[i] = true;
                }
            }
        }
    }

    public int[] getFromMatches() {
        return this.fromMatches;
    }

    public int[] getToMatches() {
        return this.toMatches;
    }

    public void setFromMatch(int index, int id) {
        this.fromMatches[index] = id;
    }

    public void setToMatch(int index, int id) {
        this.toMatches[index] = id;
    }

    public int getToMatchIndex(int toIndex) {
        if (this.toMatches[toIndex] == ANNOTATION_ONLY) {
            return ANNOTATION_ONLY;
        }
        if (this.toMatches[toIndex] != NO_MATCH) {
            return this.toMatches[toIndex];
        }
        return NO_MATCH;
    }

    public boolean isToIsolated(int index) {
        return this.toIsolated[index];
    }

    public boolean isFromIsolated(int index) {
        return this.fromIsolated[index];
    }

    public boolean hasFromMismatch() {
        return this.hasFromMismatch(true);
    }

    public boolean hasFromMismatch(boolean includeAnnotation) {
        for (int m : this.fromMatches) {
            if (includeAnnotation && m == ANNOTATION_ONLY) {
                return true;
            }
            if (m != NO_MATCH) continue;
            return true;
        }
        return false;
    }

    public boolean hasToMismatch() {
        return this.hasToMismatch(true);
    }

    public boolean hasToMismatch(boolean includeAnnotation) {
        for (int m : this.toMatches) {
            if (includeAnnotation && m == ANNOTATION_ONLY) {
                return true;
            }
            if (m != NO_MATCH) continue;
            return true;
        }
        return false;
    }

    public Iterable<Integer> getFromMismatchIterator() {
        return this.getMismatchIterator(this.fromMatches);
    }

    public Iterable<Integer> getToMismatchIterator() {
        return this.getMismatchIterator(this.toMatches);
    }

    private Iterable<Integer> getMismatchIterator(int[] matches) {
        ArrayList<Integer> mismatchIndexes = new ArrayList<Integer>();
        int i = -1;
        for (int m : matches) {
            ++i;
            if (m == ANNOTATION_ONLY || m != NO_MATCH) continue;
            mismatchIndexes.add(i);
        }
        return mismatchIndexes;
    }
}

