/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Iterator;
import java.util.Set;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;

public interface IWithAnnotations {
    public static void copy(IWithAnnotations from, IWithAnnotations to) {
        if (from == null || to == null) {
            return;
        }
        for (IAnnotation ann : from.getAnnotations()) {
            if (to.getAnnotation(ann.getClass()) != null) continue;
            to.setAnnotation(ann);
        }
    }

    public Annotations getAnnotations();

    default public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        return (A)((IAnnotation)annotationType.cast(this.getAnnotations().get(annotationType)));
    }

    default public void setAnnotation(IAnnotation annotation) {
        this.getAnnotations().set(annotation);
    }

    default public Iterator<IAnnotation> annotationIterator() {
        return this.getAnnotations().iterator();
    }

    default public Set<Class<? extends IAnnotation>> getAnnotationsTypesAsSet() {
        return this.getAnnotations().getAnnotationsTypes();
    }

    default public <A extends IAnnotation> void remove(Class<A> annotationType) {
        this.getAnnotations().remove(annotationType);
    }

    default public boolean hasAnnotations() {
        return this.getAnnotations().isEmpty();
    }

    default public <A extends IAnnotation> boolean hasAnnotation(Class<A> annotationType) {
        return this.getAnnotations().get(annotationType) != null;
    }

    default public void clear() {
        this.getAnnotations().clear();
    }
}

