/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class Segments
implements ISegments {
    private AlignmentStatus alignmentStatus = AlignmentStatus.ALIGNED;
    private TextContainer parent;
    private List<TextPart> parts;

    public Segments() {
    }

    public Segments(TextContainer parent) {
        this.parent = parent;
    }

    public void setParts(List<TextPart> parts) {
        this.parts = parts;
    }

    @Override
    public Iterator<Segment> iterator() {
        return new Iterator<Segment>(){
            int current = this.foundNext(-1);

            private int foundNext(int start) {
                for (int i = start + 1; i < Segments.this.parts.size(); ++i) {
                    if (!Segments.this.parts.get(i).isSegment()) continue;
                    return i;
                }
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public Segment next() {
                if (this.current == -1) {
                    throw new NoSuchElementException("No more content parts.");
                }
                int n = this.current;
                this.current = this.foundNext(this.current);
                return (Segment)Segments.this.parts.get(n);
            }

            @Override
            public boolean hasNext() {
                return this.current != -1;
            }
        };
    }

    @Override
    public List<Segment> asList() {
        ArrayList<Segment> segments = new ArrayList<Segment>(this.parts.size());
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            segments.add((Segment)part);
        }
        return segments;
    }

    @Override
    public void swap(int segIndex1, int segIndex2) {
        int partIndex1 = this.getPartIndex(segIndex1);
        int partIndex2 = this.getPartIndex(segIndex2);
        if (partIndex1 == -1 || partIndex2 == -1) {
            return;
        }
        TextPart tmp = this.parts.get(partIndex1);
        this.parts.set(partIndex1, this.parts.get(partIndex2));
        this.parts.set(partIndex2, tmp);
    }

    @Override
    public void append(Segment segment, boolean collapseIfPreviousEmpty) {
        this.append(segment, null, collapseIfPreviousEmpty);
    }

    @Override
    public void append(Segment segment) {
        this.append(segment, true);
    }

    @Override
    public void append(Segment segment, String textBefore, boolean collapseIfPreviousEmpty) {
        if (!Util.isEmpty(textBefore)) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty() && !this.parts.get(this.parts.size() - 1).isSegment()) {
                this.parts.set(this.parts.size() - 1, new TextPart(textBefore));
            } else {
                this.parts.add(new TextPart(textBefore));
            }
        }
        if (collapseIfPreviousEmpty) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty() && this.parts.get(this.parts.size() - 1).isSegment()) {
                this.parts.set(this.parts.size() - 1, segment);
            } else {
                this.parts.add(segment);
            }
        } else {
            this.parts.add(segment);
        }
        this.validateTextPartId(segment);
        this.parent.setHasBeenSegmentedFlag(true);
    }

    @Override
    public void append(Segment segment, String textBefore) {
        this.append(segment, textBefore, true);
    }

    @Override
    public void append(TextFragment fragment, boolean collapseIfPreviousEmpty) {
        this.append(new Segment(null, fragment), collapseIfPreviousEmpty);
    }

    @Override
    public void append(TextFragment fragment) {
        this.append(fragment, true);
    }

    @Override
    public void set(int index, Segment seg) {
        int n = this.getPartIndex(index);
        if (n < -1) {
            throw new IndexOutOfBoundsException("Invalid segment index: " + index);
        }
        this.parts.set(n, seg);
        this.validateTextPartId(seg);
    }

    @Override
    public void insert(int index, Segment seg) {
        if (index == this.count()) {
            this.append(seg, true);
            return;
        }
        int n = this.getPartIndex(index);
        if (n < -1) {
            throw new IndexOutOfBoundsException("Invalid segment index: " + index);
        }
        this.parts.add(n, seg);
        this.validateTextPartId(seg);
    }

    @Override
    public int create(List<Range> ranges) {
        return this.create(ranges, false);
    }

    @Override
    public int create(List<Range> ranges, boolean allowEmptySegments) {
        return this.create(ranges, allowEmptySegments, ISegments.MetaCopyStrategy.DEFAULT);
    }

    @Override
    public int create(List<Range> ranges, boolean allowEmptySegments, ISegments.MetaCopyStrategy strategy) {
        List<Range> originalRanges;
        TextFragment holder;
        if (ranges == null || ranges.isEmpty()) {
            return 0;
        }
        if (this.parts.size() == 1) {
            holder = this.parts.get(0).getContent();
            originalRanges = List.of(new Range(0, holder.length(), this.parts.get(0).getId()));
        } else {
            originalRanges = new ArrayList<Range>(this.parts.size());
            holder = this.createJoinedContent(originalRanges, true);
        }
        ArrayList<TextPart> originalParts = null;
        if (strategy == ISegments.MetaCopyStrategy.DEEPEN) {
            originalParts = new ArrayList<TextPart>(this.parts.size());
            for (TextPart p : this.parts) {
                originalParts.add(p.clone());
            }
        }
        this.parts.clear();
        int start = 0;
        int id = 0;
        for (Range range : ranges) {
            TextPart p;
            if (range.end == -1) {
                range.end = holder.text.length();
            }
            if (range.end < range.start) {
                throw new InvalidPositionException(String.format("Invalid segment boundaries: start=%d, end=%d.", range.start, range.end));
            }
            if (start > range.start) {
                throw new InvalidPositionException("Invalid range order.");
            }
            if (range.end == range.start && !allowEmptySegments) continue;
            if (start < range.start) {
                p = new TextPart(range.id == null ? String.valueOf(id++) : range.id, holder.subSequence(start, range.start));
                this.validateTextPartId(p);
                this.parts.add(p);
            }
            if (range.part == null) {
                p = new Segment(range.id == null ? String.valueOf(id++) : range.id, holder.subSequence(range.start, range.end));
                this.validateTextPartId(p);
            } else if (range.part.isSegment()) {
                p = new Segment(range.part.id == null ? String.valueOf(id++) : range.part.id, holder.subSequence(range.start, range.end));
                this.validateTextPartId(p);
            } else {
                p = new TextPart(range.part.id == null ? String.valueOf(id++) : range.part.id, holder.subSequence(range.start, range.end));
                this.validateTextPartId(p);
            }
            this.parts.add(p);
            start = range.end;
            this.parent.setHasBeenSegmentedFlag(true);
        }
        if (start < holder.text.length()) {
            TextPart p;
            if (start == 0) {
                if (!this.parts.isEmpty()) {
                    p = new TextPart(String.valueOf(++id), holder.subSequence(start, -1));
                    this.validateTextPartId(p);
                    this.parts.add(p);
                } else {
                    p = new Segment(String.valueOf(++id), holder);
                    this.validateTextPartId(p);
                    this.parts.add(p);
                }
            } else {
                p = new TextPart(String.valueOf(++id), holder.subSequence(start, -1));
                this.validateTextPartId(p);
                this.parts.add(p);
            }
        }
        switch (strategy) {
            case DEEPEN: {
                this.deepenCopyMetaData(originalParts, originalRanges, ranges);
                break;
            }
            case IDENTITY: {
                this.identityCopyMetadata(ranges);
                break;
            }
        }
        return this.parts.size();
    }

    private void identityCopyMetadata(List<Range> ranges) {
        assert (ranges.size() == this.parts.size());
        for (int pi = 0; pi < ranges.size(); ++pi) {
            Range r = ranges.get(pi);
            TextPart part = this.parts.get(pi);
            part.id = r.part.id;
            part.originalId = r.part.originalId;
            part.whitespaceStrategy = r.part.whitespaceStrategy;
            IResource.copy(r.part, part);
        }
    }

    private List<Range> fillInRanges(List<Range> ranges) {
        ArrayList<Range> newRanges = new ArrayList<Range>(ranges.size());
        int ri = 0;
        for (TextPart p : this.parts) {
            if (p.isSegment()) {
                newRanges.add(ranges.get(ri++));
                continue;
            }
            if (ri == 0) {
                newRanges.add(new Range(0, p.text.length()));
                continue;
            }
            newRanges.add(new Range(((Range)newRanges.get((int)(ri - 1))).end, ((Range)newRanges.get((int)(ri - 1))).end + p.text.length()));
        }
        return newRanges;
    }

    private void deepenCopyMetaData(List<TextPart> originalParts, List<Range> originalRanges, List<Range> ranges) {
        List<Range> newRanges = this.fillInRanges(ranges);
        assert (newRanges.size() == this.parts.size());
        for (int pi = 0; pi < newRanges.size(); ++pi) {
            Range r = newRanges.get(pi);
            for (int oi = 0; oi < originalRanges.size(); ++oi) {
                Range op = originalRanges.get(oi);
                TextPart part = this.parts.get(pi);
                TextPart originalPart = originalParts.get(oi);
                if (op.equals(r)) {
                    part.id = Util.isEmpty(originalPart.id) ? part.id : originalPart.id;
                    part.originalId = originalPart.originalId;
                    part.whitespaceStrategy = originalPart.whitespaceStrategy;
                    IResource.copy(originalPart, part);
                    continue;
                }
                if (!op.contains(r)) continue;
                part.id = Util.isEmpty(originalPart.id) ? part.id : String.format("%s.%d", originalPart.id, pi);
                part.whitespaceStrategy = originalPart.whitespaceStrategy;
                IResource.copy(originalPart, part);
            }
        }
    }

    @Override
    public int create(int start, int end) {
        return this.create(List.of(new Range(start, end)));
    }

    @Override
    public int count() {
        int count = 0;
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public TextFragment getFirstContent() {
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            return part.getContent();
        }
        return null;
    }

    @Override
    public TextFragment getLastContent() {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).isSegment()) continue;
            return this.parts.get(i).getContent();
        }
        return null;
    }

    @Override
    public Segment getLast() {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).isSegment()) continue;
            return (Segment)this.parts.get(i);
        }
        return null;
    }

    @Override
    public Segment get(String id) {
        for (TextPart part : this.parts) {
            if (!part.isSegment() || !part.id.equals(id)) continue;
            return (Segment)part;
        }
        return null;
    }

    @Override
    public Segment get(int index) {
        int tmp = -1;
        for (TextPart part : this.parts) {
            if (!part.isSegment() || ++tmp != index) continue;
            return (Segment)part;
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + ++tmp);
    }

    @Override
    public void joinAll() {
        this.joinAll(null);
    }

    @Override
    public void joinAll(boolean keepCodeIds) {
        this.parent.setContent(this.createJoinedContent(null, keepCodeIds));
    }

    @Override
    public void joinAll(List<Range> ranges) {
        this.parent.setContent(this.createJoinedContent(ranges));
    }

    @Override
    public void joinAll(List<Range> ranges, boolean keepCodeIds) {
        this.parent.setContent(this.createJoinedContent(ranges, keepCodeIds));
    }

    @Override
    public List<Range> getRanges() {
        return this.getRanges(false);
    }

    @Override
    public List<Range> getRanges(boolean keepCodeIds) {
        ArrayList<Range> ranges = new ArrayList<Range>(this.parts.size());
        this.createJoinedContent(ranges, keepCodeIds);
        return ranges;
    }

    @Override
    public int joinWithNext(int segmentIndex) {
        return this.joinWithNext(segmentIndex, false);
    }

    @Override
    public int joinWithNext(int segmentIndex, boolean keepCodeIds) {
        if (this.parts.size() == 1) {
            return 0;
        }
        int start = this.getPartIndex(segmentIndex);
        if (start == -1) {
            return 0;
        }
        int end = -1;
        for (int i = start + 1; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).isSegment()) continue;
            end = i;
            break;
        }
        if (end == -1) {
            return 0;
        }
        TextFragment tf = this.parts.get(start).getContent();
        int count = end - start;
        for (int i = 0; i < count; ++i) {
            tf.append(this.parts.get(start + 1).getContent(), keepCodeIds);
            this.parts.remove(start + 1);
        }
        return count;
    }

    @Override
    public int getPartIndex(int segIndex) {
        int n = -1;
        for (int i = 0; i < this.parts.size(); ++i) {
            if (!this.parts.get(i).isSegment() || ++n != segIndex) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String segId) {
        int n = 0;
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            if (segId.equals(part.id)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public AlignmentStatus getAlignmentStatus() {
        return this.alignmentStatus;
    }

    @Override
    public void setAlignmentStatus(AlignmentStatus alignmentStatus) {
        this.alignmentStatus = alignmentStatus;
    }

    public void validateTextPartId(TextPart part) {
        if (!Util.isEmpty(part.id)) {
            boolean duplicate = false;
            for (TextPart tmp : this.parts) {
                if (!tmp.isSegment() || part == tmp || !part.id.equals(tmp.id)) continue;
                duplicate = true;
                break;
            }
            if (!duplicate) {
                return;
            }
        }
        int value = 0;
        for (TextPart tmp : this.parts) {
            if (tmp == part || tmp.id == null || !Character.isDigit(tmp.id.charAt(0))) continue;
            try {
                int val = Integer.parseInt(tmp.id);
                if (value > val) continue;
                value = val + 1;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        part.id = String.valueOf(value);
    }

    private TextFragment createJoinedContent(List<Range> ranges) {
        return this.createJoinedContent(ranges, false);
    }

    private TextFragment createJoinedContent(List<Range> ranges, boolean keepCodeIds) {
        if (ranges != null) {
            ranges.clear();
        }
        int start = 0;
        TextFragment tf = new TextFragment();
        for (TextPart part : this.parts) {
            if (ranges != null) {
                Range r = new Range(start, start + part.text.text.length(), part.id);
                r.part = part;
                ranges.add(r);
            }
            start += part.text.text.length();
            tf.append(part.getContent(), keepCodeIds);
        }
        return tf;
    }

    public TextContainer getParent() {
        return this.parent;
    }

    public List<TextPart> getParts() {
        return this.parts;
    }
}

