/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.security.InvalidParameterException;
import java.util.List;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ResourceUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.BaseNameable;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.resource.simplifier.AbstractResourceSimplifier;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.SkeletonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSkeletonSimplifier
extends AbstractResourceSimplifier {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GenericSkeletonWriter skelWriter;
    private GenericSkeleton newSkel;
    private boolean isBlocked;

    public GenericSkeletonSimplifier(LocaleId trgLoc) {
        this(null, trgLoc);
    }

    public GenericSkeletonSimplifier(String outEncoding, LocaleId trgLoc) {
        this(false, null, outEncoding, trgLoc);
    }

    public GenericSkeletonSimplifier(boolean isMultilingual, GenericSkeletonWriter skelWriter, LocaleId trgLoc) {
        this(isMultilingual, skelWriter, null, trgLoc);
    }

    public GenericSkeletonSimplifier(boolean isMultilingual, GenericSkeletonWriter skelWriter, String outEncoding, LocaleId trgLoc) {
        this.setMultilingual(isMultilingual);
        this.setSkeletonWriter(skelWriter);
        this.setOutputEncoding(outEncoding);
        this.setTargetLocale(trgLoc);
        this.initialize();
    }

    public GenericSkeletonSimplifier() {
    }

    @Override
    public void initialize() {
        if (this.getSkeletonWriter() != null && !(this.getSkeletonWriter() instanceof GenericSkeletonWriter)) {
            this.logger.warn("GenericSkeletonSimplifier handles only GenericSkeletonWriter and its subclasses, {} is not supported.", (Object)ClassUtil.getShortClassName(this.getSkeletonWriter()));
            this.isBlocked = true;
            return;
        }
        if (this.getSkeletonWriter() == null) {
            this.skelWriter = new GenericSkeletonWriter();
            this.setSkeletonWriter(this.skelWriter);
            this.logger.warn("GenericSkeletonWriter instance was created as no skeleton writer was passed in.");
        } else {
            this.skelWriter = (GenericSkeletonWriter)this.getSkeletonWriter();
        }
        if (Util.isEmpty(this.getOutputEncoding())) {
            this.setOutputEncoding("UTF-8");
        }
        if (this.getSkeletonWriter() == null) {
            this.skelWriter.setOutputEncoding(this.getOutputEncoding());
            this.skelWriter.setOutputLoc(this.getTargetLocale());
            EncoderManager em = new EncoderManager();
            em.setDefaultOptions(null, this.getOutputEncoding(), "\n");
            em.setAllKnownMappings();
            em.updateEncoder(this.getOutputEncoding());
        }
        this.newSkel = new GenericSkeleton();
        this.setOutputEncoding(this.getOutputEncoding());
        this.setTargetLocale(this.getTargetLocale());
    }

    public static MultiEvent packMultiEvent(MultiEvent me) {
        Event prevEvent = null;
        MultiEvent newME = new MultiEvent();
        newME.setId(me.getId());
        for (Event event : me) {
            if (event.isNoop()) continue;
            if (prevEvent != null && event != null && prevEvent.getEventType() == EventType.DOCUMENT_PART && event.getEventType() == EventType.DOCUMENT_PART) {
                IResource prevRes;
                ISkeleton prevSkel;
                IResource res = event.getResource();
                ISkeleton skel = res.getSkeleton();
                if (!(skel instanceof GenericSkeleton) || !((prevSkel = (prevRes = prevEvent.getResource()).getSkeleton()) instanceof GenericSkeleton)) continue;
                ((GenericSkeleton)prevSkel).add((GenericSkeleton)skel);
                continue;
            }
            newME.addEvent(event);
            prevEvent = event;
        }
        return newME;
    }

    @Override
    protected Event convertEvent(Event event) {
        if (this.isBlocked) {
            return event;
        }
        if (event == null) {
            throw new InvalidParameterException("Event cannot be null");
        }
        if (event.isNoop()) {
            return event;
        }
        IResource res = event.getResource();
        if (res == null) {
            return event;
        }
        if (res instanceof IReferenceable && !event.isStartSubfilter() && !event.isStartGroup() && ((IReferenceable)((Object)res)).isReferent()) {
            if (!event.isStartSubfilter() && !event.isStartGroup()) {
                this.skelWriter.addToReferents(event);
            }
            return event.isStartSubfilter() || event.isStartGroup() ? event : Event.createNoopEvent();
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                EncoderManager em;
                StartDocument sd = (StartDocument)res;
                this.isBlocked = false;
                if (sd != null && sd.getFilterWriter() != null && !(sd.getFilterWriter().getSkeletonWriter() instanceof GenericSkeletonWriter)) {
                    this.logger.warn("GenericSkeletonSimplifier handles only GenericSkeletonWriter and its subclasses, {} is not supported.", (Object)ClassUtil.getShortClassName(sd.getFilterWriter()));
                    this.isBlocked = true;
                    return event;
                }
                EncoderManager encoderManager = em = sd.getFilterWriter() != null ? sd.getFilterWriter().getEncoderManager() : null;
                if (em == null) {
                    em = new EncoderManager();
                }
                if (Util.isEmpty(em.getEncoding())) {
                    em.setDefaultOptions(sd.getFilterParameters(), sd.getEncoding(), sd.getLineBreak());
                    em.updateEncoder(sd.getMimeType());
                }
                this.skelWriter.processStartDocument(this.getTargetLocale(), this.getOutputEncoding(), em, sd);
                break;
            }
        }
        if (!this.isComplex(res)) {
            switch (event.getEventType()) {
                case END_DOCUMENT: {
                    this.skelWriter.close();
                    break;
                }
            }
            return event;
        }
        MultiEvent me = new MultiEvent();
        this.processResource(res, me);
        switch (event.getEventType()) {
            case END_DOCUMENT: {
                if (me.size() == 0) {
                    this.skelWriter.close();
                    break;
                }
                res.setSkeleton(null);
                me.addEvent(event);
                break;
            }
            case START_DOCUMENT: 
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                res.setSkeleton(null);
                me.addEvent(event, 0);
                break;
            }
            case TEXT_UNIT: 
            case DOCUMENT_PART: {
                break;
            }
            default: {
                return event;
            }
        }
        if (me.size() == 0) {
            return event;
        }
        if (me.size() == 1) {
            return this.assignIDs(me, res).iterator().next();
        }
        return new Event(EventType.MULTI_EVENT, this.assignIDs(GenericSkeletonSimplifier.packMultiEvent(me), res));
    }

    private MultiEvent assignIDs(MultiEvent me, IResource resource) {
        int counter = 0;
        for (Event event : me) {
            if (event.isNoop()) continue;
            IResource res = event.getResource();
            String resId = resource.getId();
            if (res instanceof DocumentPart && !(resource instanceof DocumentPart)) {
                String id = "";
                id = counter++ == 0 ? resId : String.format("%s_%d", resId, counter++);
                res.setId(String.format("dp_%s", id));
                continue;
            }
            res.setId(resId);
            if (!(res instanceof BaseNameable) || !(resource instanceof BaseNameable)) continue;
            ResourceUtil.copyProperties((BaseNameable)resource, (BaseNameable)res);
        }
        return me;
    }

    private boolean isComplex(IResource res) {
        ISkeleton skel;
        if (res == null) {
            return false;
        }
        if (res instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)res;
            TextFragment tf = tu.getSource().getUnSegmentedContentCopy();
            for (Code code : tf.getCodes()) {
                if (!code.hasReference()) continue;
                return true;
            }
        }
        if ((skel = res.getSkeleton()) == null) {
            return false;
        }
        if (!(skel instanceof GenericSkeleton)) {
            return false;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) continue;
            return true;
        }
        return false;
    }

    private void flushSkeleton(String resId, int dpIndex, MultiEvent me) {
        if (this.newSkel.isEmpty()) {
            return;
        }
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("", false, this.newSkel)));
        this.newSkel = new GenericSkeleton();
    }

    private void addTU(MultiEvent me, String resId, int tuIndex, ITextUnit tu) {
        String id = null;
        if (tuIndex == 1) {
            id = resId;
        } else {
            this.logger.warn("Duplicate TU: {}", (Object)resId);
            id = String.format("%s_%d", resId, tuIndex);
        }
        ITextUnit newTU = tu.clone();
        newTU.setId(id);
        newTU.setSkeleton(null);
        newTU.setIsReferent(false);
        if (tu.isEmpty()) {
            return;
        }
        me.addEvent(new Event(EventType.TEXT_UNIT, newTU));
    }

    private void processResource(IResource resource, MultiEvent me) {
        if (resource == null) {
            throw new InvalidParameterException("Resource parameter cannot be null");
        }
        if (me == null) {
            throw new InvalidParameterException("MultiEvent parameter cannot be null");
        }
        int dpCounter = 0;
        int tuCounter = 0;
        String resId = resource.getId();
        ISkeleton skel = resource.getSkeleton();
        boolean hasGenericSkeleton = skel instanceof GenericSkeleton;
        if (resource instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)resource;
            if (tu.isReferent()) {
                if (!hasGenericSkeleton) {
                    this.newSkel.add(this.skelWriter.getString(tu, this.getTargetLocale(), EncoderContext.SKELETON));
                    return;
                }
            } else {
                TextContainer tc = null;
                if (this.getTargetLocale() == null) {
                    tc = tu.getSource();
                } else {
                    tc = tu.getTarget(this.getTargetLocale());
                    if (tc == null) {
                        tc = tu.getSource();
                    }
                }
                for (TextPart part : tc) {
                    TextFragment tf = part.getContent();
                    for (Code code : tf.getCodes()) {
                        if (!code.hasReference()) continue;
                        if (code.hasOuterData()) {
                            code.setOuterData(this.skelWriter.expandCodeContent(code, this.getTargetLocale(), EncoderContext.TEXT));
                            continue;
                        }
                        code.setData(this.skelWriter.expandCodeContent(code, this.getTargetLocale(), EncoderContext.TEXT));
                    }
                }
                if (!hasGenericSkeleton) {
                    this.addTU(me, resId, ++tuCounter, tu);
                }
            }
        }
        if (!hasGenericSkeleton) {
            return;
        }
        List<GenericSkeletonPart> parts = ((GenericSkeleton)skel).getParts();
        for (GenericSkeletonPart part : parts) {
            if (SkeletonUtil.isText(part)) {
                this.newSkel.add(this.skelWriter.getString(part, EncoderContext.SKELETON));
                continue;
            }
            if (SkeletonUtil.isSegmentPlaceholder(part, resource)) {
                this.processSegmentPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isExtSegmentPlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId, false);
                this.processSegmentPlaceholder(part, part.getParent(), me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isReference(part)) {
                IReferenceable referent;
                this.flushSkeleton(resId, ++dpCounter, me);
                Object[] marker = TextFragment.getRefMarker(part.getData());
                String refId = (String)marker[0];
                int start = (Integer)marker[1];
                int end = (Integer)marker[2];
                if (start > 0) {
                    this.newSkel.add(part.getData().substring(0, start));
                    this.flushSkeleton(resId, ++dpCounter, me);
                }
                if ((referent = this.skelWriter.getReference(refId)) == null) {
                    MultiEvent group = this.getGroup(refId);
                    if (group != null) {
                        for (Event event : group) {
                            if (event.isNoop()) continue;
                            IResource res = event.getResource();
                            if (res instanceof IReferenceable) {
                                IReferenceable r = (IReferenceable)((Object)res);
                                r.setIsReferent(false);
                            }
                            me.addEvent(event);
                        }
                    }
                } else if (referent instanceof IResource) {
                    this.processResource((IResource)((Object)referent), me);
                }
                if (end >= part.getData().length()) continue;
                this.newSkel.add(part.getData().substring(end, part.getData().length()));
                this.flushSkeleton(resId, ++dpCounter, me);
                continue;
            }
            if (SkeletonUtil.isSourcePlaceholder(part, resource)) {
                this.processSourcePlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isTargetPlaceholder(part, resource)) {
                this.processTargetPlaceholder(part, resource, me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isPropValuePlaceholder(part, resource)) {
                this.newSkel.add(this.skelWriter.getString(part, EncoderContext.SKELETON));
                continue;
            }
            if (SkeletonUtil.isExtSourcePlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId, true);
                this.processSourcePlaceholder(part, part.getParent(), me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isExtTargetPlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId, true);
                this.processTargetPlaceholder(part, part.getParent(), me, resId, tuCounter, dpCounter);
                continue;
            }
            if (SkeletonUtil.isExtPropValuePlaceholder(part, resource)) {
                this.checkExtParent(part.getParent(), resId, false);
                this.newSkel.add(this.skelWriter.getString(part, EncoderContext.SKELETON));
                continue;
            }
            this.logger.error("Unknown ref type: \"{}\" - {}", (Object)resource.getId(), (Object)part.toString());
        }
        this.flushSkeleton(resId, ++dpCounter, me);
    }

    private void processSourcePlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (this.isMultilingual()) {
            if (part.parent instanceof ITextUnit) {
                this.newSkel.add(this.skelWriter.getContent((ITextUnit)part.parent, null, EncoderContext.TEXT));
            } else {
                this.logger.warn("The self-reference must be a text-unit: {}", (Object)resId);
                this.newSkel.add(part.parent.toString());
            }
        } else {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        }
    }

    private void processTargetPlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (part.getLocale().equals(this.getTargetLocale())) {
            this.flushSkeleton(resId, ++dpCounter, me);
            this.addTU(me, resId, ++tuCounter, (ITextUnit)resource);
        } else {
            this.newSkel.add(this.skelWriter.getContent((ITextUnit)resource, part.getLocale(), EncoderContext.SKELETON));
        }
    }

    private void processSegmentPlaceholder(GenericSkeletonPart part, IResource resource, MultiEvent me, String resId, int tuCounter, int dpCounter) {
        if (resource instanceof ITextUnit) {
            int segIndex;
            Segment trgSeg;
            ITextUnit tu = (ITextUnit)resource;
            TextContainer src = tu.getSource();
            TextContainer trg = part.getLocale() == null ? null : tu.getTarget(part.getLocale());
            StringBuilder sb = new StringBuilder(part.data);
            Object[] marker = TextFragment.getRefMarker(sb);
            String segId = (String)marker[0];
            Segment srcSeg = src.getSegments().get(segId);
            Segment segment = trgSeg = trg == null ? null : trg.getSegments().get(segId);
            if (srcSeg == null && trgSeg != null && src != null) {
                segIndex = trg.getSegments().getIndex(segId);
                srcSeg = (Segment)src.get(segIndex);
            }
            if (trgSeg == null && srcSeg != null && trg != null) {
                segIndex = src.getSegments().getIndex(segId);
                trgSeg = (Segment)trg.get(segIndex);
            }
            if (part.getLocale() == null) {
                this.newSkel.add(this.skelWriter.getContent(srcSeg.getContent(), null, EncoderContext.TEXT));
            } else if (part.getLocale().equals(this.getTargetLocale())) {
                this.flushSkeleton(resId, ++dpCounter, me);
                TextContainer s = new TextContainer(this.skelWriter.getContent(srcSeg.getContent(), null, EncoderContext.TEXT));
                TextContainer t = new TextContainer(this.skelWriter.getContent(trgSeg.getContent(), part.getLocale(), EncoderContext.TEXT));
                ITextUnit segTu = TextUnitUtil.buildGenericTU(null, null, s, t, part.getLocale(), null);
                this.addTU(me, resId, ++tuCounter, segTu);
            } else {
                this.newSkel.add(this.skelWriter.getContent(trgSeg.getContent(), part.getLocale(), EncoderContext.TEXT));
            }
        }
    }

    private boolean checkExtParent(IResource parent, String resId, boolean checkReferentFlag) {
        if (parent instanceof IReferenceable) {
            IReferenceable r = (IReferenceable)((Object)parent);
            if (checkReferentFlag && !r.isReferent()) {
                this.logger.warn("Referent flag is not set in parent: {}", (Object)resId);
                return false;
            }
            return true;
        }
        return true;
    }
}

