/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.googleautoml;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class GoogleAutoMLTranslationParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String CREDENTIAL_FILE_PATH = "credentialFilePath";
    private static final String CREDENTIAL_STRING = "credentialString";
    private static final String MODEL_MAP = "modelMap";

    public String getCredentialFilePath() {
        return this.getString(CREDENTIAL_FILE_PATH);
    }

    public void setCredentialFilePath(String credentialFilePath) {
        if (credentialFilePath != null) {
            credentialFilePath = credentialFilePath.trim();
        }
        this.setString(CREDENTIAL_FILE_PATH, credentialFilePath);
    }

    public String getCredentialString() {
        return this.getString(CREDENTIAL_STRING);
    }

    public void setCredentialString(String credentialString) {
        if (credentialString != null) {
            credentialString = credentialString.trim();
        }
        this.setString(CREDENTIAL_STRING, credentialString);
    }

    public String getModelMap() {
        return this.getString(MODEL_MAP);
    }

    public void setModelMap(String modelMap) {
        if (modelMap != null) {
            modelMap = modelMap.trim();
        }
        this.setString(MODEL_MAP, modelMap);
    }

    @Override
    public void reset() {
        super.reset();
        this.setCredentialFilePath("");
        this.setCredentialString("");
        this.setModelMap("{}");
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(CREDENTIAL_FILE_PATH, "Credential file path", "Absolute path to a JSON file containing private key information for a Google service account");
        desc.add(MODEL_MAP, "Model JSON map", "String representation of a JSON that maps a language pair to the resource name of the model that will process translations for that language pair. Model resource names are typically of the form \"projects/{projectId}/locations/{computeRegion}/models/{modelId}\". Example: {\"en-US/ja-JP\": \"projects/my-project/locations/us-central1/models/ABC123\", \"en-US/de-DE\": \"projects/my-project/locations/us-central1/models/DEF456\"}");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription parametersDescription) {
        EditorDescription desc = new EditorDescription("Google AutoML Translation Connector Settings", true, false);
        desc.addTextInputPart(parametersDescription.get(CREDENTIAL_FILE_PATH));
        desc.addTextInputPart(parametersDescription.get(MODEL_MAP));
        return desc;
    }
}

