/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.doxygen;

import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.filters.doxygen.RegexTokenizer;

public class PrefixSuffixTokenizer
extends RegexTokenizer
implements Iterable<RegexTokenizer.Token> {
    private Matcher currentSuffixMatcher;
    private boolean switcher = false;

    public PrefixSuffixTokenizer(Map<Pattern, Pattern> delimiters, String string) {
        this.s = string;
        if (string == null) {
            return;
        }
        for (Map.Entry<Pattern, Pattern> e : delimiters.entrySet()) {
            Matcher prefixMatcher = e.getKey().matcher(string);
            Matcher suffixMatcher = e.getValue().matcher(string);
            this.matchers.put(prefixMatcher, suffixMatcher);
        }
    }

    private Matcher getSuffixMatcher() {
        if (this.currentSuffixMatcher != null) {
            return this.currentSuffixMatcher;
        }
        Matcher newMatcher = null;
        Matcher p = this.getPrefixMatcher();
        if (p != null && !this.firstRun) {
            Matcher s = (Matcher)this.matchers.get(p);
            newMatcher = s.find(p.end()) ? s : null;
        }
        this.currentSuffixMatcher = newMatcher;
        return this.currentSuffixMatcher;
    }

    @Override
    public Iterator<RegexTokenizer.Token> iterator() {
        return new Iterator<RegexTokenizer.Token>(){

            @Override
            public boolean hasNext() {
                if (PrefixSuffixTokenizer.this.s == null || PrefixSuffixTokenizer.this.s.length() < 1) {
                    return false;
                }
                if (PrefixSuffixTokenizer.this.firstRun) {
                    return true;
                }
                return PrefixSuffixTokenizer.this.getPrefixMatcher() != null || PrefixSuffixTokenizer.this.getSuffixMatcher() != null;
            }

            @Override
            public RegexTokenizer.Token next() {
                Matcher back;
                Matcher front;
                if (PrefixSuffixTokenizer.this.switcher) {
                    front = PrefixSuffixTokenizer.this.getPrefixMatcher();
                    back = PrefixSuffixTokenizer.this.getSuffixMatcher();
                    PrefixSuffixTokenizer.this.currentPrefixMatcher = null;
                } else {
                    front = PrefixSuffixTokenizer.this.getSuffixMatcher();
                    back = PrefixSuffixTokenizer.this.getPrefixMatcher();
                    PrefixSuffixTokenizer.this.currentSuffixMatcher = null;
                }
                PrefixSuffixTokenizer.this.switcher = !PrefixSuffixTokenizer.this.switcher;
                int n = PrefixSuffixTokenizer.this.i = back != null ? back.end() : PrefixSuffixTokenizer.this.s.length();
                if (PrefixSuffixTokenizer.this.firstRun) {
                    PrefixSuffixTokenizer.this.firstRun = false;
                }
                return (RegexTokenizer)PrefixSuffixTokenizer.this.new RegexTokenizer.Token(front, back);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

