/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.ElementParser;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.PropertiesParser;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StoryChildElementsMerger;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleRange;
import net.sf.okapi.filters.idml.StyleRangeParser;
import net.sf.okapi.filters.idml.StyleRanges;

class StoryChildElementsParser {
    private static final QName CHANGE_TYPE = Namespaces.getDefaultNamespace().getQName("ChangeType");
    private static final String DELETED_TEXT = "DeletedText";
    private static final QName ROW = Namespaces.getDefaultNamespace().getQName("Row");
    private static final QName COLUMN = Namespaces.getDefaultNamespace().getQName("Column");
    private static final QName CELL = Namespaces.getDefaultNamespace().getQName("Cell");
    private static final EnumSet<ParsingIdioms.StyledStoryChildElement> PARAGRAPH_STYLE_RANGE_STYLED_ELEMENTS = EnumSet.complementOf(EnumSet.of(ParsingIdioms.StyledStoryChildElement.UNSUPPORTED, ParsingIdioms.StyledStoryChildElement.PARAGRAPH_STYLE_RANGE));
    private final StartElement startElement;
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final XMLEventReader eventReader;
    private StyleRanges currentStyleRanges;

    StoryChildElementsParser(StartElement startElement, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
        this.startElement = startElement;
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.eventReader = eventReader;
    }

    StyleRanges currentStyleRanges() {
        return this.currentStyleRanges;
    }

    List<StoryChildElement> parseWith(StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        return this.parse();
    }

    private List<StoryChildElement> parse() throws XMLStreamException {
        if (!ParsingIdioms.StyledStoryChildElement.PARAGRAPH_STYLE_RANGE.getName().equals(this.startElement.getName())) {
            if (PARAGRAPH_STYLE_RANGE_STYLED_ELEMENTS.contains((Object)ParsingIdioms.StyledStoryChildElement.fromName(this.startElement.getName()))) {
                return this.parseAsFromParagraphStyleRange(this.startElement);
            }
            return this.parseFromUnstyledRange(this.startElement);
        }
        return this.parseFromParagraphStyleRange();
    }

    private List<StoryChildElement> parseFromUnstyledRange(StartElement startElement) throws XMLStreamException {
        StoryChildElement sce = new StoryChildElementParser(startElement, this.eventReader, this.eventFactory).parse(new StoryChildElement.Builder());
        if (sce instanceof StoryChildElement.StyledTextElement) {
            this.currentStyleRanges = ((StoryChildElement.StyledTextElement)sce).styleRanges();
        }
        return Collections.singletonList(sce);
    }

    private List<StoryChildElement> parseAsFromParagraphStyleRange(StartElement startElement) throws XMLStreamException {
        if (!ParsingIdioms.StyledStoryChildElement.CHARACTER_STYLE_RANGE.getName().equals(startElement.getName())) {
            return this.parseAsFromCharacterStyleRange(startElement, this.currentStyleRanges.paragraphStyleRange());
        }
        return this.parseFromCharacterStyleRange(startElement, this.currentStyleRanges.paragraphStyleRange());
    }

    private List<StoryChildElement> parseFromParagraphStyleRange() throws XMLStreamException {
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        StyleRange paragraphStyleRange = new StyleRangeParser(this.startElement, this.eventReader, this.eventFactory).parse();
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                return storyChildElements;
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            if (!ParsingIdioms.StyledStoryChildElement.CHARACTER_STYLE_RANGE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.addAll(this.parseAsFromCharacterStyleRange(event.asStartElement(), paragraphStyleRange));
                continue;
            }
            storyChildElements.addAll(this.parseFromCharacterStyleRange(event.asStartElement(), paragraphStyleRange));
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private List<StoryChildElement> parseAsFromCharacterStyleRange(StartElement startElement, StyleRange paragraphStyleRange) throws XMLStreamException {
        StyleRanges styleRanges = new StyleRanges(paragraphStyleRange, this.currentStyleRanges.characterStyleRange());
        if (this.parameters.getUntagXmlStructures()) {
            if (ParsingIdioms.StyledStoryChildElement.XML_ATTRIBUTE.getName().equals(startElement.getName()) || ParsingIdioms.StyledStoryChildElement.XML_COMMENT.getName().equals(startElement.getName()) || ParsingIdioms.StyledStoryChildElement.XML_INSTRUCTION.getName().equals(startElement.getName())) {
                this.skipRange(startElement);
                return Collections.emptyList();
            }
            if (ParsingIdioms.StyledStoryChildElement.XML_ELEMENT.getName().equals(startElement.getName())) {
                return this.parseFromElementRange(startElement, styleRanges);
            }
        }
        if (ParsingIdioms.StyledStoryChildElement.HYPERLINK_TEXT_SOURCE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseHyperlinkTextSource(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.FOOTNOTE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseFootnote(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.ENDNOTE_RANGE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseEndnoteRange(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.NOTE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseNote(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.TABLE.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseTable(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.CHANGE.getName().equals(startElement.getName())) {
            return this.parseFromChangedRange(startElement, styleRanges);
        }
        if (ParsingIdioms.StyledStoryChildElement.CONTENT.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseContent(startElement, styleRanges));
        }
        if (ParsingIdioms.StyledStoryChildElement.BREAK.getName().equals(startElement.getName())) {
            return Collections.singletonList(this.parseBreak(startElement, styleRanges));
        }
        return Collections.singletonList(this.parseFromStyledRange(startElement, styleRanges));
    }

    private List<StoryChildElement> parseFromCharacterStyleRange(StartElement startElement, StyleRange paragraphStyleRange) throws XMLStreamException {
        StyleRange characterStyleRange = new StyleRangeParser(startElement, this.eventReader, this.eventFactory).parse();
        StyleRanges styleRanges = new StyleRanges(paragraphStyleRange, characterStyleRange);
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextTag();
            if (event.isEndElement() && event.asEndElement().getName().equals(startElement.getName())) {
                if (0 == storyChildElements.size()) {
                    StoryChildElement.StyledTextElement.Content.Empty.Builder builder = new StoryChildElement.StyledTextElement.Content.Empty.Builder();
                    builder.setStyleRanges(styleRanges);
                    storyChildElements.add(builder.build());
                }
                return storyChildElements;
            }
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            if (this.parameters.getUntagXmlStructures()) {
                if (ParsingIdioms.StyledStoryChildElement.XML_ATTRIBUTE.getName().equals(event.asStartElement().getName()) || ParsingIdioms.StyledStoryChildElement.XML_COMMENT.getName().equals(event.asStartElement().getName()) || ParsingIdioms.StyledStoryChildElement.XML_INSTRUCTION.getName().equals(event.asStartElement().getName())) {
                    this.skipRange(event.asStartElement());
                    continue;
                }
                if (ParsingIdioms.StyledStoryChildElement.XML_ELEMENT.getName().equals(event.asStartElement().getName())) {
                    storyChildElements.addAll(this.parseFromElementRange(event.asStartElement(), styleRanges));
                    continue;
                }
            }
            if (ParsingIdioms.StyledStoryChildElement.HYPERLINK_TEXT_SOURCE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseHyperlinkTextSource(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.FOOTNOTE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseFootnote(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.ENDNOTE_RANGE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseEndnoteRange(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.NOTE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseNote(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.TABLE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseTable(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.CHANGE.getName().equals(event.asStartElement().getName())) {
                storyChildElements.addAll(this.parseFromChangedRange(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.CONTENT.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseContent(event.asStartElement(), styleRanges));
                continue;
            }
            if (ParsingIdioms.StyledStoryChildElement.BREAK.getName().equals(event.asStartElement().getName())) {
                storyChildElements.add(this.parseBreak(event.asStartElement(), styleRanges));
                continue;
            }
            storyChildElements.add(this.parseFromStyledRange(event.asStartElement(), styleRanges));
        }
        return storyChildElements;
    }

    private List<StoryChildElement> parseFromElementRange(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        XMLEvent event;
        ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
        while (!(!this.eventReader.hasNext() || (event = this.eventReader.nextTag()).isEndElement() && startElement.getName().equals(event.asEndElement().getName()))) {
            if (!event.isStartElement()) {
                throw new IllegalStateException("Unexpected structure");
            }
            storyChildElements.addAll(new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader).parseWith(styleRanges));
        }
        List<StoryChildElement> mergedStoryChildElements = new StoryChildElementsMerger(this.parameters, this.eventFactory).merge(storyChildElements);
        StoryChildElement.StyledTextElement ste = StoryChildElementsParser.lastStyledTextElementIn(mergedStoryChildElements);
        if (null != ste) {
            this.currentStyleRanges = ste.styleRanges();
        }
        return mergedStoryChildElements;
    }

    private static StoryChildElement.StyledTextElement lastStyledTextElementIn(List<StoryChildElement> storyChildElements) {
        ListIterator<StoryChildElement> iterator = storyChildElements.listIterator(storyChildElements.size());
        StoryChildElement.StyledTextElement ste = null;
        while (iterator.hasPrevious()) {
            StoryChildElement sce = iterator.previous();
            if (!(sce instanceof StoryChildElement.StyledTextElement)) continue;
            ste = (StoryChildElement.StyledTextElement)sce;
            break;
        }
        return ste;
    }

    private StoryChildElement parseHyperlinkTextSource(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        HyperlinkTextSourceStyledTextReferenceElementParser p = new HyperlinkTextSourceStyledTextReferenceElementParser(startElement, styleRanges, this.currentStyleRanges, this.parameters, this.eventFactory, this.eventReader);
        StoryChildElement.StyledTextReferenceElement sce = p.parse(new StoryChildElement.StyledTextReferenceElement.HyperlinkTextSource.HyperlinkTextSourceBuilder());
        this.currentStyleRanges = p.lastStyledTextElementStyleRanges();
        return sce;
    }

    private StoryChildElement parseFootnote(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextReferenceElement.Footnote.FootnoteBuilder footnoteBuilder = new StoryChildElement.StyledTextReferenceElement.Footnote.FootnoteBuilder();
        return new StyledTextReferenceElementParser(startElement, styleRanges, this.parameters, this.eventFactory, this.eventReader).parse(footnoteBuilder);
    }

    private StoryChildElement parseEndnoteRange(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextReferenceElement.EndnoteRange.EndnoteRangeBuilder endnoteRangeBuilder = new StoryChildElement.StyledTextReferenceElement.EndnoteRange.EndnoteRangeBuilder();
        return new StyledTextReferenceElementParser(startElement, styleRanges, this.parameters, this.eventFactory, this.eventReader).parse(endnoteRangeBuilder);
    }

    private StoryChildElement parseNote(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextReferenceElement.Note.NoteBuilder noteBuilder = new StoryChildElement.StyledTextReferenceElement.Note.NoteBuilder();
        return new StyledTextReferenceElementParser(startElement, styleRanges, this.parameters, this.eventFactory, this.eventReader).parse(noteBuilder);
    }

    private StoryChildElement parseTable(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        return new TableParser(startElement, styleRanges, this.parameters, this.eventFactory, this.eventReader).parse();
    }

    private List<StoryChildElement> parseFromChangedRange(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        String changeTypeValue = startElement.getAttributeByName(CHANGE_TYPE).getValue();
        if (DELETED_TEXT.equals(changeTypeValue)) {
            this.skipRange(startElement);
            return Collections.emptyList();
        }
        return this.acceptChanges(startElement, styleRanges);
    }

    private void skipRange(StartElement startElement) throws XMLStreamException {
        while (this.eventReader.hasNext()) {
            XMLEvent event = this.eventReader.nextEvent();
            if (!event.isEndElement() || !event.asEndElement().getName().equals(startElement.getName())) continue;
            return;
        }
        throw new IllegalStateException("Unexpected structure");
    }

    private List<StoryChildElement> acceptChanges(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        return this.parseFromElementRange(startElement, styleRanges);
    }

    private StoryChildElement parseContent(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextElement.Content.ContentBuilder contentBuilder = new StoryChildElement.StyledTextElement.Content.ContentBuilder();
        contentBuilder.setStyleRanges(styleRanges);
        return new StoryChildElementParser(startElement, this.eventReader, this.eventFactory).parse(contentBuilder);
    }

    private StoryChildElement parseBreak(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextElement.Break.BreakBuilder breakBuilder = new StoryChildElement.StyledTextElement.Break.BreakBuilder();
        breakBuilder.setStyleRanges(styleRanges);
        return new StoryChildElementParser(startElement, this.eventReader, this.eventFactory).parse(breakBuilder);
    }

    private StoryChildElement parseFromStyledRange(StartElement startElement, StyleRanges styleRanges) throws XMLStreamException {
        this.currentStyleRanges = styleRanges;
        StoryChildElement.StyledTextElement.StyledTextElementBuilder styledTextElementBuilder = new StoryChildElement.StyledTextElement.StyledTextElementBuilder();
        styledTextElementBuilder.setStyleRanges(styleRanges);
        return new StoryChildElementParser(startElement, this.eventReader, this.eventFactory).parse(styledTextElementBuilder);
    }

    private static class TableParser {
        private final StartElement startElement;
        private final StyleRanges styleRanges;
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final XMLEventReader eventReader;

        private TableParser(StartElement startElement, StyleRanges styleRanges, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
            this.startElement = startElement;
            this.styleRanges = styleRanges;
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.eventReader = eventReader;
        }

        StoryChildElement.StyledTextReferenceElement.Table parse() throws XMLStreamException {
            StoryChildElement.StyledTextReferenceElement.Table.TableBuilder tableBuilder = new StoryChildElement.StyledTextReferenceElement.Table.TableBuilder();
            tableBuilder.setStyleRanges(this.styleRanges);
            tableBuilder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextTag();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    tableBuilder.setEndElement(event.asEndElement());
                    return tableBuilder.build();
                }
                if (!event.isStartElement()) {
                    throw new IllegalStateException("Unexpected structure");
                }
                if (Properties.NAME.equals(event.asStartElement().getName())) {
                    tableBuilder.setProperties(new PropertiesParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
                    continue;
                }
                if (ROW.equals(event.asStartElement().getName()) || COLUMN.equals(event.asStartElement().getName())) {
                    tableBuilder.addMarkupRangeElement(new ElementParser(event.asStartElement(), this.eventReader, this.eventFactory).parse(new Element.Builder()));
                    continue;
                }
                if (!CELL.equals(event.asStartElement().getName())) {
                    throw new IllegalStateException("Unexpected structure");
                }
                StyleRanges cellStyleRanges = new StyleRanges(StyleRange.defaultParagraphStyleRange(this.eventFactory), StyleRange.defaultCharacterStyleRange(this.eventFactory));
                StoryChildElement.StyledTextReferenceElement.Table.Cell.CellBuilder cellBuilder = new StoryChildElement.StyledTextReferenceElement.Table.Cell.CellBuilder();
                tableBuilder.addCell((StoryChildElement.StyledTextReferenceElement.Table.Cell)new StyledTextReferenceElementParser(event.asStartElement(), cellStyleRanges, this.parameters, this.eventFactory, this.eventReader).parse(cellBuilder));
            }
            throw new IllegalStateException("Unexpected structure");
        }
    }

    private static class HyperlinkTextSourceStyledTextReferenceElementParser {
        private final StartElement startElement;
        private final StyleRanges referenceElementStyleRanges;
        private final StyleRanges childElementsBaseStyleRanges;
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final XMLEventReader eventReader;
        private StyleRanges childElementsCurrentStyleRanges;

        private HyperlinkTextSourceStyledTextReferenceElementParser(StartElement startElement, StyleRanges referenceElementStyleRanges, StyleRanges childElementsBaseStyleRanges, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
            this.startElement = startElement;
            this.referenceElementStyleRanges = referenceElementStyleRanges;
            this.childElementsBaseStyleRanges = childElementsBaseStyleRanges;
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.eventReader = eventReader;
        }

        StoryChildElement.StyledTextReferenceElement parse(StoryChildElement.StyledTextReferenceElement.StyledTextReferenceElementBuilder styledTextReferenceElementBuilder) throws XMLStreamException {
            StoryChildElementsMerger storyChildElementsMerger = new StoryChildElementsMerger(this.parameters, this.eventFactory);
            StoryChildElementsWriter storyChildElementsWriterWithEmptyStyleRanges = new StoryChildElementsWriter(new QName[0]);
            StoryChildElementsWriter storyChildElementsWriterWithCharacterStyleRanges = new StoryChildElementsWriter(StyleRange.CHARACTER_STYLE_RANGE);
            Attribute characterStyle = this.startElement.getAttributeByName(StyleRange.APPLIED_CHARACTER_STYLE);
            if (null == characterStyle) {
                characterStyle = this.eventFactory.createAttribute(StyleRange.APPLIED_CHARACTER_STYLE, "n");
            }
            this.childElementsCurrentStyleRanges = this.referenceElementStyleRanges;
            this.childElementsCurrentStyleRanges = !"n".equals(characterStyle.getValue()) ? this.childElementsCurrentStyleRanges.mergedWith(new StyleRanges(this.childElementsCurrentStyleRanges.paragraphStyleRange(), new StyleRange(this.eventFactory, StyleRange.CHARACTER_STYLE_RANGE, Collections.singletonList(characterStyle), new Properties.Empty(this.eventFactory)))) : this.childElementsCurrentStyleRanges.mergedWith(this.childElementsBaseStyleRanges);
            StyleRanges mergedReferenceAndChildElementsStyleRanges = this.childElementsCurrentStyleRanges;
            ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
            styledTextReferenceElementBuilder.setStyleRanges(this.referenceElementStyleRanges);
            styledTextReferenceElementBuilder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextTag();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    List<StoryChildElement> mergedStoryChildElements = storyChildElementsMerger.merge(storyChildElements);
                    StoryChildElementsWriter storyChildElementsWriter = this.childElementsCurrentStyleRanges.equals(mergedReferenceAndChildElementsStyleRanges) && this.sameStyleRangesFor(mergedStoryChildElements) ? storyChildElementsWriterWithEmptyStyleRanges : storyChildElementsWriterWithCharacterStyleRanges;
                    styledTextReferenceElementBuilder.setStoryChildElementsWriter(storyChildElementsWriter).addStoryChildElements(mergedStoryChildElements).setEndElement(event.asEndElement());
                    return styledTextReferenceElementBuilder.build();
                }
                if (!event.isStartElement()) {
                    throw new IllegalStateException("Unexpected structure");
                }
                if (Properties.NAME.equals(event.asStartElement().getName())) {
                    styledTextReferenceElementBuilder.setProperties(new PropertiesParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
                    continue;
                }
                StoryChildElementsParser scep = new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader);
                List<StoryChildElement> sce = scep.parseWith(this.childElementsCurrentStyleRanges);
                this.childElementsCurrentStyleRanges = this.currentStyleRangesOf(sce);
                storyChildElements.addAll(sce);
            }
            throw new IllegalStateException("Unexpected structure");
        }

        private boolean sameStyleRangesFor(List<StoryChildElement> storyChildElements) {
            return storyChildElements.stream().filter(e -> e instanceof StoryChildElement.StyledTextElement).allMatch(e -> ((StoryChildElement.StyledTextElement)e).styleRanges().equals(this.lastStyledTextElementStyleRanges()));
        }

        private StyleRanges currentStyleRangesOf(List<StoryChildElement> storyChildElements) {
            StoryChildElement.StyledTextElement ste = StoryChildElementsParser.lastStyledTextElementIn(storyChildElements);
            StyleRanges sr = null == ste ? this.childElementsCurrentStyleRanges : ste.styleRanges();
            return sr;
        }

        StyleRanges lastStyledTextElementStyleRanges() {
            return this.childElementsCurrentStyleRanges;
        }
    }

    private static class StyledTextReferenceElementParser {
        private final StartElement startElement;
        private final StyleRanges styleRanges;
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final XMLEventReader eventReader;

        private StyledTextReferenceElementParser(StartElement startElement, StyleRanges styleRanges, Parameters parameters, XMLEventFactory eventFactory, XMLEventReader eventReader) {
            this.startElement = startElement;
            this.styleRanges = styleRanges;
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.eventReader = eventReader;
        }

        StoryChildElement.StyledTextReferenceElement parse(StoryChildElement.StyledTextReferenceElement.StyledTextReferenceElementBuilder styledTextReferenceElementBuilder) throws XMLStreamException {
            ArrayList<StoryChildElement> storyChildElements = new ArrayList<StoryChildElement>();
            styledTextReferenceElementBuilder.setStyleRanges(this.styleRanges);
            styledTextReferenceElementBuilder.setStartElement(this.startElement);
            while (this.eventReader.hasNext()) {
                XMLEvent event = this.eventReader.nextTag();
                if (event.isEndElement() && event.asEndElement().getName().equals(this.startElement.getName())) {
                    StoryChildElementsMerger storyChildElementsMerger = new StoryChildElementsMerger(this.parameters, this.eventFactory);
                    styledTextReferenceElementBuilder.setStoryChildElementsWriter(new StoryChildElementsWriter(StyleRange.PARAGRAPH_STYLE_RANGE, StyleRange.CHARACTER_STYLE_RANGE)).addStoryChildElements(storyChildElementsMerger.merge(storyChildElements)).setEndElement(event.asEndElement());
                    return styledTextReferenceElementBuilder.build();
                }
                if (!event.isStartElement()) {
                    throw new IllegalStateException("Unexpected structure");
                }
                if (Properties.NAME.equals(event.asStartElement().getName())) {
                    styledTextReferenceElementBuilder.setProperties(new PropertiesParser(event.asStartElement(), this.eventReader, this.eventFactory).parse());
                    continue;
                }
                StoryChildElementsParser scep = new StoryChildElementsParser(event.asStartElement(), this.parameters, this.eventFactory, this.eventReader);
                storyChildElements.addAll(scep.parseWith(this.styleRanges));
            }
            throw new IllegalStateException("Unexpected structure");
        }
    }

    private static class StoryChildElementParser
    extends ElementParser {
        StoryChildElementParser(StartElement startElement, XMLEventReader eventReader, XMLEventFactory eventFactory) {
            super(startElement, eventReader, eventFactory);
        }

        StoryChildElement parse(StoryChildElement.Builder storyChildElementBuilder) throws XMLStreamException {
            return (StoryChildElement)super.parse(storyChildElementBuilder);
        }
    }
}

