/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.idml.CodeTypes;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.TextSkeleton;

final class TextElementMapping {
    private static final String SPECIAL_CHARACTER = "special-character";
    private static final String DASH = "-";
    private static final String TAG_OPENING = "<";
    private static final String TAG_CLOSING = "/>";
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator textUnitIds;
    private TextFragment textFragment;
    private Map<Integer, MarkupRange> codeMap;
    private int nextCodeId;

    TextElementMapping(Parameters parameters, XMLEventFactory eventFactory, IdGenerator textUnitIds) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.textUnitIds = textUnitIds;
    }

    ITextUnit textUnitFor(Element textElement) {
        this.codeMap = new HashMap<Integer, MarkupRange>();
        this.nextCodeId = 1;
        this.textFragment = new TextFragment();
        this.mapCodesIn(textElement.innerEvents());
        TextUnit textUnit = new TextUnit(this.textUnitIds.createId());
        textUnit.setPreserveWhitespaces(true);
        textUnit.setSource(new TextContainer(this.applyCodeFinder(this.textFragment)));
        TextSkeleton skeleton = new TextSkeleton(textElement, this.codeMap);
        skeleton.setParent(textUnit);
        textUnit.setSkeleton(skeleton);
        return textUnit;
    }

    private TextFragment applyCodeFinder(TextFragment textFragment) {
        if (this.parameters.getUseCodeFinder()) {
            this.parameters.getCodeFinder().process(textFragment);
            for (Code code : textFragment.getCodes()) {
                if (this.codeMap.containsKey(code.getId())) continue;
                this.codeMap.put(code.getId(), new MarkupRange.CodeFinder());
            }
        }
        return textFragment;
    }

    private void mapCodesIn(List<XMLEvent> events) {
        for (XMLEvent event : events) {
            if (event.isProcessingInstruction()) {
                this.addIsolatedCodeFor(new SpecialCharacter.Instruction(event));
                continue;
            }
            if (!event.isCharacters()) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.isolateSpecialCharactersIn(event.asCharacters().getData());
        }
    }

    private void addIsolatedCodeFor(MarkupRange markupRange) {
        String codeType = CodeTypes.createCodeType(markupRange);
        String codeData = "<special-character-" + this.nextCodeId + TAG_CLOSING;
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, codeType, codeData);
        code.setId(this.nextCodeId);
        this.textFragment.append(code);
        this.codeMap.put(this.nextCodeId, markupRange);
        ++this.nextCodeId;
    }

    private void isolateSpecialCharactersIn(String characters) {
        for (int i = 0; i < characters.length(); ++i) {
            String character = String.valueOf(characters.charAt(i));
            Matcher m = this.parameters.specialCharacterPattern().matcher(character);
            if (m.matches()) {
                SpecialCharacter.Type specialCharacterType = SpecialCharacter.Type.fromDefaultString(character);
                if (this.parameters.getSkipDiscretionaryHyphens() && SpecialCharacter.Type.DISCRETIONARY_HYPHEN == specialCharacterType) continue;
                SpecialCharacter.Default specialCharacter = new SpecialCharacter.Default(this.eventFactory.createCharacters(character));
                this.addIsolatedCodeFor(specialCharacter);
                continue;
            }
            this.textFragment.append(character);
        }
    }
}

