/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.markdown.parser;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.InlineLinkNode;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.RefNode;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.WhiteSpace;
import com.vladsch.flexmark.ext.admonition.AdmonitionBlock;
import com.vladsch.flexmark.ext.admonition.AdmonitionExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacter;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.Strikethrough;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.Subscript;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCaption;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableHead;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TableSeparator;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterBlock;
import com.vladsch.flexmark.ext.yaml.front.matter.YamlFrontMatterExtension;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.AllNodesVisitor;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.DelimitedNode;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.VisitHandler;
import com.vladsch.flexmark.util.ast.Visitor;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.filters.markdown.Parameters;
import net.sf.okapi.filters.markdown.parser.HeaderAnchorGenerator;
import net.sf.okapi.filters.markdown.parser.MarkdownToken;
import net.sf.okapi.filters.markdown.parser.MarkdownTokenType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownParser {
    private static final MutableDataHolder OPTIONS = new MutableDataSet().set(Parser.EXTENSIONS, Arrays.asList(StrikethroughSubscriptExtension.create(), TablesExtension.create(), YamlFrontMatterExtension.create(), EscapedCharacterExtension.create(), AdmonitionExtension.create())).set(Parser.HEADING_NO_ATX_SPACE, (Object)true).set(Parser.BLANK_LINES_IN_AST, (Object)true);
    private static final Parser PARSER = Parser.builder((DataHolder)OPTIONS).build();
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String newline = System.lineSeparator();
    private Node root = null;
    private final Deque<MarkdownToken> tokenQueue = new LinkedList<MarkdownToken>();
    private boolean lastAddedTranslatableContent = false;
    private Parameters params;
    private final Pattern urlPatternToTranslate;
    private boolean isBlockQuoteNonTranslatable = false;
    private String linePrefix = "";
    private final Pattern docusaurusAdmonitionOpening = Pattern.compile(":::([a-z]+) ?.*$");
    private final Pattern exportMdxPattern = Pattern.compile("^(?s)export (const|default)");
    private final HeaderAnchorGenerator anchorGenerator = new HeaderAnchorGenerator();
    private static final Pattern HEADER_ID_PATTERN = Pattern.compile("\\{#\\S+}");
    private static final Pattern END_OF_HTML_BLOCK_PATTERN = Pattern.compile("</[a-zA-Z]+>\\s*");
    private final Pattern NEWLINE_ONLY_PATTERN = Pattern.compile("^(\r?\n)$");
    private int admonitionBlockNestLevel = 0;
    private int admonitionBlankLineCount = 0;
    private final Map<String, Boolean> refVisible = new HashMap<String, Boolean>();
    private final Set<String> usedRefTextSet = new HashSet<String>();
    private final AllNodesVisitor preVisitor = new AllNodesVisitor(){

        protected void process(@NotNull Node node) {
            RefNode refNode;
            LinkRef linkRefNode;
            BasedSequence refTextBS;
            if (node instanceof LinkRef && MarkdownParser.this.isDefined(refTextBS = (linkRefNode = (LinkRef)node).getReference())) {
                String refText = refTextBS.toString();
                if (MarkdownParser.this.refVisible.containsKey(refText)) {
                    if (MarkdownParser.this.refVisible.get(refText).booleanValue()) {
                        return;
                    }
                } else {
                    MarkdownParser.this.refVisible.put(refText, false);
                }
                if (!MarkdownParser.this.isDefined(linkRefNode.getText())) {
                    MarkdownParser.this.refVisible.put(refText, true);
                }
            }
            if (node instanceof RefNode && MarkdownParser.this.isDefined(refTextBS = (refNode = (RefNode)node).getReference())) {
                MarkdownParser.this.usedRefTextSet.add(refTextBS.toString().toLowerCase(Locale.US));
            }
        }
    };
    private final NodeVisitor visitor = new NodeVisitor(new VisitHandler[]{new VisitHandler(AutoLink.class, node -> {
        if (this.isStartOfLine(node)) {
            this.addToQueue(MarkdownParser.findIndent(this.linePrefix, node.getChars()) + node.getChars(), false, MarkdownTokenType.AUTO_LINK);
        } else {
            this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.AUTO_LINK);
        }
    }), new VisitHandler(BlankLine.class, node -> {
        if (this.admonitionBlockNestLevel > 0) {
            ++this.admonitionBlankLineCount;
            this.addToQueue(this.newline, false, MarkdownTokenType.BLANK_LINE);
        } else if (this.admonitionBlankLineCount > 0) {
            --this.admonitionBlankLineCount;
        } else {
            this.addToQueue(this.newline, false, MarkdownTokenType.BLANK_LINE);
        }
    }), new VisitHandler(BlockQuote.class, (Visitor)new Visitor<BlockQuote>(){

        public void visit(@NotNull BlockQuote node) {
            boolean revertNonTranslatableFlag = false;
            if (!MarkdownParser.this.params.getNonTranslateBlocks().isEmpty()) {
                String[] nonTranslatableBlocks;
                for (String block : nonTranslatableBlocks = MarkdownParser.this.params.getNonTranslateBlocks().split(",")) {
                    if (!node.getChars().toString().contains(block)) continue;
                    MarkdownParser.this.isBlockQuoteNonTranslatable = true;
                    revertNonTranslatableFlag = true;
                    break;
                }
            }
            String prevLinePrefix = MarkdownParser.this.linePrefix;
            MarkdownParser.this.linePrefix = prevLinePrefix + node.getOpeningMarker().prefixWithIndent().extendByAny(CharPredicate.SPACE_TAB).toString();
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            MarkdownParser.this.visitor.visitChildren((Node)node);
            if (!MarkdownParser.this.hasDescendantParagraph((Node)node) && !MarkdownParser.this.hasDescendantBlankLine((Node)node) && node.getChars().endsWith((CharSequence)MarkdownParser.this.newline)) {
                MarkdownParser.this.addNewline();
            }
            if (revertNonTranslatableFlag) {
                MarkdownParser.this.isBlockQuoteNonTranslatable = false;
            }
            MarkdownParser.this.linePrefix = prevLinePrefix;
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
        }
    }), new VisitHandler(BulletList.class, this::visitListBlock), new VisitHandler(BulletListItem.class, node -> this.visitListItem((ListItem)node, MarkdownTokenType.BULLET_LIST_ITEM)), new VisitHandler(Code.class, (Visitor)new Visitor<Code>(){

        public void visit(@NotNull Code node) {
            if (MarkdownParser.this.params.getTranslateInlineCodeBlocks()) {
                MarkdownParser.this.addToQueue(node.getOpeningMarker().toString(), false, MarkdownTokenType.CODE);
                MarkdownParser.this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT);
                MarkdownParser.this.addToQueue(node.getClosingMarker().toString(), false, MarkdownTokenType.CODE);
            } else {
                String sb = node.getOpeningMarker().toString() + node.getText().toString() + node.getClosingMarker().toString();
                MarkdownParser.this.addToQueue(sb, false, MarkdownTokenType.CODE);
                if (node.getText().toString().contains("\n") || node.getText().toString().contains("\r")) {
                    MarkdownParser.this.LOGGER.debug("Code.getText() includes one or more newlines:{}", (Object)node.getText());
                }
            }
        }
    }), new VisitHandler(Block.class, (Visitor)new Visitor<Block>(){

        public void visit(@NotNull Block node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(Node.class, (Visitor)new Visitor<Node>(){

        public void visit(@NotNull Node node) {
            MarkdownParser.this.visitor.visitChildren(node);
        }
    }), new VisitHandler(Document.class, (Visitor)new Visitor<Document>(){

        public void visit(@NotNull Document node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(Emphasis.class, node -> this.visitDelimitedNode((DelimitedNode)node, MarkdownTokenType.EMPHASIS)), new VisitHandler(FencedCodeBlock.class, (Visitor)new Visitor<FencedCodeBlock>(){

        public void visit(@NotNull FencedCodeBlock node) {
            String prevLinePrefix = MarkdownParser.this.linePrefix;
            String strippedPrefix = prevLinePrefix.stripTrailing();
            int extraPrefixIndent = Math.max(prevLinePrefix.length() - strippedPrefix.length(), 0);
            if (!prevLinePrefix.equals(MarkdownParser.findIndent(prevLinePrefix, node.getChars()))) {
                MarkdownParser.this.linePrefix = MarkdownParser.this.linePrefix + MarkdownParser.findIndent(MarkdownParser.this.linePrefix, node.getChars());
                MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            }
            MarkdownParser.this.addToQueue(node.getOpeningFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK);
            if (MarkdownParser.this.isDefined(node.getInfo())) {
                MarkdownParser.this.addToQueue(node.getInfo().prefixWithIndent().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK_INFO);
            }
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
            for (BasedSequence seq : node.getContentLines()) {
                String prefixWithIndent = seq.prefixWithIndent().toString();
                if (MarkdownParser.this.NEWLINE_ONLY_PATTERN.matcher(prefixWithIndent).matches()) continue;
                if (MarkdownParser.this.linePrefix.isBlank() && !MarkdownParser.this.linePrefix.equals(MarkdownParser.this.linePrefix + MarkdownParser.findIndent(MarkdownParser.this.linePrefix, seq))) {
                    MarkdownParser.this.linePrefix = MarkdownParser.this.linePrefix + MarkdownParser.findIndent(MarkdownParser.this.linePrefix, seq);
                    MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
                }
                MarkdownParser.this.addToQueue(seq.toString(), MarkdownParser.this.params.getTranslateFencedCodeBlocks(), MarkdownTokenType.TEXT);
            }
            if (!prevLinePrefix.equals(MarkdownParser.findIndent(prevLinePrefix, node.getChars()))) {
                MarkdownParser.this.linePrefix = prevLinePrefix + MarkdownParser.findIndent(prevLinePrefix, node.getChars());
                MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            }
            MarkdownParser.this.addToQueue(node.getClosingFence().toString(), false, MarkdownTokenType.FENCED_CODE_BLOCK);
            MarkdownParser.this.addNewline();
        }
    }), new VisitHandler(YamlFrontMatterBlock.class, (Visitor)new Visitor<YamlFrontMatterBlock>(){

        public void visit(@NotNull YamlFrontMatterBlock node) {
            if (MarkdownParser.this.params.getTranslateHeaderMetadata()) {
                MarkdownParser.this.addToQueue("---", false, MarkdownTokenType.THEMATIC_BREAK);
                MarkdownParser.this.addNewline();
                StringBuilder yaml = new StringBuilder();
                for (BasedSequence sequence : node.getContentLines()) {
                    if (sequence.matchChars((CharSequence)"---")) continue;
                    yaml.append(sequence.normalizeEndWithEOL());
                }
                MarkdownParser.this.addToQueue(yaml.toString(), true, MarkdownTokenType.YAML_METADATA_HEADER);
                MarkdownParser.this.addToQueue("---", false, MarkdownTokenType.THEMATIC_BREAK);
                MarkdownParser.this.addNewline();
            } else {
                MarkdownParser.this.addToQueue(node.getContentChars().toString(), false, MarkdownTokenType.THEMATIC_BREAK);
                if (!node.getContentChars().endsWith((CharSequence)MarkdownParser.this.newline)) {
                    MarkdownParser.this.addNewline();
                }
            }
        }
    }), new VisitHandler(HardLineBreak.class, (Visitor)new Visitor<HardLineBreak>(){

        public void visit(@NotNull HardLineBreak node) {
            String x = node.getChars().toString();
            if (x.endsWith(MarkdownParser.this.newline)) {
                MarkdownParser.this.addToQueue(x.substring(0, x.length() - MarkdownParser.this.newline.length()), false, MarkdownTokenType.HARD_LINE_BREAK);
                MarkdownParser.this.addToQueue(MarkdownParser.this.newline, true, MarkdownTokenType.SOFT_LINE_BREAK);
            } else {
                MarkdownParser.this.LOGGER.warn("HardLineBreak nodes is not ending with a newline.");
                MarkdownParser.this.addToQueue(x, false, MarkdownTokenType.HARD_LINE_BREAK);
            }
        }
    }), new VisitHandler(AdmonitionBlock.class, (Visitor)new Visitor<AdmonitionBlock>(){

        public void visit(@NotNull AdmonitionBlock node) {
            ++MarkdownParser.this.admonitionBlockNestLevel;
            String prevLinePrefix = MarkdownParser.this.linePrefix;
            BasedSequence openingSequence = null;
            if (node.getOpeningMarker() != BasedSequence.NULL) {
                if (MarkdownParser.this.tokenQueue.peekLast() == null || !MarkdownParser.this.tokenQueue.peekLast().getType().equals((Object)MarkdownTokenType.LINE_PREFIX)) {
                    MarkdownParser.this.linePrefix = prevLinePrefix + MarkdownParser.findIndent(prevLinePrefix, node.getOpeningMarker());
                    MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
                }
                MarkdownParser.this.addToQueue(node.getOpeningMarker().extendByAny(CharPredicate.SPACE_TAB).toString(), false, MarkdownTokenType.ADMONITION_OPENING);
                openingSequence = node.getOpeningMarker();
            }
            if (node.getTitle() != BasedSequence.NULL && node.getTitle().length() > 0) {
                MarkdownParser.this.addToQueue(node.getInfo().extendByAny(CharPredicate.SPACE_TAB).toStringOrNull(), false, MarkdownTokenType.ADMONITION_INFO);
                MarkdownParser.this.addToQueue("\"", false, MarkdownTokenType.TEXT);
                MarkdownParser.this.addToQueue(Objects.requireNonNull(node.getTitle().toStringOrNull()), true, MarkdownTokenType.TEXT);
                MarkdownParser.this.addToQueue("\"", false, MarkdownTokenType.TEXT);
                openingSequence = node.getTitle();
            } else if (Objects.equals(node.getTitleOpeningMarker().toStringOrNull(), "\"") && node.getTitle().length() == 0) {
                MarkdownParser.this.addToQueue(node.getInfo().extendByAny(CharPredicate.SPACE_TAB).toStringOrNull(), false, MarkdownTokenType.ADMONITION_INFO);
                MarkdownParser.this.addToQueue("\"\"", false, MarkdownTokenType.TEXT);
                openingSequence = node.getTitleOpeningMarker();
            } else if (node.getTitle().length() == 0) {
                MarkdownParser.this.addToQueue(node.getInfo().toStringOrNull(), true, MarkdownTokenType.TEXT);
            }
            MarkdownParser.this.addNewline();
            if (openingSequence != null && (openingSequence = openingSequence.extendToEndOfLine(true).getEmptySuffix().extendToEndOfLine()).toString().isBlank()) {
                MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.BLANK_LINE);
            }
            MarkdownParser.this.linePrefix = MarkdownParser.this.linePrefix + "    ";
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            MarkdownParser.this.visitor.visitChildren((Node)node);
            MarkdownParser.this.addToQueue("", false, MarkdownTokenType.END_TEXT_UNIT);
            MarkdownParser.this.linePrefix = prevLinePrefix;
            MarkdownParser.this.addToQueue(MarkdownParser.this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            --MarkdownParser.this.admonitionBlockNestLevel;
        }
    }), new VisitHandler(Heading.class, (Visitor)new Visitor<Heading>(){

        public void visit(@NotNull Heading node) {
            Matcher m;
            MarkdownToken prevNode;
            if (node.getOpeningMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addToQueue(node.getOpeningMarker().extendByAny(CharPredicate.SPACE_TAB).toString(), false, MarkdownTokenType.HEADING_PREFIX);
            }
            MarkdownParser.this.visitor.visitChildren((Node)node);
            if (MarkdownParser.this.params.getGenerateHeaderAnchors() && (prevNode = MarkdownParser.this.tokenQueue.peekLast()) != null && prevNode.getType() == MarkdownTokenType.TEXT && !(m = HEADER_ID_PATTERN.matcher(prevNode.getContent())).find()) {
                String anchorText = MarkdownParser.this.anchorGenerator.generateAnchorText(prevNode.getContent());
                MarkdownParser.this.addToQueue("", false, MarkdownTokenType.END_TEXT_UNIT);
                MarkdownParser.this.addToQueue(" {#" + anchorText + "}", false, MarkdownTokenType.HEADING_ANCHOR);
            }
            if (node.getClosingMarker() != BasedSequence.NULL) {
                MarkdownParser.this.addNewline();
                MarkdownParser.this.addToQueue(node.getClosingMarker().toString(), false, MarkdownTokenType.HEADING_UNDERLINE);
            }
            MarkdownParser.this.addNewline();
        }
    }), new VisitHandler(HtmlBlock.class, node -> {
        this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_BLOCK);
        if (node.getChars().endsWith((CharSequence)this.newline)) {
            this.addNewline();
        }
    }), new VisitHandler(HtmlCommentBlock.class, node -> {
        this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_COMMENT_BLOCK);
        if (node.getChars().endsWith((CharSequence)this.newline)) {
            this.addNewline();
        }
    }), new VisitHandler(HtmlEntity.class, node -> this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_ENTITY)), new VisitHandler(HtmlInline.class, (Visitor)new Visitor<HtmlInline>(){

        public void visit(@NotNull HtmlInline node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE);
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(HtmlInlineComment.class, (Visitor)new Visitor<HtmlInlineComment>(){

        public void visit(@NotNull HtmlInlineComment node) {
            MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.HTML_INLINE_COMMENT);
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(HtmlInnerBlock.class, node -> this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_INNER_BLOCK)), new VisitHandler(HtmlInnerBlockComment.class, node -> this.visitHtmlBlockBase((HtmlBlockBase)node, MarkdownTokenType.HTML_INNER_BLOCK_COMMENT)), new VisitHandler(Image.class, node -> this.visitInlineLink((InlineLinkNode)node, MarkdownTokenType.IMAGE)), new VisitHandler(ImageRef.class, node -> this.visitRefLink((RefNode)node, MarkdownTokenType.IMAGE_REF)), new VisitHandler(IndentedCodeBlock.class, node -> {
        String indent = "    ";
        String prevLinePrefix = this.linePrefix;
        if (!node.getContentLines().isEmpty()) {
            indent = MarkdownParser.findIndent(prevLinePrefix, (BasedSequence)node.getContentLines().get(0));
        }
        this.linePrefix = prevLinePrefix + indent;
        this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
        for (BasedSequence seq : node.getContentLines()) {
            this.addToQueue(seq.toString(), this.params.getTranslateIndentedCodeBlocks(), MarkdownTokenType.TEXT);
        }
        this.addToQueue("", false, MarkdownTokenType.END_TEXT_UNIT);
        this.linePrefix = prevLinePrefix;
        this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
    }), new VisitHandler(Link.class, node -> this.visitInlineLink((InlineLinkNode)node, MarkdownTokenType.LINK)), new VisitHandler(LinkRef.class, node -> this.visitRefLink((RefNode)node, MarkdownTokenType.LINK_REF)), new VisitHandler(MailLink.class, node -> this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.MAIL_LINK)), new VisitHandler(Paragraph.class, (Visitor)new Visitor<Paragraph>(){

        public void visit(@NotNull Paragraph node) {
            Matcher exportMdxMatcher = MarkdownParser.this.exportMdxPattern.matcher(node.getChars().toString());
            if (MarkdownParser.this.params.getParseMdx() && exportMdxMatcher.find()) {
                MarkdownParser.this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.MDX_EXPORT);
            } else {
                MarkdownParser.this.visitor.visitChildren((Node)node);
            }
            if (node.getChars().endsWith((CharSequence)MarkdownParser.this.newline) && (node.getNext() != null || MarkdownParser.this.admonitionBlockNestLevel < 1 || node.getParent() != null && node.getParent() instanceof ListItem && node.getParent().getNext() != null)) {
                MarkdownParser.this.addNewline();
            }
            if (node.getParent() != null && node.getParent() instanceof AdmonitionBlock) {
                int endOffset = node.getChars().getEndOffset();
                try {
                    BasedSequence maybeNewline = node.getChars().getBaseSequence().subSequence(endOffset, endOffset + MarkdownParser.this.newline.length());
                    if (maybeNewline.toString().equals(MarkdownParser.this.newline)) {
                        MarkdownParser.this.addNewline();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }), new VisitHandler(OrderedList.class, this::visitListBlock), new VisitHandler(OrderedListItem.class, node -> this.visitListItem((ListItem)node, MarkdownTokenType.ORDERED_LIST_ITEM)), new VisitHandler(Reference.class, this::visitReferenceDefinition), new VisitHandler(SoftLineBreak.class, node -> this.addToQueue(this.newline, true, MarkdownTokenType.SOFT_LINE_BREAK)), new VisitHandler(StrongEmphasis.class, node -> this.visitDelimitedNode((DelimitedNode)node, MarkdownTokenType.STRONG_EMPHASIS)), new VisitHandler(Subscript.class, node -> this.visitDelimitedNode((DelimitedNode)node, MarkdownTokenType.SUBSCRIPT)), new VisitHandler(Strikethrough.class, node -> this.visitDelimitedNode((DelimitedNode)node, MarkdownTokenType.STRIKETHROUGH)), new VisitHandler(EscapedCharacter.class, node -> {
        if (this.params.getUnescapeBackslashCharacters()) {
            this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT);
        } else {
            this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT);
        }
    }), new VisitHandler(Text.class, node -> {
        if (node.getChars().toString().isEmpty()) {
            return;
        }
        if (this.tokenQueue.peekLast() != null && node.getPrevious() instanceof ImageRef && this.tokenQueue.peekLast().getType().equals((Object)MarkdownTokenType.IMAGE)) {
            return;
        }
        Matcher admonitionMatcher = this.docusaurusAdmonitionOpening.matcher(node.getChars().toString());
        if (admonitionMatcher.matches()) {
            if (AdmonitionExtension.getQualifierTitleMap().keySet().stream().anyMatch(node.getChars().toString()::contains)) {
                this.addToQueue(":::", false, MarkdownTokenType.ADMONITION_OPENING);
                String admonitionInfo = admonitionMatcher.group(1);
                this.addToQueue(admonitionInfo, false, MarkdownTokenType.ADMONITION_INFO);
                if (node.getChars().toString().contains(" ")) {
                    this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE);
                    String title = node.getChars().toString().substring(admonitionInfo.length() + 4);
                    this.addToQueue(title, true, MarkdownTokenType.TEXT);
                }
                if (node.getNext() != null) {
                    this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
                }
                return;
            }
        }
        if (node.getChars().toString().equals(":::") && this.maybeAddDocusaurusAdmonitionEnding(node)) {
            return;
        }
        if (!node.getChars().toString().trim().isEmpty()) {
            if (this.isStartOfLine(node)) {
                if (!this.linePrefix.isBlank()) {
                    this.addToQueue(MarkdownParser.findIndent(this.linePrefix, node.getChars()), true, MarkdownTokenType.WHITE_SPACE);
                    this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT);
                } else if (node.getParent() != null && node.getParent() instanceof Paragraph && Objects.equals(node.getParent().getFirstChild(), node)) {
                    this.addToQueue(this.linePrefix + MarkdownParser.findIndent(this.linePrefix, node.getChars()), false, MarkdownTokenType.LINE_PREFIX);
                    this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT);
                } else {
                    this.addToQueue(this.linePrefix + MarkdownParser.findIndent(this.linePrefix, node.getChars()) + node.getChars(), true, MarkdownTokenType.TEXT);
                }
            } else {
                this.addToQueue(node.getChars().toString(), true, MarkdownTokenType.TEXT);
            }
        } else {
            MarkdownToken lastToken = this.tokenQueue.peekLast();
            this.addToQueue(node.getChars().toString(), this.lastAddedTranslatableContent || lastToken != null && lastToken.getType().isInline(), MarkdownTokenType.TEXT);
        }
    }), new VisitHandler(TextBase.class, (Visitor)new Visitor<TextBase>(){

        public void visit(@NotNull TextBase node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(ThematicBreak.class, node -> {
        this.addToQueue(node.getChars().toString(), false, MarkdownTokenType.THEMATIC_BREAK);
        this.addNewline();
    }), new VisitHandler(WhiteSpace.class, (Visitor)new Visitor<WhiteSpace>(){

        public void visit(@NotNull WhiteSpace node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(TableBlock.class, (Visitor)new Visitor<TableBlock>(){

        public void visit(@NotNull TableBlock node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
            if (!node.getChars().endsWith((CharSequence)MarkdownParser.this.newline)) {
                MarkdownParser.this.tokenQueue.removeLast();
            }
        }
    }), new VisitHandler(TableBody.class, (Visitor)new Visitor<TableBody>(){

        public void visit(@NotNull TableBody node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(TableCaption.class, (Visitor)new Visitor<TableCaption>(){

        public void visit(@NotNull TableCaption node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(TableCell.class, (Visitor)new Visitor<TableCell>(){

        public void visit(@NotNull TableCell node) {
            MarkdownParser.this.addToQueue("| ", false, MarkdownTokenType.TABLE_PIPE);
            Node cn = node.getFirstChild();
            if (cn == node.getLastChild() && cn instanceof Text && cn.getChars().toString().equals(" ")) {
                int ns = node.getTextLength() - 2;
                if (!node.getOpeningMarker().isEmpty()) {
                    --ns;
                }
                MarkdownParser.this.addToQueue(StringUtil.repeatChar(' ', ns), false, MarkdownTokenType.WHITE_SPACE);
            } else {
                MarkdownParser.this.visitor.visitChildren((Node)node);
                MarkdownParser.this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE);
            }
        }
    }), new VisitHandler(TableHead.class, (Visitor)new Visitor<TableHead>(){

        public void visit(@NotNull TableHead node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
        }
    }), new VisitHandler(TableRow.class, (Visitor)new Visitor<TableRow>(){

        public void visit(@NotNull TableRow node) {
            MarkdownParser.this.visitor.visitChildren((Node)node);
            MarkdownParser.this.addToQueue("|", false, MarkdownTokenType.TABLE_PIPE);
            MarkdownParser.this.addToQueue(MarkdownParser.this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
        }
    }), new VisitHandler(TableSeparator.class, node -> {
        String nodeText = node.getChars().toString();
        if (nodeText.endsWith("\r")) {
            nodeText = nodeText.substring(0, nodeText.length() - 1);
        }
        this.addToQueue(nodeText, false, MarkdownTokenType.TABLE_SEPARATOR);
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
    })});

    public MarkdownParser(Parameters params) {
        this.params = params;
        this.urlPatternToTranslate = Pattern.compile(params.getUrlToTranslatePattern());
    }

    public MarkdownParser(Parameters params, String newline) {
        this(params);
        this.newline = newline;
    }

    public void parse(String markdownContent) {
        this.root = PARSER.parse(markdownContent);
        this.tokenQueue.clear();
        this.lastAddedTranslatableContent = false;
        this.preVisitor.visit(this.root);
        this.visitor.visit(this.root);
    }

    public boolean hasNextToken() {
        return !this.tokenQueue.isEmpty();
    }

    public MarkdownToken getNextToken() {
        if (!this.hasNextToken()) {
            throw new IllegalStateException("No more tokens remaining");
        }
        return this.tokenQueue.removeFirst();
    }

    public String getNewline() {
        return this.newline;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public String dumpTokens() {
        StringBuilder builder = new StringBuilder();
        for (MarkdownToken tok : this.tokenQueue) {
            builder.append(tok).append(this.newline);
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.generateAstString(this.root, 0, builder);
        return builder.toString();
    }

    private void generateAstString(Node node, int depth, StringBuilder builder) {
        if (node == null) {
            builder.append("The root node is null!\n");
            return;
        }
        builder.append(" ".repeat(Math.max(0, depth)));
        builder.append(node.toAstString(true)).append(this.newline);
        for (Node child : node.getChildren()) {
            this.generateAstString(child, depth + 1, builder);
        }
    }

    private void addToQueue(String content, boolean isTranslatable, MarkdownTokenType type) {
        if (content.equals(this.newline) && !isTranslatable) {
            this.lastAddedTranslatableContent = false;
            this.tokenQueue.addLast(new MarkdownToken(content, false, type));
            return;
        }
        if (this.lastAddedTranslatableContent && isTranslatable) {
            MarkdownToken lastToken = this.tokenQueue.peekLast();
            assert (lastToken != null);
            lastToken.setContent(lastToken.getContent() + content);
            if (lastToken.getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK)) {
                lastToken.setType(type);
            }
            return;
        }
        if (this.isBlockQuoteNonTranslatable) {
            isTranslatable = false;
        }
        this.lastAddedTranslatableContent = isTranslatable;
        this.tokenQueue.addLast(new MarkdownToken(content, isTranslatable, type));
    }

    private boolean isVisibleRef(String refText) {
        return this.refVisible.getOrDefault(refText, false);
    }

    private boolean isRefTextUsed(String refText) {
        return this.usedRefTextSet.contains(refText.toLowerCase(Locale.US));
    }

    private boolean maybeAddDocusaurusAdmonitionEnding(Node node) {
        AtomicInteger numOpenings = new AtomicInteger();
        AtomicInteger numClosings = new AtomicInteger();
        this.tokenQueue.stream().filter(token -> token.getContent().equals(":::")).forEach(token -> {
            switch (token.getType()) {
                case ADMONITION_OPENING: {
                    numOpenings.getAndIncrement();
                    break;
                }
                case ADMONITION_CLOSING: {
                    numClosings.getAndIncrement();
                }
            }
        });
        if (numOpenings.get() > numClosings.get()) {
            if (node.getPrevious() != null) {
                this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
            }
            this.addToQueue(":::", false, MarkdownTokenType.ADMONITION_CLOSING);
            return true;
        }
        return false;
    }

    private void addNewline() {
        this.addToQueue(this.newline, false, MarkdownTokenType.SOFT_LINE_BREAK);
    }

    private void visitDelimitedNode(DelimitedNode node, MarkdownTokenType type) {
        assert (node instanceof Node);
        this.addToQueue(node.getOpeningMarker().toString(), false, type);
        this.visitor.visitChildren((Node)node);
        this.addToQueue(node.getClosingMarker().toString(), false, type);
    }

    private void visitHtmlBlockBase(HtmlBlockBase node, MarkdownTokenType type) {
        boolean shouldTranslate;
        boolean bl = shouldTranslate = !type.equals((Object)MarkdownTokenType.HTML_COMMENT_BLOCK) && !type.equals((Object)MarkdownTokenType.HTML_INNER_BLOCK_COMMENT);
        if (node.getChars().endsWith((CharSequence)":::\r\n") || node.getChars().endsWith((CharSequence)":::\r") || node.getChars().endsWith((CharSequence)":::\n")) {
            this.addToQueue(node.getChars().toString().trim().substring(0, node.getChars().length() - 4), shouldTranslate, type);
            this.maybeAddDocusaurusAdmonitionEnding((Node)node);
        } else {
            if (END_OF_HTML_BLOCK_PATTERN.matcher(node.getChars().toString()).matches()) {
                this.addToQueue("", false, MarkdownTokenType.SOFT_LINE_BREAK);
            }
            if (this.isStartOfLine((Node)node)) {
                this.addToQueue(MarkdownParser.findIndent(this.linePrefix, node.getChars()) + node.getChars().trimEnd(), shouldTranslate, type);
            } else {
                this.addToQueue(((BasedSequence)node.getChars().trimEnd()).toString(), shouldTranslate, type);
            }
        }
        for (Node child : node.getChildren()) {
            this.visitor.visit(child);
        }
    }

    private void visitInlineLink(InlineLinkNode node, MarkdownTokenType type) {
        StringBuilder sb = new StringBuilder();
        Object openingMarker = node.getTextOpeningMarker().toString();
        if (this.isStartOfLine((Node)node)) {
            openingMarker = MarkdownParser.findIndent(this.linePrefix, node.getTextOpeningMarker()) + (String)openingMarker;
        }
        if (node instanceof Image) {
            if (this.params.getTranslateImageAltText()) {
                this.addToQueue((String)openingMarker, false, type);
                this.visitor.visitChildren((Node)node);
                sb.append((CharSequence)node.getTextClosingMarker());
            } else {
                sb.append((String)openingMarker).append(node.getText().toString()).append((CharSequence)node.getTextClosingMarker());
            }
        } else {
            assert (node instanceof Link);
            this.addToQueue((String)openingMarker, false, type);
            this.visitor.visitChildren((Node)node);
            sb.append((CharSequence)node.getTextClosingMarker());
        }
        sb.append((CharSequence)node.getLinkOpeningMarker());
        sb.append((CharSequence)node.getUrlOpeningMarker());
        sb.append((CharSequence)node.getUrl());
        sb.append((CharSequence)node.getUrlClosingMarker());
        if (this.isDefined(node.getTitle())) {
            sb.append(" ").append((CharSequence)node.getTitleOpeningMarker());
            this.addToQueue(sb.toString(), false, type);
            this.addToQueue(node.getTitle().toString(), true, MarkdownTokenType.TEXT);
            sb = new StringBuilder((CharSequence)node.getTitleClosingMarker());
        }
        sb.append((CharSequence)node.getLinkClosingMarker());
        this.addToQueue(sb.toString(), false, type);
    }

    private void visitRefLink(RefNode node, MarkdownTokenType type) {
        Object openingMarker = node.getTextOpeningMarker().toString();
        if (this.isStartOfLine((Node)node)) {
            openingMarker = MarkdownParser.findIndent(this.linePrefix, node.getTextOpeningMarker()) + (String)openingMarker;
        }
        if (this.isDefined(node.getText())) {
            if (node instanceof ImageRef) {
                this.addToQueue((String)openingMarker, false, type);
                this.addToQueue(node.getText().toString(), true, MarkdownTokenType.TEXT);
                this.addToQueue(node.getTextClosingMarker().toString(), false, type);
            } else {
                this.addToQueue((String)openingMarker, false, type);
                this.visitor.visitChildren((Node)node);
                this.addToQueue(node.getTextClosingMarker().toString(), false, type);
            }
        } else if (node instanceof ImageRef) {
            if (node.getReferenceOpeningMarker().toString().equals("![") && node.getNext() instanceof Text) {
                Image image = new Image(node.getReferenceOpeningMarker(), node.getReference(), node.getReferenceClosingMarker(), (BasedSequence)node.getNext().getChars().safeSubSequence(0, 1), (BasedSequence)node.getNext().getChars().safeSubSequence(1, node.getNext().getChars().length() - 1), (BasedSequence)node.getNext().getChars().safeSubSequence(node.getNext().getChars().length() - 1, node.getNext().getChars().length()));
                image.appendChild((Node)new Text(node.getReference()));
                this.visitInlineLink((InlineLinkNode)image, MarkdownTokenType.IMAGE);
                return;
            }
            this.addToQueue((String)openingMarker + node.getTextClosingMarker().toString(), false, type);
        }
        if (this.isDefined(node.getReferenceOpeningMarker())) {
            this.addToQueue(node.getReferenceOpeningMarker().toString(), false, type);
            if (this.isDefined(node.getReference())) {
                String refText = node.getReference().toString();
                if (this.isVisibleRef(refText)) {
                    this.visitor.visitChildren((Node)node);
                } else {
                    this.addToQueue(refText, false, type);
                }
            } else if ("[ ]".equals(node.getChars().toString())) {
                this.addToQueue(" ", false, MarkdownTokenType.WHITE_SPACE);
            } else {
                this.LOGGER.warn("{} node [{}] reports a reference opening marker but the reference is empty.", (Object)node.getClass().getName(), (Object)node.toAstString(false));
            }
            if (this.isDefined(node.getReferenceClosingMarker())) {
                this.addToQueue(node.getReferenceClosingMarker().toString(), false, type);
            } else {
                this.LOGGER.warn("{} node [{}] reports a reference opening marker but lacks a closing marker.", (Object)node.getClass().getName(), (Object)node.toAstString(false));
            }
        }
    }

    private void visitReferenceDefinition(Reference node) {
        this.addToQueue(node.getOpeningMarker().toString(), false, MarkdownTokenType.REFERENCE);
        String refText = node.getReference().toString();
        this.addToQueue(refText, this.isVisibleRef(refText), MarkdownTokenType.REFERENCE);
        this.addToQueue(node.getClosingMarker().extendByAny(CharPredicate.SPACE_TAB).toString(), false, MarkdownTokenType.REFERENCE);
        if (this.isDefined(node.getUrlOpeningMarker())) {
            this.addToQueue(node.getUrlOpeningMarker().toString(), false, MarkdownTokenType.REFERENCE);
        }
        if (this.shouldTranslateUrl((LinkNodeBase)node)) {
            this.addToQueue(node.getUrl().toString(), this.isRefTextUsed(refText), MarkdownTokenType.REFERENCE);
        } else {
            this.addToQueue(node.getUrl().toString(), false, MarkdownTokenType.REFERENCE);
        }
        if (this.isDefined(node.getUrlClosingMarker())) {
            this.addToQueue(node.getUrlClosingMarker().toString(), false, MarkdownTokenType.REFERENCE);
        }
        if (this.isDefined(node.getTitle())) {
            this.addToQueue(" " + node.getTitleOpeningMarker().toString(), false, MarkdownTokenType.REFERENCE);
            this.addToQueue(node.getTitle().toString(), this.isRefTextUsed(refText), MarkdownTokenType.REFERENCE);
            this.addToQueue(node.getTitleClosingMarker().toString(), false, MarkdownTokenType.REFERENCE);
        }
        this.addToQueue(this.newline, false, MarkdownTokenType.REFERENCE);
    }

    private void visitListBlock(ListBlock listBlock) {
        this.visitor.visitChildren((Node)listBlock);
    }

    private void visitListItem(ListItem listItem, MarkdownTokenType type) {
        if (!listItem.hasChildren()) {
            this.addToQueue(listItem.getOpeningMarker().extendByAny(CharPredicate.SPACE_TAB).toString(), false, type);
            this.addNewline();
        } else {
            String prevLinePrefix = this.linePrefix;
            this.linePrefix = prevLinePrefix + MarkdownParser.findIndent(prevLinePrefix, listItem.getChars());
            this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
            this.addToQueue(listItem.getOpeningMarker().extendByAny(CharPredicate.SPACE_TAB).toString(), false, type);
            this.visitor.visitChildren((Node)listItem);
            this.linePrefix = prevLinePrefix;
            this.addToQueue(this.linePrefix, false, MarkdownTokenType.LINE_PREFIX);
        }
    }

    private static String findIndent(String prevLinePrefix, BasedSequence sequence) {
        String strippedPrefix = prevLinePrefix.stripTrailing();
        String withIndent = sequence.isEmpty() ? "" : sequence.prefixWithIndent().toString();
        String withoutIndent = sequence.toString();
        if (prevLinePrefix.length() - strippedPrefix.length() > withIndent.length() - withoutIndent.length()) {
            return strippedPrefix;
        }
        return withIndent.substring(prevLinePrefix.length() - strippedPrefix.length(), withIndent.length() - withoutIndent.length());
    }

    private boolean isStartOfLine(Node node) {
        return node.getPrevious() != null && node.getPrevious() instanceof HardLineBreak || this.tokenQueue.peekLast() != null && (this.tokenQueue.peekLast().getType().equals((Object)MarkdownTokenType.SOFT_LINE_BREAK) || this.tokenQueue.peekLast().getType().equals((Object)MarkdownTokenType.BLANK_LINE) || this.tokenQueue.peekLast().getContent().endsWith("\r\n") || this.tokenQueue.peekLast().getContent().endsWith("\n") || this.tokenQueue.peekLast().getContent().endsWith("\r")) && node.getChars().extendToStartOfLine().startsWith((CharSequence)this.linePrefix);
    }

    private boolean isDefined(BasedSequence sequence) {
        return sequence != BasedSequence.NULL && !sequence.isEmpty();
    }

    private boolean shouldTranslateUrl(LinkNodeBase node) {
        return this.params.getTranslateUrls() && this.isDefined(node.getUrl()) && this.urlPatternToTranslate.matcher(node.getUrl().toString()).matches();
    }

    private boolean hasDescendantParagraph(Node node) {
        return this.hasDescendantOf(Paragraph.class, node);
    }

    private boolean hasDescendantBlankLine(Node node) {
        return this.hasDescendantOf(BlankLine.class, node);
    }

    private boolean hasDescendantOf(Class<?> nodeClass, Node node) {
        while (node.getLastChild() != null) {
            if (!nodeClass.isInstance(node = node.getLastChild())) continue;
            return true;
        }
        return false;
    }
}

